        TITLE   '<ki43 ver 1.41>'
;       by M. Adachi 11/26/83. Westland, MI
;       UPDATE  03/19/84
;       Assemble this code under the name of ki43/flt
;       [FILTER *KI ki43 (parm,...)]
;       This will enable <CTRL> key and <CAPS> key .
;       Also, <Function> keys above numeric pad can be
;       optionally enabled.
;       Use with Ldos ki/dvr. LDOS 513 and UP.
;       Allowable parameters are as follows
;       [Pause] or [P] : This assign <F1> to Pause, <F2>
;       to screen print and <F3> to toggle DEBUG.
;       [Pause] default to off
;       [Assign] or [A] : This assign <F1> thru <F3> key
;       to any single character. [Assign] default to on.
;       F1=xx : This assign <F1> key to xx. <F1> default
;       to 7bh ("{").
;       F2=xx : This assign <F2> key to xx. <F2> default
;       to 7ch ("|").
;       F3=xx : This assign <F3> key to xx. <F3> default
;       to 7dh  ("}").
;       Assign parameter must be ON to use F1 thru F3.
;       When [Pause]  is ON, [Assign] is ignored.
;       example:
;       ex1     filter *ki ki43 (a=n)
;                 This will enable <Caps> and <CTRL> only
;       ex2     filter *ki ki43 (f1=x'08',f2=10,f3=9)
;                 You get extra BKSP,VTAB and HTAB
;                 as well as <CAPS> and <CTRL>
;       ex3     filter *ki ki43
;                 <CAPS> and <CTRL> are enabled, F1 thru
;                 F3  default to {,|,}.
;                 Handy for preparing C/Pascal source.
;       ex4     filter *ki ki43 (p)
;                 You can use <F1> in lieu of <shift><@>
;                 <F2> for Screen dump, and <F3> to 
;                 toggle DEBUG ON and OFF.
;                if JKL is active, then F2 invoke JKL.
;                Otherwise rom routine will be used.
;********************************************************
;       Routine to install this *ki filter from JCL was
;       added in 02/19/84, suggested by LDOS QUARTERLY
;       page 74-75, Octover 1,1982 (vol 1. No.6)
;********************************************************
;       Routine to assign <F1> thru <F3> as parameter
;       option was added 02/26/844
;********************************************************
;       Routine to serch thru himem module and replace 
;       rom screen dump with JKL3 screen dump was added
;       03/08/84.
;********************************************************
CR      EQU     13      ;<enter> key
LF      EQU     10      ;line feed
ETX     EQU     3       ;end of text
@EXIT   EQU     402DH   ;LDOS normal exit
@ABORT  EQU     4030H   ;error abort
@LOGOT  EQU     447BH   ;display and log msg
@DSPLY  EQU     4467H
@ADTSK  EQU     403DH
@PAUSE  EQU     0060H
@SCRN   EQU     01D9H   ;print screen contents
@DBG    EQU     400FH   ;jump vector to debug
@DBGHK  EQU     4405H   ;System debug hook location
@PARM   EQU     4454H   ;parameter perser
HIGH$   EQU     4411H   ;hi-memory
KFLAG$  EQU     429FH   ;keyboard flag
SFLAG$  EQU     442BH   ;system flag
KIJCL$  EQU     42BEH   ;save area for kijcl dcb
AMOUNT  EQU     0280H   ;delay amount 9.5 milisec.
;*** macro definition   ******
OFFSET  MACRO   #RELO   ;relocation of absolute address
        LD      HL,(#RELO)
        ADD     HL,DE
        LD      (#RELO),HL
        ENDM
PRMXFER MACRO   #VECTOR,#ADDRESS
        LD      A,(#VECTOR)
        LD      (#ADDRESS+1),A
        ENDM
CPHL    MACRO   #OBJ
        LD      A,#OBJ
        CP      (HL)
        ENDM
; ***     start of program  ***
        ORG     5200H
;** Relocation routine from LDOS manual **
KI43    LD      A,(DE)          ;get device type
        AND     5               ;make sure its an
        JP      Z,NOGOOD        ;input device
        PUSH    IX
        PUSH    HL              ;save command line ptr
;
        LD      HL,SFLAG$       ;get sflag$ and
        BIT     5,(HL)          ;see if DO is in effect
        JR      Z,MANUAL        ;if not then proceed
        LD      DE,KIJCL$       ;else real jump vector
        DEC     DE              ;is in kijcl$
;
MANUAL  POP     HL              ;command line ptr
        PUSH    DE              ;save device code
        PUSH    HL              ;save command line ptr
        LD      HL,MSG          ;point to banner message
        CALL    @DSPLY          ; and display it
        POP     HL              ;recover command line ptr
        LD      DE,PARMTBL      ;point to parameter tbl
        CALL    @PARM           ;look for parameter
        JP      NZ,PRMERR       ;if error,go handle it.
        POP     IX              ;recover device DCB
        LD      A,(IX+1)        ;xfer orig DCB vector
        LD      (KIDVR+1),A     ;to driver CALL
        LD      A,(IX+2)
        LD      (KIDVR+2),A
        LD      HL,(HIGH$)      ;get himem$
        LD      (OLDMEM),HL     ;store old himem
        PUSH    HL              ;save Old mem
        LD      BC,LAST-1       ;get last byte address
        PUSH    BC              ;and save it
        XOR     A               ;clear the carry
        SBC     HL,BC           ;calc offset
        EX      DE,HL           ;de= offset
        OFFSET  RELO1
        OFFSET  RELO4
        OFFSET  RELO5
        POP     HL              ;hl =last byte
        POP     DE              ;de = hi mem
        LD      BC,LAST-START   ; bc= length of pgm
        LDDR                    ;move it!
        LD      (HIGH$),DE      ;save new high$
        INC     DE              ;point DE at new START
        DI                      ;interrupts off for now
        LD      (IX+1),E        ;update DCB vector
        LD      (IX+2),D        ;to filter entry
        EI                      ;clock back on
        LD      A,(VPAUSE)
        OR      A
        JP      Z,ISASN
        PUSH    DE              ;go for a long journey
        PUSH    HL              ;in serch of JKL3
        PUSH    BC
        LD      HL,(HIGH$)      ;get first module addrs.
LOOP    INC     HL              ;advance pointer
        PUSH    HL              ;save it
        INC     HL
        INC     HL              ;point to the addrs
        LD      A,(HL)          ;of next module and
        LD      (POINTR),A      ;save it to (pointr)
        INC     HL
        LD      A,(HL)
        LD      (POINTR+1),A
        INC     HL              ;save # of char for
        LD      B,(HL)          ;memory header
        LD      DE,JKL3         ;we are looking for
SERCH   INC     HL              ;'JKL3' string
        LD      A,(DE)
        INC     DE              ;compare string
        CP      (HL)            ;one by one 
        JR      NZ,NOMATCH
        DJNZ    SERCH           ;for # of char
;       try to find out specific code seaquence.
FOUND   POP     HL
        INC     HL
        INC     HL
        LD      E,(HL)
        INC     HL      ;code seaquence we are look-
        LD      D,(HL)  ;-ing for is 3a8942h which is
        EX      DE,HL   ;LD     A,(SFlAG$)
        OR      A       ;then decrement count by 2
        SBC     HL,DE   ;to point to push instruction
        LD      B,H     ;This gives an entry point to
        LD      C,L     ;the JKL3 screen dump. 
        EX      DE,HL   ;(as far as 513 and 514 concerns)
        INC     HL
CODE1   CPHL    3AH
        JR      Z,TEST1
        JR      CODE2
TEST1   INC     HL
        CPHL    89H
        JR      Z,TEST2
        DEC     HL
        JR      CODE2
TEST2   INC     HL
        CPHL    42H
        DEC     HL
        DEC     HL
        JR      Z,THISIS
CODE2   DEC     BC
        LD      A,C
        OR      B
        JR      Z,JKLDONE
        INC     HL
        JR      CODE1
THISIS  DEC     HL
        DEC     HL
        LD      (SCRN+1),HL
        JR      Z,JKLDONE
;
NOMATCH POP     HL
        LD      HL,(POINTR)     ;get next block addrs
        PUSH    BC              ;in case himem module
        PUSH    HL              ;does not follow LDOS
        OR      A               ;style header, we have to
        LD      BC,5200H        ;look if lost truck of
        SBC     HL,BC           ;himem module
        POP     HL
        POP     BC
        JR      C,JKLDONE       ;if so, get out.
        PUSH    HL
        PUSH    BC              ;otherwise check to
        LD      BC,0FFFFH       ;see if looking at
        SBC     HL,BC           ;last himem module
        POP     BC
        POP     HL
        JR      NZ,LOOP         ;if not keep searching
;
JKLDONE POP     BC              ;return from the journey
        POP     HL
        POP     DE
        LD      HL,(HIGH$)      ;xfer <Pause> module to
        LD      (OLDMEM2),HL    ;himem
        PUSH    HL
        LD      BC,LAST2-1
        PUSH    BC
        XOR     A
        SBC     HL,BC
        EX      DE,HL
        OFFSET  RELO2
        OFFSET  RELO3
        OFFSET  RELO6
        OFFSET  RELO7
        OFFSET  RELO8
        POP     HL
        POP     DE
        LD      BC,LAST2-LAST
        LDDR
        LD      (HIGH$),DE
        LD      HL,PMSG
        CALL    @DSPLY
        LD      DE,TCB
RELO3   EQU     $-2
        LD      A,0             ;interrupt slot 0
        CALL    @ADTSK          ;insert it
        JR      DONE    ;all done for <Pause> parameter
;
ISASN   LD      A,(VASN)        ;see if <assign>=on
        OR      A
        JR      Z,DONE  ;no parameter found
; Install <Assign> option block to himem area.
        PRMXFER VF1,CF1 ;xfer parameter to the wk area.
        PRMXFER VF2,CF2
        PRMXFER VF3,CF3
        LD      DE,(HIGH$)
        LD      (OLDMEM3),DE
        LD      HL,LAST3-1
        LD      BC,LAST3-LAST2
        LDDR
        LD      (HIGH$),DE
        INC     DE
        LD      (FUNC),DE
RELO4   EQU     $-2
        LD      A,0CDH          ;nemonic for call $
        LD      (FUNC-1),A
RELO5   EQU     $-2
DONE    POP     IX              ;pop ix reg
        JP      @EXIT
; Message table
NOGOOD  LD      HL,ERRMSG       ;point to error message
        JR      ERREXIT         ;and exit
PRMERR  LD      HL,PARMM        ;point to error message
ERREXIT CALL    @LOGOT          ;log error message
        JP      @ABORT          ;abort the request
MSG     DM      '<CTL> key and <CAPS> key are now active',CR
PMSG    DM      '<F1>= Pause, <F2>= Screen print, <F3>= Toggle Debug',CR
ERRMSG  DM      'Nothing done, This filter is for *ki only',CR
PARMM   DM      'Parameter error',CR
PARMTBL DB      'PAUSE '
        DW      VPAUSE
        DB      'P     '
        DW      VPAUSE
        DB      'ASSIGN'
        DW      VASN
        DB      'A     '
        DW      VASN
        DB      'F1    '
        DW      VF1
        DB      'F2    '
        DW      VF2
        DB      'F3    '
        DW      VF3
        NOP                     ;indicate table end.
VPAUSE  DW      0               ;default to off
VASN    DW      -1              ;default to on
VF1     DW      007BH           ;default to "{"
VF2     DW      007CH           ;default to "|"
VF3     DW      007DH           ;default to "}"
POINTR  DW      0FFFFH
JKL3    DB      'JKL3'
;************************************************
;       actual filter routine to go $high
;************************************************
START   JR      START2
OLDMEM  DW      $-$     ;old himem address goes here
        DB      START2-TITLE
TITLE   DB      'KI43'          ;ldos style header
START2  LD      A,(3880H)       ;see if key pressed
        LD      E,A             ;save A => E
        LD      HL,IMAGE        ;HL point to previous image
RELO1   EQU     $-2     ;relocation address
        XOR     (HL)    ;if same, it will be zero
        JR      Z,KIDVR ; go for LDOS dvr
        LD      A,E             ;restore A
        LD      (HL),A          ;save new imagee
        AND     11111000B       ;ignore shifts and <CTL>
        JR      Z,KIDVR         ;<Shift> or <CTRL>.
        PUSH    AF
        LD      BC,AMOUNT       ;10 msec delay for preca-
        CALL    @PAUSE          ;-ution of key debounce.
        POP     AF
        LD      HL,KFLAG$       ;hl=kflag status
        BIT     3,A     ;test for <CAPS>
D1      JR      Z,ISFKI
        BIT     5,(HL)          ;test CAPS lock
        SET     5,(HL)          ;set it anyway
        JR      Z,KIDVR         ;if not zero then
        RES     5,(HL)          ;have to reset
        XOR     A               ;clear zero flag
        RET                     ;and return
ISFKI   XOR     A               ;link to assign parameter
FUNC    RET     ;these 3 lines will be changed to
        NOP     ;*CALL  FKI* when <ASSIGN> engaged.
        OR      A
        RET
KIDVR   CALL    $-$             ;go for LDOS driver
        RET     Z               ;return upon no entry
        PUSH    AF              ;save AF
        LD      A,(3880H)       ;look at kbd
        AND     00000100B       ;mask CTL key
        JR      NZ,CTL          ;go if control
        POP     AF              ;no CTL
        RET                     ;therefore return
CTL     POP     AF              ;restore af
        AND     1FH             ;thread to cntrol
        SCF                     ;set carry flag
        RET                     ;all done.
IMAGE   DB      00H             ;image of 3880h
LAST    EQU     $
;*****************************************************
;       interrupt task block option. 
TASK    JR      TASKA
OLDMEM2 DW      $-$
        DB      TCB-TITLE2
TITLE2  DB      'ki43tsk'
TCB     DW      TASK
RELO2   EQU     $-2     ;vector point to interrupt task
F3FLAG  DB      00H     ;reserved for f3 ki status
TASKA   LD      A,(3880H)       ;read in keys
        LD      HL,KFLAG$
        BIT     4,A             ;see if <F1> pressed
        JR      Z,ISF2
        SET     1,(HL)          ;set <pause> bit
        RET
ISF2    BIT     5,A
        JR      Z,ISF3
SCRN    JP      @SCRN   ;Rom screen print routine.
ISF3    BIT     6,A
        JR      NZ,SETF ;see if flag is set
        XOR     A       ;else reset the flag
        LD      (IX+2),A        ;ix+2=>k3flag
        RET             ;and return
SETF    LD      A,(IX+2)        ;ix+2=>k3flag
        OR      A
        RET     NZ      ;if already set,do nothing
        LD      A,0FFH  ;else set flag
        LD      (IX+2),A
        LD      HL,DMSG
RELO8   EQU     $-2
        CALL    @DSPLY
        LD      B,26    ;wait a bit
        CALL    @PAUSE
        LD      HL,SFLAG$
        BIT     7,(HL)
        SET     7,(HL)
        JR      NZ,DBGOFF
        LD      HL,@DBG         ;debug vector
        LD      A,0C3H          ;jump instruction
        LD      (@DBGHK+1),HL   ;hook to system
        LD      (@DBGHK),A
        LD      HL,ONMSG
RELO6   EQU     $-2
        JR      SHOWIT
DBGOFF  RES     7,(HL)
        LD      A,0C9H          ;return instruction
        LD      (@DBGHK),A      ;unhook from system
        LD      HL,OFFMSG
RELO7   EQU     $-2
SHOWIT  JP      @DSPLY
DMSG    DB      'Debug ',ETX
ONMSG   DB      'on',CR
OFFMSG  DB      'off',CR
LAST2   EQU     $
;******* Assign option block *************
FKI     JR      START3
OLDMEM3 DW      $-$
        DB      START3-TITLE3
TITLE3  DB      'fki43'
START3  BIT     4,A
        JR      Z,F2
CF1     LD      A,7BH
        JR      ISCTL
F2      BIT     5,A
        JR      Z,F3
CF2     LD      A,7CH
        JR      ISCTL
F3      BIT     6,A
        JR      Z,NOINPUT
CF3     LD      A,7DH
ISCTL   CP      20H     ;see if control char
        JR      Z,SPC   ;zero flag has to be reset
        RET             ;ctrl returns with carry set
SPC     OR      A       ;reset zero flag
        RET             ;and return
NOINPUT XOR     A
        RET
LAST3   EQU     $
        END     KI43

