;
;INSTALLS/ASM/CMD
;  SVC Generation program for INSTALL.
;  21 Mar 87
;  By Shane Dawalt
;  Copyright 1987 by Shane Dawalt.
;
;Assembly Notes:
;	Assemble with -GC switch on command line.
;
;SVC constants
;
@GTMOD	EQU	83
@GTDCB	EQU	82
@DSPLY	EQU	10
@KEYIN	EQU	9
@HEXDEC	EQU	97
@DECHEX	EQU	96
@DSP	EQU	2
@HEX16	EQU	99
@EXIT	EQU	22
@FLAGS	EQU	101
@VDCTL	EQU	15
@HIGH$	EQU	100
;
;Constants
;
CR	EQU	13
LF	EQU	10
ETX	EQU	3
DEFAULT	EQU	127		;default SVC slot number
TEST	EQU	0		;TEST define: 1 = in TEST, 0 = normal
;
;Macros
;
SVC		MACRO	#SVC_NUM
		LD	A,#SVC_NUM
		RST	28H
		ENDM
;
GENSVCA		MACRO
		RLCA			;; A = A * 2
		LD	H,(IY+26)	;; get MSB of SVC table into H
		LD	L,A		;; replace L with LSB of table
		ENDM
;
;Begin program
;
		IFEQ	TEST,1
		ORG	3000H		;if under test, load in main memory
		ELSE
		ORG	2600H		;else, load in overlay memory
		ENDIF
START		PUSH	HL		;save keyboard ptr
		LD	HL,HELLO
		SVC	@DSPLY
		SVC	@FLAGS
		POP	HL		;restore keyboard pointer
		LD	A,62H		;check version
		SUB	(IY+27)
		JR	Z,START1	;go if 6.2
		JR	C,START1	;go if above 6.2
		LD	HL,BADVERS
BADBYE		SVC	@DSPLY
		LD	HL,-1		;signal error
		SVC	@EXIT
START1		CALL	PARSEIN		;parse input
		LD	DE,MODNAME
		SVC	@GTMOD
		JR	NZ,START5	;if @GTMOD unsuccessful, go on
		LD	A,(SVCSLOT)	;get character on cmd line
		CP	'R'		;REMOVE requested?
		JP	Z,REMOVE	;go if so
		LD	(KEEP1),HL	;save in case we goto link routine
		LD	HL,4		;offset DE to SVCSLOT in module
		ADD	HL,DE
		LD	A,(HL)		;p/u slot number
		LD	(OLDSLOT),A
		GENSVCA			;generate SVC address for it
		INC	HL		;point to MSB
		LD	A,(HL)
		CP	26H		;under 26H?  If so, module unlinked
		JR	NC,START3	;if linked, display slot & exit
		LD	A,(SVCSLOT)	;p/u slot number
		OR	A		;if zero, use slot in module
		JR	NZ,START2	;go if user entered a slot
		LD	A,0		;p/u slot from module
OLDSLOT		EQU	$-1
		LD	(SVCSLOT),A	;update slot number
START2		CALL	CHKSLOT		;is slot ok?
		CALL	NZ,GETSLOT
		LD	A,(SVCSLOT)
		GENSVCA
		LD	DE,0
KEEP1		EQU	$-2
		JP	START30		;jump into 
START3		LD	A,(OLDSLOT)
		LD	L,A		;put into HL
		LD	H,0
		LD	DE,BUFFER	;generate decimal equiv
		SVC	@HEXDEC
		LD	DE,ADDRMS4
		LD	HL,BUFFER+2
		LD	BC,3		;move 3 bytes
		LDIR
		LD	HL,RESIDENT
		JR	BADBYE
START5		LD	A,(SVCSLOT)	;a = svc slot for call
		OR	A		;use default or user provided?
		JR	NZ,START7	;user provided
		LD	A,DEFAULT	;else, use default
		LD	(SVCSLOT),A
START7		CALL	CHKSLOT		;check if slot available
		CALL	NZ,GETSLOT	;if not, get a slot
START10		CALL	GENMODULE	;generate the header & module
		LD	HL,MODULE
		LD	BC,(BYTES)
		LD	D,1		;hi memory load
		LD	IX,RELOTAB
		CALL	INSTALL
		JR	Z,START20	;continue if ok
		LD	HL,CANTINS
		SVC	@DSPLY
		LD	HL,CANTEND
		JP	BADBYE		;exit with JCL abort
START20		PUSH	HL		;save beginning of module ptr
		INC	HL
		INC	HL		;point to MODEND word of header
		LD	(HL),E		;p/d pointer to last byte
		INC	HL
		LD	(HL),D
		POP	DE
		LD	A,(SVCSLOT)
		GENSVCA
;here if resident but unlinked
START30		LD	C,(HL)		;get old system SVC vector
		LD	(HL),E		;place INSTALL vector into table
		INC	HL
		LD	B,(HL)
		LD	(HL),D
		LD	HL,14
		ADD	HL,DE		;point to SVCSLOT storage
		LD	A,(SVCSLOT)	;pickup slot number in & place it
		LD	(HL),A		;must do since this code used for
		INC	HL		;  relinking (doesn't require install)
		LD	(HL),C		;save old SVC vector in module
		INC	HL
		LD	(HL),B
		LD	HL,(BYTES)	;if BYTES = 0, just relinking
		LD	A,H
		OR	L
		JR	Z,START35	;branch to appropriate message setup
		LD	HL,ADDRMS3
		LD	(MSGADD1),HL
		LD	HL,INPLACE
		LD	(MSGADD2),HL
		JR	START40
START35		LD	HL,ADDRMS5
		LD	(MSGADD1),HL
		LD	HL,RELINK
		LD	(MSGADD2),HL
		JR	START45		;bypass # of bytes & stuff
START40		LD	HL,ADDRMS1	;place in message
		SVC	@HEX16
		LD	DE,(BYTES)	;p/u # of bytes in module
		LD	HL,ADDRMS2	;place in message
		SVC	@HEX16
START45		LD	A,(SVCSLOT)	;make SVCSLOT ascii & move to line
		LD	L,A
		LD	H,0
		LD	DE,BUFFER
		SVC	@HEXDEC		;generate decimal number for SVC slot
		LD	DE,0		;message address placed by code
MSGADD1		EQU	$-2
		LD	HL,BUFFER+2
		LD	BC,3		;place in message
		LDIR
		LD	HL,0		;message address placed by code
MSGADD2		EQU	$-2
BYE		SVC	@DSPLY
		LD	HL,0		;exit with no error
		SVC	@EXIT
GETSLOT		LD	HL,SLOTFULL	;display message
		SVC	@DSPLY
		LD	C,124		;loop through all 4 user SVCs
		LD	B,4		;  to determine availability
GETSLOT1	LD	A,C
		CALL	CHKSLOT
		JR	NZ,GETSLOT5	;go if not available
		LD	L,C		;place in HL
		LD	H,0
		LD	DE,BUFFER
		PUSH	BC		;save counters
		SVC	@HEXDEC		;convert number to decimal
		LD	HL,BUFFER
		SVC	@DSPLY
		POP	BC		;restore counters
GETSLOT5	INC	C		;bump SVC number
		DJNZ	GETSLOT1	;do till B = 0
		LD	HL,JCLON	;message for JCL execution
		BIT	5,(IY+'S'-'A')	;check if JCL executing
		JP	NZ,BADBYE	;exit, user can't use keyboard
		LD	HL,PROMPT
		SVC	@DSPLY		;query user for slot
		LD	B,4		;get current cursor position
		SVC	@VDCTL
		DEC	H		;point to LAST line
		LD	L,PROEND	;new column number
		LD	(CURSOR),HL	;save cursor
		LD	B,3		;reposition cursor there
		SVC	@VDCTL
GETSLOT7	LD	HL,BUFFER	;buffer for input
		LD	BC,300H		;b= max chars, c = 0
		SVC	@KEYIN
		LD	HL,BREAK
		JP	C,BYE		;exit if BREAK
		LD	A,3
		CP	B		;test if less than 3 chars input
		JR	NZ,GETSLOT10	;if so, bad input
		LD	HL,BUFFER	;point to buffer
		SVC	@DECHEX		;convert to binary
		CALL	CHKVALUE	;check the value returned
		JR	NZ,GETSLOT10	;go if bad
		LD	A,(SVCSLOT)	;p/u slot number checked
		CALL	CHKSLOT		;slot available?
		LD	C,0DH		;force a line down
		SVC	@DSP
		RET	Z		;if so, continue initialization
GETSLOT10	LD	HL,0
CURSOR		EQU	$-2
		LD	B,3		;reposition cursor
		SVC	@VDCTL
		LD	C,30		;output Clear to End of Line
		SVC	@DSP
		JR	GETSLOT7	;wait for input again
;Patch area
		DC	32,0
;
REMOVE		LD	(MODSTA),HL	;save pointer to module
		LD	HL,4		;point HL to SVC slot #
		ADD	HL,DE
		LD	A,(HL)		;p/u SVC slot #
		LD	(SVCSLOT),A	;save it
		INC	HL
		LD	A,(HL)
		LD	(OLDSVC),A	;p/u old SVC system vector
		INC	HL
		LD	A,(HL)
		LD	(OLDSVC+1),A
		LD	A,(SVCSLOT)
		GENSVCA
		LD	DE,(OLDSVC)	;ready to unlink module from SVC table
		LD	(HL),E
		INC	HL
		LD	(HL),D		;now, module is unlinked from system
		LD	HL,UNLINK
		SVC	@DSPLY
		LD	B,0
		LD	HL,0
		SVC	@HIGH$		;get high$ pointer
		INC	HL		;point to protected byte
		OR	A
		LD	DE,0		;p/u start of module
MODSTA		EQU	$-2
		SBC	HL,DE		;same?
		JR	NZ,NORECLA	;can't reclaim memory
		INC	DE
		INC	DE		;p/u last byte pointer into HL
		LD	A,(DE)
		LD	L,A
		INC	DE
		LD	A,(DE)
		LD	H,A
		LD	B,0
		SVC	@HIGH$		;reset high$: unprotect SVC
		JR	NZ,NOREM	;go if can't change HIGH$
		LD	HL,RECLAIM	;else, all ok
		LD	IX,CANTREL
NORECLA		EQU	$-3
		JP	BYE
NOREM		LD	HL,CANTRMV
		SVC	@DSPLY
		LD	HL,CANTEND
		JP	BYE		;exit without a JCL abort
;
;Slot number must be in A
;
CHKSLOT		GENSVCA
		INC	HL		;bump to MSB of SVC vector
		LD	A,25H
		CP	(HL)		;check if < 26h
		RET	Z		;ok, flag Z & return
		RET	C		;if C flag (Z flag already NZ)
		CP	A		;else, flag Z & return
		RET
;
;Copies INCLUDE from workable subroutine to end of memory header.  A relocation
;  is done on each address listed in RELOTAB to relocate it to that space.
;
GENMODULE	LD	HL,INSTALL
		LD	BC,HELLO-INSTALL ;# of bytes in INSTALL
		LD	DE,MODBEG	;where to move it
		LDIR
		LD	HL,HELLO-INSTALL ;# of bytes in INSTALL
		LD	BC,MODBEG-MODULE ;# of bytes in header
		ADD	HL,BC		;calculate total # of module bytes
		LD	(BYTES),HL	;save for later
		LD	HL,RELOTAB
		LD	BC,MODBEG-INSTALL ;generates constant to move
;move absolute addresses from original INSTALL to location of MODBEG.
GENMODULE1	LD	E,(HL)		;get pointer pointed to
		INC	HL
		LD	D,(HL)
		INC	HL		;point to next word
		LD	A,E
		OR	D		;pointer 0?
		RET	Z		;done if so
		PUSH	HL		;save RELOTAB pointer
		EX	DE,HL		;put pointer into HL
		LD	E,(HL)		;get address to relocate
		INC	HL
		LD	D,(HL)
		EX	DE,HL		;address to relocate to HL
		ADD	HL,BC		;relocate to MODBEG
		EX	DE,HL		;relocated address to DE
		LD	(HL),D		;resave to program
		DEC	HL
		LD	(HL),E
		POP	HL		;restore RELOTAB pointer
		JR	GENMODULE1	;loop
;
;Assumed HL = pointer returned by TRSDOS
;
PARSEIN		LD	A,(HL)		;check if entry input
		CP	CR		;end of line?
		RET	Z		;go if so
		CP	3AH		;numeric?
		JR	C,PARSEIN5	;go if numeric
		AND	5FH		;force uppercase
		CP	'R'		;accept "R" only
		JR	NZ,PARSEIN7	;parameter error, exit
		LD	(SVCSLOT),A	; save & return
		RET
PARSEIN5	SVC	@DECHEX		;convert number to BINARY
		CALL	CHKVALUE	;is value in range?
		RET	Z		;if ok, return
PARSEIN7	POP	HL		;clear return address
		LD	HL,BADPARM	;display error & exit
		JP	BADBYE
;
;Value assumed passed in BC
;
CHKVALUE	LD	A,C		;get LSB
		SUB	124		;down by 124
		OR	B		;add in b
		CP	128-124		;check if mess is less than 4
		JR	NC,CHKVALUE1	;go if not (bad parameter)
		LD	A,C
		LD	(SVCSLOT),A	;save parameter
		CP	A		;else, force Z flag
		RET
CHKVALUE1	OR	1		;force NZ flag
		RET
*INCLUDE INSTALL/ASM
HELLO	DB	LF,'INSTALLS - 1.0.0 - SVC generator program for INSTALL'
	IFEQ	TEST,1
	DB	' *** IN TESTING MODE ***'
	ENDIF
	DB	LF,'(c) 1987 by Shane Dawalt, [71076,511]',LF,CR
BADVERS	DB	'DOS version must be 6.2 or greater',CR
BADPARM	DB	'Slot number must be 124 thru 127 ONLY.',CR
CANTINS	DB	'Can''t install ',ETX
CANTRMV	DB	'Can''t remove ',ETX
CANTEND	DB	'module, HIGH$ changes inhibited',CR
INPLACE	DB	'INSVC located at x''xxxx'' for x''xxxx'' bytes at SVC slot'
	DB	' xxx',CR
ADDRMS1	DEFL	INPLACE+19
ADDRMS2	DEFL	INPLACE+31
ADDRMS3	DEFL	INPLACE+55
RESIDENT DB	'INSVC already resident in SVC slot xxx',CR
ADDRMS4	DEFL	$-4
RELINK	DB	'INSVC relinked to SVC slot xxx',CR
ADDRMS5	DEFL	$-4
SLOTFULL DB	'Slot occupied.  Available slots identified below:',LF,9
	DB	ETX
PROMPT	DB	LF,LF,'Enter slot number or <BREAK> to exit: ',CR
PROEND	DEFL	$-3-PROMPT		;generates # of bytes to end of prompt
BREAK	DB	LF,'<break>, module NOT activated.',CR
JCLON	DB	LF,LF,'Enter slot number on command line.',CR
UNLINK	DB	'SVC unlinked from memory',CR
CANTREL	DB	'Cannot release memory space',CR
RECLAIM	DB	'Memory space released',CR
BUFFER	DC	5,0			;general purpose buffer
	DB	ETX
BYTES	DW	0
;
; Relocation table is next
;
RELOTAB	DW	MODBEG+1,MODBEG+5,MODBEG+9,MODBEG+13,MODBEG+36,MODBEG+49
	DW	MODBEG+55,MODBEG+58,MODBEG+88,MODBEG+105,MODBEG+111,MODBEG+114
	DW	MODBEG+123,MODBEG+132,MODBEG+138,MODBEG+156,0
;
;Memory header
;
MODULE	JR	MODBEG
	DW	0			;MODEND word goes here
 	DB	5			;module name char count
MODNAME	DB	'INSVC'
	DW	0,0			;words not used but required by system
SVCSLOT	DB	0			;where SVC link number is saved
OLDSVC	DW	0			;contains system SVC vector
MODBEG	EQU	$
	TIME				;stamp file w/ control data
	DATE
	IFGT	MODBEG,2FFFH		;check if out of overlay area
	ERR	'User core violated.'
	ENDIF
	END	START
