*LIST OFF
;
;INSTALL/ASM.
;   21 Mar 87
;   By Shane Dawalt
;This file is released to public domain by the author.
;
;INSTALLATION module.
;
;To be included with assembly program BEFORE assembly.
;
;Input,  D = 0 if lower memory load. 
;	     Any other value flags a hi memory load.
;	BC = Length of module to install.
;	HL = Address of module to install.
;	IX = Relocation table address.
;	     Terminate the table with 2 bytes of zeros.
;
;Return,
;	If Z flag = Operation successful.
;	    HL = Address of relocated module
;	    DE = Address of last byte in relocated module
;	If NZ flag then:
;	    If low memory load, insuffecient memory to complete installation.
;	    If hi memory load, system flag $CFLAGS prohibits changing of HIGH$.
;	    In either case, HL & DE are invalid.
;
;	Registers destroyed are HL, BC, DE and AF.
;
	PUBLIC	INSTALL
*MOD
INSTALL	LD	(INS?00D),HL	;Save registers altered
	LD	(INS?01D),BC	;  (code <INS>tall, #<01>, <D>ata)
	LD	(INS?02D),IX
	LD	(INS?03D),SP	;stuff stack incase of error
	INC	D
	DEC	D		;0 entered?
	JR	NZ,INS?00P	;go hi mem
;				   (code <INS>tall, #<00>, <P>rogram)
	LD	DE,'IK'		;get DCB ptr to *KI
	LD	A,52H		;@GTDCB request
	RST	28H
	DEC	HL
	DEC	HL		;HL is Pointer to Low Memory Pointer (PLMP)
	PUSH	HL		;save PLMP
	LD	E,(HL)		;p/u Low Memory Pointer (LMP)
	INC	HL
	LD	D,(HL)
	PUSH	DE
	POP	HL		;LMP -> HL also
	LD	BC,(INS?01D)
	ADD	HL,BC		;add LMP to module length
	INC	HL		;+1 to save last byte
	LD	BC,1300H
	SBC	HL,BC		;out of memory?
	JR	NC,INS?01P	;exit if so
	PUSH	DE		;else save LMP
	CALL	INS?02P		;relocate absolute (abs) addresses (addr)
	POP	DE		;refresh DE
	PUSH	DE		;prepare to move module
	LD	BC,(INS?01D)	;  p/u # of module length
	LD	HL,(INS?00D)	;  p/u abs addr
	LDIR
	POP	BC		;get original LMP
	POP	HL		;restore PLMP
	LD	(HL),E		;save new LMP (protect module)
	INC	HL
	LD	(HL),D
	LD	L,C		;original LMP -> HL
	LD	H,B
	DEC	DE		;setup DE for return
	CP	A		;force Z flag
	RET
INS?01P	LD	SP,0		;restore original stack on error
INS?03D	EQU	$-2
	OR	1		;force NZ flag
	RET
INS?00P	LD	HL,0		;get hi mem
	LD	B,0
	LD	A,64H
	RST	28H
	LD	BC,(INS?01D)	;p/u # of module length
	OR	A
	SBC	HL,BC		;new hi mem pointer (HMP)
	PUSH	HL		;save
	LD	B,0		;update HIGH$ with HMP
	LD	A,64H
	RST	28H
	JR	NZ,INS?01P	;error if HIGH$ can't change
	POP	DE		;refresh DE with HMP
	INC	DE		;point to first protected byte
	PUSH	DE		;save it
	CALL	INS?02P		;relocate abs addr
	POP	DE		;refresh DE
	PUSH	DE		;prepare to move module
	LD	BC,(INS?01D)	;p/u # of module length
	LD	HL,(INS?00D)	;p/u abs addr
	LDIR
	POP	HL		;setup for return; restore HMP
	DEC	DE		;point to last byte of module
	CP	A		;force Z flag
	RET
;
;Entry, DE = Address of relocation
;
INS?02P	LD	HL,(INS?00D)	;p/u abs module addr
	EX	DE,HL		;exchange with relocation addr
	OR	A
	SBC	HL,DE		;get offset value
	LD	B,H		;lo memory offset is 2's comp.
	LD	C,L		;offset -> BC
	LD	HL,(INS?02D)	;p/u relocation table
	LD	A,H
	OR	L
	RET	Z		;exit if no table
INS?03P	LD	(INS?02D),HL	;save table pointer
	LD	A,(HL)		;p/u pointer to abs addr
	INC	HL
	LD	H,(HL)
	LD	L,A
	OR	H		;is it 0?
	RET	Z		;return if so (end of table)
	LD	E,(HL)		;p/u addr to relocate
	INC	HL
	LD	D,(HL)
	EX	DE,HL		;save addr pointer in DE
	ADD	HL,BC		;relocate it [add offset]
	EX	DE,HL		;put addr pointer in HL
	LD	(HL),D		;store relocated value
	DEC	HL
	LD	(HL),E
	LD	HL,(INS?02D)	;p/u table pointer
	INC	HL
	INC	HL		;adjust to next pointer
	JR	INS?03P		;loop
INS?00D	DW	0		;storage: Abs module addr
INS?01D	DW	0		;storage: Length of module
INS?02D	DW	0		;storage: Relocation table pointer
*LIST ON
	END
