;
;INSTALLS/ASM/CMD
;  SVC Generation program for INSTALL.
;  Written: 21 Mar 87   Version 1.0
;  Updated: 17 May 87   Version 1.1
;       Code changed to use auto MODEND insert feature of INSTALL
;	@PARAM now used for parameter entry
;	New LOW parameter used for user loading of INSVC into low memory
;
;  Copyright 1987 by Shane Dawalt.
;
;Assembly Notes:
;	Assemble with -GC switch on command line [PRO-MRAS].
;
;SVC constants
;
@GTMOD	EQU	83
@GTDCB	EQU	82
@DSPLY	EQU	10
@KEYIN	EQU	9
@HEXDEC	EQU	97
@DECHEX	EQU	96
@DSP	EQU	2
@HEX16	EQU	99
@EXIT	EQU	22
@FLAGS	EQU	101
@VDCTL	EQU	15
@HIGH$	EQU	100
@PARAM	EQU	17
;
;Constants
;
CR	EQU	13
LF	EQU	10
ETX	EQU	3
DEFAULT	EQU	127		;default SVC slot number
TEST	EQU	0		;TEST define: 1 = in TEST, 0 = normal
;
;Macros
;
SVC		MACRO	#SVC_NUM
		LD	A,#SVC_NUM
		RST	28H
		ENDM
;
GENSVCA		MACRO
		RLCA			;; A = A * 2
		LD	H,(IY+26)	;; get MSB of SVC table into H
		LD	L,A		;; replace L with LSB of table
		ENDM
;
BACKREF		MACRO	#NAME, #LENGTH
#NAME	EQU	$-#LENGTH
		ENDM
;
;Begin program
;
		IFEQ	TEST,1
		 ORG	3000H		;if under test, load in main memory
		ELSE
		 ORG	2600H		;else, load in overlay memory
		ENDIF
START		PUSH	HL		;save keyboard ptr
		LD	HL,HELLO	;"hi all"
		SVC	@DSPLY
		SVC	@FLAGS
		POP	HL		;restore keyboard ptr
		LD	A,62H		;DOS version?
		SUB	(IY+27)
		JR	Z,START1	;go if 6.2
		JR	C,START1	;go if above 6.2
		LD	HL,BADVERS	;bad DOS version
BADBYE		SVC	@DSPLY
		LD	HL,-1		;JCL abort
		SVC	@EXIT
START1		LD	DE,PARAMTAB	;parse parameters
		SVC	@PARAM
		LD	HL,BADPARM
		JR	NZ,BADBYE	;exit if bad parameter
;    Check parameter types entered
		LD	A,(SLOTFLAG)
		AND	.NOT.80H	;other than value type?
		JR	NZ,BADBYE	;bye if so
		LD	A,(RMVFLAG)	;get remove flag
		LD	B,A
		LD	A,(LDFLAG)
		OR	B		;overlay with remove flag
		AND	.NOT.40H	;other than flag type?
		JR	NZ,BADBYE	;bye if so
;     Valid input, continue
		LD	BC,$-$		;get entered SVC slot
		BACKREF	SLOTPARM,2
		LD	A,C
		LD	(SVCSLOT),A	;save just in case BC = 0
		OR	C		;zero?
		JR	Z,START1_7	;skip (use default)
		CALL	CHKVALUE	;check slot value in BC
		LD	HL,BADSLOT
		JR	NZ,BADBYE	;go if bad
START1_7	LD	DE,MODNAME	;check if INSVC resident
		SVC	@GTMOD
		JR	NZ,START5	;if not, go
		LD	BC,$-$		;check REMOVE status
		BACKREF	RMVPARM,2
		INC	B
		JP	Z,REMOVE	;go if REMOVE
		LD	(KEEP1),HL	;save module start (for linking)
		LD	HL,4		;offset DE to SVCSLOT in module
		ADD	HL,DE
		LD	A,(HL)		;p/u slot number
		BIT	7,A		;link status?
		RES	7,A		;remove flag
		LD	(OLDSLOT),A	;save slot number
		JR	Z,START3	;go if status was linked [0]
		LD	A,(SVCSLOT)	;else, p/u user slot
		OR	A		;user or default?
		JR	NZ,START2	;if user, go
		LD	A,0		;p/u default slot
		BACKREF	OLDSLOT,1
		LD	(SVCSLOT),A	;update slot number
START2		CALL	CHKSLOT		;slot ok?
		CALL	NZ,GETSLOT	;get new if not
		LD	A,(SVCSLOT)
		GENSVCA
		LD	DE,0
		BACKREF	KEEP1,2
		JP	START30		;jump into relinking code
START3		LD	HL,RESIDENT
		SVC	@DSPLY
		LD	A,(OLDSLOT)
		CALL	PRINTSLOT
		JP	BADBYE
START5		LD	A,(SVCSLOT)	;p/u SVC slot
		OR	A		;default?
		JR	NZ,START7	;go if not
		LD	A,DEFAULT
		LD	(SVCSLOT),A
START7		CALL	CHKSLOT		;slot available?
		CALL	NZ,GETSLOT	;get new if not
START10		CALL	GENMODULE	;generate INSVC
		LD	HL,MODULE
		LD	DE,$-$
		BACKREF	MEND,2
		LD	BC,$-$		;p/u load parameter
		BACKREF	LDPARM,2
		LD	A,B		;use MSB (arbitrary)
		CPL			;reverse (LOW mem is flagged 0)
		AND	01H		;mask out all but bit 0
		LD	B,0		;set B to ignore IY (bit 1)
		OR	B		;add in memory select
		LD	B,A		;result to B
		LD	IX,RELOTAB
		CALL	INSTALL		;attempt to install it
		JR	Z,START20	;continue if ok
		LD	HL,CANTINS	;display start
		SVC	@DSPLY
		LD	A,(LDPARM+1)	;get MSB load parameter
		OR	A		;test if HI or LOW memory
		JR	Z,START19
		LD	HL,CANTINSL	;low memory error
		JR	START19_5
START19		LD	HL,CANTINSH
START19_5	JP	BADBYE		;bye
START20		EX	DE,HL		;determine # of bytes taken
		OR	A
		SBC	HL,DE
		LD	(MODLENGTH),HL
		LD	A,(SVCSLOT)	;p/u slot #
		GENSVCA
;here if resident but unlinked
START30		LD	C,(HL)		;get old SVC vector from table &
		LD	(HL),E		;   replace with INSTALL SVC vector
		INC	HL
		LD	B,(HL)
		LD	(HL),D
		LD	HL,14
		ADD	HL,DE		;point to SVCSLOT storage
		LD	A,(SVCSLOT)	;p/u slot number
		LD	(HL),A		;put into INSVC module
		INC	HL
		LD	(HL),C		;old SVC vector to INSVC too
		INC	HL
		LD	(HL),B
		LD	HL,(MEND)	;if BYTES = 0, just relinking
		LD	A,H
		OR	L
		JR	Z,START35	;vector to required message
		LD	HL,INPLACE
		LD	(MSGADD2),HL
		JR	START40
START35		LD	HL,RELINK
		LD	(MSGADD2),HL
		JR	START45		;goto slot number print
START40		LD	HL,ADDRMS2	;place start of module in message
		SVC	@HEX16
		LD	DE,$-$		;# of bytes to display
		BACKREF	MODLENGTH,2
		LD	HL,ADDRMS1
		SVC	@HEX16
START45		LD	HL,0		;address placed at setup
		BACKREF	MSGADD2,2
		SVC	@DSPLY		;display message
		LD	A,(SVCSLOT)
		CALL	PRINTSLOT
BYE		SVC	@DSPLY
		LD	HL,0		;no error exit to DOS
		SVC	@EXIT
;
;  Determines availibility of the 4 user slots.
;
GETSLOT		LD	HL,SLOTFULL	;display message
		SVC	@DSPLY
		LD	C,124		;loop 4 times (124-127)
		LD	B,4
GETSLOT1	LD	A,C
		CALL	CHKSLOT
		JR	NZ,GETSLOT5	;go if not available
		LD	L,C		;else, display it on the screen
		LD	H,0
		LD	DE,BUFFER
		PUSH	BC		;save counters
		SVC	@HEXDEC
		LD	HL,BUFFER
		SVC	@DSPLY
		POP	BC		;restore counters
GETSLOT5	INC	C		;bump SVC number
		DJNZ	GETSLOT1	;do till B = 0
		LD	HL,JCLON	;JCL abort message
		BIT	5,(IY+'S'-'A')	;JCL executing?
		JP	NZ,BADBYE	;bye if so
		LD	HL,PROMPT
		SVC	@DSPLY		;query user for slot
		LD	B,4		;get cursor position
		SVC	@VDCTL
		DEC	H		;point to LAST line
		LD	L,PROEND	;new column number
		LD	(CURSOR),HL	;save it
		LD	B,3		;reposition cursor there
		SVC	@VDCTL
GETSLOT7	LD	HL,BUFFER
		LD	BC,300H		;max 3 chars
		SVC	@KEYIN
		LD	HL,BREAK	;ready for BREAK
		JP	C,BYE		;exit if BREAK
		LD	A,3
		CP	B		;less than 3 chars?
		JR	NZ,GETSLOT10	;bad input if so
		LD	HL,BUFFER	;else, convert to binary
		SVC	@DECHEX
		CALL	CHKVALUE	;check validity
		JR	NZ,GETSLOT10	;go if bad
		LD	C,0DH
		SVC	@DSP		;move down a line
		LD	A,(SVCSLOT)	;slot available?
		CALL	CHKSLOT
		RET	Z		;continue if so
GETSLOT10	LD	HL,0		;else, restore cursor
		BACKREF	CURSOR,2
		LD	B,3
		SVC	@VDCTL
		LD	C,30		;clear last response
		SVC	@DSP
		JR	GETSLOT7	;go back for another
;Patch area (only under testing condition)
		IFEQ	TEST,1
		DC	32,0
		ENDIF
;
REMOVE		LD	(MODSTA),HL	;save pointer to module
		LD	HL,4		;point to SVC slot #
		ADD	HL,DE
		LD	A,(HL)		;p/u slot #
		LD	(SVCSLOT),A	;save it
		OR	80H		;indicate module unlinked
		LD	(HL),A		;back to module
		INC	HL
		LD	A,(HL)		;p/u old SVC system vector
		LD	(OLDSVC),A
		INC	HL
		LD	A,(HL)
		LD	(OLDSVC+1),A
		LD	A,(SVCSLOT)	;generate SVC slot address
		GENSVCA
		LD	DE,(OLDSVC)	;unlink INSVC from table
		LD	(HL),E
		INC	HL
		LD	(HL),D
		LD	HL,UNLINK	;display unlinked message
		SVC	@DSPLY
		LD	HL,(MODSTA)
		LD	DE,1300H	;highest in low memory
		OR	A
		SBC	HL,DE
		JP	NC,REMOVE5	;go if hi mem
		LD	DE,'IK'
		SVC	@GTDCB
		DEC	HL
		LD	A,(HL)		;p/u low memory pointer
		DEC	HL
		LD	(POINTER),HL	;save pointer to above
		LD	L,(HL)
		LD	H,A
		PUSH	HL		;save low memory pointer
		LD	HL,(MODSTA)	;p/u end addr of module
		INC	HL
		INC	HL
		LD	E,(HL)
		INC	HL
		LD	D,(HL)
		INC	DE		;bump to byte AFTER module
		POP	HL
		OR	A
		SBC	HL,DE		;check if module after current
		JR	NZ,NOREM	;cant release mem
		LD	HL,$-$
POINTER		EQU	$-2
		LD	DE,(MODSTA)
		LD	(HL),E
		INC	HL
		LD	(HL),D
		JR	RECLA		;RECLAIMED
REMOVE5		LD	B,0		;determine if memory can be reclaimed
		LD	HL,0
		SVC	@HIGH$
		INC	HL		;point to protected byte
		OR	A
		LD	DE,0		;p/u start of module
		BACKREF	MODSTA,2
		SBC	HL,DE		;same?
		JR	NZ,NOREM	;if not, can't reclaim memory
		INC	DE		;else, point to Last Byte address in
		INC	DE		;   module
		LD	A,(DE)		;get it
		LD	L,A
		INC	DE
		LD	A,(DE)
		LD	H,A
		LD	B,0		;reset HIGH$ to it
		SVC	@HIGH$
		JR	NZ,NOREM	;go if can't change HIGH$
RECLA		LD	HL,RECLAIM	;else, display OK
		LD	IX,CANTREL
		BACKREF	NOREM,3
		JP	BYE
;
;Slot number must be in A
;
CHKSLOT		GENSVCA
		INC	HL		;bump to MSB of SVC vector
		LD	A,(HL)
		CP	25H		;< 26h?
		RET	NC		;error if > 25h
		CP	13H		;< 13h?
		RET	C		;error if < 13h
		CP	A		;else, force Z flag
		RET
;
;Copies INCLUDE from workable subroutine to end of memory header.  A relocation
;  is done on each address listed in RELOTAB to relocate it to that space.
;
GENMODULE	LD	HL,INSTALL
		LD	BC,HELLO-INSTALL ;# of bytes in INSTALL
		LD	DE,MODBEG	;where to move it
		LDIR
		LD	(MEND),DE	;save for later
		LD	HL,RELOTAB
		LD	BC,MODBEG-INSTALL ;Calculate offset for relocation
;move absolute addresses from original INSTALL to location of MODBEG.
GENMODULE1	LD	E,(HL)		;get pointer pointed to
		INC	HL
		LD	D,(HL)
		INC	HL		;point to next word
		LD	A,E
		OR	D		;pointer 0?
		RET	Z		;done if so
		PUSH	HL		;save RELOTAB pointer
		EX	DE,HL		;put pointer into HL
		LD	E,(HL)		;get address to relocate
		INC	HL
		LD	D,(HL)
		EX	DE,HL		;address to relocate to HL
		ADD	HL,BC		;relocate to MODBEG
		EX	DE,HL		;relocated address to DE
		LD	(HL),D		;resave to program
		DEC	HL
		LD	(HL),E
		POP	HL		;restore RELOTAB pointer
		JR	GENMODULE1	;loop
;
;Value assumed passed in BC
;
CHKVALUE	LD	A,C		;get LSB
		SUB	124		;down by 124
		OR	B		;add in b
		CP	128-124		;check if mess is less than 4
		JR	NC,CHKVALUE1	;go if not (bad parameter)
		LD	A,C
		LD	(SVCSLOT),A	;save parameter
		CP	A		;else, force Z flag
		RET
CHKVALUE1	OR	1		;force NZ flag
		RET
;
; generate the ASCII slot number
; Requires slot number be in A.
;
PRINTSLOT	LD	L,A		;put into HL
		LD	H,0
		LD	DE,BUFFER	;generate decimal equ.
		SVC	@HEXDEC
		LD	HL,BUFFER+2	;where ASCII data goes
		LD	DE,SLOTVAL
		LD	BC,3		;move 3 bytes
		LDIR
		LD	HL,SLOTDSP	;address of message
		RET
*INCLUDE INSTALL/ASM
HELLO	DB	LF,'INSTALLS - 1.1 - SVC generator program for INSTALL'
	IFEQ	TEST,1
	DB	' *** IN TESTING MODE ***'
	ENDIF
	DB	LF,'(c) 1987 by Shane Dawalt, [71076,511]',LF,CR
BADVERS	DB	'DOS version must be 6.2 or greater',CR
BADSLOT	DB	'Slot number must be 124 thru 127 inclusive',CR
BADPARM	DB	'Illegal parameter',CR
CANTINS	DB	'Can''t install module, ',ETX
CANTINSL: DB	'low memory full',CR
CANTINSH: DB	'HIGH$ changes inhibited',CR
CANTREL	DB	'Cannot release memory space',CR
RECLAIM	DB	'Memory space released',CR
INPLACE	DB	'INSVC located at x''xxxx'' for x''xxxx'' bytes at',ETX
	BACKREF	ADDRMS1,15
	BACKREF	ADDRMS2,27
RESIDENT DB	'INSVC already resident in',ETX
RELINK	DB	'INSVC relinked to',ETX
SLOTDSP	DB	' SVC slot xxx',CR
	BACKREF	SLOTVAL,4
SLOTFULL DB	'Slot occupied: available slots identified below:',LF,9,ETX
PROMPT	DB	LF,LF,'Enter slot number or <BREAK> to exit: ',CR
	BACKREF	PROEND,PROMPT-3		;# of bytes to end of prompt
BREAK	DB	LF,'<break>, module NOT activated.',CR
JCLON	DB	LF,LF,'Enter slot number on command line.',CR
UNLINK	DB	'SVC unlinked from system',CR
BUFFER	DC	5,0			;general purpose buffer
	DB	ETX
PARAMTAB	DB	80H		;begin table
		DB	94H,'SLOT'	;for SLOT parameter
SLOTFLAG	DB	0
		DW	SLOTPARM
		DB	56H,'REMOVE'	;for REMOVE parameter
RMVFLAG		DB	0
		DW	RMVPARM
		DB	53H,'LOW'	;for LOW memory parameter
LDFLAG		DB	0
		DW	LDPARM
		DB	0		;terminate table
;
; Relocation table is next
;
RELOTAB	DW	MODBEG+1,MODBEG+8,MODBEG+13,MODBEG+17,MODBEG+71,MODBEG+74
	DW	MODBEG+81,MODBEG+107,MODBEG+124,MODBEG+127,MODBEG+148
	DW	MODBEG+167,MODBEG+178,MODBEG+181,0
;
;Memory header
;
MODULE	JR	MODBEG
	DW	0			;MODEND (automatically stuffed)
 	DB	5			;module name char count
MODNAME	DB	'INSVC'
	DW	0,0			;words not used but required by system
SVCSLOT	DB	0			;where SVC link number is saved
OLDSVC	DW	0			;contains system SVC vector
MODBEG	EQU	$
	TIME				;stamp file w/ control data
	DATE
	IFGT	MODBEG,2FFFH		;check if out of overlay area
	ERR	'User core violated.'
	ENDIF
	END	START
