;*LIST OFF
;
;INSTALL/ASM  by Shane Dawalt
;	Version 1.0   21 Mar 87
;Updated to:
;	Version 1.1   16 May 87
;	Added: Auto stuffing of module ending address and (optionally) DCB
;		address.
;
;This file is released to public domain by the author.
;To be included with assembly program BEFORE assembly or linked into an
;assembly program.  For usage, see documentation.
;
;	PUBLIC	INSTALL
*MOD
INSTALL	LD	(INS?00D),HL	;Save data for later
	EX	DE,HL
	OR	A
	SBC	HL,DE		;calc # bytes in module
	LD	(INS?01D),HL	;save length
	EX	DE,HL
	LD	(INS?02D),IX
	LD	A,B
	LD	(INS?03D),A	;save in code
	RRA			;DCB flag to carry
	RRA
	JR	NC,INS?10P	;ignore if 0
	INC	HL		;p/u length of module name
	INC	HL
	INC	HL
	INC	HL
	LD	C,(HL)
	LD	B,0		;in BC
	INC	HL
	ADD	HL,BC		;offset to "MODDCB"
	PUSH	IY
	POP	BC		;get DCB
	LD	(HL),C		;stuff it
	INC	HL
	LD	(HL),B
INS?10P	LD	A,0		;**FLAGS SAVING**
INS?03D	EQU	$-1
	RRA		 	;memory flag to carry
	JR	C,INS?00P	;go if hi memory
	LD	DE,'IK'		;get *KI DCB via @GTDCB
	LD	A,52H
	RST	28H
	DEC	HL
	DEC	HL		;HL is Pointer to Low Memory Pointer (PLMP)
	PUSH	HL		;save it
	LD	E,(HL)		;p/u Low Memory Pointer (LMP)
	INC	HL
	LD	D,(HL)
	PUSH	DE
	POP	HL		;LMP -> HL also
	LD	BC,$-$		;**LENGTH OF MODULE**
INS?01D	EQU	$-2
	ADD	HL,BC		;add LMP to length
	INC	HL		;save last byte
	LD	BC,1300H
	SBC	HL,BC		;out of memory?
	JR	NC,INS?01P	;bye if so
	LD	(INS?04D),DE	;where to move to
	CALL	INS?02P		;relocate & move it
	POP	HL		;restore PLMP
	LD	(HL),E		;save new LMP (protect module)
	INC	HL
	LD	(HL),D
INS?20P	LD	HL,(INS?04D)	;where module moved to
	DEC	DE		;point to LAST used byte
	PUSH	HL		;save return data
	INC	HL		;point to "MODEND"
	INC	HL
	LD	(HL),E		;stuff End Of Module pointer
	INC	HL
	LD	(HL),D
	POP	HL		;restore return data
	CP	A		;force Z flag
	RET
INS?01P	POP	HL		;clear stack
	OR	1		;force NZ flag
	RET
INS?00P	LD	HL,0		;get hi mem
	LD	B,0
	LD	A,64H
	RST	28H
	LD	BC,(INS?01D)	;p/u module length
	OR	A
	SBC	HL,BC		;new Hi Mem Pointer (HMP)
	PUSH	HL		;save it
	LD	B,0		;update HIGH$ with HMP
	LD	A,64H
	RST	28H
	JR	NZ,INS?01P	;error if can't change
	POP	DE		;restore HMP
	INC	DE		;point to protected byte
	LD	(INS?04D),DE	;where to move
	CALL	INS?02P		;relocate & move
	JR	INS?20P		;jump to ending
;
;Entry, DE = Address of relocation
;
INS?02P	LD	HL,$-$		;**MODULE START**
INS?00D	EQU	$-2
	EX	DE,HL		;exchange with relocation addr
	OR	A
	SBC	HL,DE		;get offset value
	LD	B,H		;lo memory offset is 2's comp.
	LD	C,L		;offset -> BC
	LD	HL,$-$		;**RELOCATION TABLE**
INS?02D	EQU	$-2
	LD	A,H
	OR	L
	JR	Z,INS?05P	;exit if no table
INS?03P	LD	(INS?02D),HL	;save table pointer
	LD	A,(HL)		;p/u pointer to abs addr
	INC	HL
	LD	H,(HL)
	LD	L,A
	OR	H		;is it 0?
	JR	Z,INS?05P	;return if so (end of table)
	LD	E,(HL)		;p/u addr to relocate
	INC	HL
	LD	D,(HL)
	EX	DE,HL		;save addr pointer in DE
	ADD	HL,BC		;relocate it [add offset]
	EX	DE,HL		;put addr pointer in HL
	LD	(HL),D		;store relocated value
	DEC	HL
	LD	(HL),E
	LD	HL,(INS?02D)	;p/u table pointer
	INC	HL
	INC	HL		;adjust to next pointer
	JR	INS?03P		;loop
INS?05P	LD	DE,0		;**RELOCATION ADDRESS**
INS?04D	EQU	$-2
	LD	BC,(INS?01D)	;amount to move
	LD	HL,(INS?00D)	;what to move
	LDIR
	RET
;*LIST ON
	END
