	TITLE	<XLR8ER LDOS BOOT>
;-------------------------------------------------
; XBOOT -- assist program to initialize the
;	HD64180 CPU in an XLR8er board before
;	attempting to load the MODELA/III file
;	on a 4P.  Assemble this code, and rename
;	it to MODELB/III.  Copy it to your boot
;	diskette for LDOS or TRSDOS 1.3.  When
;	booting "cold" into model 3 mode, hold
;	down the B key when you press reset. Then
;	when you are prompted to press <Enter>,
;	do so and proceed with normal booting
;	procedure, including any special keypress
;	you may require.
;
;	For best results, the directory entry for
;	this file should be in the first directory
;	sector, immediately after that for MODELA/III.
;	This can be achieved by zapping DIR/SYS or
;	by using the INSXBOOT/JCL file.
;
;	Gary Lee Phillips, CIS ID [72425,354]
;	Midsummer, 1987
;-------------------------------------------------
; Define the ports we need to use:
;-------------------------------------------------
DCNTL	EQU	32H		;dma/wait cntl port
RCR	EQU	36H		;refresh cntl port
OPREG	EQU	84H		;memory mapping cntl
BOOT	EQU	9CH		;boot rom cntl port
;-------------------------------------------------
	SPACE	1
	ORG	8000H		;above everything
XBOOT	EQU	$		;else that we use
	DI			;just to be safe
	SPACE	1
; Set up the internal 64180 port values:
	SPACE	1
	LD	B,00H		;simulate in0/out0
	LD	C,RCR		;but z80 compatible
	IN	A,(C)		;get refresh cntl
	OR	02H		;CYC1 = 1
	AND	0FEH		;CYC0 = 0
	OUT	(C),A		;set 40 state refresh
	LD	C,DCNTL		;now get wait state
	IN	A,(C)		;cntl bits and set them
	OR	90H		;MWI1 = 1, IWI0 = 1
	AND	9FH		;MWI0 = 0, IWI1 = 0
	OUT	(C),A		;2 mem waits, 2 i/o
	PAGE
; Set up the 4P memory control ports:
	SPACE	1
	LD	A,01H		;remove memory write
	OUT	(OPREG),A	;protection
	XOR	A		;make sure ROM image
	LD	(3000H),A	;gets (re)loaded
	LD	A,01H		;get boot ROM resident
	OUT	(BOOT),A	;in low memory
	SPACE	1
; Use boot ROM routine to display banner message:
	SPACE	1
	OR	A		;reset Z flag bit
	LD	HL,MVECT	;point to msg block
	RST	18H		;display prompt
	SPACE	1
; Now wait for user to press <Enter>:
; (If you prefer not to have to press a key to continue
; the bootstrap operation, omit the next 3 instructions.
	SPACE	1
KSCAN	EQU	$
	LD	A,(3840H)	;read kbd matrix
	BIT	0,A		;enter key?
	JR	Z,KSCAN		;no, so wait
	SPACE	1
	JP	0005H		;do normal boot
	SPACE	2
MSG1	DB	'XLR8er Boot Assist '
	DB	'version 1.0',00H
MSG2	DB	'  by Gary L. Phillips,'
	DB	' June, 1987.',00H
MSG3	DB	'Press <ENTER> to '
	DB	'continue with bootstrap.',00H
	SPACE	3
MVECT	DW	1*64,MSG1,-2
	DW	2*64,MSG2,-2
	DW	4*64,MSG3,-1
	SPACE	2
	END	XBOOT
