	TITLE	'<SU+ 3.2 HyperBoot Disk Formatter>'
;===================================================================
; HyperBoot disk formatter utility  -   Version 2.10   -   03 Jan 99
; Copyright (c) 1998,99 by Pete Cervasio (cervasio@airmail.net)
;
; Distribute and/or modify freely without changing any copyrights or
; misrepresenting where this came from and whose idea it was!
;-------------------------------------------------------------------
; HyperBoot is my non-trademarked cool name for a way to take the 
; Super Utility 3.2 /CMD files, and re-create a self-booting disk.
;
; Mostly original code by myself.  There are a few pieces of code
; (the track table's layout and the code to set up the track in RAM)
; originally from Kim Watt's utility for creating copy protected
; Super Utility disks.  Also, his code to actually format the disk is
; the basis of what I'm using, though it's been chopped up a bit.
; Other small parts are from the LSDOS (and possibly LDOS, when I
; get the M1/3 part done) FORMAT/CMD utility and LSDOS's floppy
; driver code in SYSRES.  The disk format is somewhat like HyperZap.
;
;-------------------------------------------------------------------
; TO DO:
;	Make this run on a Model I and Model III
;	Allow single-density only (for M1 w/o doubler)
;	Add command line parameters for drive & single/both density
;===================================================================

;-------------------------------------------------------------------
;	Machine selection - Don't change this yet. :)
;-------------------------------------------------------------------
;
@MOD1	EQU	0		; Model I version
@MOD3	EQU	0		; Model III version
@MOD4	EQU	-1		; Model 4 version
;
;	Various equates
;
RETRIES	EQU	3		; Allow 3 tries to write/verify
ETX	EQU	3		; End of text
LF	EQU	10		; Line feed
CR	EQU	13		; Carriage return
BOL	EQU	29		; Go to beginning of line

	IF	@MOD4.OR.@MOD3

WRNMIPORT EQU	0E4H		; NMI mask register
FDCCMD	EQU	0F0H		; FDC Command port (write)
FDCSTAT	EQU	0F0H		; FDC Status port (read)
TRKREG	EQU	0F1H		; FDC Track port (r/w)
SECREG	EQU	0F2H		; FDC Sector port (r/w)
DATREG	EQU	0F3H		; FDC Data port (r/w)
DSELCT	EQU	0F4H		; Drive select port

	ELSE

DSELCT	EQU	37E0H		; Drive select port
FDCCMD	EQU	37ECH		; FDC Command port (write)
FDCSTAT	EQU	37ECH		; FDC Status port (read)
TRKREG	EQU	37EDH		; FDC Track port (r/w)
SECREG	EQU	37EEH		; FDC Sector port (r/w)
DATREG	EQU	37EFH		; FDC Data port (r/w)

	ENDIF
;
;
;-------------------------------------------------------------------
;	Get Model I/III/4 comatibility macros, set the origin and
;	any machine/system dependent equates
;-------------------------------------------------------------------
;
	IF	@MOD4
*GET	SVCMAC			; Get LSDOS SVC macros
@NMI	EQU	0066H		; Model 4 NMI address
	ORG	2600H		; Start low.
	ENDIF

	IF	@MOD1
*GET	LDOS1MAC		; Model 1 LDOS CALL macros
@NMI	EQU	????		; Need to figure this out
	ORG	5200H
	ENDIF

	IF	@MOD3
*GET	LDOS3MAC		; Model III LDOS CALL macros
@NMI	EQU	404AH		; Model III NMI address
	ORG	5200H
	ENDIF
;
;-------------------------------------------------------------------
;	START - Program entry point
;-------------------------------------------------------------------
;
START	LD	(SAVESP),SP	; Save initial stack
	@@DSPLY	HELLO$		; Greet the user
;
;	Clear out unused memory (this seems to help)
;
	LD	HL,0		; HL=0 to get value
	LD	B,0		; B=0 to get HIGH$
	@@HIGH$			; Get it
	LD	BC,PGMEND	; HL=EOMEM, BC=EOPROG
	XOR	A		; Clear carry
	SBC	HL,BC		; # bytes to clear
	LD	B,H		; Move it to BC
	LD	C,0		; Minus a little extra
	LD	HL,PGMEND	; Std mem clearing thing
	LD	DE,PGMEND+1
	LD	(HL),A
	LDIR
;
;	Grab the original NMI pointer for later use, as
;	we mess with this during formatting.
;
	LD	HL,(@NMI+1)	; Get old NMI address
	LD	(SAVENMI),HL	; Save for fixup later
;
;	Program loops here
;
LOOPIT	LD	SP,SAFESP	; Paranoia - Reset stack pointer
	CALL	GETDRV		; Get the drive to format
	JP	C,BRKOUT	; Abort on break
;
;	Prompt for the disk, then format and verify it
;
PMTDSK	@@DSPLY	LOADIT$		; "Gimme a disk!"
	CALL	GETENT		; "Press enter or break"
	JP	C,BRKOUT	; Abort if break pressed
	CALL	DOFORM		; Format the disk
	JR	NZ,DISBAD	; Bad disk if NZ
	CALL	DOVERF		; Verify the disk
DISBAD	CALL	NZ,SHOWBAD	; If it's bad, say so
	CALL	RESTDCT		; Fix our DCT changes
;
	@@DSPLY	DOMORE$		; Do another one?
	CALL	GETYN		; Get Y, N or BREAK
	JR	Z,LOOPIT	; Loop if yes
	JR	GOODBYE		; Otherwise done.
;
;	BRKOUT - Come here when BREAK pressed
;
BRKOUT	@@DSPLY	BRKDET$		; "Break pressed!"
	LD	HL,-1		; Set error flag
	DB	0DDH		; Ignore next instr
;
;	GOODBYE - Normal exit from the program
;
GOODBYE	LD	HL,0		; Clear exit code
	PUSH	HL		; Save it for a sec...
	LD	HL,(SAVENMI)	; Get original NMI addr
	LD	A,H		; Sanity check!
	OR	L		; Was it saved?
	JR	Z,BYE01		; Skip if not, else
	LD	(@NMI+1),HL	;   put back what we found.
BYE01	POP	HL		; Get exit code back
	LD	SP,(SAVESP)	; Get stack pointer back
	@@EXIT			;   and go away
;
;-------------------------------------------------------------------
;	GETDRV - Get the drive to format from the user
;-------------------------------------------------------------------
;
GETDRV	@@DSPLY	GETDRV$		; Ask user for drive
	LD	HL,INPBUF
	LD	BC,1<8!0	;1 char string length
	@@KEYIN
	RET	C		; Exit if BREAK pressed
	LD	A,B
	OR	A		; Anything entered?
	JR	NZ,GETDR0
;
	CALL	MUSTHAV		; Must have input!
	RET	C		; Quit on break
	JR	GETDRV		; Try again
;
GETDR0	LD	A,(HL)		; Get char entered
	LD	(DSTDRV$),A	; Save it in the messages
	LD	(DSTDR1$),A
	LD	(DSTDR2$),A
	SUB	'0'		; Convert to binary
	JR	C,GETDRV	; Go back if too low
	CP	8
	JR	NC,GETDRV	;   or if too high
	LD	(DESTDRV),A	; Save it in binary form
;
;	Get drive's DCT and make sure it's enabled.
;
	LD	C,A		; Logical drive number to C
	@@GTDCT
	LD	A,(IY+0)	; Make sure it's enabled!
	CP	0C3H		; JP stored there?
	JR	Z,GETDRV1	; Continue if so
	@@DSPLY	DISABL$		; Otherwise complain
	JR	GETDRV		;   and try again
;
;	Make sure it's not a hard drive partition
;
GETDRV1	BIT	3,(IY+3)	; Set up as a hard disk?
	JR	Z,GETDRV2	; We're fine if not
	@@DSPLY	NOTHD$		; Otherwise complain about it
	JR	GETDRV		;   and try again
;
;	Make sure the controller can do DDEN.  This isn't smart
;	enough to handle SDEN only, yet.  Maybe version 3 will be.
;
GETDRV2	BIT	6,(IY+4)	; Controller can do DDEN?
	JR	NZ,GETDRV3	; Continue if okay
	@@DSPLY	NOTDD$		; Sorry. I'm not that smart.
	JR	GETDRV		;   Please try again.
;
;	Make sure the "alien controller" bit isn't set
;
GETDRV3	BIT	4,(IY+4)	; Is it a space-alien?
	JR	Z,GETDRV4	; It's good that it's not
	@@DSPLY	ALIEN$		; Can't use martian controllers!
	JR	GETDRV		;   Do you have another?
;
GETDRV4	BIT	7,(IY+3)	; Software WP?
	JR	Z,GETDRV5	; Go if not
	@@DSPLY	SOFTWP$		; Complain
	JR	GETDRV		;   and try again
;
;	Drive passes the tests.  Save DCT pointer and return.
;
GETDRV5	CALL	COPYDCT
	RES	4,(IY+03H)	; Set to use side 0
	RES	5,(IY+04H)	; Set to 1 sided
	LD	A,(IY+4)	; Get drive select
	AND	0FH		; Mask off other stuff
;	OR	40H		; Set wait states (No, don't)
	LD	(PHYDRV),A	; Save DSEL bits for later
	LD	A,39		; Set 40 tracks
	LD	(IY+06H),A
	XOR	A		; Set Z status
	RET
;
;-------------------------------------------------------------------
;	MUSTHAV - Tells user the entry needs input (or break)
;-------------------------------------------------------------------
;
MUSTHAV	@@DSPLY	MUSTHV$		; Gripe at the user
GETENT	@@DSPLY	GETENT$		; Ask for an ENTER key
GETENT1	@@KEY
	CP	13		; Enter?
	RET	Z
	CP	80H		; BREAK?
	JR	NZ,GETENT1	; Loop if not
	SCF			; Else set carry flag
	RET			;   and go back

;-------------------------------------------------------------------
;	SHOWBAD - Say that the disk is bad.  Get enter.
;-------------------------------------------------------------------
;
SHOWBAD	@@DSPLY	BADISK$		; "Disk bad"
	RET			; No need for anything else
;
;-------------------------------------------------------------------
;	GETYN - Get <Y>es, <N>o or <BREAK> and return Z/NZ/C status
;-------------------------------------------------------------------
;
GETYN	PUSH	DE		; Save DE
	@@KEY			; Get single keypress
	POP	DE
	LD	C,A		; Save it
	CP	80H		; BREAK pressed?
	JR	NZ,GETYN1	; Skip if not
	SCF			; Return CY status
	RET
;
GETYN1	OR	20H		; Convert to lower case
	CP	'y'		; Yes?
	JR	Z,YPRESS	; Return Z status
	CP	'n'		; No?
	JR	NZ,GETYN	; Loop back if not
	OR	0FFH
;
YPRESS	PUSH	AF		; Save status
	LD	C,A
	@@DSP			; Show character
	LD	C,CR		; Force newline
	@@DSP
	POP	AF		; Get status back
	RET			;   and return
;
;===================================================================
;	DOFORM - Format an entire disk - Return Z on completion if
;	the format was successful.  Return NZ on errors.
;===================================================================
;
DOFORM	XOR	A		; Start at track 0
	LD	(CURRTRK),A	; Save it
	CALL	SETSDEN		; Do the density setup
	LD	DE,0
	CALL	SELECT
	CALL	RESTORE		; Restore to track 0
	RET	NZ		; Error!
;
FORMLP	LD	A,(CURRTRK)	; Get current track
	LD	D,A		; That goes in D
	LD	E,0		; Fake sector # to E
;
FRMLP2	PUSH	BC		; Save registers...
	PUSH	DE
	PUSH	HL
	CALL	FIXTRKS		; Fix up track #s in table
	CALL	BUILD		; Build track image in memory
	POP	HL		; Then get regs back
	POP	DE
	POP	BC
	CALL	WRITETR		; Write track to disk
	RET	NZ		; Abort on an error
;
	LD	A,(CURRTRK)	; Get the current track #
	INC	A		; Make it the next one
	LD	(CURRTRK),A	; Save new track number
	CP	40		; Are we done yet?
	JR	NC,FRMLP3	; Get out if we are
	CALL	STEPIN		; Step in
	CALL	TSTBSY		; Wait til done
	JR	FORMLP		; and loop for another
;
FRMLP3	LD	A,(DESTDRV)
	LD	C,A		; Set drive again
	CALL	RESTORE		; Seek to track 0
	CALL	TSTBSY		; Wait until not busy
	XOR	A		; Set Z (good) status
	RET			;   and go back to main
;
;-------------------------------------------------------------------
;	FIXTRKS - Fix track numbers in the sector table
;-------------------------------------------------------------------
;
FIXTRKS	PUSH	HL		; Save regs
	PUSH	BC
	LD	HL,FIXTKNS	; Point to table
;
FXTKLP1	LD	C,(HL)		; Get address into BC
	INC	HL
	LD	B,(HL)
	INC	HL
	LD	A,B		; Are we done?
	OR	C
	JR	Z,FXTKLP2	; Go if we are
	LD	A,(CURRTRK)	; p/u curr track
	LD	(BC),A		; set in sector entry
	JR	FXTKLP1		; loop til done
;
FXTKLP2	POP	BC		; Get regs back
	POP	HL
	RET
;
;-------------------------------------------------------------------
;	BUILD - Sets up a track image in memory
;-------------------------------------------------------------------
;
BUILD	LD	A,(CURRTRK)	; Get track
	LD	C,A
	SLA	C		; Times 2
	LD	B,0		; BC = offset in table
	LD	HL,TTABLE	; Start of track table
	ADD	HL,BC		; HL = indirect address
	LD	E,(HL)		; Get LSB
	INC	HL		; Table +1
	LD	D,(HL)		; Get MSB - DE => table
	EX	DE,HL		; HL => table
;
	PUSH	HL		; Pass table addr to IX
	POP	IX		; IX => SDEN length (bytes)
	INC	HL		; Bump past length
	INC	HL		; HL => sector data
	LD	DE,BUFFER	; DE => I/O buffer
;
;	Create the track image in memory
;
SECLP	LD	A,(HL)		; Get a byte
	INC	A		; FF terminator?
	RET	Z		; yes, done!
	INC	A		;
	CALL	MOVE		; fill
	JR	SECLP		; go till done
;
;	Move bytes to buffer
;
MOVE	LD	B,(HL)		; Get byte count
	INC	HL		; Bump table
	LD	A,(HL)		; Get fill byte
	INC	HL		; Bump table
FILL	LD	(DE),A		; Char to buffer
	INC	DE		; Bump buffer pointer
	DJNZ	FILL		; Go till done
	RET			; Buffer filled
;
;-------------------------------------------------------------------
;	TSTBSY - Reselect drive while controller is busy
;-------------------------------------------------------------------
;
TSTBSY	LD	A,10H		; Was 0CH - 10H seems to work better
TSTB01	DEC	A		;   for a short delay
	JR	NZ,TSTB01
	LD	A,(PHYDRV)	; Pickup drive select bits
	OUT	(DSELCT),A	;   & reselect
	IN	A,(FDCSTAT)	; Read FDC status reg
	BIT	0,A		; Busy?
	RET	Z		; Return if not
	JR	TSTBSY		; Loop until not busy
;
;-------------------------------------------------------------------
;	TSTTK0 - Wait for track 0 (longer delay for type 1 cmd)
;-------------------------------------------------------------------
;
TSTTK0	LD	A,25		; Short delay
TSTTK01	DEC	A		;   but longer than TSTBSY
	JR	NZ,TSTTK01
TSTTK02	LD	A,(PHYDRV)	; Pickup drive select
	OUT	(DSELCT),A	;   & reselect
	IN	A,(FDCSTAT)	; Get FDC status
	AND	4		; Mask off other bits
	CP	4		; Want Z/NZ status
	RET	Z		; Return if we're there
	JR	TSTTK02		; Loop until idle

;
;-------------------------------------------------------------------
;	SELECT - Select the drive and make sure the motor is on
;-------------------------------------------------------------------
;
SELECT	CALL	TSTBSY		; Wait until not busy
	IN	A,(FDCSTAT)	; Read status
	AND	80H		; Check if motor on
	PUSH	AF		; Save motor state
	LD	A,(PHYDRV)	; Get drive select
	BIT	6,(IY+3)	; Doing DDEN?
	JR	Z,SELCT1	; Go if not
	OR	80H		; else merge DDEN bit
SELCT1	OUT	(DSELCT),A	; Select the drive
	LD	(PHYDRV),A	; Save it
	POP	AF		; Get motor status
	RET	Z		; Exit if motor running
;
	PUSH	BC		; Save BC
	LD	BC,2000H	; Give a bit of delay
	@@PAUSE
	POP	BC		; 
	JR	SELECT		; Check for motor now
;
;-------------------------------------------------------------------
;	SETDRV - Setup the drive's density flag in the DCT
;-------------------------------------------------------------------
;
SETDRV	LD	A,(CURRDEN)	; Get density we're doing now
	OR	A		; Which are we doing?
	JR	NZ,SETDDEN	; Go if double
;
;	SETSDEN - Set DCT+3 byte to single density mode
;
SETSDEN	RES	6,(IY+3)	; Force Density to single
	LD	A,(PHYDRV)	; Get drive select bits
	AND	0FH		; Mask off dden (if set)
	LD	(PHYDRV),A	; Save it back
	XOR	A		; Clear our idea of it
	JR	SETDD01
;
;	SETDDEN - Set DCT+3 byte to double density mode
;
SETDDEN	SET	6,(IY+3)	; Set Density flag
	LD	A,(PHYDRV)	; Get drive select bits
	OR	80H		; Merge DDEN bit
	LD	(PHYDRV),A	; Save it back
	LD	A,0FFH		; and set our idea of it
SETDD01	LD	(CURRDEN),A
	XOR	A		; Set NZ state
	RET			; Done
;
;-------------------------------------------------------------------
;	RESTORE - Send the disk to track 0
;-------------------------------------------------------------------
;
RESTORE	CALL	RSTR01		; Do the restore
	CALL	TSTTK0		; Wait for track 0 bit to show up
	RET			; Okay, we're done.

RSTR01	PUSH	BC		; Save this
	LD	A,(DESTDRV)	; Get the drive we're using
	LD	C,A		; Drive # in C
	XOR	A
	LD	(IY+5),A	; Set track to 0
	LD	(CURRTRK),A	;
	LD	B,0BH		; FDC restore (40 ms)
	JR	SEEKAA
;
;-------------------------------------------------------------------
;	SEEK - Seek track # in D
;-------------------------------------------------------------------
;
SEEK	PUSH	BC		; Save BC
	CALL	TSTBSY		; Wait until not busy
	IN	A,(TRKREG)	; What does the FDC think?
	LD	B,A
	LD	A,(IY+5)	; Get current cylinder
	CP	B		; The same??
	JR	NZ,SEEK01	; Go if we really need to
	POP	BC		;   else get BC back,
	CALL	SELECT		;   reselect the drive,
	RET			;   and return
;
SEEK01	OUT	(TRKREG),A	; Set FDC to track we want
	LD	A,E		; Get sector
	OUT	(SECREG),A	; Send it to FDC, too
	LD	A,D
	OUT	(DATREG),A	; Set desired track to FDC
	LD	(CURRTRK),A	; Save it for later
	LD	(IY+5),A	; Update current cyl in DCT
	LD	A,(DESTDRV)	; Get current drive
	LD	C,A		; Set into C
	LD	B,1BH		; Seek without verify command
SEEKAA	CALL	SELECT		; Select drive
	LD	A,(IY+3)
	AND	3		; Strip all but step rate
	OR	B
PASSCMD	OUT	(FDCCMD),A	; Give FDC its command
	LD	B,1CH		; Delay time
	DJNZ	$		; Wait a bit
	XOR	A		; Z-flag for return
	POP	BC		; Recover the BC reg
FDCRET	RET
;
;-------------------------------------------------------------------
;	STEPIN - Do a stepin command
;-------------------------------------------------------------------
;
STEPIN	PUSH	BC
	LD	A,(CURRTRK)	; Get the current track
	LD	(IY+5),A	; Keep the DCT current
	CALL	TSTBSY		; Make sure the FDC isn't busy
	LD	B,5BH		; Step in, load head, update
	JR	SEEKAA		; Jump into the seek routine
;
;-------------------------------------------------------------------
;	WRITETR - Write track out to the disk (Kim's stuff, sort of)
;		AF' gets trashed by this routine.
;-------------------------------------------------------------------
;
WRITETR	LD	A,(IY+4)	; Get drive select address
	AND	0FH		; Mask off other bits
	LD	D,A		;   and puts it in D, too
;
RWCOMM	LD	A,RETRIES	; Get # retries
	LD	(CURRTRY),A	; Init for this track
	CALL	SHOWRTR		; Say what we're doing
;
;	Loop for # retries (unless no error)
;
WRITLP	LD	A,(CURRTRK)	; Get track
	LD	D,A
	PUSH	BC
	CALL	TRWRITE		; Write the track
	POP	BC
;
;	Test status after write...
;
	JR	NZ,WRERROR	; Go on error
	JP	FIXNMI		; Done, fix and return
;
;	Error - check retries
;
WRERROR	EX	AF,AF'		; Else save error
	LD	A,(CURRTRY)	; Get retry count
	DEC	A		; Decrement it
	LD	(CURRTRY),A	; Save it back
	JR	NZ,WRITLP	; go if retries left
	CALL	FIXNMI		; Fix the NMI stuff we did
	EX	AF,AF'		; else get NZ back
	RET			; return with error flag
;
;-------------------------------------------------------------------
;	DSKSLO - Send command w/short wait for valid status
;-------------------------------------------------------------------
;
DSKSLO	EQU	$
;	IF	@MOD3.OR.@MOD4
	OUT	(FDCCMD),A	; Issue FDC command
	LD	A,22		; Delay count
;	ELSE
;	LD	(37ECH),A	; Send to M1 FDC
;	LD	A,13		; Delay count
;	ENDIF
DSKSLO1	DEC	A		; Decr counter
	JR	NZ,DSKSLO1	; Wait for count
	RET			; Then return
;
;-------------------------------------------------------------------
;	TRWRITE - Routine to do the actual track writing
;-------------------------------------------------------------------
;
TRWRITE	LD	(SPSAVE),SP	; Save current stack
	CALL	SETNMI		; Setup for NMI exit
;	LD	BC,0<8!DATREG	; Counter, I/O port (2.10 do elsewhere)
	INC	E		; Set mask = 3
	LD	HL,BUFFER	; Where we're writing from
	LD	A,0F0H		; Write track command
	CALL	DSKSLO		; Send with short delay
;
TRW1	IN	A,(FDCSTAT)	; Read FDC status
	AND	E		; Check if ready
	JP	PO,TRW1		; Loop if not
	OUTI			; Send byte
	DEC	E		; Set mask = 2
;
TRW2	IN	A,(FDCSTAT)	; Read FDC status
	AND	E		; Check if ready
	JR	Z,TRW2		; Loop again
	OUTI			; Another byte to  FDC
;
	LD	B,D		; Grab select code
	LD	E,(IX+0)	; Get SDEN byte count into
	LD	D,(IX+1)	;   DE reg pair
;
TRW4	LD	A,B		; Get select command
	OUT	(DSELCT),A	; Select drive
	OUTI			; Anouther data byte out
	LD	B,A		; Pass back from OUTI
	DEC	DE		; Decrement SDen count
	LD	A,D		; Still writing SDEN?
	OR	E
	JR	NZ,TRW4		; Loop for SDen bytes
;
	LD	A,B		; Get select/wait bites
	OR	0C0H		; Add DDEN and WAIT bits
TRW5	OUT	(DSELCT),A	; Select drive again
	OUTI			; Now keep writing bytes
	JR	TRW5		; Until an interrupt
;
;-------------------------------------------------------------------
;	SETNMI - Temporarily take over the NMI vector
;-------------------------------------------------------------------
;
SETNMI	IN	A,(FDCSTAT)	; Clear FDC status
	LD	BC,RETNMI	; New NMI return vector
	LD	(@NMI+1),BC	; Set address part
	LD	A,0C3H		; JP opcode
	LD	(@NMI),A	; Set into vector as well
;
	LD	BC,DATREG	; B=0, C=I/O port
	LD	A,(IY+4)	; Get drive select bits
	AND	0FH		; Mask off all other bits
	OR	40H		; Set wait
	LD	D,A		; Save that in D
	LD	A,(CURRTRK)	; Get current track
	CP	23		; < 23?
	LD	A,0		; Init for no precomp
	JR	C,NOTG23	; Go if none needed
	LD	A,20H		;   else load pre-comp bit
NOTG23	OR	D		; Merge with select
	OUT	(DSELCT),A	; Select drive
	OR	40H		; Set wait bit
	LD	D,A		; Pass it
	LD	E,2		; Set bit 1 for test
	DI			; Disable ints for xfer
	LD	A,0C0H		; Enable NMI
	OUT	(WRNMIPORT),A	; Do it
	RET			; Done, return
;
;-------------------------------------------------------------------
;	RETNMI - return from NMI vector
;-------------------------------------------------------------------
;
RETNMI	XOR	A		; Load zero
	OUT	(WRNMIPORT),A	; Disable any more NMI's
	LD	HL,NMIRET	; Non-disk NMI's
	LD	(@NMI+1),HL	; Save fixed address
	IN	A,(FDCSTAT)	; Read status
	PUSH	AF		; Save status
	LD	A,0D0H		; Reset FDC
	OUT	(FDCCMD),A	; Assure terminated cmd
	PUSH	BC
	LD	BC,50
	@@PAUSE
	POP	BC
	IN	A,(FDCSTAT)
	POP	AF		; Restore status
NMICOMM	OR	A		; Check for errors
	LD	SP,(SPSAVE)	; Fix our return location
	EI			; Can enable these now
	RET			; Return with status
;
SPSAVE	DS	2		; Place to save the stack pointer
;
NMIRET	RETN			; non-disk
;
;-------------------------------------------------------------------
;	FIXNMI - Put the NMI vector back the way it was!!!!
;-------------------------------------------------------------------
;
FIXNMI	DI			; Not now, please
	PUSH	HL		; Save this register pair
	PUSH	AF		;   and status
	LD	HL,(SAVENMI)	; Get where it should be
	LD	(@NMI+1),HL	; Set the old location
FIXNM2	LD	A,0C0H		; Enable NMI
	OUT	(WRNMIPORT),A	; Enabled!
	POP	AF		; Get status back
	POP	HL		;   and HL
	EI			; Interrupts can go back on
	RET			; Okay, we're done
;
SAVENMI	DW	0		; Saves the real NMI addr.
;
;-------------------------------------------------------------------
;	SHOWRTR - Show what we're formatting
;-------------------------------------------------------------------
;
SHOWRTR	PUSH	HL		; Save the registers because this
	PUSH	DE		;   would clobber them.
	PUSH	BC
	PUSH	AF
	LD	HL,(CURRTRK)	; Get current track
	LD	DE,FMTTRK$	; Location in string
	LD	B,2		; 2 byte buffer
	@@HDEC			; Track # to decimal in msg
	@@DSPLY	FMTMSG$		; Show the message
;
	POP	AF
	POP	BC		; Okay, get it all back
	POP	DE
	POP	HL
	RET
;
;===================================================================
;	DOVERF - Verify - Return Z flag if disk is okay
;===================================================================
;
DOVERF	LD	C,CR		; Start on next line
	@@DSP
	XOR	A		; Start at track 0
	LD	(CURRTRK),A	; Save it
	LD	(CURRDEN),A	; Set single density flag
	CALL	SETDRV		; Do the density setup
	CALL	RESTORE		; Restore to track 0
	RET	NZ		; Error!
;
;	Read track 0 and make sure it's okay
;
	LD	DE,0000H	; Track 0, Sector 0
	CALL	SHOVRTR
	CALL	READSEC		; Try to read it
	RET	NZ		; Quit on error
	LD	HL,DEFBOOT	; Get default boot sector
	CALL	WRITSEC		; Write it to M1 loc'n
	RET	NZ		; Abort on error
;
	LD	A,43H		; Patch boot for Model III
	LD	HL,DEFBOOT+XXBT01-4200H
	LD	(HL),A		; (which we'll get to)
	LD	HL,DEFBOOT+XXBT02-4200H
	LD	(HL),A
	LD	A,0C3H		; JP instruction
	LD	HL,DEFBOOT+HOLD2-4200H
	LD	(HL),A		; Store in reboot code
;
;	Now read the rest of the SDEN part of track 0
;
	LD	DE,0002H	; Start at sec 2
VRLUP0	CALL	READSEC		; Read the sector
	RET	NZ
;
	PUSH	DE		; Save trk/sec
	PUSH	BC		; Save drive
	LD	HL,BUFFER	; Point to buffer
	PUSH	HL		; Save that
	LD	DE,BUFFER+1	; Clear the buffer
	LD	BC,255
	LD	(HL),0
	LDIR
	POP	HL		; HL = buffer again
	POP	BC		; Get drive back
	POP	DE		; And track/sector
	CALL	WRITSEC		; Write zeros to disk

	INC	E		; Bump sector number
	LD	A,E		; Done yet?
	CP	10
	JR	C,VRLUP0	; Loop until done
;
;	Finally (for track 0) do sector 1 in DDEN
;
	CALL	SETDDEN		; Quick force DDEN
	LD	DE,0001H
	CALL	READSEC
	RET	NZ
	LD	HL,DEFBOOT	; Model III setup now
	CALL	WRITSEC		; Write to disk
	RET	NZ		; Abort on write error
;
;	Now, we do the program/loader tracks (1 to 39)
;
VRLOOP	INC	D		; Bump track
	LD	A,D
	LD	(CURRTRK),A	; Save it
	CP	40
	JR	Z,VERDUN	; Return if all done
	CALL	SETSDEN		; Set SDEN
	CALL	SHOVRTR		; Say where we are
	CALL	SECLOOP		; Read SDEN sectors
	RET	NZ
	CALL	SETDDEN		; Set DDEN flag
	CALL	SHOVRTR		; Say where we are
	CALL	SECLOOP		;   and read those too
	RET	NZ
	JR	VRLOOP		; Loop until done
;
VERDUN	CALL	RESTORE		; Go to track 0
	CALL	TSTTK0		; Wait until we're there
	RET
;
;-------------------------------------------------------------------
;	SECLOOP - Read sectors 6 downto 1 & return status
;-------------------------------------------------------------------
;
SECLOOP	LD	B,6		; Init counter
SECLP1	LD	E,B		; Set sector number
	LD	A,(CURRTRK)	; Make sure track is set
	LD	D,A
	CALL	READSEC		; Attempt a read
	RET	NZ		; Abort on an error
	DJNZ	SECLP1		; Loop for # of sectors
	RET			; and return
;
;-------------------------------------------------------------------
;	READSEC - Read a sector and return Z/NZ status
;-------------------------------------------------------------------
;
READSEC	CALL	SETDRV		; Force density to be right
	LD	A,(DESTDRV)	; Logical drive to C
	LD	C,A
	LD	HL,BUFFER	; Set I/O buffer
	@@RDSEC			; Read the sector
	JR	Z,READSC2	; Go if "okay"
	CP	6		; Ignore "system sector" errors
	JR	Z,READSC2
	RET			; Something else - error!
;
READSC2	CALL	CHKDEN		; Make sure we're on the right one!
	RET			; Return status
;
;-------------------------------------------------------------------
;	CHKDEN - Make sure LS-DOS hasn't switched densities on us
;-------------------------------------------------------------------
;
CHKDEN	LD	A,(CURRDEN)	; Get *our* density flag
	OR	A		; What should it be?
	JR	Z,CHKSDEN	; Go check for SDEN still set
;
CHKDDEN	BIT	6,(IY+3)	; DDen bit still set?
	JR	NZ,DDENOK	; Go if it is
	SET	6,(IY+3)	; Force it back on!
	OR	1		; Set NZ return
	RET
;
DDENOK	XOR	A		; Set Z return
	RET
;
CHKSDEN	BIT	6,(IY+3)	; Still set?
	RET	Z		; Go back if okay
	RES	6,(IY+3)	; Otherwise fix it
	OR	1		;   and set NZ return
	RET
;
;-------------------------------------------------------------------
;	SHOVRTR - Show what we're verifying
;-------------------------------------------------------------------
;
SHOVRTR	PUSH	HL		; Save the registers because this
	PUSH	DE		;   would clobber them.
	PUSH	BC
	PUSH	AF
	LD	HL,(CURRTRK)	; Get current track
	LD	DE,VERTRK$	; Location in string
	LD	B,2		; 2 byte buffer
	LD	A,95		; @HDEC
	RST	28H
	@@DSPLY	VERMSG$		; Show the message
	LD	A,(CURRDEN)	; Get current density
	OR	A		; Single?
	JR	Z,SHOVRT1	; Go if it is
	LD	C,'D'		; Add a "D"
	@@DSP
	JR	SHOVRT2		; And get out
;
SHOVRT1	LD	C,'S'		; Add an S
	@@DSP
;
SHOVRT2	POP	AF		; Okay, get it all back
	POP	BC
	POP	DE
	POP	HL
	RET
;
;-------------------------------------------------------------------
;	WRITSEC - Write a sector to disk
;-------------------------------------------------------------------
;
WRITSEC	@@WRSEC			; Write sector
	RET	NZ		; Return if error
	CALL	CHKDEN		; Check density still okay!
	RET			; Return that status
;
;===================================================================
;	DEFBOOT	- Default boot sector written to track 0, on both
;	sectors 0 and 1.  Patched for 43xxH load before writing to
;	sector 1, since that's where the Model III loads its boot.
;	This is NOT the one that HBCREATE will put on the disk!
;===================================================================
;
DEFBOOT	EQU	$
CORE$	DEFL	$
;
	ORG	4200H		; Execute at ROM boot
	LORG	CORE$		;   but load here
;
	NOP
	CP	03H		; "dir" track (hah!)
	DI			; No interruptions, okay?
	DC	12,0
	LD	DE,80*11+0F413H	; Mod 4 vid loc
	LD	HL,BOOTDSK$	; Xfer error to video
XXBT01	EQU	$-1
	LD	BC,BSTRLEN
	LDIR
	LD	DE,64*8+3C00BH	; Mod I/III vid loc
	LD	HL,BOOTDSK$	; Xfer error to video
XXBT02	EQU	$-1
	LD	BC,BSTRLEN
	LDIR
BOOTLUP	LD	A,(3840H)	; read keyboard
	RRCA			; enter pressed?
	JR	NC,BOOTLUP	; wait till yes
HOLD2	HALT			; re-boot Model I
	DW	0		; Hold 00s for M3 JP
;
BOOTDSK$ DB	'CANNOT BOOT - HYPERBOOT DISK NOT FINISHED!'
BSTRLEN	EQU	$-BOOTDSK$
	DC	-$&0FFH,0
;
;===================================================================
;
	ORG	CORE$+256	; Fix our location
	LORG	CORE$+256
;
;-------------------------------------------------------------------
;	COPYDCT - Make backup copy of current drives DCT table
;	  Entry:  IY -> DCT of selected drive
;-------------------------------------------------------------------
;
COPYDCT	PUSH	IY		; Move DCT to into HL
	POP	HL
	LD	DE,DCTSAV$	; Point to our save area
	LD	BC,10		; 10 bytes to move
	LDIR
	LD	A,(IY+4)	; Get DCT byte
	AND	0FH		; Mask off all but drv select
	LD	(PHYDRV),A	; Save drive select bits
	XOR	A
	RET
;
;-------------------------------------------------------------------
;	RESTDCT - Restore original DCT setup for current drive
;-------------------------------------------------------------------
;
RESTDCT	LD	A,(DESTDRV)	; Get drive #
	LD	C,A
	@@GTDCT			; Get DCT for it
	PUSH	IY
	POP	DE		; That's the destination
	LD	HL,DCTSAV$	; Backup is the source
	LD	A,(HL)		; Anything there??
	OR	A
	RET	Z		; Return if not
	LD	BC,10		; Else move the 10 bytes back
	LDIR			;   into the original entry
	RET
;
;===================================================================
;	Data and message area
;===================================================================
;
;	Data storage
;
SAVESP	DW	0		; Store startup stack pointer
DESTDRV	DB	0		; Logical drive # to format (0-7)
CURRTRK	DW	0		; Current track # for format/verify
CURRSEC	DB	0		; Current sector number
CURRDEN	DB	0		; Current density
CURRTRY	DB	0		; Current retries countdown
PHYDRV	DB	0		; Physical drive select bits
DCTSAV$	DC	10,0		; Save area for the DCT

;
;	Messages used by the program
;
	IF	@MOD4
HELLO$	DB	'HBFORM4 - HyperBoot Disk Formatter for Model 4 LS-DOS 6.x - Ver 2.1',LF
	ENDIF
	IF	@MOD3
HELLO$	DB	'HBFORM3 - HyperBoot Disk Formatter for Model 3 LDOS 5.x - v 2.1',LF
	ENDIF
	IF	@MOD1
HELLO$	DB	'HBFORM1 - HyperBoot Disk Formatter for Model 1 LDOS 5.x - v 2.1',LF
	ENDIF
	DB	'Copyright (c) 1998, Pete Cervasio - Distribute freely.',CR
;
FMTMSG$	DB	BOL,'Formatting Drive '
DSTDRV$	DB	'$, Track '
FMTTRK$	DB	'$$',ETX
;
VERMSG$	DB	BOL,'Verifying  Drive '
DSTDR1$	DB	'$, Track '
VERTRK$	DB	'$$ Den: ',ETX

;	Prompts
;
GETDRV$	DB	LF,'Enter logical drive to format (0-7): ',ETX
MUSTHV$	DB	LF,'This entry has no default.  Please supply a valid input.',CR
LOADIT$	DB	LF,'Place a blank diskette in drive :'
DSTDR2$	DB	'$ and press either',CR
GETENT$	DB	'<ENTER> to continue or <BREAK> to abort the program.',CR
DOMORE$	DB	LF,'Would you like to format another disk? <Y/N> :',ETX
;
;	Error messages
;
BRKDET$	DB	LF,'BREAK key detected.  User aborted program.',CR
DISABL$	DB	LF,'That drive is DISABLED.  Another one, please.',LF,CR
SOFTWP$	DB	LF,'That drive is write protected!  Try again.',LF,CR
NOTHD$	DB	LF,'Cannot write to a HARD DISK partition!',LF,CR
ALIEN$	DB	LF,'That drive has a non-standard controller! (reported by DOS)',LF,CR
NOTDD$	DB	LF,'Not set up to handle single density only drives.  Sorry!'
	DB	LF,'Maybe version 3 will be that smart.',LF,CR
BADISK$	DB	LF,'Verify error!  Disk is bad.  Please try another.',CR

;
;	Misc stuff
;
INPBUF	DS	32		; Buffer for user input
;
;-------------------------------------------------------------------
;	Track table - Which sector layout used for each track
;-------------------------------------------------------------------
;
TTABLE	DW	TRAK0		; 00 - BOOT and config/patch data
	DW	TRAK1		; 01 - 80 track loader and logo
	DW	TRAK1		; 02 - 40 track loader and logo
	DW	TRAK1		; 03 - Empty / unused / "dir"
	DW	TRAK1		; 04 - Start of program tracks
	DW	TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1   ;05-11
	DW	TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1   ;12-18
	DW	TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1   ;19-25
	DW	TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1   ;26-32
	DW	TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1,TRAK1   ;33-39
;
;-------------------------------------------------------------------
;	Sector layout tables (from Kim Watt's code, modified)
;	Used to create track images in memory for formatting
;
;	Table layout:
;
;	+00 - +01 - # of single density bytes on the track
;
;	+02 - +03 - Byte count, value to write
;	repeat count/value until 0FFh byte count found
;
;-------------------------------------------------------------------
;	Definition for track 0 (secs 0,2-9 SD, 1 DD)
;-------------------------------------------------------------------
;
TRAK0	DW	2697		;length of single density
;SDEN
	DB	16,0FFH		;post-index
	DB	06,000H		;sync bytes
	DB	01,0FCH		;index mark
;Sector 00
	DB	12,0FFH		;pre-id
	DB	06,000H		;pre-id sync
	DB	01,0FEH		;id address mark
	DB	01,000H		;track
	DB	01,000H		;head
	DB	01,000H		;sector
	DB	01,001H		;sector length
	DB	01,0F7H		;crc byte
	DB	10,0FFH		;pre-data gap
	DB	04,000H		;pre-data sync
	DB	01,0FBH		;data address mark
	DB	00,0E5H		;data fill byte
	DB	01,0F7H		;crc byte
;Sector 02
	DB	12,0FFH
	DB	06,000H
	DB	01,0FEH
	DB	01,000H
	DB	01,000H
	DB	01,006H
	DB	01,001H
	DB	01,0F7H
	DB	10,0FFH
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 03
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
	DB	01,000H		;track
	DB	01,000H		;head
	DB	01,002H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 04
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
	DB	01,000H		;track
	DB	01,000H		;head
	DB	01,007H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 05
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
	DB	01,000H		;track
	DB	01,000H		;head
	DB	01,003H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 06
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
	DB	01,000H		;track
	DB	01,000H		;head
	DB	01,008H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 07
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
	DB	01,000H
	DB	01,000H
	DB	01,004H
	DB	01,001H
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 08
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
	DB	01,000H
	DB	01,000H
	DB	01,009H
	DB	01,001H
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 09
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
	DB	01,000H
	DB	01,000H
	DB	01,005H
	DB	01,001H
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;
	DB	12,0FFH		;gap before density change
;DDEN
;Sector 01
	DB	22,04EH		;pre-id
	DB	12,000H
	DB	03,0F5H
	DB	01,0FEH
	DB	01,000H		;track
	DB	01,000H		;head
	DB	01,001H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	24,04EH		;pre-data
	DB	08,000H
	DB	03,0F5H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
	DB	22,04EH
;
	DB	00,04EH		;filler
	DB	00,04EH
	DB	00,04EH
	DB	-1,-1		;terminator
;
;	Definition for tracks 1 to 39
;	(Sectors 1 to 6 in SD, then 1 to 6 in DD)
;
TRAK1	DEFW	1809		;length single den -2
;
;SDEN part
	DB	16,0FFH		;post-index
	DB	06,000H
	DB	01,0FCH
;Sector 01
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
T1S1S	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,001H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 02
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
T1S2S	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,002H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 03
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
T1S3S	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,003H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 04
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
T1S4S	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,004H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 05
	DB	12,0FFH
	DB	06,000H
	DB	01,0FEH
T1S5S	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,005H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-data
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 06
	DB	12,0FFH		;pre-id
	DB	06,000H
	DB	01,0FEH
T1S6S	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,006H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	10,0FFH		;pre-id
	DB	04,000H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;
	DB	12,0FFH		;before change gap
;DDEN
;Sector 01
	DB	22,04EH		;pre-id
	DB	12,000H
	DB	03,0F5H
	DB	01,0FEH
T1S1D	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,001H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	24,04EH		;pre-data
	DB	08,000H
	DB	03,0F5H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 02
	DB	22,04EH		;pre-id
	DB	12,000H
	DB	03,0F5H
	DB	01,0FEH
T1S2D	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,002H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	24,04EH		;pre-data
	DB	08,000H
	DB	03,0F5H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 03
	DB	22,04EH		;pre-id
	DB	12,000H
	DB	03,0F5H
	DB	01,0FEH
T1S3D	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,003H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	24,04EH		;pre-data
	DB	08,000H
	DB	03,0F5H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 04
	DB	22,04EH
	DB	12,000H
	DB	03,0F5H
	DB	01,0FEH
T1S4D	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,004H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	24,04EH		;pre-data
	DB	08,000H
	DB	03,0F5H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 05
	DB	22,04EH		;pre-id
	DB	12,000H
	DB	03,0F5H
	DB	01,0FEH
T1S5D	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,005H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	24,04EH		;pre-data
	DB	08,000H
	DB	03,0F5H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;Sector 06
	DB	22,04EH		;pre-id
	DB	12,000H
	DB	03,0F5H
	DB	01,0FEH
T1S6D	DB	01,001H		;track
	DB	01,000H		;head
	DB	01,006H		;sector
	DB	01,001H		;length
	DB	01,0F7H
	DB	24,04EH		;pre-data
	DB	08,000H
	DB	03,0F5H
	DB	01,0FBH
	DB	00,0E5H
	DB	01,0F7H
;end filler
	DB	00,04EH
	DB	00,04EH
	DB	00,04EH
	DB	00,04EH
	DB	-1,-1

;
;-------------------------------------------------------------------
;	Fixup table for track numbers in the loader/program track
;	sector definiton table.  Unlike the real SU+, which keeps
;	weird track/sector/head IDs, HyperBoot uses the real track,
;	side and sector numbers on the disk.
;-------------------------------------------------------------------
;
FIXTKNS	DW	T1S6S+1		;SDen sector track IDs
	DW	T1S5S+1
	DW	T1S4S+1
	DW	T1S3S+1
	DW	T1S2S+1
	DW	T1S1S+1
	DW	T1S6D+1		; DDen sector track IDs
	DW	T1S5D+1
	DW	T1S4D+1
	DW	T1S3D+1
	DW	T1S2D+1
	DW	T1S1D+1
	DW	0		; End of the table
;
PGMEND	EQU	$		; End of program
DBUFF	EQU	$&0FF00H	; Last even page
SAFESP	EQU	DBUFF+300H	; Safe place for our stack
BUFFER	EQU	DBUFF+400H	; First free page
;
	END	START

