	TITLE	'<SU+ 3.2 HyperBoot Disk Writer>'
;===================================================================
; HyperBoot disk writing utility   -    Version 2.20   -   06 Jan 99
; Copyright (c) 1998,99 by Pete Cervasio (cervasio@airmail.net)
;
; Distribute and/or modify freely without changing any copyrights or
; misrepresenting where this came from and whose idea it was!
;-------------------------------------------------------------------
; HyperBoot is my non-trademarked cool name for a way to take the 
; Super Utility 3.2 /CMD files, and re-create a self-booting disk,
; which loads VERY fast.  In fact, the boot sector is a highly 
; modified version of the example in the HyperZap manual, which is
; why I am calling this HyperBoot.  :)
;
; This would require extensive changes to run on a Model I or III
; itself, as it does an @LOAD call to get the entire SU1/CMD and 
; SU3/CMD files into memory in a swell foop, and then writes them
; to disk from RAM.
;
; ------------------------------------------------------------------
; TO DO:
;	Add command line parsing for filenames of SU+ /CMD files.
;	Add command line parsing for destination drive.
;	Add option to write just Model I or III sectors.
;	Add an optional verify after write.
;	Make it run on Model I and III machines.
;===================================================================
;
*GET	SVCMAC			; LSDOS 6.x SVC macros
;
	ORG	2600H		; Start this thing low.
;
; ---------------------------------------------------------
;	Some Equates we need for things
; ---------------------------------------------------------
;
ETX	EQU	3
LF	EQU	10
CR	EQU	13
BOL	EQU	29
;
;	These two really aren't needed, as the xfer address
;	is read from the /CMD files.
;
STRTAD1	EQU	0E8DFH		; Default Model I Entry point
STRTAD3	EQU	0E8A9H		; Default Model III entry point
;
M13SCRN	EQU	3C00H		; The real screen address
L13SCRN	EQU	4400H		; Where screen/loaders go
;
LOADAD	EQU	5200H		; SU?/CMD loads from here
;
NPGMTK	EQU	26		; Number of program tracks
;
; ---------------------------------------------------------
;	Floppy Controller addresses
; ---------------------------------------------------------
;	Model I locations
;
DRIVE1	EQU	37E0H		; Drive 0 Motor
COMAND1	EQU	37ECH		; Command register
STATUS1	EQU	37ECH		; Status register
TRACK1	EQU	37EDH		; Track number register
SECTOR1	EQU	37EEH		; Sector number register
DATA1	EQU	37EFH		; Data I/O register
;
;	Model III locations
;
COMAND3	EQU	0F0H		; Command register
STATUS3	EQU	0F0H		; Status register
TRACK3	EQU	0F1H		; Track number register
SECTOR3	EQU	0F2H		; Sector number register
DATA3	EQU	0F3H		; Data I/O register
DRIVE3	EQU	0F4H		; Drive 0 Motor
;
; --------------------------------------------------------------
;	Start this HyperBoot disk writer puppy up!
; --------------------------------------------------------------
;
START	@@DSPLY	HELLO$		; Sign-on message
;
;	Load up SU1/CMD
;
	@@DSPLY	GETSDS$		; "Loading SU1"
;
	LD	HL,SDPRG$	; Program file name
	LD	DE,SDFCB	; FCB for it
	@@FSPEC			; Set filespec into FCB
	@@LOAD			; Load it in
	LD	(SDSTRT),HL	; Save start addr in code
	@@DSPLY	PATCH$		; Say we're patching it
	LD	HL,M13SCRN	; Point to screen
	LD	DE,L13SCRN	; Point 1k below loader
	LD	BC,1024		; # of bytes to move
	LDIR			;   and do it
	LD	HL,SU1PCH	; Point to SU1 patches
	CALL	PATCH		;   and do them
;
;	Get destination drive
;
GTDST	@@DSPLY	GETDST$		; Ask for dest drive
	LD	HL,INPBUF	; Input buffer
	LD	B,1		; 1 char
	LD	C,0
	@@KEYIN			; Get input from user
	JP	C,M4DONE	; Quit on BREAK
	LD	A,B
	OR	A
	JR	Z,GTDST		; Must have some input
	LD	A,(HL)		; Get byte
	LD	(DSTDRV$),A	; Save in message
	LD	(DSTDR1$),A
	SUB	'0'		; Convert to binary
	JR	C,GTDST		; Go if too low
	CP	8
	JR	NC,GTDST	;   or if too high
	LD	(DESTDRV),A	; Save it
;
;	Force into single density mode
;
	LD	C,A		; Get the DCT for that drive
	@@GTDCT
	LD	A,(IY+3)	; Get DCT flags
	BIT	3,A		; Is it a hard drive?
	JR	NZ,GTDST	; BZZZT!!
	LD	(ORIGDEN),A	; Save original value
	AND	10101111B	; SDEN, Side 0
	LD	(SAVEDEN),A	; Save the info for later
	LD	(IY+3),A	; Set it into the DCT
;
;	Prompt for the disk
;
	LD	HL,GETENT$	; "Press enter when ready"
	CALL	MSGENT		; Show msg & wait for <enter> key
;
;	Write Model I boot sector to Trk 0, Sector 0
;
	LD	HL,BOOT1	; Model I boot
	LD	A,(DESTDRV)	; Pick up dest drive
	LD	C,A
	@@RSTOR			; Restore to track 0
	LD	DE,0		; Track 0, Sector 0
	@@WRSEC			; Write sector
	JP	NZ,OOPSIE	; Jump on error
;
;	Write empty sectors to Trk 0, Sec 2-9
;
	LD	HL,SECBUF	; I/O sector for this
	LD	B,0		; Do 256 bytes
ZERLP1	LD	(HL),0		; Set buffer byte
	INC	HL		; Bump pointer
	DJNZ	ZERLP1		; Loop whole sector
;
	LD	E,2		; Start w/sector 2
WRLP0	@@WRSEC			; Write sector
	JP	NZ,OOPSIE	; Go on error
	INC	E		; Bump sector number
	LD	A,E		; Done yet?
	CP	0AH
	JR	NC,WRLP0	; Loop until > 9
;
;	Now write the program to the disk
;
	LD	HL,SU1PCH2	; Point to M1 loader patch
	CALL	WRITER		;   and write the program out
;
;	Done SD - Get SU3 and write it, too.
;
	LD	A,(ORIGDEN)	; Set the DCT back to the way
	LD	(IY+3),A	;   we originally found it
;
	LD	HL,DONESD$	; Done - swap disks if needed
	CALL	MSGENT		; Show and get enter
;
	@@DSPLY	GETDDS$		; "Loading SU"
	LD	HL,DDPRG$	;'SU3/CMD'
	LD	DE,DDFCB
	@@FSPEC			; Put into the FCB
	@@LOAD			; and load it in
	LD	(DDSTRT),HL	; Save start addr in code
;
	LD	HL,M13SCRN	; Move Mod III screen into
	LD	DE,L13SCRN	;   proper position
	LD	BC,1024
	LDIR
	@@DSPLY	PATCH$		; "Patching it
	LD	HL,SU3PCH	; Point to SU3 patches
	CALL	PATCH		;   and do them
;
	LD	A,(SAVEDEN)	; Grab our DCT+3 byte
	OR	01000000B	; Set DDEN bit in it
	LD	(IY+3),A	; and put it into the DCT
;
	LD	HL,GETEN2$	; "Press enter when ready to write
	CALL	MSGENT		; Show msg & wait for <enter> key
;
;	Write 4300-43FF boot sector to Trk 0, Sec 1
;
	LD	HL,BOOT3	; Model I boot
	LD	A,(DESTDRV)	; Pick up dest drive
	LD	C,A
	LD	DE,0001H	; Track 0, Sector 1
	@@WRSEC			; Write sector
	JP	NZ,OOPSIE	; Jump on error
;
	LD	HL,SU3PCH2	; Mod 3 loader patch
	CALL	WRITER		; Write program to disk
;
	LD	A,(ORIGDEN)	; Back to the original DCT
	LD	(IY+3),A	;   byte
;
;	Finished!
;
	LD	HL,DONEDD$	; Done - swap disks if needed
	CALL	MSGENT
	JR	NMLEXIT
;
; ---------------------------------------------------------
;	OOPSIE - Come here on error
; ---------------------------------------------------------
;
OOPSIE	@@DSPLY	ERRMSG$		; "Barf"
	LD	HL,-1		; NZ return code
	JR	M4DONE		; and get out
;
; ---------------------------------------------------------
;	NMLEXIT - Normal exit
; ---------------------------------------------------------
;
NMLEXIT	@@DSPLY	FINISH$		; "Bye now"
	LD	HL,0		; Set exit code
;
M4DONE	@@EXIT			; Go away
;
;
; ---------------------------------------------------------
;	MSGENT - Prompt for the disk
; ---------------------------------------------------------
;
MSGENT	@@DSPLY
KEYLP	@@KEY
	CP	80H		; BREAK key?
	JP	Z,M4DONE
	CP	CR		; Enter?
	JR	NZ,KEYLP	; Loop until it is
	LD	C,A		; Display the enter.
	@@DSP
	RET
;
; ---------------------------------------------------------
;	PATCH - Routine to apply patches
;	Entry: HL-> two entry patch table
; ---------------------------------------------------------
;
PATCH	CALL	PATCH01		; Do this twice
PATCH01	LD	E,(HL)		; Address to patch in DE
	INC	HL		; from (HL)
	LD	D,(HL)
	INC	HL		; Point to new 3 bytes
	LD	BC,3		; Length of patch
	LDIR			; Do it
	RET
;
; ---------------------------------------------------------
;	WRITER - Routine to write out the screen/loader 
;	and program tracks.
;	Entry: HL -> current patch values
;
;	First do the two screen/loader tracks - The first
;	keeps the double step in the boot sector.  The
;	second does not.
; ---------------------------------------------------------
;
WRITER	PUSH	HL		; Save curr patch ptr
	LD	DE,0101H	; Trk 1, Sec 1 to start
	LD	HL,L13SCRN	; Point to screen area
	CALL	WRTRAK		; Write 80 track loader
	POP	HL		; Get patch area back
	CALL	PATCH		; Fix loader for 40 Tk boot
	LD	HL,L13SCRN
	LD	DE,0201H	; Start trk 2, sec 1
	CALL	WRTRAK		; Write 40 track loader
;
;	Now write the program
;
	LD	B,NPGMTK	; Number of tracks to write
	LD	DE,0401H	; Start on track 4, sector 1
	LD	HL,LOADAD	; Load address of /CMD files
;
WRITLUP	CALL	WRTRAK		; Write the track out
	INC	D		; Next track
	DJNZ	WRITLUP		; Loop for # of tracks
	RET			;   and that's that.
;
; ---------------------------------------------------------
;	WRTRAK - write a track in D with data at HL
;	Writes 6 sectors, starting at 1
; ---------------------------------------------------------
;
WRTRAK	PUSH	DE		; Save track/sector
	PUSH	HL		; and buffer
	LD	A,(DESTDRV)	; Set the drive
	LD	C,A
	PUSH	BC		;   and save it
	LD	L,D		; Get current track into
	LD	H,0		;  message string
	LD	DE,VERTRK$
	LD	B,2		; 2 byte buffer
	@@HDEC			; Binary to Ascii
	@@DSPLY	WRTMSG$		; Show the message
	LD	C,'S'		; Add density
	BIT	6,(IY+3)	; Single?
	JR	Z,WRKSHD	; Skip adding D
	LD	C,'D'		;   else show DDen
WRKSHD	@@DSP
	POP	BC		; Get drive back
	POP	HL		;   and the buffer
	POP	DE		;   and track/sec
	PUSH	DE		; Save this again
	@@RSLCT
WRTKLP	@@WRSEC			; Write sector to disk
	JP	NZ,OOPSIE	; Abort on write error
	INC	H		; Bump buffer page
	INC	E		;   and sector num
	LD	A,E
	CP	7		; Done yet?
	JR	C,WRTKLP	; Do another if not
	POP	DE		; Get track & sector 1 back
	RET
;
; =========================================================
;	HBCREATE data and messages
; =========================================================
;
DENFLAG	DB	0		; 0 = Single, 1 = Double
DESTDRV	DB	1		; 0, 1, 2 or 3
SAVEDEN	DB	0		; Saved value from DCT+3
ORIGDEN	DB	0		; Original DCT+3 value
;
;	Patch tables - format is address & 3 bytes to set
;
;	Model I SU program patches to enable config load/save
;
SU1PCH	DW	0E310H		; Address
	DB	0CDH,0F3H,0CBH	; Three bytes
	DW	0E776H		; 2nd address
	DB	21H,15H,40H	; 3 bytes
;
;	Model I patch to loader for 40 track
;
SU1PCH2	DW	ZZ101		; NOP extra calls to step in
	DB	0,0,0		; the head
	DW	ZZ102
	DB	0,0,0
;
;	Model III SU program patches for config load/save
;
SU3PCH	DW	0E29EH		; Address
	DB	0CDH,87H,0CBH	; 3 bytes
	DW	0E740H		; Address again
	DB	21H,15H,40H	; and three more bytes
;
;	Model III patch to loader for 40 track
;
SU3PCH2	DW	ZZ301		; Nop out extra track stepin
	DB	0,0,0		; Model III version
	DW	ZZ302
	DB	0,0,0
;
HELLO$	DB	'HBCREATE - HyperBoot Super Utility 3.2 Disk Maker - Version 2.20',LF
	DB	'Copyright (c) 1998,99 by Pete Cervasio (cervasio@airmail.net)',LF,CR
;
GETDST$	DB	'Enter drive containing HBFORM formatted disk: ',ETX
;
GETSDS$	DB	'Loading Model 1 SU+ program file...',CR
GETDDS$	DB	'Loading Model 3 SU+ program file...',CR
;
CPYSDN$	DB	'Writing single density sectors',CR
CPYDDN$	DB	'Writing double density sectors',CR

WRTMSG$	DB	BOL,'Writing to drive :'
DSTDR1$	DB	'$, Track '
VERTRK$	DB	'$$ Den: ',ETX
;
DONESD$	DB	LF,'Model 1 SU+ written.  Replace disk if needed and press <ENTER>',ETX
DONEDD$	DB	LF,'Model 3 SU+ written.  Remove disk and press <ENTER>',ETX
;
PATCH$	DB	'Applying patches in memory to allow saving configuration',CR
;
GETENT$	DB	'Press <ENTER> when formatted disk is on drive :'
DSTDRV$	DB	'x',ETX
GETEN2$	DB	'Press <ENTER> when the new SU disk is back in.',ETX
;
ERRMSG$	DB	LF,'Error writing to the disk!',LF,CR
;
SDPRG$	DB	'SU1/CMD',CR	; Filename of Model 1 SU+ /CMD
	DS	8		; Expansion room for when (S1="" added)
SDFCB	DS	32		; File control block for SU1/CMD

DDPRG$	DB	'SU3/CMD',CR	; Filename of Model 3 SU+ /CMD
	DS	8		; Expansion room for when (S3="" added)
DDFCB	DS	32		; FCB for SU3/CMD

FINISH$	DB	LF,'Done!',CR
TSTBT$	DB	'Please test boot the disk on a Model I and a III/4',CR
;
INPBUF	DS	32
;
SECBUF	DS	256
;
;
; =========================================================
;	BOOT1 - Boot Sector, Model I Version
; =========================================================
;
	ORG	4200H
;
BOOT1	DI			; Disable interrupts
	CP	3		; Standard DIR track pointer
	LD	SP,BOOT1-1	; Set stack somewhere safe
	LD	HL,COMAND1	; HL => command/status reg
	LD	DE,L13SCRN	; DE => storage pointer
	CALL	TRACK21		; Start drive, skip to track 2
	CALL	TRKLOD1		; Get loader and screen image
	JP	UTILS1		; Model 1 40/80 track loader
;
; ---------------------------------------------------------
;	NOTBUS1 - Wait until the controller isn't busy
; ---------------------------------------------------------
;
NOTBUS1	BIT	0,(HL)
	JR	NZ,NOTBUS1	; Wait until not busy
	RET			; Return to the caller
;
; ---------------------------------------------------------
;	TRACK21 - Step twice and read the track
; ---------------------------------------------------------
;
TRACK21	CALL	RETRIG1		; Select drive 0
	LD	A,0D0H		; Force FDC interrupt
	LD	(HL),A
	LD	B,0		; Delay while command
	DJNZ	$		;   takes effect
	LD	(HL),A		; Repeat it
	DJNZ	$
;
STEPT21	CALL	$+3		; Step twice
	CALL	NOTBUS1		; Wait til not busy
	LD	(HL),53H	; Step out to next track
	LD	B,10		; Delay
	DJNZ	$
	CALL	NOTBUS1		; Wait til not busy again
	CALL	RETRIG1		; retrigger drive
	LD	A,(HL)		; Get status
	BIT	4,A		; Seek error?
	RET	Z		; No OK quit
;
; ---------------------------------------------------------
;	Clear screen and print disk error message
; ---------------------------------------------------------
;
ERROR1	LD	HL,3FFFH	; Clear screen from bottom
	LD	DE,3FFEH	;   to top
	LD	BC,1023
	LD	(HL),' '
	LDDR			; Slurp!
	LD	HL,DSKERR1	; Point to error msg
	LD	BC,DSKERL	; Same length for 1 and 3
	LDIR			; Show on screen
;
HOLDIT1	LD	A,(3840H)	; Scan keyboard
	RRCA			; Enter pressed?
	JR	NC,HOLDIT1	; Loop if not
	HALT			; Reboot Mod I
;
; ---------------------------------------------------------
;	TRKLOD1 - Load # tracks in B to memory
;
;	Note that the first time through this will
; 	only read one track.  The loader patches the
;	RET instruction to a RET Z.
; ---------------------------------------------------------
;
TRKLOD1	LD	C,1		; Starting sector
;
SECLOD1	PUSH	BC		; Save trk count & sec #
	LD	(DETEMP1),DE	; Save load address
	LD	B,10		; 10 tries per sector
SECTRY1	PUSH	BC		;   before aborting
	CALL	RDSEC1		; Try to read the sector
	POP	BC		; Get count back (in B)
	JR	Z,SECOK1	; Go on if okay
	LD	DE,(DETEMP1)	; Get the storage poiner
	DJNZ	SECTRY1		; Try sector again
	JP	ERROR1		; Tried all we can...
;
SECOK1	POP	BC		; Get Trk/Sec counts back
	INC	C		; Next sector
	LD	A,C		; Are we done yet?
	CP	7
	JR	C,SECLOD1	; Get another if not
	DEC	B		; Decr tracks remaining
SECOK2	RET			; RET Z (patched by loader)
;
;	We never get here until loader is running
;
	CALL	RETRIG1		; Reselect drive
	PUSH	BC		; Save counts
	CALL	STEPTK1		; Next track (call to loader)
	POP	BC		; Get counters back
	JR	TRKLOD1		; and go back for more
;
; ---------------------------------------------------------
;	RETRIG1 - Keep drive running
; ---------------------------------------------------------
;
RETRIG1	LD	A,1		; Drive 0 bit
	LD	(DRIVE1),A	; Select it
	RET
;
; ---------------------------------------------------------
;	RDSEC1 - Read next sector (C) to mem (DE)
; ---------------------------------------------------------
;
RDSEC1	LD	(HL),0D0H	; Interrupt controller
	LD	B,10
	DJNZ	$		; short delay
	LD	(HL),0D0H	; Repeat force interrupt
	LD	B,10
	DJNZ	$		; Another delay
	CALL	RETRIG1		; Keep drive going
	LD	A,C		; Get sector number
	LD	(SECTOR1),A	; set it
	LD	BC,DATA1	; BC => FDC data register
	LD	A,88H		; Read Sector command
	LD	(HL),A		; Issue it
	LD	A,6		; Yet another delay
DELAY11	DEC	A
	JR	NZ,DELAY11
GETDRQ1	LD	A,(HL)		; Read status reg
	BIT	1,A		; Test DRQ bit
	JP	NZ,GETBYT1	; Yes, get data
	AND	1		; Test DRQ bit
	JR	NZ,GETDRQ1	; Go if data is ready
	CALL	RETRIG1		;   else retrigger drive
	LD	A,(HL)		; Get status
	AND	9CH		; RNF, Lost data, drive ready
	RET
;
; ---------------------------------------------------------
;	GETBYT1 - Get a byte of data
; ---------------------------------------------------------
;
GETBYT1	LD	A,(BC)		; Get byte from FDC
	LD	(DE),A		; Store it
	INC	DE		; Next position
	JR	GETDRQ1
;
; ---------------------------------------------------------
;	Storage for DE in case sector read has
;	to be restarted for some reason.
; ---------------------------------------------------------
;
DETEMP1	DW	0
;
; ---------------------------------------------------------
;	Message displayed on a disk error
; ---------------------------------------------------------
;
DSKERR1	DB	'DISK ERROR',0
;
M1BLEFT	DC	-$&0FFH,0	; Fill rest of sector with 0 bytes
;
;
;
; =========================================================
;	BOOT3 - Boot Sector, Model III version
; =========================================================
;
	ORG	4300H
;
BOOT3	DI			; Disable interrupts
	CP	3		; "Dir" track
	LD	SP,BOOT3-1	; Set stack ptr to safe area
	LD	DE,L13SCRN	; DE is storage pointer
	CALL	TRACK23		; Start drive, step head twice
	CALL	TRKLOD3		; Get screen and loader
	JP	UTILS3		; Jump to Model III loader
;
; ---------------------------------------------------------
;	NOTBUS3 - Wait until the controller isn't busy
; ---------------------------------------------------------
;
NOTBUS3	IN	A,(STATUS3)	; Test if busy
	BIT	0,A
	JR	NZ,NOTBUS3	; Wait until not busy
	RET			; Return to the caller
;
; ---------------------------------------------------------
;	TRACK23 - Step twice and read the resulting track
; ---------------------------------------------------------
;
TRACK23	CALL	RETRIG3		; Select drive 0
	LD	A,0D0H		; Force FDC interrupt
	OUT	(COMAND3),A
	LD	B,0		; Delay while command
	DJNZ	$		;   takes effect
	OUT	(COMAND3),A	; Repeat
	DJNZ	$
;
STEPT23	CALL	$+3		; Step twice
	CALL	NOTBUS3		; Wait til not busy
	LD	A,53H		; Step out to next track
	OUT	(COMAND3),A	; Send it
	LD	B,10		; Delay
	DJNZ	$
	CALL	NOTBUS3		; Wait til not busy again
	CALL	RETRIG3		; retrigger drive
	IN	A,(STATUS3)	; Get status
	BIT	4,A		; Seek error?
	RET	Z		; No OK quit
;
; ---------------------------------------------------------
;	Clear screen and print error message
; ---------------------------------------------------------
;
ERROR3	LD	HL,3FFFH	; Clear video screen
	LD	DE,3FFEH	;   from bottom to top
	LD	BC,3FFH
	LD	(HL),' '
	LDDR			; Slurp!
	LD	HL,DSKERR3	; "Disk error"
	LD	BC,DSKERL	; Same length for 1 and 3
	LDIR			; Msg to screen
;
HOLDIT3	LD	A,(3840H)	; Scan keyboard
	RRCA			; Enter pressed?
	JR	NC,HOLDIT3	; Loop if not
	RST	0		; Reboot Mod III
;
; ---------------------------------------------------------
;	TRKLOD3 - Read # tracks in B to memory
;
;	Note that the first time through this will
; 	only read one track.  The loader patches the
;	RET instruction to a RET Z.
; ---------------------------------------------------------
;
TRKLOD3	LD	C,1		; Start sector
;
SECLOD3	PUSH	BC		; Save it
	LD	(DETEMP3),DE	; Save store point
	LD	B,10		; 10 tries per sector
SECTRY3	PUSH	BC		;   before aborting
	CALL	RDSEC3		; Try to read the sector
	POP	BC		; Get count back (in B)
	JR	Z,SECOK3	; Go on if okay
	LD	DE,(DETEMP3)	; Get the storage poiner
	DJNZ	SECTRY3		; Try sector again
	JP	ERROR3		; Tried all we can...
;
SECOK3	POP	BC		; Get Trk/Sec counts back
	INC	C		; Next sector
	LD	A,C		; Move to A for test
	CP	7		; Done yet?
	JR	C,SECLOD3	; Loop for 6 sectors
	DEC	B		; Decr tracks remaining
SECOK4	RET			; made RET Z by loader
;
;	We never get here until loader is running
;
	CALL	RETRIG3		; Reselect drive
	PUSH	BC		; Save counts
	CALL	STEPTK3		; Next track (from loader)
	POP	BC		; Get counters back
	JR	TRKLOD3		; and go back for more
;
; ---------------------------------------------------------
;	RETRIG3 - Keep drive running
; ---------------------------------------------------------
;
RETRIG3	LD	A,81H		; DDen, drive 0
	OUT	(DRIVE3),A	; Select it
	RET
;
; ---------------------------------------------------------
;	RDSEC3 - Read next sector (C) to memory (DE)
; ---------------------------------------------------------
;
RDSEC3	LD	A,0D0H		; Interrupt controller
	OUT	(COMAND3),A
	LD	B,10		; Delay
	DJNZ	$
	LD	B,10		; Repeat
	OUT	(COMAND3),A
	DJNZ	$
	CALL	RETRIG3		; Keep drive going
	LD	A,C		; Get sector number
	OUT	(SECTOR3),A	; set it
	LD	H,83H		; Bit masks
	LD	L,2
	LD	A,88H		; Read Sector command
	OUT	(COMAND3),A	; Issue it
	LD	A,5		; Delay value
DELAY13	DEC	A
	JR	NZ,DELAY13
RDSEC13	IN	A,(STATUS3)	; Read status reg
	AND	H		; Test DRQ, BUSY and READY
	JP	PO,RDSEC13
;
; ---------------------------------------------------------
;	Must have some data coming in finally
; ---------------------------------------------------------
;
RDSEC23	IN	A,(DATA3)	; Get byte
	LD	(DE),A		; Store it
	INC	DE		; Next position
RDSEC33	IN	A,(STATUS3)	; Get status
	AND	L
	JR	NZ,RDSEC23
	IN	A,(STATUS3)
	AND	L
	JR	NZ,RDSEC23
	IN	A,(STATUS3)
	AND	L
	JR	NZ,RDSEC23
	IN	A,(STATUS3)
	BIT	0,A		; Still busy?
	JR	Z,SEXIT3
	BIT	7,A		; Not ready?
	JR	Z,RDSEC33
SEXIT3	AND	1CH		; Test RNF, CRC, Not Ready
	RET
;
; ---------------------------------------------------------
;	Storage for DE in case sector read has
;	to be restarted for some reason.
; ---------------------------------------------------------
;
DETEMP3	DW	0
;
; ---------------------------------------------------------
;	Error message displayed on error
; ---------------------------------------------------------
;
DSKERR3	DB	'Disk error'
DSKERL	EQU	$-DSKERR3
;
	DC	-$&0FFH,0	; Fill rest of sector with 0 bytes
;
;	End of boot sectors
;
; =========================================================
;	SU Logo screen area (as loaded by boot sector)
; =========================================================
;
	ORG	L13SCRN
	DS	1024		; Where it sits when we write it
;

; =========================================================
;	Model I/III Utility & Loader routines
; =========================================================
;
; ---------------------------------------------------------
;	MEMTEST - tests memory from 5000H to FFFFH (also
;	ensures a 48K machine.  From real SU+ loader.
; ---------------------------------------------------------
;
MEMTEST LD	HL,5000H	; start free memory
MEMLP   LD	A,-1		; set all bits
	LD	(HL),A		; to memory
	CP	(HL)		; still there?
	JR	NZ,MEMERR	; go mem error if no
	INC	A		; clear all bits
	LD	(HL),A		; to memory
	CP	(HL)		; still there?
	JR	NZ,MEMERR	; go mem error if no
	INC	HL		; bump pointer
	OR	H		; at 0000H?
	OR	L
	JR	NZ,MEMLP	; go if more to do
	RET			; else memory OK!
;
MEMERR$	DB	'MEMORY ERROR: ',0
;
; ---------------------------------------------------------
;	MEMERR - Displays memory error
; ---------------------------------------------------------
;
MEMERR	PUSH	HL		; Save bad address
	CALL	CLRSCR		; Clear the screen
	LD	DE,MEMERR$	; "Mem err"
	CALL	WRITEST		; Write (DE) at (HL)
	POP	DE		; Get err addr back
	CALL	HEXSHOW		; Convert to ASCII
;
; ---------------------------------------------------------
;	HOLD - Wait until <ENTER>, then reboot
; ---------------------------------------------------------
;
HOLD	LD	A,(3840H)	; Scan keyboard
	RRCA			; Enter pressed?
	JR	NC,HOLD		; Loop if not
HOLD2	RST	0		; Re-boot III (HALT for M1)
;
; ---------------------------------------------------------
;	CLRSCR - Clear the Model I/III screen
; ---------------------------------------------------------
;
CLRSCR	LD	HL,3FFFH	; Clear screen
	LD	DE,3FFEH
	LD	BC,1023
	LD	(HL),20H
	LDDR
	RET
;
; ---------------------------------------------------------
;	HEXSHOW - Shows DE in hex @ HL (LS-DOS code)
; ---------------------------------------------------------
;
HEXSHOW	LD	A,D		; Convert reg D to
	CALL	HEX8		;   to two hex digits
	LD	A,E		; Convert reg E to
HEX8	PUSH	AF		;   to two hex digits
	RRA			; Do left nibble first
	RRA
	RRA
	RRA
	CALL	HEX8A		; Bits 0-3 stuffed to hex
	POP	AF		; Reget the byte
HEX8A	AND	0FH		;   & use right nibble
	ADD	A,90H		; Convert nibble to hex
	DAA
	ADC	A,40H
	DAA
	LD	(HL),A		; Stuff into (HL)
	INC	HL
	RET
;
; ---------------------------------------------------------
;	Write string in (DE) to (HL) until nul
; ---------------------------------------------------------
;
WRITEST	LD	A,(DE)		; Get char
	OR	A		; nul termianted
	RET	Z
	LD	(HL),A
	INC	HL		; next character
	INC	DE
	JR	WRITEST
;
; ---------------------------------------------------------
;	SHOWLGO - Show the logo screen
; ---------------------------------------------------------
;
SHOWLGO	LD	HL,L13SCRN	; Where it was loaded
	LD	DE,M13SCRN	; Screen start
	LD	BC,1024		; Length of screen
	LDIR			; Do it!
	RET
;
; ---------------------------------------------------------
;	UTILS1 - Model I loader for SU+
; ---------------------------------------------------------
;
UTILS1	CALL	SHOWLGO		; Something to look at
	LD	A,0C8H		; RET to RET Z
	LD	(SECOK2),A
	LD	A,76H		; HALT instr
	LD	(HOLD2),A	; Fix for Mod 1 reboot

	CALL	MEMTEST		; Test memory
	LD	HL,COMAND1	; HL is command/status reg
				;    (40 Tk)   (80 tk)
	CALL	STEPTK1		; Tk (2 -> 3)  (1 -> 2)
	CALL	STEPTK1		; Tk (3 -> 4)  (2 -> 3)
ZZ101	CALL	STEPTK1		;      NOP     (3 -> 4)
	LD	B,NPGMTK	; Number of PROGRAM tracks
	LD	DE,LOADAD	; Where to start loading SU+
	CALL	TRKLOD1		; Get it...
	JP	STRTAD1		;   and run it!
SDSTRT	EQU	$-2
;
; ---------------------------------------------------------
;	STEPTK1 - Mod 1 track stepin routine for the loader
;
;	This is the exact same code as in the boot sector
;	but it was easier to have a separate one here that
;	could be more easily patched for 40/80 track loading.
; ---------------------------------------------------------
;
ZZ102	EQU	$		; For nopping this
STEPTK1	CALL	STEPINA
STEPINA	CALL	NOTBUS1		; Wait til not busy
	LD	(HL),53H	; Step out to next track
	LD	B,10
WREADYA	DJNZ	WREADYA		; Spin in a circle for a bit
	CALL	NOTBUS1		; Wait til not busy again
	CALL	RETRIG1		; retrigger drive
	LD	A,(HL)		; Get status
	BIT	4,A		; Seek error?
	RET	Z		; No is a good thing.
	JP	ERROR1		; Otherwise show the error
;
;---------------------------------------------------------------
;	UTILS3 - Model III loader for SU+
; ---------------------------------------------------------
;
UTILS3	CALL	SHOWLGO		; Show logo screen
	LD	A,0C8H		; RET to RET Z
	LD	(SECOK4),A	; Fix code

	CALL	MEMTEST		; Simple memory test
	CALL	STEPTK3		; Skip to track 4
	CALL	STEPTK3
ZZ301	CALL	STEPTK3		; (NOP for 40 tk loader)
	LD	B,NPGMTK	; Number of PROGRAM tracks
	LD	DE,LOADAD	; Where to start loading SU+
	CALL	TRKLOD3		; Load up the program
	JP	STRTAD3		;   and run it!
DDSTRT	EQU	$-2
;
; ---------------------------------------------------------
;	STEPTK3 - Mod 3 track stepin routine for the loader
; ---------------------------------------------------------
;
ZZ302	EQU	$
STEPTK3	CALL	STEPINB		; Step twice (NOP for 40 tk)
STEPINB	CALL	NOTBUS3		; Wait til not busy
	LD	A,53H		; Step out to next track
	OUT	(COMAND3),A	; Send it
	LD	B,10		; Delay
WREADYB	DJNZ	WREADYB
	CALL	NOTBUS3		; Wait til not busy again
	CALL	RETRIG3		; retrigger drive
	IN	A,(STATUS3)	; Get status
	BIT	4,A		; Seek error?
	RET	Z		; No. OK quit
	JP	ERROR3
;
ENDLOD	EQU	$		; End of loader
;
UTLSIZE	EQU	ENDLOD-MEMTEST	; Just a quick check that shows
UTLLEFT	EQU	200H-UTLSIZE	;   up on screen at assem time
;
*LIST OFF
	DC	UTLLEFT,0	; Fill loader sectors with 00s
*LIST ON

;
	END	START

