;		===== HIMAP VER 3.0.1 =====
;			6/2/86
;
;                by:  Bill McQueen
;			805 Ely Road
;			Hixson, Tn
;			(615) 875-0731
;
;
;		   === NOTICE ===
;		       ------
;
;This program placed in the PUBLIC DOMAIN and submitted to
;NORTHERN BYTES and THE ALTERNATE SOURCE" by Bill McQueen.
;It may be used, modified, given away etc. by anyone.
;Please give credit to the author and NORTHERN BYTES or
;THE ALTERNATE SOURCE
;---------------------------------------------------------
;
;This program is a utility for use with LDOS 5.1.x. (tm).
;It will display a directory and map of all modules
;resident in high memory, provided all are identified with
;the LDOS (tm) standard header.
;All system modules, filters, drivers etc. by Logical
;Systems, Inc (tm) and MISOSYS (tm) intended to
;be resident in high memory have this header.  (If you need
;info on this header and can't find it in your LDOS 
;documentation, contact LSI, INC or the author).
;
;This source file was written with SAID, the text editor
;by MISOSYS to be assembled on EDAS (tm), the MISOSYS
;macro assembler.
;
;	NOTE:	VERSION 3.0.1 is the same program as
;		Ver 3.0.0 except that it has been
;		re-arranged so that it contains the
;		appropriate portions of the FBUFF
;		library in its source code. Therefore
;		it can be assembled with EDAS or other
;		non-relocatable assembler.
;
;If you have questions or want a copy of the object code
;of this program, contact the author.  Improved versions
;are planned.
;
;--------------------------------------------------------
ETX	EQU	03H		;end of text mark (ASCII)
CRTN	EQU	0DH		;ASCII carriage return
LNFEED	EQU	0AH		;ASCII end of line mark
@DSPLY	EQU	4467H		;LDOS display routine
@EXIT	EQU	402DH		;Return to DOS
D0_MSK	EQU	00001111B	;Digit 0 mask
D1_MSK	EQU	11110000B	;Digit 1 mask
; MODEL III EQUATES
HIGH3$	EQU	4411H
;----------------------------------------------------
;
	COM	'<HIMAP ver 3.0.1 by Bill McQueen. Placed in the Public Domain and  submitted to Northern Bytes/Alternate SOURCE 6/2/86.>'
;
	ORG	5200H
BEGIN	DW	0		;address of beginning
				;of code segment.
END	DW	0		;AND ITS END.
;
ENTRY
	LD	HL,(HIGH3$)	;Fetch and
	LD	(END),HL	;save HIGH$
	DEC	HL
	LD	SP,HL		;Set Stack
	LD	HL,BANNER	;Clear screen and 
	CALL	@DSPLY		;print banner.
	CALL	SHO_HI		;display high$
LOOP1
	LD	HL,(END)	;HL = High$
	INC	HL		;HL = First byte of hi mem
	LD	(BEGIN),HL	;save it
	LD	A,H		;Check to see if we are
	CP	0		;at top of physical memory
	JR	NZ,SKIP1	;Jump if not.
	LD	A,L
	CP	0
	JR	Z,NO_HI		;If so jump --------->
SKIP1				;There is some high mem
				;storage left.
	INC	HL
	INC	HL		;HL-->Begining of segment
	PUSH	HL		;Transfer it
	POP	IX		;to IX.
	LD	E,(IX)		;Then get address of
	LD	D,(IX+1)	;end of segment
	LD	(END),DE	;and save it.
	CALL	SHO_SEG		;Display the data on CRT
	JR	LOOP1		;Then loop.
;
;------------------------------------------------------
NO_HI
;
;	There is no more High Memory so ...
	JP	@EXIT		; return to LDOS
;-----------------------------------------------------
SHO_HI
;
;	Display the current HIGH$ value.
;
	LD	IX,BCB		;IX --> Buffer control block
	CALL	CLRB		;Clear work buffer
	LD	DE,L1A		;DE --> txt to be printed
	LD	A,0		;No chr count, stop on ETX
	CALL	ASC_BUF		;Put it in buffer
	LD	A,16		;Tab val
	CALL	TABA		;Move cursor
	LD	BC,(END)	;BC = HIGH$
	CALL	HEX_BUF		;Print hex val to buffer
	LD	A,LNFEED	;Let's add a Line Feed
	CALL	WR_BYT		;Writhe that byte to buffer
	LD	A,CRTN		;Also a Carriage Return
	CALL	WR_BYT		;Mark end of work buffer
	LD	HL,BUFFER	;HL --> buffer
	CALL	@DSPLY		;Print to screen
	RET
;
;-----------------------------------------------------
;
SHO_SEG
;
;	DISPLAY THE SEGMENT DATA
;
	LD	IX,BCB		;IX --> Buffer
	CALL	CLRB		;Clear text format buffer
	INC	HL
	INC	HL		;HL--> length of name
	LD	A,(HL)		;Nr of bytes to move
	PUSH	HL		;Transfer it to DE
	POP	DE
	INC	DE		;DE--> name
	CALL	ASC_BUF		;Move name to buffer
	LD	A,16		;Tab value
	CALL	TABA		;Tab to pos 16
	LD	BC,(BEGIN)	;BC = start add of seg
	CALL	HEX_BUF		;Put seg start add to buffer
	LD	A,16+5		;Tab value
	CALL	TABA		;Tab
	LD	A,0		;No char count
	LD	DE,LXB		;DE --> txt
	CALL	ASC_BUF		;Move text to buffer
	LD	BC,(END)	;BC = Seg Ending Address
	CALL	HEX_BUF		;Write hex value to buffer
	LD	A,CRTN		;Lets put a Carriage Ret
	CALL	WR_BYT		;Mark end of txt
	LD	HL,BUFFER	;HL --> Buffer
	CALL @DSPLY		;Display to CRT
	RET
;
;=======================================================
;	The following are portions of the
;	ASCII Buffer Formatting Library (FBUFF)
;=======================================================
SAVE_REGISTERS	MACRO
	PUSH	HL
	PUSH	DE
	PUSH	BC
	ENDM
;
RESTORE_REG	MACRO
	POP	BC
	POP	DE
	POP	HL
	ENDM
;
;=====================================================
CLRB
	SAVE_REGISTERS
	CALL	$CLRB
	JR	$EXIT
WR_BYT
	SAVE_REGISTERS
	CALL	$WR_BYT
	JR	$EXIT
TABA
	SAVE_REGISTERS
	CALL	$TABA
	JR	$EXIT
TABR
	SAVE_REGISTERS
	CALL	$TABR
	JR	$EXIT
ASC_BUF
	SAVE_REGISTERS
	CALL	$ASC_BUF
	JR	$EXIT
HEX_BUF
	SAVE_REGISTERS
	CALL	$HEX_BUF
	JR	$EXIT
;
$EXIT
	RESTORE_REG
	RET
;
;=====================================================
$CLRB
	LD	L,(IX)		;Fetch buffer address
	LD	H,(IX+1)	;(HL-->buffer)
	LD	B,(IX+2)	;Fetch buffer length
	LD	A,20H		;A = space
$LOOP1	LD	(HL),A		;set char to space
	INC	HL		;Bump ctr
	DJNZ	$LOOP1		;Repeat til buffer clear
	LD	A,(IX+5)	;Fetch ETX mark value
	LD	(HL),A		;Mark end of buffer
	XOR	A
	LD	(IX+3),A	;Set "cursor" to zero
	RET
;
;-----------------------------------------------------
$WR_BYT
	LD	L,(IX)		;Fetch buffer address
	LD	H,(IX+1)
	LD	E,(IX+3)	;Fetch cursor postion
	LD	D,0
	ADD	HL,DE		;HL--> next chr in buff
	LD	(HL),A		;put byte in buffer
	LD	A,(IX+3)
	INC	A
	JR	TABA		;Advance cursor
;
;------------------------------------------------------
$TABA
	LD	C,A		;Save argument
	LD	H,0
	LD	L,A		;HL = argument (tab)
	LD	D,0
	LD	E,(IX+2)	;DE = buffer length
	XOR	A		;clear flags
	SBC	HL,DE		;Subtract buffer length
	JP	M,GOOD_TAB	;Jp if tab within buffer
	JR	TAB_ERR		;Else report an error
GOOD_TAB
	LD	A,C		;Restore argument
	LD	(IX+3),A	;Set cursor
	XOR	A		;Set zero flg
	JR	EXIT_TAB
;
;------------------------------------------------------
$TABR
	LD	H,0
	LD	L,A		;HL = argument
	LD	D,0
	LD	E,(IX+3)	;DE = current cursor position
	ADD	HL,DE		;HL = requested position
	LD	A,L		;A = requested position
	JR	TABA
;
;---------------------------------------------------------
TAB_ERR
	XOR	A		;Clear A
	ADD	A,1		;Set non-zero Condition
EXIT_TAB
	LD	A,(IX+3)	;Restore A to resulting
				;cursor position
	RET
;
;----------------------------------------------------------
$ASC_BUF
	LD	(IX+7),A	;Save count
	LD	(IX+8),A	;Twice
LOOP2
	LD	A,(IX+8)	;Fetch original Count
	CP	0		;Was it zero?
	JR	Z,SKIP2		;If so skip count check
	LD	A,(IX+7)	;Fetch count
	CP	0
	JR	Z,END_TXT	;Max chr count, quit
	DEC	(IX+7)		;Decrement chr cntr
SKIP2
	LD	A,(DE)		;Fetch Character
	CP	0		;Is it a zero byte?
	JR	Z,END_TXT	;If so get out
	CP	0DH		;Is it a carriage return?
	JR	Z,END_TXT
	CP	03H		;Is it an ETX mark?
	JR	Z,END_TXT
	PUSH	DE
	CALL	WR_BYT		;put char in buffer
	POP	DE
	JR	NZ,END_TXT	;Quit if end of buffer
	INC	DE		;Bump string pointer
	JR	LOOP2		;and do it again
;
END_TXT
	XOR	A		;clear flags
	JR	EXIT_TAB
;
;------------------------------------------------------
;
D0_MSK	EQU	00001111B	;Digit 0 mask
D1_MSK	EQU	11110000B	;Digit 1 mask
;
$HEX_BUF
	;enter with hex number in BC
;
	LD	A,B		;get msb
	CALL	CNVT_DIG
	LD	A,B
	AND	D0_MSK
	CALL	CNVT_DIG2
	LD	A,C
	CALL	CNVT_DIG
	LD	A,C
	AND	D0_MSK
	CALL	CNVT_DIG2
	RET
;------------------------------------------------------
CNVT_DIG
	SRL	A
	SRL	A
	SRL	A
	SRL	A
CNVT_DIG2
	PUSH	BC
	CALL	ADJUST		;cnvt to ASCII Hex digit
	CALL	WR_BYT		;put digit in buffer
	POP	BC
	RET
;
;-------------------------------------------------------
ADJUST
;	Enter with binary digit in A.  Adjust A to
;	an ASCII Hex digit
;
	ADD	A,30H
	CP	3AH
	JP	M,SKIP3
	ADD	A,7H
SKIP3	RET
;=====================================================
;
BANNER	DB	1CH,1FH
	DB	'High Memory Map        Ver 3.0.1',LNFEED
	DB	'--------------------------------',CRTN
;
L1A	DB	'(HIGH$)  =  ',ETX
LXB	DB	'<----> ',ETX
;-----------------------------------------------------
;
BCB
BADD	DW	BUFFER
BLEN	DB	40H
BCUR	DB	0
	DB	0
BETX	DB	0DH
BFILL	DB	'-'
T123	DB	0,0,0
BTAB	DB	0
	DB	10H
	DB	0FFH
	DW	0
BUFFER
	DS	50H
;------------------------------------------------------
;
	END	ENTRY
