	ORG	3000H
START	EQU	$
	CALL	NOCURS		;turn off cursor
	CALL	CLS		;erase text screen
	CALL	GINIT		;initialize graphics board
	CALL	GCLS		;erase graphics screen
	CALL	TXTON		;turn on grahic text mode
	LD	HL,0000H	;graphic cursor position
	LD	BC,50AAH	;length & Xcharacter
	LD	DE,1E80H	;height & Ycharacter
	CALL	BOX		;draw box as specified
	LD	HL,0102H	;text cursor position
	LD	DE,MSG1		;message to display
	CALL	DSPLY		;display it
	LD	L,22H		;move cursor to 1,34
	LD	DE,MSG2		;point DE to MSG2
	CALL	DSPLY		;display it
	LD	L,33H		;move cursor to 1,51
	LD	DE,MSG3		;point DE to MSG3
	CALL	DSPLY		;display it
	LD	HL,4027H	;move graphics cursor to 64,39
	LD	B,16		;loop counter
	PUSH	HL		;save graphic cursor position
	PUSH	BC		;save loop counter
	CALL	DIAGL		;draw left diagonal line
	POP	BC		;restore loop counter
	POP	HL		;restore graphic cursor position
	INC	L		;position graphic cursor at 64,40
	CALL	DIAGR		;draw right diagonal line
	LD	HL,0C018H	;position graphic cursor at 192,24
	LD	BC,20AAH	;length=32, character is AAH
	CALL	HLINE		;draw horizontal line
	CALL	GRON		;turn graphics screen on
;
;
;
;
	CALL	INKEY		;wait for key stroke
	CALL	GROFF		;turn graphic screen off
	CALL	CLS		;erase text screen
	CALL	CURSOR		;turn cursor on
	RET			;return to dos
;
;------------------------------
;BOX - draw box on screen
;enter with HL = YX
;           BC = length,Xcharacter
;	    DE = height,Ycharacter
;
BOX	EQU	$
	PUSH	BC		;save length & Xchr
	PUSH	HL		;save start position
	PUSH	DE		;save height & Ychr
	CALL	HLINE		;draw top line
	LD	E,0		;calculate offset
	ADD	HL,DE		;to bottom line
	CALL	HLINE		;draw bottom line
	POP	DE		;restore height & Ychr
	POP	HL		;restore start position
	INC	H		;move to next line
	DEC	D		;decrement heigth
	LD	B,D		;transfer height
	LD	C,E		;transfer Ychr
	CALL	VLINE		;draw left line
	POP	BC		;restore length & Xchr
	LD	C,B		;calculate offset
	LD	B,0		;to right
	ADD	HL,BC		;side
	DEC	L		;adjust right side
	LD	A,E		;right side character to A
	LD	B,7		;need to
BOX1	RRCA			;reverse
	DJNZ	BOX1		;the bit setting
	LD	B,D		;copy length to B
	LD	C,A		;copy character to C
	CALL	VLINE		;draw right line
	RET
;------------------------------
;CLS - clear text screen
;
CLS	EQU	$
	LD	A,28		;home cursor
	CALL	DSP
	LD	A,31		;erase from cursor to end of screen
	JP	DSP
;------------------------------
;CURSOR	- turns cursor on
;
CURSOR	EQU	$
	LD	A,14		;cursor on
	JP	DSP
;------------------------------
;DIAGL - draw diagonal line left
;enter with HL = YX
;            B = height
;
DIAGL	EQU	$
DIAGL1	PUSH	BC
	CALL	GCURS
	LD	A,1
	LD	B,8
DIAGL2	OUT	(82H),A
	SLA	A
	DJNZ	DIAGL2
	LD	B,8
DIAGL3	INC	H
	DJNZ	DIAGL3
	DEC	L
	POP	BC
	DJNZ	DIAGL1
	RET
;------------------------------
;DIAGR - draw diagonal line right
;enter with HL = YX
;            B = length
;
DIAGR	EQU	$
DIAGR1	PUSH	BC
	CALL	GCURS
	LD	A,128
	LD	B,8
DIAGR2	OUT	(82H),A
	SRL	A
	DJNZ	DIAGR2
	LD	B,8
DIAGR3	INC	H
	DJNZ	DIAGR3
	INC	L
	POP	BC
	DJNZ	DIAGR1
	RET
;------------------------------
;DSP - display character to text screen
;enter with A = character
;
DSP	EQU	$
	PUSH	BC
	PUSH	DE
	LD	C,A
	LD	A,2
	RST	40
	POP	DE
	POP	BC
	RET
;------------------------------
;DSPLY - display text
;enter with HL = cursor position
;           DE = start of text
;
DSPLY	EQU	$
	PUSH	HL
	PUSH	DE
	LD	A,15
	LD	B,3
	RST	40
	POP	HL
	LD	A,10
	RST	40
	POP	HL
	RET
;------------------------------
;GCLS - erase graphics screen
;
GCLS	EQU	$
	LD	A,70H		;graphics off,
	OUT	(83H),A		;waits off, inc Y
	XOR	A
	OUT	(80H),A
	OUT	(81H),A
	LD	B,80		;X loop counter
GCLSX	PUSH	BC		;save X loop counter
	LD	B,239		;Y loop counter
	XOR	A		;A = 0
GCLSY	OUT	(82H),A		;erase XY position
	DJNZ	GCLSY		;repeat
	LD	A,30H		;inc XY after write
	OUT	(83H),A
	XOR	A		;A = 0
	OUT	(82H),A		;erase 240th Y position
	OUT	(81H),A		;reset Y to 0
	LD	A,70H		;graphics off,
	OUT	(83H),A		;waits off, inc Y
	POP	BC		;restore X loop counter
	DJNZ	GCLSX		;repeat
	RET
;------------------------------
;GCURS - position the graphic cursor
;
GCURS	EQU	$
	LD	A,L		;horizontal position to A
	OUT	(80H),A		;set horizontal
	LD	A,H		;vertical position to A
	OUT	(81H),A		;set it
	RET
;------------------------------
;GINIT - initialize graphics board
;
GINIT	EQU	$
	LD	A,16		;set bit 4
	OUT	(0ECH),A	;enable external I/O
	RET
;------------------------------
;GROFF - turn of graphics board
;
GROFF	EQU	$
	LD	A,0		;turn off
	OUT	(83H),A		;graphics board
	RET
;------------------------------
;GRON - turn on graphics board
;
GRON	EQU	$
	LD	A,1		;turn on
	OUT	(83H),A		;graphics board
	RET
;------------------------------
;HLINE draws horizontal line
;enter with HL = YX
;           BC = length,character
;
HLINE	EQU	$
	PUSH	BC		;save length & Xchr
	LD	A,0B0H		;inc X after write
	OUT	(83H),A
	CALL	GCURS		;position graphics cursor
	LD	A,C		;character for line
HLINE1	OUT	(82H),A		;write it to screen
	DJNZ	HLINE1		;do it again
	POP	BC		;restore length & Xchr
	RET
;------------------------------
;
INKEY	EQU	$
	LD	A,1
	RST	40
	RET
;
;------------------------------
;NOCURS	- turns cursor off
;
NOCURS	EQU	$
	LD	A,15
	JP	DSP
;------------------------------
;TXTOFF - no text with graphics
;
TXTOFF	EQU	$
	XOR	A
	OUT	(8EH),A
	RET
;------------------------------
;TXTON - allow text and graphics
;
TXTON	EQU	$
	LD	A,1
	OUT	(8EH),A
	RET
;-------------------------------
;VLINE - draw vertical line
;enter with HL = YX
;           BC = heigth,character
;
VLINE	EQU	$
	PUSH	BC		;save height & Ychr
	LD	A,70H
	OUT	(83H),A
	CALL	GCURS		;position graphics cursor
	LD	A,C
VLINE1	OUT	(82H),A
	DJNZ	VLINE1
	POP	BC		;restore height & Ychr
	RET
;------------------------------
;MESSAGES
;
MSG1	DB	'TRSTimes presents:',3
MSG2	DB	'HI-RES TEST',3
MSG3	DB	'(c) 1990 by Lance Wolstrup',3
	END	START
