;	HDDEINIT/ASM   (x'1b' + x'14' puts DMP printer in cond char mode)
;
;  Written 14 Feb 90
;  by J.F.R. Slinkman, 1511 Old Compton Road, Richmond, VA  23233
;  (804) 741-0205;  CompuServe ID:  72411,650
;
;  Routine to initialize additional GATs, HITs and drive slot tables in the
;  DIR/SYS track of hard drive partitions.
;
*GET	EQUATES
;
	ORG	3000H
;
GAT	DS	2200H
HIT	EQU	GAT+256
LASTSEC	DS	100H
HOWMANY	EQU	LASTSEC+4
LETTER	EQU	LASTSEC+5
;
;
BEGIN	LD	A,(HL)
	CP	':'		;does command line specify drive number?
	JR	Z,BGN010	;falls thru if not
;
SYNERR	LD	HL,SYNTAX
DSPOUT	SVC	@DSPLY
	LD	HL,0
	SVC	@EXIT
;
BGN010	INC	HL
	LD	A,(HL)		;p/u drive number
	CP	'0'
	JR	C,SYNERR
	CP	'8'
	JR	NC,SYNERR	;must be in range '0' to '7'
	XOR	'0'		;convert to binary
	LD	(DRIVNO),A	;   and store
	LD	C,A
	SVC	@GTDCT		;point IY to drive's DCT
	LD	A,(IY)
	CP	0C3H		;is DCT active?
	JP	NZ,ILDRIVE	;error if not
;
	SVC	@CKDRV		;is drive ready?
	JR	Z,BGN020
	LD	A,8		;'Device not available' error
	JP	ERROR
;
BGN020	BIT	3,(IY+3)	;is hard drive bit set?
	JR	NZ,BGN030	;OK if so
	LD	HL,NOTHARD
	JR	DSPOUT
;
BGN030	LD	A,(IY+8)
	AND	0E0H
	RLCA
	RLCA
	RLCA
	INC	A
	LD	C,A		;# grans/track is multiplier
	LD	A,(IY+8)
	AND	1FH
	INC	A
	LD	L,A
	LD	H,0		;# sectors/gran is multiplicand
	SVC	@MUL16
	DEC	A		;A is # of last sector on a track
	PUSH	AF
	LD	(LSECNO),A
	LD	E,A
	LD	A,(DRIVNO)
	LD	C,A
	LD	D,(IY+9)	;p/u directory track #
	LD	HL,LASTSEC
	SVC	@RDSSC		;read last DIR/SYS sector into LASTSEC
	JP	NZ,ERROR
	LD	DE,MODNAME
	LD	BC,400H		;B counts chars, C counts matches
BGN040	LD	A,(DE)		;do 1st 4 bytes in sector = 'HDDE'?
	CP	(HL)
	JR	NZ,BGN050
	INC	C		;if chars match
BGN050	INC	DE
	INC	HL
	DJNZ	BGN040
	LD	A,C		;p/u # of matching characters
	CP	4		;do all 4 match?
	JR	NZ,BGN060	;OK if not
;
	LD	HL,CANT		;else sub-dirs already initialized and must
	JR	DSPOUT		;   not be re-initialized
;
BGN060	POP	AF		;A is # of last sector on a track
	LD	H,0
	LD	L,A
	INC	HL		;HL = # sectors/track
	PUSH	HL
	LD	C,34		;divisor is sectors/directory
	SVC	@DIV16
	LD	A,L		;A = # of directories which will fit
	POP	HL		;HL = sectors/track
	CP	2
	JR	NC,BGN070	;go if room for 2 or more directories
	LD	HL,USELESS
	JP	DSPOUT
;
BGN070	LD	(LIMIT),A	;store physical limit for possible imposition
	INC	A
	LD	(CHECK),A	;value to compare with logical limit
	LD	A,(IY+8)
	AND	0E0H
	RLCA
	RLCA
	RLCA
	INC	A
	LD	C,A		;multiplier is grans/track
	LD	L,(IY+6)
	INC	L
	LD	H,0		;HL = # of tracks
	SVC	@MUL16
	LD	H,L
	LD	L,A		;HL = # grans on drive
	LD	DE,255		;for rounding up
	ADD	HL,DE
	LD	A,H		;A = logical limit ((grans+255)/256)
	CP	2		;is it > 2?
	JR	NC,BGN080	;go if so
	LD	HL,USELESS
	JP	DSPOUT
;
BGN080	CP	8		;is logical limit <= physical limit?
CHECK	EQU	$-1
	JR	C,BGN090	;if so, use logical limit
	LD	A,7		;   else impose physical limit
LIMIT	EQU	$-1
BGN090	PUSH	AF		;save # of directories to create (twice)
	PUSH	AF
	LD	(HOWMANY),A
;
	LD	HL,MODNAME
	LD	DE,LASTSEC
	LD	BC,4
	LDIR			;copy header to LASTSEC
	INC	DE		;skip over HOWMANY
	LD	HL,MAP		;copy 7-character map ('abcdefg') after HOWMANY
	LD	C,7
	LDIR			;all nec data now in LASTSEC; so write it back
	LD	A,(LSECNO)
	LD	E,A
	LD	D,(IY+9)	;p/u dir cyl number
	LD	C,0
DRIVNO	EQU	$-1		;drive number
	LD	HL,LASTSEC
	SVC	@WRSSC
	JP	NZ,ERROR
	SVC	@VRSEC
	JR	Z,BGN100
	CP	6
	JP	NZ,ERROR
;
BGN100	LD	E,0
	LD	HL,GAT		;-> base of buffer/work area
	LD	B,34
BGN110	SVC	@RDSSC
	JP	NZ,ERROR
	INC	E
	INC	H
	DJNZ	BGN110		;read directory into buffer
;
	POP	AF		;A has # sub-dirs in bits 2-0
	LD	A,'a'
	LD	(DIRCODE),A
	LD	(GAT+0D7H),A	;change last pack name char to 'a'
	LD	E,0
	LD	HL,GAT
	SVC	@WRSSC		;write GAT page back to 1st dir sector
	JR	NZ,ERROR
;
      	LD	HL,HIT+8	;keep first 8 /sys HIT entries @ 00H-07H and
	LD	DE,HIT+9	;   null out others from 08H-1FH
	LD	BC,23
	LD	(HL),0
	LDIR
	LD	HL,HIT+28H	;keep 2nd 8 /sys HIT entries @ 20H-27H and
	LD	DE,HIT+29H	;   null out all other HIT entries
	LD	BC,0D7H
	LD	(HL),0
	LDIR
;
	LD	B,8		;count first 8 pages of directory records
BGN120	PUSH	BC
	LD	H,D		;H and D both have msb of page address
	LD	L,40H
	LD	E,41H		;point HL and DE past /sys slots
	LD	BC,191
	LD	(HL),0
	LDIR			;and eliminate all non-/sys entries
	POP	BC
	DJNZ	BGN120
;
	LD	H,D		;at this point, DE -> byte 0 of 9th page
	LD	L,E
	DEC	L		;HL -> nul in last byte of 8th page
	LD	BC,24*256	;erase all dir records on 24 remaining pages
	LDIR
;
	POP	AF		;A = total number of directories to write
	DEC	A		;subtract the one already written
	LD	B,A		;B counts extra directories to write
	LD	A,(DRIVNO)
	LD	C,A		;drive number in C
	LD	E,22H		;sector address for 2nd directory
	LD	D,(IY+9)	;directory track number
BGN130	PUSH	BC
	LD	A,(DIRCODE)
	INC	A		;bump the ID character
	LD	(DIRCODE),A	;store for next time
	LD	(GAT+0D7H),A	;write to 8th char of name
;
	LD	HL,GAT		;-> base of buffer
	LD	B,34
BGN140	SVC	@WRSSC		;write directory sector
	CALL	NZ,VERIFY	;go on error
	SVC	@VRSEC		;make sure what is written is readable
	JR	Z,BGN150	;OK if no error
	CP	6		;if error, was it 'Attempt to read sys record'?
	CALL	NZ,VERIFY	;OK if so, else retry
BGN150	INC	E		;next sector number
	INC	H		;next buffer page
	DJNZ	BGN140
;
	POP	BC
	DJNZ	BGN130		;next directory
;
	LD	HL,0
	SVC	@EXIT
;
ILDRIVE	LD	A,32		;'Illegal drive number'
;
ERROR	OR	40H
	LD	C,A
	SVC	@ERROR
;
VERIFY	PUSH	BC		;save counter
	LD	B,5		;count 5 retries
VFY010	SVC	@WRSSC		;write the sector again
	JR	NZ,VFY040	;try again if error
	SVC	@VRSEC		;if it takes, verify sector
	JR	NZ,VFY030	;falls thru if no error
VFY020	POP	BC		;restore counter
	RET			;   and return for next sector write
VFY030	CP	6		;was error 'Attempt to read system record'?
	JR	Z,VFY020	;OK if so
VFY040	DJNZ	VFY010		;perform next try
	POP	BC		;after 5 failures, clear stack, report the
	JR	ERROR		;   error, and end
;
DIRCODE	DB	0
LSECNO	DB	0
;
CANT	DM	'Directory track already initialized',LF,LF
	DM	'Function aborted',LF,CR
MAP	DM	'abcdefg'
NOTHARD	DM	'Specified drive is not a hard drive',LF,CR
SYNTAX	DM	'Correct syntax is:  '
MODNAME	DM	'HDDEINIT :d',LF
	DM	'   where "d" is the drive number (0-7)',LF,CR
USELESS	DM	'Directory track not large enough to support multiple directories',LF,CR
;
	END	BEGIN
