;An example program which uses a number guessing
;game. Copyright 1988 by Mel Patrick
;Filename - GUESS/ASM
;
	ORG	3000H		;starting point of program
	GET	MASTER/SVC	;all the @SVC codes (EQUates)
;
begin	LD	A,@cls		;clear video first
	RST	svc		;so we can present some instructions
	LD	HL,inst		;point to instructions to show
	CALL	disply		;and print them on the screen
retry	LD	HL,ok		;message "I am thinking..."
	CALL	disply		;print it so we know what its doing
	CALL	random		;reseed the pseudo number generator
	CALL	rnd		;get a number from 1-255
	XOR	A		;remove old trys number
	LD	(trys),A	;save it
;
gloop	LD	HL,what		;ok, WHAT IS YOUR GUESS
	CALL	disply		;get it
	LD	HL,guess	;point to guessing buffer
	LD	B,3		;maximum 3 numbers for input
	LD	A,@keyin	;do an INPUT
	RST	svc
	JP	C,todos		;on BREAK we exit to DOS Ready
	LD	A,B		;B=length we typed in, Z=just enter
	OR	A		;see if A=0
	JR	Z,gloop		;redo on null entry
	LD	HL,guess	;else point to the ASCII number
	LD	A,@decbin	;convert to BINARY to check our number
	RST	svc		;number comes back in BC, but we need C
	LD	A,C		;get number we entered
	LD	(test),A	;save it
	LD	A,(seed)	;check against our random number
	CP	C		;if SAME we guess it!
	JR	Z,right		;go if correct guess
	JR	C,toohi		;else your number was too hi, go lower
	LD	HL,low		;else your number was TOO LOW
redo	CALL	disply		;show it
	LD	A,(trys)	;get the times we have tried to guess
	INC	A		;add one to total
	LD	(trys),A	;save it again
	JR	gloop		;and keep going
toohi	LD	HL,high		;your number was TOO HIGH, try lower
	JR	redo		;display msg, add 1 to trys, retry
right	LD	HL,hooray	;you got it
	CALL	disply		;show it
	LD	A,(trys)	;get times it took
	LD	L,A		;move to HL to convert to DECIMAL
	LD	H,0		;hopefully you got it sooner than 255
	LD	DE,total	;point to buffer to receive number
	LD	A,@bindec	;convert binary to DECIMAL
	RST	svc
	LD	HL,only		;only took you X tries msg
	CALL	disply
	LD	HL,quest	;want to try again?
	CALL	disply
	LD	A,@key		;wait for a key
	RST	svc
	AND	5FH		;convert to upper case
	CP	'Y'		;must be Y or abort
	JP	Z,retry		;go if yes
	LD	HL,thanks	;else thanks for playing
	CALL	disply
;
todos	LD	HL,0		;reset all ERROR codes first
	LD	A,@exit		;and exit to DOS
	RST	svc
;
random	LD	A,R		;read a value from the REFRESH reg
	LD	(seed),A	;it will be from 0-127, store it
	RET			;and go back
;
rnd	LD	B,24		;bits to shift through
	LD	IX,seed		;point to seed byte
rndlp	LD	A,(IX)		;read in a byte
;this next subroutine merely displays the old "I am thinking idea"
;it can be removed with no problems to the program
	PUSH	AF		;save char
	LD	C,'.'		;print a . on the video
	LD	A,@dsp
	RST	svc
	PUSH	BC		;we have to save the B count first
	LD	BC,4000		;time to make it appear "thinking"
	LD	A,@pause	;delay x micro seconds
	RST	svc
	POP	BC		;then get it back
	POP	AF		;get back original char now
;end of thinking subroutine
	RLA			;and we start the shifting to get number
	RLA
	RLA
	RLA
	RLA			;use shift to get number
	XOR	(IX)		;xor bit 18 and bit 23
	RLA			;result to carry flag
	RL	(IX+2)		;shift according to carry
	RL	(IX+1)		;to propagate
	RL	(IX)		;through the seed
	DJNZ	rndlp		;loop for 24 bits
	LD	A,(seed)	;this is the number we really want
	OR	A		;test for 0
	JR	Z,rnd		;redo if we ended up with a 0
	RET			;and go back with it
;
disply	LD	A,(HL)		;read a character of text
	CP	3		;3=end of text
	RET	Z		;back if we have printed all chars
	LD	C,A		;else move to C for display
	LD	A,@dsp		;single byte display routine
	RST	svc
	INC	HL		;point to next char in message
	JR	disply		;always ends with a 3
;
inst	DM	'                         GUESS/CMD',13,13
	DM	'  This simple program is a game which works on the same principle as the',13
	DM	'original BASIC game of HI/LOW. In effect this program will generate a random',13
	DM	'number between 1 and 255 and you will guess it. It will record the number of',13
	DM	'tries it takes you to guess the actual number it had and will tell you after',13
	DM	'each guess if you are HIGH or LOW in respect to the actual number. No bells',13
	DM	'and whistles have been added like multi-player with high scores, or saving to',13
	DM	'disk. It is meant to serve as an example and perhaps enable you to use',13
	DM	'some of the subroutines in your own programs.',13,13,3
;
ok	DM	13,'I am thinking of a number',3
what	DM	13,'What is your guess : ',3
high	DM	'Your number is TOO HIGH, try a LOWER number',13,3
low	DM	'Your number is TOO LOW, try a HIGHER number',13,3
hooray	DM	13,13,'************************* CORRECT!!!! **************************',13,3
only	DM	13,'It only took you '
total	DM	'.....'
	DM	' trys to get it!',13,3
quest	DM	13,'Do you want to play again (Y/N) : ',3
thanks	DM	13,13,'Well thanks for playing!',13,3
;
guess	DS	5		;buffer for number we enter to guess
seed	DB	6,0B0H,65H	;random number start seed
trys	DB	0		;trys to guess the number
test	DB	0		;number we guess
;
	END	begin		;auto execution address
