;	GRAM/ASM
;  0x1b + 0x14 to put printer in condensed characte2 mode
;
; routine to establish a disk file to function as a hi-res graphics board video
; ram as an ERAMDISK disk file, clear it, and establish a high-priority task to
; use this ram to continuously refresh the video display.
;
;	 written 04 Jan 90, J.F.R. "Frank" Slinkman
;
; this code is placed in the public domain, and all are welcome to use it,
; modify it, and/or adapt it to suit your own purposes and uses.  However,
; proper credit to the original author in the program or in the program docs
; would be appreciated.
;
*GET EQUATES			;SVC and HD64180 definitions
;
	ORG	3000H
;
ABORTMS	DM	LF,LF,'Job aborted',CR
BILBORD	DM	28,31,LF,TAB+37,'GRAM',LF
	DM	TAB+24,'by J.F.R. Slinkman     04 Jan 90',LF,TAB+14
	DM	'Establishes graphics video ram at 0xB000 in bank 10',LF
	DM	TAB+21,'and GRAM/IMG disk file on the ERAMDISK',LF
	DM	TAB+17,'and enables task slot 11 graphics refresh task',LF,LF
	DM	TAB+22,'Type number of desired refresh rate:',LF,LF
	DM	TAB+22,'[1]  60 lines/sec (4 seconds/screen)',LF
	DM	TAB+22,'[2] 120 lines/sec (2 seconds/screen)',LF
	DM	TAB+22,'[3] 180 lines/sec (1.333 sec/screen)',LF
	DM	TAB+22,'[4] 240 lines/sec (1  second/screen)',LF
	DM	TAB+22,'[5] 300 lines/sec (0.8   sec/screen)',LF
	DM	TAB+22,'[6] 360 lines/sec (0.667 sec/screen)',LF
	DM	TAB+22,'[8] 480 lines/sec (0.500 sec/screen)',LF,LF,CR
CRE8	DM	'create gram/img:'
DRIVNO	DM	'0 (lrl=80,rec=256)',CR
ERD	DM	'ERD',CR
INACTMS	DM	'ERAMDISK inactive!',ETX
NOBNKMS	DM	'ERAMDISK does not include Bank 10!',ETX
NOERDMS	DM	'ERAMDISK not installed!',ETX
NOSPACE	DM	'Memory needed for GRAM/IMG already in use!',ETX
NOT2MSG	DM	'ERAMDISK must be Type 2!',ETX
PERRMSG	DM	'Parameter error!',ETX
STRTCYL	NOP
TASKMSG	DM	'Task slot 11 already in use!',ETX
;
;
BEGIN	LD	HL,BILBORD
	SVC	@DSPLY
BGN002	SVC	@KEY		;get response to menu prompt
	CP	'1'
	JR	C,BGN002	;nfg if < '1'
	CP	'7'
	JR	Z,BGN002	;240 won't divide by 7
	CP	'9'
	JR	NC,BGN002	;nfg if > '8'
	XOR	30H		;convert to binary
;
	LD	(RFSH010-1),A	;result is number of lines per iteration
	LD	C,A		;# of lines/itr is divisor
	LD	E,240		;screen height in lines is dividend
	SVC	@DIV8
	LD	(CODE+5),A	;initiate iteration counter in task code
	LD	(RFSH030+1),A	;   and it's replacement value
;
	LD	DE,ERD
	SVC	@GTMOD		;is ERAMDISK installed?
	JR	Z,BGN010	;go if so
;
	LD	HL,NOERDMS
ABORT	SVC	@DSPLY
	LD	HL,ABORTMS
	SVC	@DSPLY
	SVC	@EXIT
;
BGN010	LD	C,7		;here, HL -> ERAMDISK module
BGN020	SVC	@GTDCT		;test each drive slot in turn (7 to 0)
	LD	A,(IY)		;p/u 1st byte of DCT
	CP	0C9H		;drive inactive?
	JR	Z,BGN030	;go if so
	LD	A,(IY+1)
	CP	L		;do lsbs match?
	JR	NZ,BGN030
	LD	A,(IY+2)
	CP	H		;do msbs match?
	JR	Z,BGN040	;go if ERAMDISK DCT found
BGN030	DEC	C		;   else try next lower slot number
	JP	P,BGN020	;   while slot number >= 0
	LD	HL,INACTMS	;here if ERAMDISK inactive
	JR	ABORT
;
BGN040	LD	A,C		;C is ERAMDISK drive slot number
	OR	30H		;convert to ASCII
	LD	(DRIVNO),A	;put drive number in CREATE command
	LD	A,(IY+8)
	AND	1FH		;isolate sectors per granule
	CP	1		;is it a type 2 drive?
	JR	Z,BGN050	;go if so
	LD	HL,NOT2MSG
	JR	ABORT
;
BGN050	LD	BC,20AH		;B is function code, C specifies bank 10
	SVC	@BANK		;is bank 10 in use?
	JR	NZ,BGN060	;go if so
	LD	HL,NOBNKMS
	JR	ABORT
;
BGN060	CP	2BH		;was there a param error?
	JR	NZ,BGN080	;go if not
BGN070	LD	HL,PERRMSG
	JR	ABORT
;
BGN080	LD	A,(IY+6)	;p/u highest cyl number (offset 0)
	SUB	4		;we need five x 4K cyls to hold 19,200 bytes
	LD	(STRTCYL),A	;store result
	ADD	A,5		;A = # of ERAMDISK cylinders
	SRL	A
	SRL	A
	SRL	A		;div by 8 to get # of eramdisk banks
	SUB	11
	NEG			;A = starting ERAMDISK bank
	LD	C,A
	LD	B,0
	SVC	@BANK		;select 1st ERAMDISK bank
	LD	HL,9000H	;-> GAT
	LD	A,(STRTCYL)
	LD	L,A		;-> GAT entry for 5th from last track
	LD	B,5		;count 5 tracks we need
	XOR	A		;test value
BGN090	CP	(HL)
	JR	NZ,BGN100	;go if track in use
	INC	HL
	DJNZ	BGN090
	JR	BGN110		;go if all 5 top tracks available
BGN100	LD	HL,NOSPACE
	JP	ABORT
;
BGN110	SVC	@FLAGS
	LD	A,(IY)		;preserve AFLAG$ value
	PUSH	AF
	LD	A,(STRTCYL)
	LD	(IY),A		;force system to put file in top 5 tracks
	LD	HL,CRE8
	SVC	@CMNDR		;create GRAM/IMG file
	POP	AF;
	LD	(IY),A		;restore original AFLAG$ value
	LD	A,H
	OR	L
	JR	Z,BGN120	;go if no error (from create command)
	SVC	@EXIT
;
BGN120	LD	BC,10		;code to select bank 10
	SVC	@BANK
	JP	NZ,ERROR
	LD	HL,0B000H	;-> start of graphics image area
	LD	DE,0B001H
	LD	BC,19199
	LD	(HL),0
	LDIR			;null out graphics ram area
	LD	HL,CODE
	LD	BC,CODELEN
	LDIR			;put guts of task code at top of bank 10
	LD	A,0FEH
	OUT	(CONTROL),A	;put both RS and uL boards in normal mode
	OUT	(YREG),A
	LD	A,80		;set gfx board to 80,254 (these coordinates
	OUT	(XREG),A	;   exist only on RS board)
	LD	A,55H		;graphics board test value
	LD	E,A
	OUT	(GFXDAT),A	;send test value to board
	LD	BC,1200
	SVC	@PAUSE		;wait 1/60th of a second
	IN	A,(GFXDAT)	;read value back
	CP	E		;does value read = value written?
	JR	NZ,BGN130	;if not, it's a uL board
	LD	A,0BBH		;RS board code for auto inc X on write, waits
	OUT	(CONTROL),A	;   on, gfx on
	LD	A,1
	OUT	(8EH),A		;enable RS board text overlay
	JR	BGN140
BGN130	LD	A,0B9H		;uL board code for auto inc X on write, text
	OUT	(CONTROL),A	;   on, gfx on
BGN140	LD	BC,0
	SVC	@BANK		;select bank 0
	JP	NZ,ERROR
	LD	C,11
	SVC	@CKTSK		;is task slot 0 free?
	JR	Z,BGN150	;go if so
	LD	HL,TASKMSG
	JP	ABORT
;
BGN150	LD	HL,(206H)	;get address of 1st available lomem byte
	PUSH	HL		;save old value
	EX	DE,HL		;lomem ptr in DE
	LD	HL,TASKLEN
	ADD	HL,DE		;possible new lomem ptr
	LD	BC,1301H	;top of lomem + 1
	SBC	HL,BC		;set CY if room in lomem
	JR	NC,BGN160	;go if task must be put in high memory
;
	LD	HL,2		;here if task will fit in lomem
	ADD	HL,DE		;calculate value of header word
	LD	(GFXTASK),HL	;and write it to task header
	LD	HL,GFXTASK
	LD	BC,TASKLEN
	LDIR			;put task in low memory
	LD	(206H),DE	;update lomem address
	POP	DE		;old value is task address
	JR	BGN180		;go to initiate task
;
BGN160	EQU	$		;here if task must go to high memory
	POP	HL		;clear stack
	LD	B,0
	LD	HL,0
	SVC	@HIGH$		;get high memory pointer
	JR	Z,BGN170
;
ERROR	OR	40H
	LD	C,A
	SVC	@ERROR
;
BGN170	EX	DE,HL		;old hi-mem pointer becomes dest address
	LD	HL,ENDTASK	;-> end of task code
	LD	BC,TASKLEN
	LDDR			;put task in high memory
	EX	DE,HL
	SVC	@HIGH$		;update HIGH$ (B=0 from LDDR)
	JR	NZ,ERROR
	INC	HL		;-> start of task
	EX	DE,HL		;DE is now task address
	LD	HL,2
	ADD	HL,DE		;HL -> start of actual task code
	EX	DE,HL
	LD	(HL),E
	INC	HL
	LD	(HL),D		;write actual start to task header
	DEC	HL
	EX	DE,HL		;and restore to DE
;
BGN180	LD	HL,VRAMADD-ADJUST
	LD	BC,528H
	OTIMR			;initiate DMAC0 source and dest addresses
	LD	C,11		;specify task slot 11
	SVC	@ADTSK		;initiate the task
	LD	HL,0
	SVC	@EXIT
;
;
GFXTASK	DW	DO_IT
DO_IT	LD	HL,0FB00H	;address of actual task code in bank 10
	LD	BC,8AH		;bank 10 with bit 7 set
	SVC	@BANK		;this amouts to a jump to 7FB00H
ENDTASK	RET			;difficult to error check AND turn off task
TASKLEN	EQU	$-GFXTASK	;   within the task, so to heck with it. Be-
				;   sides, all requirements for success already
				;   checked and verified.
;
ADJUST	EQU	0FB00H-$	;offset for hard addresses after code is moved
;
CODE	PUSH	HL		;return address
	PUSH	BC		;previous bank info
	JR	REFRESH
;
ROW	EQU	$+ADJUST
	NOP			;current gfx board row number
ITCTR	EQU	$+ADJUST
	DB	40		;iteration counter (set from menu response)
VRAMADD	EQU	$+ADJUST
	DB	0		;data for MAR1L	(28H)	\
	DB	0B0H		;data for MAR1H (29H)	 >  source address
	DB	7		;data for MAR1B	(2AH)	/
	DW	GFXDAT		;data for IAR1 (2BH & 2CH)  dest port
LENGTH	EQU	$+ADJUST
	DW	80		;data for BCR	(2EH & 2FH) bytes to send
	DB	80H		;data for DSTAT	(30H)       DMAC0 enable
;
REFRESH	IN0	E,DCNTL		;store DCNTL value
	XOR	A		;set DCNTL for 0,1,80 and level sense (for some
	OUT0	DCNTL,A		;   reason, edge sense won't work)
	LD	D,6		;count lines of data to send (set from menu)
RFSH010	XOR	A
	OUT	(XREG),A	;set gfx board to column 0
	LD	A,(ROW)
	OUT	(YREG),A	;   and to current row number
	INC	A
	LD	(ROW),A		;update ROW
	LD	HL,LENGTH
	LD	BC,32EH		;3 bytes for internal ports 2EH to 30H
	OTIMR			;this sends one 80-byte line
	DEC	D
	JR	NZ,RFSH010	;while line counter > 0
;
	LD	HL,ITCTR
	DEC	(HL)		;has entire screen been filled?
	JR	Z,RFSH030	;go if so
;
RFSH020	OUT0	DCNTL,E		;restore original DCNTL value
	POP	BC		;old bank info
	POP	HL		;return address
	SVC	@BANK		;return to task module
;
RFSH030	LD	(HL),40		;reset iteration counter (set from menu)
	LD	HL,VRAMADD
	LD	BC,328H
	OTIMR			;reset video ram address to start of data
	XOR	A
	LD	(ROW),A		;reset ROW to 0
	JR	RFSH020
;
CODELEN	EQU	$-CODE
;
	END	BEGIN
