GPRT105 - 7 bit graphics printer utility ver 01.02.00


ADDR    OPCODE          MNEMONIC        COMMENTS

4000    11 D2 40        LD DE,40D2      Input parameters from
4003    3E 11           LD A,11         command line, exit program
4005    EF              RST 28          on error
4006    C2 B8 40        JP NZ,40B8

4009    21 C5 40        LD HL,40C5      Set graphics mode on printer,
400C    3E 0E           LD A,0E         exit program on error
400E    EF              RST 28
400F    C2 B8 40        JP NZ,40B8

4012    3A E5 40        LD A,(40E5)     Set graphics board to 
4015    E6 01           AND A,01        increment Y on read, set bit 0
4017    F6 D0           OR A,D0         if VIEW=Y
4019    D3 83           OUT 83,A

401B    3A E7 40        LD A,(40E7)     Set start X coordinate to 4F
401E    D3 80           OUT 80,A

4020    21 04 41        LD HL,4104      Read data into graphics buffer
4023    CD 78 40        CALL 4078

4026    3E 6A           LD A,6A         Check for BREAK key, exit if
4028    EF              RST 28          pressed
4029    C2 B0 40        JP NZ,40B0

402C    3A E8 40        LD A,(40E8)     Shift data N bits from shift
402F    B7              OR A,A          buffer into graphics buffer
4030    28 03           JR Z,03
4032    CD 81 40        CALL 4081

4035    CD 9A 40        CALL 409A       Print graphics from buffer,
4038    C2 B8 40        JP NZ,40B8      exit program on error

403B    21 00 42        LD HL,4200      Read data into shift buffer
403E    CD 78 40        CALL 4078

4041    3A E7 40        LD A,(40E7)     If X=0 print last column, end
4044    B7              OR A,A          program
4045    28 15           JR Z,15

4047    3A E8 40        LD A,(40E8)     If N=7 set N=0, print unshifted
404A    FE 07           CP A,07         data
404C    20 06           JR NZ,06
404E    AF              XOR A,A
404F    32 E8 40        LD (40E8),A
4052    18 CC           JR CC

4054    21 E7 40        LD HL,40E7      Decrement X, increment N,
4057    35              DEC (HL)        continue to next column
4058    23              INC HL
4059    34              INC (HL)
405A    18 BF           JR BF

405C    21 04 41        LD HL,4104      Fill graphics buffer with 00
405F    06 F0           LD B,F0         if INV=N else FF if INV=Y
4061    3A E3 40        LD A,(40E3)
4064    77              LD (HL),A
4065    23              INC HL
4066    10 FC           DJNZ,FB

4068    21 E8 40        LD HL,40E8      Increment N
406B    34              INC (HL)

406C    CD 81 40        CALL 4081       Shift data N bits into graphics
406F    CD 9A 40        CALL 409A       buffer, print last column, exit
4072    C2 B8 40        JP NZ,40B8      program on error

4075    C3 B0 40        JP 40B0         Done, end program

4078    AF              XOR A,A         Set Y coordinate to 0, read
4079    D3 81           OUT 81,A        data into buffer specified by
407B    01 82 F0        LD BC,F082      HL from caller, return to program
407E    ED B2           INIR
4080    C9              RET

4081    21 04 41        LD HL,4104      Shift N bits from shift buffer
4084    11 00 42        LD DE,4200      to graphics buffer, return to
4087    06 F0           LD B,F0         program
4089    C5              PUSH BC
408A    3A E8 40        LD A,(40E8)
408D    47              LD B,A
408E    1A              LD A,(DE)
408F    17              RLA
4090    CB 16           RL (HL)
4092    10 FB           DJNZ,FB
4094    13              INC DE
4095    23              INC HL
4096    C1              POP BC
4097    10 F0           DJNZ,F0
4099    C9              RET

409A    21 04 41        LD HL,4104      Prepare data for print and
409D    06 F0           LD B,F0         invert if INV=Y, print data,
409F    3A E3 40        LD A,(40E3)     return to program
40A2    AE              XOR A,(HL)
40A3    F6 80           OR A,80
40A5    77              LD (HL),A
40A6    23              INC HL
40A7    10 F6           DJNZ,F6
40A9    21 00 41        LD HL,4100
40AC    3E 0E           LD A,0E
40AE    EF              RST 28
40AF    C9              RET

40B0    21 CC 40        LD HL,40CC      Set printer to text mode,
40B3    3E 0E           LD A,0E         exit program if no errors
40B5    EF              RST 28
40B6    28 06           JR Z,06

40B8    F6 40           OR A,40         Set error display options
40BA    4F              LD C,A          display error message
40BB    3E 1A           LD A,1A
40BD    EF              RST 28

40BE    3E F0           LD A,F0         Reset graphics board
40C0    D3 83           OUT 83,A

40C2    3E 16           LD A,16         Exit to DOS
40C4    EF              RST 28

40C5    1E 1B 17 1B                     Set printer to graphics data
        0E 12 03

40CC    1E 1B 0F 1B                     Set printer to text mode data
        13 03

40D2    80 53 49 4E                     Parameter table
        56 00 E1 40
        54 56 49 45
        57 00 E3 40
        00

40E3    00 00 00 00                     Parameter address vectors

40E7    4F                              X coordinate start value
40E8    00                              N start value

4100    1B 10 00 30                     Tab format for print buffer
