;	DR -- Program to use wildspec to dipslay file names on a disk(s)
;
LF	EQU	0AH
CR	EQU	0DH
ETX	EQU	03H
;
@FLAGS	EQU	65H
@CKDRV	EQU	21H
@DODIR	EQU	22H
@DSP	EQU	02H
@ERROR	EQU	1AH
@LOGOT	EQU	0CH
@CKBRKC EQU	6AH
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
	ORG	3000H
;
START:	LD	(OLD_SP),SP	;Save old stack for exit
	SVC	@CKBRKC
	JR	NZ,EX_EXT	;GO EXTENDED ERROR EXIT
	CALL	DR		;GO DO THE COMMAND
	LD	HL,0		;SHOW NO ERROR EXIT
	JR	EXIT		;AND LEAVE
;
DOSERR:	LD	L,A		;MOVE RET CODE TO HL
	LD	H,00H
	OR	0C0H		;SET SHORT, RET BITS
	LD	C,A		;MOVE TO C FOR ERROR
	SVC	@ERROR
	JR	EXIT
;
PRG_ERR:
	SVC	@LOGOT
EX_EXT:	LD	HL,-1
EXIT:	LD	SP,0000H	;RESTORE OLD STACK
OLD_SP:	EQU	$-2
	SVC	@CKBRKC
	RET			;RETURN TO CALLING PROGRAM
;
DR:	CALL	SKIP_SPC
	CP	' '		;CK FOR CTRL CHAR
	JP	C,NO_DRV	;IF END OF LINE, GO DO EVERYTHING
	CP	'-'		;CK FOR NEG WILDSPEC
	JR	NZ,MOVE_FILE
	LD	(NEG_FLG),A	;SET NEGATIVE FLAG
	LD	A,(HL)		;P/U NEXT CHAR
	INC	HL		;BUMP TO NEXT CHAR
MOVE_FILE:
	LD	DE,FILE_NAME	;BUFFER FOR WILD FILE NAME
	LD	B,9		;LEN OF FILE NAME + 1
	CALL	MOVE_SPEC
	JP	Z,WILD_ERR
	CP	'/'		;NEXT CHAR MARK EXT?
	JR	NZ,MOVE_DRV
	INC	HL		;MOVE PAST EXT MARKER
	LD	DE,FILE_EXT
	LD	B,4		;LEN OF EXT + 1
	CALL	MOVE_SPEC
	JP	Z,WILD_ERR
MOVE_DRV:
	CALL	CK_DRV_NUM
	JR	NZ,NO_DRV	;NO DRIVE, SKIP
	LD	(DRV_STUF1),A	;SAVE DRIVE NUM
	LD	(DRV_STUF2),A	;TWICE
NO_DRV:
	LD	C,00H		;P/U DRIVE NUMBER
DRV_STUF1: EQU	$-1
	LD	HL,DIR_BUF
LP_4:	SVC	@CKDRV
	JR	Z,DRV_RDY
	LD	A,(DRV_STUF2)	;P/U DRIVE NUMBER
	INC	A		;TEST
	LD	A,20H		;SET ILLEGAL DRIVE NUMBER ERROR
	JP	NZ,DOSERR	;GO ERROR
	JR	NXT_DRV		;ELSE GET NEXT DRIVE NUMBER
;
DRV_RDY:
	PUSH	HL		;SAVE DIR BUF PTR
	PUSH	BC		;SAVE DRIVE NUM IN C
	LD	B,1		;FUNCTION: DIR TO MEMORY
	SVC	@DODIR
	POP	BC		;P/U DRIVE NUMBER
	JP	NZ,DOSERR
	POP	HL		;P/U BUFFER PTR
	LD	DE,16		;LEN OF DIR ENTRY - 2
LP_5:
	LD	A,(HL)		;P/U FIRST BYTE OF ENTRY
	INC	A		;TEST FOR 0FFH
	JR	Z,DRV_CONT
	INC	HL		;HL==>DATE MOD FIELD
	INC	HL
	LD	(HL),C		;SAVE DRIVE NUMBER
	ADD	HL,DE		;OFFSET HL TO NEXT ENTRY
	JR	LP_5		;AND LOOP FOR ENTIRE DIR
;
DRV_CONT:
	LD	A,0FFH
DRV_STUF2: EQU	$-1
	INC	A		;TEST FOR LAST DRIVE
	JR	NZ,SELECT	;DONE LOADING DIRS, NOW SELECT FILES
NXT_DRV:
	INC	C		;BUMP DRIVE NUMBER
	LD	A,C		;MOVE TO A
	CP	8		;CK FOR HIGHEST DRIVE
	JR	C,LP_4		;LOOP FOR ALL DRIVES
				;IF LAST DRIVE, FALL INTO SELECT
;
SELECT:
	LD	(BUF_END),HL	;SAVE END OF BUFFER PTR
	LD	HL,DIR_BUF
LP_3:	PUSH	HL		;SAVE BUFFER PTR
	LD	(BP_STUF),HL
	SVC	@CKBRKC		;CK FOR BREAK
	JP	NZ,EX_EXT
	PUSH	HL		;SAVE CURRENT POINTER
	LD	DE,$-$
BUF_END	EQU	$-2
	OR	A		;CLEAR CARRY
	SBC	HL,DE		;COMPARE TWO
	POP	HL		;RESTORE POINTER
	JR	C,CONT		;CONTINUE IF HL < DE
				;I.E., BUF PTR < END OF BUFFER
	POP	HL		;CLEAR STACK
	XOR	A		;SET Z FLAG
	RET			;RETURN
;
CONT:	CALL	MATCH		;CK FOR MATCH TO WILD SPEC
	JP	NZ,NOT_MATCHED	;NOT MATCHED, GET NEXT ENTRY
	LD	HL,0000H	;P/U DIR BUF PTR
BP_STUF: EQU	$-2
	LD	DE,5		;OFFSET TO FILE NAME
	ADD	HL,DE		;HL==>FILE NAME
	CALL	DSP_F_SPEC
	LD	A,CR		;DISPLAY A CR
	CALL	DSPC
;
NOT_MATCHED:
	POP	HL		;P/U DIR BUF PTR
	LD	DE,18		;OFFSET TO NEXT DIR ENTRY
	ADD	HL,DE		;HL==>NEXT DIR ENTRY
	JP	LP_3		;LOOP TIL DONE
;
DSPC:
	PUSH	BC		;SAVE COUNT IN B
	LD	C,A		;MOVE CHAR TO C
	SVC	@DSP
	POP	BC		;RESTORE COUNT
	RET	Z		;RET NO ERROR, ELSE GO ERROR
	JP	DOSERR
;
SYN_ERR:
	LD	HL,SYN_ERR$
	DB	0DDH
WILD_ERR:
	LD	HL,WILD_ERR$
	JP	PRG_ERR
;
DSP_F_SPEC:
	CALL	DSP_FN		;DSP 8 CHAR FILE NAME
	LD	C,B		;P/U NUM OF SPACES
	LD	B,00H		;BC==OFFSET TO EXT
	ADD	HL,BC		;HL==>EXT
	LD	A,(HL)		;P/U EXT CHAR
	CP	' '		;FIRST CHAR A SPACE?
	JR	Z,DSP_DRV	;YES, GO DSP drive
	LD	A,'/'		;NO, DSP /
	CALL	DSPC
	CALL	DSP_FX		;& EXT OF FILE
;
DSP_DRV:
	LD	A,':'
	CALL	DSPC
	LD	HL,(BP_STUF)
GET_DRV:
	INC	HL		;HL==>DRIVE # IN DIR
	INC	HL
	LD	A,(HL)		;P/U DRIVE #
	AND	07H		;MASK FOR DRIVE #
	OR	30H		;MAKE ASCII
	CALL	DSPC
	RET
;
MATCH:
	PUSH	HL		;SAVE PTR TO DIR ENTRY
	LD	DE,5		;OFFSET TO FILE NAME
	ADD	HL,DE		;HL==>FILE NAME
	LD	DE,FILE_NAME	;DE==>WILD SPEC TO MATCH
	LD	BC,0802H	;B=8 CHAR, C=2 FIELDS
LP_9:
	LD	A,(DE)		;P/U CHAR FROM WILD SPEC
	CP	'?'		;MATCH ANY CHAR?
	JR	Z,NXT_CHR
	CP	'*'		;REST OF FIELD?
	JR	Z,SKP_FLD
	CP	(HL)		;CP TO FILE NAME
	JR	NZ,END_MATCH
;
NXT_CHR:
	INC	HL		;BUMP PTR TO FILE NAME
	INC	DE		;BUMP PTR TO WILD SPEC
	DJNZ	LP_9		;AND LOOP FOR FIELD
;
MATCH_X:
	LD	B,03H		;LEN OF EXT
	DEC	C		;DEC COUNT OF FIELDS
	JR	NZ,LP_9		;MATCH EXT FIELD IF POSSIBLE
	JR	END_MATCH	;ELSE AT END OF MATCH
;
SKP_FLD:
	INC	HL		;BUMP FILE PTR TO NEXT FIELD
	INC	DE		;BUMP WILD PTR TO NEXT FIELD
	DJNZ	SKP_FLD
	JR	MATCH_X		;AND MATCH NEXT FIELD
;
END_MATCH:
	POP	HL		;P/U PTR TO DIR ENTRY
	LD	A,00H		;P/U NEGATIVE FLAG
NEG_FLG: EQU	$-1
	JR	NZ,TST_NEG	;NO MATCH FROM ABOVE, TEST NEG
	OR	A		;MATCH FROM ABOVE, SET Z ACC NEG
	RET			;RET Z IF USE ENTRY
;
TST_NEG:
	XOR	'-'		;NO MATCH FROM ABOVE, CP NEG FLAG
	RET			;RET Z IF USE ENTRY
;
CK_DRV_NUM:
	LD	A,(HL)		;P/U WILD CHAR
	CP	':'		;DRIVE NUM MARKER?
	RET	NZ		;NO, RETURN
	INC	HL		;HL==>DRIVE NUM
	LD	A,(HL)		;P/U DRIVE NUM
	CP	'0'		;0 OR GREATER?
	JP	C,SYN_ERR	;NO, GO SYNTAX ERROR
	CP	'8'		;7 OR LESS?
	JP	NC,SYN_ERR	;NO, GO SYNTAX ERROR
	INC	HL		;HL==>NEXT CHAR
	AND	07H		;MAKE DRIVE NUM BINARY
	CP	A		;SET Z FLAG
	RET
;
SKIP_SPC:
	LD	A,(HL)
	CP	' '
	RET	NZ
	INC	HL
	JR	SKIP_SPC
;
MOVE_SPEC
	LD	A,(HL)		;P/U WILD SPEC CHAR
	CALL	TO_UPPER
	RET	NZ
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	MOVE_SPEC
	RET
;
TO_UPPER:
	BIT	7,A		;TEST ASCII
	RET	NZ		;NOT, GO BACK
	CP	'a'		;LESS THAN 'a'?
	JR	C,SKP_1		;yes, skip
	RES	5,A		;MAKE UPPER CASE
SKP_1:
	CP	'?'
	RET	Z
	CP	'*'
	RET	Z
	CP	'0'
	RET	C
	CP	':'
	JR	NC,SKP_2
	CP	A
	RET
SKP_2:
	CP	'A'
	RET	C
	CP	'Z'
	RET	NC
	CP	A
	RET
;
DSP_FX:
	LD	B,03H		;B=LEN OF EXT
	LD	DE,0806H	;DUMMY FOR LD B,8
DSP_FN:	EQU	$-2
LP_10:
	LD	A,(HL)
	CP	' '
	RET	Z
	INC	HL
	CALL	DSPC
	DJNZ	LP_10
	RET
;
FILE_NAME: DB	'*       '
FILE_EXT: DB	'*  '
SYN_ERR$: DB	'Syntax error: DR WILDCARDSPEC',CR
WILD_ERR$: DB	'Wildcardspec syntax error!',CR
DIR_BUF: DS	32257		;STORGE FOR 18 BYTES PER REC
				; * 256 MAX DIR RECS/DRIVE
				; * MAX DRIVES + 1 FOR FINAL BYTE
;
	END	START
