;GETDISK4/ASM v.2.0
;by Lance Wolstrup and Gary W. Shanafelt
;Copyright (c) 1993 - all rights reserved
;
;for TRS-80 Model 4
;converts entire single-sided, single-density
;Model I disk to a normal data file
;directory of Model I disk MUST be on track 17
;
	ORG	3000H
START	LD	C,15		;cursor off
	LD	A,2		;@dsp
	RST	40
;
	LD	A,105		;@cls
	RST	40
;
	LD	HL,HELLO$ 	;point to header msg
	LD	A,10		;@dsply
	RST	40
;
ASKSRC	LD	HL,0906H	;print@(9,6)
	CALL	LOCATE		;position cursor
;
	LD	HL,SRCMSG 	;point to source prompt
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;set default
	LD	(SRC),A		;and store it
;
	LD	HL,BUFFER	;point to buffer
	LD	BC,0100H  	;max input chr=1
	LD	A,9		;@keyin
	RST	40
;
	JP	C,EXIT		;exit if break
;
	LD	HL,BUFFER 	;point to input
	LD	A,(HL)		;and get it
	CP	13		;is it just enter?
	JR	Z,ASKDST 	;yes-default chosen-jump
;
	CP	30H		;is it 0?
	JR	C,ASKSRC 	;jump if less
	CP	38H		;jump if
	JR	NC,ASKSRC 	;larger than 7
	SUB	30H		;drv num legal - so strip ascii
	LD	(SRC),A		;and store in buffer
;
ASKDST	LD	HL,0B00H 	;print@(11,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,DSTMSG	;point to destination prompt
	LD	A,10		;@dsply
	RST	40
;
	LD	A,2		;set default
	LD	(DST),A		;and store it
;
	LD	HL,BUFFER	;point to common buffer
	LD	BC,0100H	;max char input is 1
	LD	A,9		;@keyin
	RST	40
;
	JR	C,ASKSRC	;to previous prompt if break
;
	LD	HL,BUFFER	;point to input
	LD	A,(HL)		;and get it
;
	CP	13
	JR	Z,ASKTRK	;jump if default
;
	CP	30H		;is it 0
	JR	C,ASKDST	;jump if less
	CP	38H		;is it 7 or more
	JR	NC,ASKDST	;jump if so
;
	SUB	30H		;strip ascii
	LD	B,A		;dst drv num to B
	LD	A,(SRC)		;get src drv num
	CP	B		;compare them
	JR	NZ,SETDST	;jump if different
;
DRVERR	LD	HL,0D00H	;print@(13,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,SRCDST	;point to error message
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;@key
	RST	40
;
	CP	13		;is it enter
	JR	NZ,DRVERR	;not enter - so prompt again
	JR	ASKDST		;go ask for destination drive num
;
SETDST	LD	A,B		;retrieve dst drive number
	LD	(DST),A		;and store it
;
ASKTRK	LD	HL,0D08H	;print@(13,8)
	CALL	LOCATE		;position cursor
;
	LD	HL,TRKMSG	;point to track prompt
	LD	A,10		;@dsply
	RST	40
;
	LD	A,35		;set up default
	LD	(TRK),A		;and store it
;
	LD	HL,BUFFER	;point to input buffer
	LD	BC,0200H	;max input chars=2
	LD	A,9		;@keyin
	RST	40
;
	JR	C,ASKDST	;jump if break
	LD	A,B		;num of key strokes to a
	OR	A		;any there
	JR	Z,ASKNAM	;jump if default
;
	LD	HL,BUFFER	;point to input
	LD	A,96		;@dechex
	RST	40
;
	LD	A,C		;xfer hex number to a
	CP	35		;is it 35 tracks
	JR	C,ASKTRK	;jump if less
	CP	81		;max is 80 tracks
	JR	NC,ASKTRK	;jump if larger than 80
;
	LD	(TRK),A		;store number of tracks
;
ASKNAM	LD	HL,0F0FH	;print@(15,15)
	CALL	LOCATE		;position cursor
;
	LD	HL,NAMMSG	;point to name message
	LD	A,10		;@dsply
	RST	40
;
	LD	HL,BUFFER	;point to input buffer
	LD	BC,1800H	;max input char=23+cr
	LD	A,9		;@keyin
	RST	40
;
	JR	C,ASKTRK	;previous prompt if break
;
	LD	A,B		;get number of chars input
	OR	A		;any input there?
	JR	Z,ASKNAM	;yes - assume filename - jump
;
PUTDN	INC	HL		;find end of filename
	LD	A,(HL)		;get char
	CP	':'		;is drv number attached
	JR	Z,PUTDN1	;attached-so skip colon
	DJNZ	PUTDN
;
	LD	A,':'		;append colon
	LD	(HL),A		;to filename
PUTDN1	INC	HL		;next filename position
	LD	A,(DST)		;get destination drive number
	ADD	A,30H		;make it ascii
	LD	(HL),A		;append it to filename
	INC	HL		;next filename position
	LD	A,13		;append
	LD	(HL),A		;terminator to filename
;
ASKRDY	LD	HL,1200H	;print@(18,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,RDYMSG	;point to ready message
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;@key
	RST	40
;
	CP	80H		;is it break
	JR	Z,ASKNAM	;back to previous prompt if break
;
	CP	13		;is it enter
	JR	NZ,ASKRDY	;no - ask again
;
	LD	HL,1200H	;print@(18,0)
	CALL	LOCATE		;position cursor
;
	LD	C,15		;cursor off
	LD	A,2		;@dsp
	RST	40
	LD	C,31		;clear to end of display
	LD	A,2		;@dsp
	RST	40
;
	LD	HL,BUFFER	;point to filespec
	LD	DE,FCB		;point to fcb
	LD	A,78		;@fspec
	RST	40
;
	LD	HL,BUFFER	;point to i/o buffer
	LD	B,0		;rec len=256
	LD	A,58		;@init
	RST	40
;
	LD	A,(TRK)		;get number of tracks
	LD	B,A		;xfer to b
	LD	A,(SRC)		;get source drive number
	LD	C,A		;xfer to c
	LD	A,41		;@slct
	RST	40
;
	LD	D,0		;begin at track 0
TLOOP	PUSH	BC		;save track loop counter
	PUSH	DE		;save current track number
	LD	HL,1200H	;print@(18,0)
	CALL	LOCATE		;position cursor
	LD	L,D		;trk num to hl
	LD	H,0
	LD	DE,DECTRK	;convert to decimal
	LD	A,97		;@hexdec
	RST	40
;
	LD	HL,RDMSG	;display message
	LD	A,10		;@dsply
	RST	40
;
	POP	DE		;restore current track number
	POP	BC		;restore track loop counter
	PUSH	BC		;save track loop
	LD	E,0		;sector 0
	PUSH	DE		;save track
	LD	HL,BUFFER	;point to i/o buffer
	LD	B,10		;10 sectors
SLOOP	LD	A,49		;@rdsec
	RST	40
	JR	Z,SLOOP1	;jump if good read
	CP	6		;is it dir read error
	JR	NZ,ERROR	;jump only if other error
SLOOP1	PUSH	DE		;save sector
	LD	DE,256		;point to next
	ADD	HL,DE		;segment of buffer
	POP	DE		;restore sector
	INC	E		;next sector
	DJNZ	SLOOP
;
	LD	HL,1200H	;vertical=18, horizontal=0
	CALL	LOCATE		;position cursor
;
	LD	HL,WRTMSG	;point to write message
	LD	A,10		;@dsply
	RST	40
;
	LD	B,10		;10 sectors
	LD	HL,BUFFER	;point to i/o buffer
	LD	DE,FCB		;point to fcb
	PUSH	DE		;copy fcb pointer
	POP	IX		;to ix
WLOOP	LD	(IX+3),L	;stuff address of current
	LD	(IX+4),H	;buffer segment in fcb
	LD	A,75		;@write
	RST	40
	JR	NZ,ERROR	;jump if write error
;
	PUSH	DE		;save fcb pointer
	LD	DE,256		;figure new address
	ADD	HL,DE
	POP	DE		;restore fcb pointer
	DJNZ	WLOOP
;
	POP	DE		;restore tracks
	INC	D		;next track
	POP	BC		;restore counter
	DJNZ	TLOOP
;
	LD	DE,FCB		;point to fcb
	LD	A,60		;@close
	RST	40
;
ASKRPT	LD	HL,1200H 	;print@(18,0)
	CALL	LOCATE		;position cursor
	LD	HL,OKMSG 	;point to message
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;@kbd
	RST	40
	CP	80H		;is it break?
	JR	Z,EXIT		;yes - jump to exit
	CP	13		;is it enter?
	JP	Z,ASKSRC	;yes - back to 1st prompt
	JR	ASKRPT		;no - so prompt again
;
EXIT	LD	C,14		;cursor on
	LD	A,2		;@dsp
	RST	40
	RET			;back to dos
;
ERROR	POP	DE
	POP	BC
	OR	192		;set bits 6 & 7
	LD	C,A
	LD	HL,1500H 	;print@(21,0)
	CALL	LOCATE
	LD	A,26		;@error
	RST	40
	JR	EXIT
;
LOCATE	PUSH	BC
	PUSH	DE
	LD	B,3	;position cursor
	LD	A,15	;@vdctl
	RST	40
	POP	DE
	POP	BC
	RET
;
HELLO$	DB	'GETDISK4',10,10
	DB	'Transfer a single-sided, single-density '
	DB	'Model I disk into a normal data file',10
	DB	'By Lance Wolstrup and Gary W. Shanafelt',10
	DB	'Copyright ',21,239,21
	DB	' 1993 v.2.0. All rights reserved',10,10
	DB	'NOTE: The destination disk must have more '
	DB	'free space than the source disk!!',13
;
SRCMSG	DB	15,31
	DB	'Enter source drive number (default = 1): ',14,3
;
DSTMSG	DB	15,31
	DB	'Enter destinataion drive number (default = 2): ',14,3
;
SRCDST	DB	15
	DB	'The source and destination drives cannot be the same '
	DB	'- press ENTER to continue ',14,3
;
TRKMSG	DB	15,31
	DB	'Enter number of tracks (default = 35): ',14,3
;
;
NAMMSG	DB	15,31
	DB	'Enter name of destination file: ',14,3
;
RDYMSG	DB	15,31
	DB	'Press ENTER when source and destination disks '
	DB	'are ready ',14,3
;
OKMSG	DB	15,31
	DB	'Disk is now transferred to normal data file - '
	DB	'press ENTER to continue ',14,3
;
WRTMSG	DB	'Writing',3
RDMSG	DB	31
	DB	'Reading track '
DECTRK	DS	5
	DB	13
;
SRC	DB	0
DST	DB	0
TRK	DB	0
FCB	DS	32
BUFFER	DS	2560
;
	END	START
