;****************************************************************
;	GETIM6/ASM  - gets the date and time from a ADC Modem
;	and installs them as system time under TRSDOS/LS-DOS 6.
;
;	Original program by Steven C. Jenkins (72407,2012)
;	Modified for EDAS/MRAS assembler and to correct problems
;	in accessing the modem while HD drivers installed in
;	high memory.  Also corrects 12 hour error at the 12
;	midnight and 12 noon point.  Extensive commenting added.
;
;	The value at the YEAR label should be corrected for the
;	current year and the string in the REQUEST label should
;	be changed to either AT@T or AT*T depending upon the
;	model of your DAK modem.
;				Jim Gaffney (70515,1036)
;****************************************************************
@GET	EQU	3
@MSG	EQU	13
@DATE	EQU	18
@TIME	EQU	19
@EXIT	EQU	22
@GTDCB	EQU	82
@MUL8	EQU	90
;
	ORG	3000H
SVC	MACRO	#RST_ADDR
	LD	A,#RST_ADDR
	RST	40
	ENDM
MULT8	MACRO
	LD	C,A			;Load multiplicand
	LD	E,10			;Load multiplier
	LD	A,5AH
	SVC	@MUL8			;Call 8 bit multiply
	ENDM
;****************************************************************
START	LD	DE,'LC'			;Load device name in reverse order
	SVC	@GTDCB			;Get Device Control Block
	JR	NZ,DIRECT		;Failure, do it the hard way
	LD	(DCB),HL		;Save pointer to DCB
	LD	HL,REQUEST		;Load request for Time/Date to modem
	LD	DE,(DCB)		;Point to *CL for @GET
	SVC	@MSG			;Send it
	LD	HL,INTAKE		;point to intake buffer
GETLUP	SVC	@GET			;get 1st byte
	JR	NZ,GETLUP		;loop on error
	CP	0AH			;line feed (the end)?
	JR	Z,STEP2			;done, start the conversions
	LD	(HL),A			;else store the character,
	INC	HL			;bump the pointer
	JR	GETLUP			;and loop to next character
;==================================================================
DIRECT	LD	A,55H
	OUT	(0E8H),A		;UART Master reset
	OUT	(0E9H),A		;Baud rate generator - 300
	LD	A,6CH
	OUT	(0EAH),A		;To UART status register
	LD	HL,REQUEST		;Point to message to send
	LD	B,5			;Number of char to send
PAUSE1	IN	A,(0EAH)		;get status
	BIT	6,A			;check if ready
	JR	Z,PAUSE1		;loop until ready
	LD	A,(HL)			;load char to send
	INC	HL			;bump pointer
	OUT	(0EBH),A		;send out character
PAUSE1A	IN	A,(0EAH)		;get status
	BIT	7,A
	JR	Z,PAUSE1A		;Loop until ready
	IN	A,(0EBH)		;UART transmit/holding reg.
	DJNZ	PAUSE1			;Loop until all char. sent
	LD	HL,INTAKE		;point to storage area
PAUSE2	IN	A,(0EAH)		;get status
	BIT	7,A
	JR	Z,PAUSE2		;loop until ready
	IN	A,(0EBH)		;get a character
	CP	0AH			;LF?
	JR	NZ,PAUSE2		;flush echo-back
	LD	HL,INTAKE		;point to storage area again
PAUSE3	IN	A,(0EAH)		;get status
	BIT	7,A
	JR	Z,PAUSE3		;loop until ready
	IN	A,(0EBH)		;Input a character
	LD	(HL),A			;store it
	INC	HL			;Bump the pointer
	CP	0AH			;LF?
	JR	NZ,PAUSE3		;No, loop for another char.
	JR	STEP3			;go start computations
STEP2	LD	HL,INTAKE		;Point to the modem ASCII output
STP2LUP	SVC	@GET			;(DCB)
	JR	NZ,STP2LUP		;loop on error
	LD	(HL),A			;store a character into INTAKE
	INC	HL			;bump pointer
	CP	0AH			;line feed?
	JR	NZ,STP2LUP		;not done, loop for more
STEP3	LD	A,(INTAKE)		;Read 1st month char
	CP	'0'			;Is is a zero?
	LD	B,0			;Store zero for tens digit
	JR	Z,MONTH1		; and go
	LD	B,10			;Else store 1 for tens digit
MONTH1	LD	A,(INTAKE+1)		;Get 2nd month character
	SUB	'0'			;Strip ASCII bias
	ADD	A,B			;add in the appropriate tens digit
	LD	B,A			;Month is in reg. B in hex
	LD	A,(INTAKE+3)		;Get 1st day character
	SUB	'0'			;Strip ASCII bias
	PUSH	BC			;Save month
	MULT8				;Mult. 1st day character by ten
	POP	BC			;Restore month
	LD	C,A			;put 1st day character in C
	LD	A,(INTAKE+4)		;get 2nd day character
	SUB	'0'			;Strip ASCII bias
	ADD	A,C			;Add back in 1st day character
	LD	C,A			;Day is in reg. C in hex
	PUSH	BC			;Save month and date
	LD	HL,DUMBUF		;Point to dummy buffer
	SVC	@DATE			;DUMBUF
	POP	BC			;get month and day back
	PUSH	DE			;save pointer to date storage area
	POP	HL			;use HL to point to DATE$
	LD	A,(YEAR)		;get year
	LD	(HL),A			;store it
	INC	HL			;move to day
	LD	(HL),C			;stuff it there
	INC	HL			;move to month
	LD	(HL),B			;and stuff THAT too.
	LD	A,(INTAKE+6)		;get 1st hour digit
	CP	'0'			;is 1st digit a zero
	LD	B,0			;store zero for tens digit
	JR	Z,HOUR1			;and go
	LD	B,10			;else store 1 for tens digit
HOUR1	LD	A,(INTAKE+7)		;get 2nd hour digit
	SUB	'0'			;strip the ASCII bias
	ADD	A,B			;add back in the tens digit
	LD	B,A			;Hour is in B register
	LD	A,(INTAKE+15)		;get AM/PM character
	CP	'A'			;Is it an A?
	LD	A,0			;add no 24 hour clock bias
	JR	Z,HOUR2			;and go
	LD	A,12			;else correct for P.M.
HOUR2	ADD	A,B			;add appropriate bias
	CP	12			;is time midnite -> 1 a.m.?
	JR	NZ,CHK24		;no, check for noon
	SUB	12			; yes, chg it back to" 00" hours
	JR	TIMOUT			;and put into time$ slot
CHK24	CP	24			;is time noon -> 1 p.m.?
	JR	NZ,TIMOUT		;no, send the time
	SUB	12			; yes, change it back to "12" hours
TIMOUT	LD	B,A			;now in 24-hr format
	PUSH	BC			;and save it
	LD	HL,DUMBUF		;Point to dummy buffer
	SVC	@TIME			;Get TIME$ pointer
	POP	BC			;restore 24 hour time
	PUSH	DE			;time location to stack
	POP	IX			;and then back to IX
	LD	(IX+2),B		;get the hour done.
	LD	A,(INTAKE+9)		;get 1st minutes character
	SUB	'0'			;Strip the ASCII bias
	MULT8				;Multipy it by 10
	LD	B,A			;Put it into B
	LD	A,(INTAKE+10)		;get 2nd minutes character
	SUB	'0'			;strip the ASCII bias
	ADD	A,B			;Add in the tens digit
	LD	(IX+1),A		;stuff the minutes in.
	LD	A,(INTAKE+12)		;get the 1st seconds character
	SUB	'0'			;strip the ASCII bias
	MULT8				;multiply it by 10
	LD	B,A			;and save it in B
	LD	A,(INTAKE+13)		;get the 2nd seconds digit
	SUB	'0'			;strip the ASCII bias
	ADD	A,B			;Add back in the tens digit
	LD	(IX+0),A		;and stuff the seconds into place.
	XOR	A			;zero the accumulator
	LD	HL,0			;and the HL register
	SVC	@EXIT			;and jump back to DOS
YEAR	DB	87			;change to match current year
REQUEST	DB	'AT*T',13		; String must match your Modem type
DUMBUF	DB	'         '		;DUMMY BUFFER
DCB	DW	0			;DCB for Modem
INTAKE	DS	30			;storage for TRSDOS date/time
	END	START
T