/*
 * Converted for BDS compiler (under CP/M-80), 20-Jan-83, by Chris Kern.
 * for AZTEC C 03/15/87 by Les Mikesell (w/wild card dir internal)
 * #define TRS and either TRS4 or TRS3 to compile (should also work
 * with MISOSYS C compiler)
 */
/*
 * The	information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 *	Copyright (C) 1980, DECUS
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the	fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#include <stdio/h>		/* stdio.h for other compilers */
#include <ctype/h>
#define ERROR 0
#define CPMEOF 26

#ifdef DOC

char	*documentation[] {
	"grep searches a file for a given pattern.  Execute by",
	"	 grep [flags] regular_expression file_list",
	"",
	"Flags are single characters preceeded by '-':",
	"   -c     Only a count of matching lines is printed",
	"   -f     Print file name for matching lines switch, see below",
	"   -n     Each line is preceeded by its line number",
	"   -v     Only print non-matching lines",
	"",
	"On RSX, RT11, RSTS, input or output may be redirected:",
	"	 grep ... <file.in >file.out",
	"The file_list is a list of files (wildcards are acceptable on RSX modes).",
	"If no files are given, input comes from the terminal.	There is no prompting.",

	"The file name is normally printed if there is a file given.",
	"The -f flag reverses this action (print name no file, not if more).",
	"",
	"The regular_expression defines the pattern to search for.  Upper- and",
	"lower-case are always ignored.  Blank lines never match.  The expression",
	"should be quoted to prevent file-name translation.",
	"x	An ordinary character (not mentioned below) matches that character.",
	"'\\'	The backslash quotes any character.  \"\\$\" matches a dollar-sign.",
	"'^'	A circumflex at the beginning of an expression matches the",
	"	  beginning of a line.",
	"'$'	A dollar-sign at the end of an expression matches the end of",
	"	  a line.",
	"'.'	A period matches any character except \"new-line\".",
	"':a'	A colon matches a class of characters described by the following",
	"':d'	  character.  \":a\" matches any alphabetic, \":d\" matches digits,",
	"':n'	  \":n\" matches alphanumerics, \": \" matches spaces, tabs, and",
	"': '	  other control characters, such as new-line.",
	"'*'	An expression followed by an asterisk matches zero or more",
	"	  occurrances of that expression: \"fo*\" matches \"f\", \"fo\"",
	"	  \"foo\", etc.",
	"'+'	An expression followed by a plus sign matches one or more",
	"	  occurrances of that expression: \"fo+\" matches \"fo\", etc.",
	"'-'	An expression followed by a minus sign optionally matches",
	"	  the expression.",
	"'[]'	A string enclosed in square brackets matches any character in",
	"	  that string, but no others.  If the first character in the",
	"	  string is a circumflex, the expression matches any character",
	"	  except \"new-line\" and the characters in the string.  For",
	"	  example, \"[xyz]\" matches \"xx\" and \"zyx\", while \"[^xyz]\"",
	"	  matches \"abc\" but not \"axb\".  A range of characters may be",
	"	  specified by two characters separated by \"-\".  Note that,",
	"	  [a-z] matches alphabetics, while [z-a] never matches.",
	"",
	"The concatenation of regular expressions is a regular expression.",
	"",
	0 };

#endif

#define LMAX	512
#define PMAX	256

#define CHAR	1
#define BOL	2
#define EOL	3
#define ANY	4
#define CLASS	5
#define NCLASS	6
#define STAR	7
#define PLUS	8
#define MINUS	9
#define ALPHA	10
#define DIGIT	11
#define NALPHA	12
#define PUNCT	13
#define RANGE	14
#define ENDPAT	15

int	cflag;
int	fflag;
int	nflag;
int	vflag;
int	nfile;

int	debug ;		/* Set for debug code		*/

char	*pp;

char	file_name[81];

char	lbuf[LMAX];
char	pbuf[PMAX];
char *program;

main(argc, argv)
char *argv[];
{
	register char	*p;
	register int	c, i;
	char *fnms;
	int		gotpattern;
	int		gotcha;

	FILE		*f;

	cflag = fflag = nflag = vflag = debug = nfile = 0;
#ifdef TRS
	skflg();  /* clear & init KFLAG address */
#endif

	program = argv[0]; /* save for error messages */
	if (argc < 2)
		usage("No arguments");
	if (argc == 2 && argv[1][0] == '?' && argv[1][1] == 0) {
		help();
		exit(0);
	}
	gotpattern = 0;
	while (--argc)  {
		p = *++argv ;
		if (*p == '-') {
			while (c = *++p) {
				switch(tolower(c)) {

				case '?':
					help();
					break;

				case 'c':
					++cflag;
					break;

				case 'd':
					++debug;
					break;

				case 'f':
					++fflag;
					break;

				case 'n':
					++nflag;
					break;

				case 'v':
					++vflag;
					break;

				default:
					usage("Unknown flag");
				} /* end switch */
			} /* end while */
		} else if (!gotpattern) {
			compile(p);
			++gotpattern;
		} else {
			break;
		}
	}
	if (!gotpattern)
		usage("No pattern");
	if (argc == 0)
		grep(stdin, 0);
	else {
		fflag = fflag ^ (argc > 0);
#ifdef TRS
		argv=wcx(&argc,argv);
#endif
		for (i=0; i < argc; ++i) {
			if (p = argv[i]) {
#ifdef TRS4
				setro();
#endif
				if ((f= fopen(p,"r")) == ERROR)
					cant(p);
				else {
					grep(f,p);
					fclose(f);
				}
			}
		}
	}
}


file(s)
char *s;
{
	printf("File %s:\n", s);
}

cant(s)
char *s;
{
	fprintf(stderr,"\n%s: cannot open %s\n",program, s);
}

help()
/*
 * Give good help
 */
{
#ifndef DOC
	printf("%s [options] regular_expression file_list",program);
	printf("\n\noptions:");
	printf("\n        -c   just print count of matching lines");
	printf("\n        -f   don't print file name");
	printf("\n        -n   number matching lines");
	printf("\n        -v   print non-matching lines");
	printf("\nin pattern:");
	printf("\n        ^  = beginning of line");
	printf("\n        $  = end of line");
	printf("\n        .  = any character except newline");
	printf("\n        :a = any alphabetic character");
	printf("\n        :d = any digit");
	printf("\n        :n = any alphanumeric");
	printf("\n        :_ = any white space character");
	printf("\n        *  = zero or more occurrances of previous character");
	printf("\n        +  = one or more occurrances");
	printf("\n        -  = previous character optional");
	printf("\n        \\  = escape (match following metacharacter literally)");
	printf("\n        []   enclose character set (form: [abcde] or [a-e])\n");

#else

	register char	**dp;

	for (dp = documentation; *dp; dp++)
		printf("%s\n", *dp);

#endif

}


usage(s)
char	*s;
{
	fprintf(stderr, "?%s-E -%s\n",program,s);
	fprintf(stderr,"Usage: %s [-cfnv] pattern [file ...].  %s ? for help\n",program,program);
	exit(1);
}

compile(source)
char		*source;	/* Pattern to compile			*/
/*
 * Compile the pattern into global pbuf[]
 */
{
	register char		*s;	/* Source string pointer	*/
	register char		*lp;	/* Last pattern pointer 	*/
	register int		c;	/* Current character		*/
	int			o;	/* Temp 			*/
	char			*spp;	/* Save beginning of pattern	*/
	char		*cclass();	/* Compile class routine	*/

	s = source;
	if (debug)
		printf("Pattern = \"%s\"\n", s);
	pp = pbuf;
	while (c = *s++) {
		/*
				 * STAR, PLUS and MINUS are special.
				 */
		if (c == '*' || c == '+' || c == '-') {
			if (pp == pbuf || (o=pp[-1]) == BOL ||
				o == EOL || o == STAR ||
				o == PLUS || o == MINUS)
				badpat("Illegal occurrance op.", source, s);
			store(ENDPAT);
			store(ENDPAT);
			spp = pp;		/* Save pattern end	*/
			while (--pp > lp)	/* Move pattern down	*/
				*pp = pp[-1];	/* one byte		*/
			*pp =	(c == '*') ? STAR :
			(c == '-') ? MINUS : PLUS;
			pp = spp;		/* Restore pattern end	*/
			continue;
		}
		/*
				 * All the rest.
				 */
		lp = pp;			/* Remember start	*/
		switch(c) {

		case '^':
			store(BOL);
			break;

		case '$':
			store(EOL);
			break;

		case '.':
			store(ANY);
			break;

		case '[':
			s = cclass(source, s);
			break;

		case ':':
			if (*s) {
				c = *s++;
				switch(tolower(c)) {

				case 'a':
					store(ALPHA);
					break;

				case 'd':
					store(DIGIT);
					break;

				case 'n':
					store(NALPHA);
					break;

				case '_':
					store(PUNCT);
					break;

				default:
					badpat("Unknown : type", source, s);

				}
				break;
			}	else	badpat("No : type", source, s);

		case '\\':
			if (*s)
				c = *s++;

		default:
			store(CHAR);
			store(tolower(c));
		}
	}
	store(ENDPAT);
	store(0);				/* Terminate string	*/
	if (debug) {
		for (lp = pbuf; lp < pp;) {
			if ((c = (*lp++ & 0377)) < ' ')
				printf("\\%o ", c);
			else	printf("%c ", c);
		}
		printf("\n");
	}
}

char *
cclass(source, src)
char		*source;	/* Pattern start -- for error msg.	*/
char		*src;		/* Class start				*/
/*
 * Compile a class (within [])
 */
{
	register char	*s;		/* Source pointer		*/
	register char	*cp;		/* Pattern start		*/
	register int	c;		/* Current character		*/
	int		o;		/* Temp 			*/

	s = src;
	o = CLASS;
	if (*s == '^') {
		++s;
		o = NCLASS;
	}
	store(o);
	cp = pp;
	store(0);				/* Byte count		*/
	while ((c = *s++) && c!=']') {
		if (c == '\\') {		/* Store quoted char	*/
			if ((c = *s++) == '\0') /* Gotta get something	*/
				badpat("Class terminates badly", source, s);
			else	store(tolower(c));
		}	else if (c == '-' &&
			(pp - cp) > 1 && *s != ']' && *s != '\0') {
			c = pp[-1];		/* Range start		*/
			pp[-1] = RANGE; 	/* Range signal 	*/
			store(c);		/* Re-store start	*/
			c = *s++;		/* Get end char and	*/
			store(tolower(c));	/* Store it		*/
		} else {
			store(tolower(c));	/* Store normal char	*/
		}
	}
	if (c != ']')
		badpat("Unterminated class", source, s);
	if ((c = (pp - cp)) >= 256)
		badpat("Class too large", source, s);
	if (c == 0)
		badpat("Empty class", source, s);
	*cp = c;
	return(s);
}

store(op)
{
	if (pp >= &pbuf[PMAX])
		error("Pattern too complex\n");
	*pp++ = op;
}


badpat(message, source, stop)
char		*message;	/* Error message			*/
char		*source;	/* Pattern start			*/
char		*stop;		/* Pattern end				*/
{
	register int	c;

	fprintf(stderr, "-GREP-E-%s, pattern is\"%s\"\n", message, source);
	fprintf(stderr, "-GREP-E-Stopped at byte %d, '%c'\n",
	stop-source, stop[-1]);
	error("Bad pattern\n");
}

grep(fp, fn)
FILE		*fp;		/* File to process			*/
char		*fn;		/* File name (for -f option)		*/
/*
 * Scan the file for the pattern in pbuf[]
 */
{
	register int lno, count, m;

	lno = 0;
	count = 0;
	while (fgetss(lbuf, LMAX, fp)) {
		++lno;
		m = match();
		if ((m && !vflag) || (!m && vflag)) {
			++count;
			if (!cflag) {
				if (fflag && fn) {
					file(fn);
					fn = 0;
				}
				if (nflag)
					printf("%d  \t", lno);
				printf("%s\n", lbuf);
			}
		}
	}
	if (cflag) {
		if (fflag && fn)
			file(fn);
		printf("%d\n", count);
	}
}


match()
/*
 * Match the current line (in lbuf[]), return 1 if it does.
 */
{
	register char	*l;		/* Line pointer 		*/
	char *pmatch();

	for (l = lbuf; *l; l++) {
		if (pmatch(l, pbuf))
			return(1);
	}
	return(0);
}

char *
pmatch(line, pattern)
char		*line;		/* (partial) line to match		*/
char		*pattern;	/* (partial) pattern to match		*/
{
	register char	*l;		/* Current line pointer 	*/
	register char	*p;		/* Current pattern pointer	*/
	register char	c;		/* Current character		*/
	char		*e;		/* End for STAR and PLUS match	*/
	int		op;		/* Pattern operation		*/
	int		n;		/* Class counter		*/
	char		*are;		/* Start of STAR match		*/

	l = line;
	if (debug > 1)
		printf("pmatch(\"%s\")\n", line);
	p = pattern;
	while ((op = *p++) != ENDPAT) {
		if (debug > 1)
			printf("byte[%d] = 0%o, '%c', op = 0%o\n",
			l-line, *l, *l, op);
		switch(op) {

		case CHAR:
			if (tolower(*l) != *p++)
				return(0);
			l++;
			break;

		case BOL:
			if (l != lbuf)
				return(0);
			break;

		case EOL:
			if (*l != '\0')
				return(0);
			break;

		case ANY:
			if (*l++ == '\0')
				return(0);
			break;

		case DIGIT:
			if ((c = *l++) < '0' || (c > '9'))
				return(0);
			break;

		case ALPHA:
			c = tolower(*l);
			l++;
			if (c < 'a' || c > 'z')
				return(0);
			break;

		case NALPHA:
			c = tolower(*l);
			l++;
			if (c >= 'a' && c <= 'z')
				break;
			else if (c < '0' || c > '9')
				return(0);
			break;

		case PUNCT:
			c = *l++;
			if (c == 0 || c > ' ')
				return(0);
			break;

		case CLASS:
		case NCLASS:
			c = tolower(*l);
			l++;
			n = *p++ & 0377;
			do {
				if (*p == RANGE) {
					p += 3;
					n -= 2;
					if (c >= p[-2] && c <= p[-1])
						break;
				} else if (c == *p++)
					break;
			} while (--n > 1);
			if ((op == CLASS) == (n <= 1))
				return(0);
			if (op == CLASS)
				p += n - 2;
			break;

		case MINUS:
			e = pmatch(l, p);	/* Look for a match	*/
			while (*p++ != ENDPAT); /* Skip over pattern	*/
			if (e)			/* Got a match? 	*/
				l = e;		/* Yes, update string	*/
			break;			/* Always succeeds	*/

		case PLUS:			/* One or more ...	*/
			if ((l = pmatch(l, p)) == 0)
				return(0);	/* Gotta have a match	*/
		case STAR:			/* Zero or more ...	*/
			are = l;		/* Remember line start	*/
			while (*l && (e = pmatch(l, p)))
				l = e;		/* Get longest match	*/
			while (*p++ != ENDPAT); /* Skip over pattern	*/
			while (l >= are) {	/* Try to match rest	*/
				if (e = pmatch(l, p))
					return(e);
				--l;		/* Nope, try earlier	*/
			}
			return(0);		/* Nothing else worked	*/

		default:
			printf("Bad op code %d\n", op);
			error("Cannot happen -- match\n");
		}
	}
	return(l);
}

fgetss(s, n, iop)
char *s;
int n;
FILE *iop;
{
	register int	c;
	register char	*cs;

#ifdef TRS
	if (ckflg()) exit (1);
#endif
	cs = s;
	while (--n)
		if ((c = getc(iop)) == CPMEOF) {
			if (cs != s)
				ungetc(c, iop);
			break;
		} else if (c == EOF)
			break;
		else if (c == '\r') {
			if ((c = getc(iop)) != '\n')
				ungetc(c, iop);
			break;
		} else
		*cs++ = c;
	*cs = '\0';
	return ((c == CPMEOF || c == EOF && cs == s) ? NULL : s);
}


error(s)
char *s;
{
	fprintf(stderr, "%s: %s",program,s);
	exit(1);
}

/* This could be replaced with #option wildcard when compiled
 * with the MISOSYS compiler if you don't mind losing the
 * ability to start a pattern with a * followed by an alpha char
 * /

/* wild card filename entry expansion function
 * call with: argv = wcx(&argc,argv)
 * returns new argv array and modifies argc if
 * wildcards are matched
 * argv[0] is not handled as a special case so
 * that the routine may be called to expand a
 * single filename
 * argv is an array of pointers to strings that
 * may be wildcard filenames
 * argc is the int count of the strings
*/
/*
 * wild card is of the form * / *[.pswd]:* (possibly allow ranges later)
 * ? matches any single char / * matches from posn to end of field
 * if ? or * is in file spec and no drive spec given
 * :* assumed (all drives) 
 * trsdos filenames = 8 char name,3 char ext
 * :d = drive spec
 * could have 240 * 8 entries if * / *:*
 * if no match is found the pattern is left unchanged in the argv array
 */
#define ARGNUM 1000  /* max argc allowed */

wcx (cptr,argv) /* expand wild card filespec */
int *cptr;
char **argv;
{
	FILE *dir;           /* read directory as a file */
	char *targv[ARGNUM]; /* local argv array */
	char buff[20];       /* space to construct filename */
	char drive[3];       /* space for drive spec */
	char dirbuff[32];    /* space for raw directory read */
	char *cp,*qp,c,d,dpat; 
	int i,k,j,n,argn;
	drive[0] = ':';
	drive[2] = '\0';      /* set up as string */
	argn = 0; /* index for new argv array */
	for (k=0 ; k < *cptr; k++)  { /* for each argument passed */
		cp = targv[argn] = argv[k]; /* copy pointer to argument */
		/* look for wc */
		if (index(cp,'*') || index (cp,'?') || *cp == '!')  {  /* has wc */
			/*  have possible filespec, now  cycle through drives */
			i=0;        /* flag no match yet */
			dpat = '?';
			if ((qp=index(cp,':')) && isdigit(*++qp)) dpat = *qp;
			for (d='0' ; d<'8' ; d++) {
				drive[1] = d;
				if (dpat == '?' || d == dpat) {
					strcpy (buff,"DIR/SYS");
					strcat (buff,drive);
					if ((dir = fopen (buff,"r")) == NULL)
						continue; /* skip this one */
					fseek (dir,512L,0);/*skip GAT/HIT */
					while (fread(dirbuff,32,1,dir) > 0) {
						/* directory entries 1st byte means:
												 * bit 3, 1 = inv
												 * bit 4, 1 = alive
												 * bit 6, 1 = system
												 * bit 7, 1 = fxde
												 * so mask all others, look for only bit 4 = 1
												 * to find live, vis, fpde only
												*/
						if((*dirbuff == 0x10 ) && /* live,visfpde */
						( n= wlddir(cp,dirbuff+5,buff))) {
							/* found a match - save copy of filename */
							++i;  /* flag match */
							if ((targv[argn]=malloc(n+3)) == NULL) {
nospace:
								fputs ("wcx: no memory\n",stderr);
								exit (-1);
							}
							strcpy (targv[argn],buff);
							strcat(targv[argn++],drive);
						} /* end if live etc. */
					} /* end while (fread) */
					fclose (dir);
				} /* end if this drive */
			} /* end for (drives) */
			/*          if (i==0) argn++;    keep old pattern */
		} /* end if wildc */
		else argn++; /* if not wildc then count copied oldarg */
	}/*end for (args) */
	/* if wildcards expanded to more than one, must alloc new argv array */
	if (argn > *cptr ) {
		if((argv = malloc (argn * 2)) == NULL)/* should be sizeof (char *) */
			goto nospace;
	}
	for (j=0;j<argn;j++) argv[j] = targv[j];
	*cptr = argn; /* set new argc */
	return (argv);
} /* end function */

/* put matching directory entry in buffer as actual filename */
/* return # of chars used in storeit - 0 means no match */
wlddir (spec,actual,storeit)
char *spec,*actual,*storeit;
{
	char c,d;
	int i,n,notflag,nomatch;
	i=notflag =nomatch= 0;
	if (*spec == '!') {
		notflag=1;
		spec++;
	}
	for (n=0; n<11; n++) { /* max 11 chars moved */
		if (n==8) { /* moving to ext field */
			if (actual [n] != ' ') storeit [i++] = '/';
			if (c== '*') spec++;
			c = *spec;
			if (c == '/' || c== '.') spec++;
		} /* end if  n==8 */
		if ((d = actual[n]) != ' ') storeit[i++] = d;
		c = toupper (*spec);
		switch (c) {
		case '.':  /* allow *.* like other systems */
		case '/':
		case '\0':
		case ':':  /* do not advance on these terminators */
			c = ' ';
			break;
		case '*':
			break;
		default:
			spec++;
			break;
		} /* end switch */
		/* set flags according to specified wc for posn */
		if (!(c == '*' ||   /* matchall */
		c == d ||     /* actual match */
		(c =='?' && d != ' '))) nomatch=1; /* match non-space */
	} /* end for chars */
	if (notflag) nomatch = !nomatch; /* reverse sense of match */
	if (nomatch) return (0); /* skip this one */
	if ( (c = *spec) && c != '.')  c = *++spec;      /* if not end of spec */
	if (c =='.') {           /* password may be here */
		for (n=0;n<6;n++) { 
			if ( (c = *spec++) && c != ':' )
				storeit[i++]=c;
			else break;
		} /* end for */
	} /* end if */
	storeit[i++] = '\0';
	return (i);
} /* end function */

/* This probably doesn't have to be quite this strange, but it should work 
 * with both AZTEC's 8080 assembler and the MISOSYS compiler (MC)
 */
#ifdef TRS4
setro()
{
#asm
; fix problem of OPEN error with lrl >0 (AZTEC)
  DB 0FDH,0E5H          ; PUSH IY
  DB 3EH,65H            ; LD      A,101
  DB 0EFH               ; RST     40
  DB 0FDH,0CBH,12H,0C6H ; SET 0,(IY+'S'-'A')
  DB 0FDH,0E1H          ; POP IY
  DB 0C9H               ; RET
#endasm
}
skflg() {
#asm
; get KFLAG address & clear brk and pause bits
  DB 0FDH,0E5H          ; PUSH IY
  DB 3EH,65H            ; LD      A,101
  DB 0EFH               ; RST     40
  DB 0FDH,0E5H          ; PUSH IY
  DB 0D1H               ; POP     DE
  DB 21H,0AH,00H        ; LD      HL,'K'-'A'      ;offset to KFLAG$
  DB 19H                ; ADD     HL,DE           ;HL=>KFLAG$
  DB 22H
  DW _KFLAG             ; LD      (_KFLAG),HL      ;store pointer
  DB 0CBH,86H           ; RES     0,(HL)          ;kick break bit off
  DB 0CBH,8EH           ; RES     1,(HL)          ;pause also
  DB 0FDH,0E1H          ; POP IY
  DB 0C9H               ; RET
#endasm
}
ckflg() 
{
#asm
; check brk/pause, wait for pause ret 
  DB 3AH                ; LD A,(_KFLAG)
_KFLAG: DW 0
  DB 0FH                ; RRCA                 ;Test <BREAK> bit
  DB 38H,27H            ; JR     C,_GOTBRK
  DB 0FH                ; RRCA                 ; test <PAUSE> bit
  DB 38H,05H            ; JR     C,_GOTPS
  DB 21H,00,00          ; LD     HL,0
  DB 0AFH               ; XOR    A
  DB 0C9H               ; RET
;_GOTPS:
  DB 0CDH
  DW _RESKFL            ;  CALL   _RESKFL        ;
;_CLRLP:
  DB 3EH,08H            ; LD     A,8 
  DB 0EFH               ; RST    40
  DB 28H,0FBH           ; JR     Z,_CLRLP       ;Clear type-ahead
;_ISPAWS:
  DB 3EH,01H            ; LD     A,1           ;@key
  DB 0EFH               ; RST    40
  DB 0FEH,80H           ; CP     80H
  DB 28H,10H            ; JR     Z,_GOTBRK
  DB 0FEH,60H           ; CP     60H           ;Pause char
  DB 28H,0F5H           ; JR     Z,_ISPAWS
;
_RESKFL:
  DB 2AH
  DW _KFLAG             ; LD     HL,(_KFLAG)  ;Get correct KFLAG$
  DB 0CBH,86H           ; RES    0,(HL)
  DB 0CBH,8EH           ; RES    1,(HL)
  DB 21H,00,00          ; LD     HL,0
  DB 0AFH               ; XOR    A
  DB 0C9H               ; RET
;
_GOTBRK:
  DB 3EH,08H            ; LD A,8
  DB 0EFH               ; RST 40
  DB 21H,01H,00H        ; LD   HL,1
  DB 0B5H               ; OR   L
  DB 0C9H               ; RET
;
#endasm
}
#endif
/* actually this is for LDOS mod 3 (& 1 with modified AZTEC lib */
#ifdef TRS3
skflg()
{
#asm
;get KFLAG address & clear brk and pause bits
    DB 3AH,25H,01H       ; LD      A,(125H)
    DB 0EEH,49H          ; XOR     'I'
    DB 21H,23H,44H       ; LD      HL,4423H    ; mod 1 KFLAG$
    DB 20H,03H           ; JR      NZ,M1            ;HL=>KFLAG$
    DB 21H,9FH,42H       ; LD      HL,429FH    ; mod 3 KFLAG$
;M1:
    DB 22H               ; LD      (_KFLAG),HL      ;store pointer
    DW _KFLAG
    DB 0CBH,86H          ; RES     0,(HL)          ;kick break bit off
    DB 0CBH,8EH          ; RES     1,(HL)          ;pause also
    DB 0C9H              ; RET
#endasm
}
ckflg()
{
#asm
; check brk/pause, wait for pause ret 
    DB 3AH               ; LD A,(_KFLAG)
_KFLAG: DW 0
    DB 0FH               ; RRCA                 ;Test <BREAK> bit
    DB 38H,28H           ; JR     C,_GOTBRK
    DB 0FH               ; RRCA                 ; test <PAUSE> bit
    DB 38H,05H           ; JR     C,_GOTPS
    DB 21H,00,00         ; LD     HL,0
    DB 0AFH              ; XOR    A
    DB 0C9H              ; RET
;_GOTPS:
    DB 0CDH
    DW _RESKFL           ; CALL   _RESKFL        ;
; _CLRLP:
    DB 0CDH,2BH,00       ; CALL    2BH        ;@kbd
    DB 0B7H              ; OR     A
    DB 20H,0FAH          ; JR     NZ,_CLRLP   ;Clear type-ahead
; _ISPAWS:
    DB  0CDH,49H,00      ; CALL   49H           ;@key
    DB  0FEH,01H         ; CP     1
    DB 28H,10H           ; JR     Z,_GOTBRK
    DB 0FEH,60H          ; CP     60H           ;Pause char
    DB  28H,0F5H         ; JR     Z,_ISPAWS
;
_RESKFL:
    DB  2AH
    DW _KFLAG             ; LD     HL,(_KFLAG)  ;Get correct KFLAG$
    DB  0CBH,86H          ; RES    0,(HL)
    DB  0CBH,8EH          ; RES    1,(HL)
    DB  21H,00H,00H       ; LD     HL,0
    DB  0AFH              ; XOR    A
    DB  0C9H              ; RET
;_GOTBRK:
    DB  0CDH,2BH,00H      ; CALL 2BH
    DB  21H,01H,00H       ; LD   HL,1
    DB  0B5H              ; OR   L
    DB  0C9H              ; RET
#endasm
}
#endif
