	ORG	3000H
START	EQU	$
	CALL	GINIT
	CALL	GCLS
	LD	HL,0000H
	LD	BC,50AAH
	LD	DE,0EE80H
	CALL	BOX
	LD	HL,0510H
	LD	DE,MSG1
	CALL	DSPLY
	CALL	GRON
	CALL	INKEY
	CALL	GROFF
	RET
;
;------------------------------
;BOX - draw box on screen
;enter with HL = YX
;           BC = length,Xcharacter
;	    DE = height,Ycharacter
;
BOX	EQU	$
	PUSH	BC		;save length & Xchr
	PUSH	HL		;save start position
	PUSH	DE		;save height & Ychr
	CALL	HLINE		;draw top line
	LD	E,0		;calculate offset
	ADD	HL,DE		;to bottom line
	CALL	HLINE		;draw bottom line
	POP	DE		;restore height & Ychr
	POP	HL		;restore start position
	INC	H		;move to next line
	DEC	D		;decrement heigth
	LD	B,D		;transfer height
	LD	C,E		;transfer Ychr
	CALL	VLINE		;draw left line
	POP	BC		;restore length & Xchr
	LD	C,B
	LD	B,0
	ADD	HL,BC
	DEC	L
	LD	A,E
	LD	B,7
BOX1	RRCA
	DJNZ	BOX1
	LD	B,D
	LD	C,A
	CALL	VLINE		;draw right line
	RET
;------------------------------
;CHROUT - normal text to screen
;enter with HL = YX
;           DE = start of text
;
CHROUT	LD	A,L
	OUT	(80H),A
	LD	A,H
	OUT	(81H),A
	LD	A,80H
	OUT	(83H),A
CHOUT1	LD	A,(DE)
	OR	A
	RET	Z
	OUT	(82H),A
	INC	DE
	JR	CHOUT1
;------------------------------
;DSPLY - display text
;enter with HL = cursor position
;           DE = start of text
;
DSPLY	EQU	$
	LD	A,L
	OUT	(80H),A
	LD	A,H
	OUT	(81H),A
	LD	A,1
	OUT	(8EH),A
	EX	DE,HL
	LD	A,10
	RST	40
	RET
;------------------------------
;GCLS - erase graphics screen
;
GCLS	EQU	$
	LD	A,70H		;graphics off,
	OUT	(83H),A		;waits off, inc Y
	XOR	A
	OUT	(80H),A
	OUT	(81H),A
	LD	B,80		;X loop counter
GCLSX	PUSH	BC		;save X loop counter
	LD	B,239		;Y loop counter
	XOR	A		;A = 0
GCLSY	OUT	(82H),A		;erase XY position
	DJNZ	GCLSY		;repeat
	LD	A,30H		;inc XY after write
	OUT	(83H),A
	XOR	A		;A = 0
	OUT	(82H),A		;erase 240th Y position
	OUT	(81H),A		;reset Y to 0
	LD	A,70H		;graphics off,
	OUT	(83H),A		;waits off, inc Y
	POP	BC		;restore X loop counter
	DJNZ	GCLSX		;repeat
	RET
;------------------------------
;GINIT - initialize graphics board
;
GINIT	EQU	$
	LD	A,16		;set bit 4
	OUT	(0ECH),A	;enable external I/O
	RET
;------------------------------
;GROFF - turn of graphics board
;
GROFF	EQU	$
	LD	A,0		;turn off
	OUT	(83H),A		;graphics board
	RET
;------------------------------
;GRON - turn on graphics board
;
GRON	EQU	$
	LD	A,1		;turn on
	OUT	(83H),A		;graphics board
	RET
;------------------------------
;HLINE draws horizontal line
;enter with HL = YX
;           BC = length,character
;
HLINE	EQU	$
	PUSH	BC		;save length & Xchr
	LD	A,0B0H		;inc X after write
	OUT	(83H),A
	LD	A,H		;get Y position
	OUT	(81H),A		;store it
	LD	A,L		;get X position
	OUT	(80H),A		;store it
	LD	A,C		;character for line
HLINE1	OUT	(82H),A		;write it to screen
	DJNZ	HLINE1		;do it again
	POP	BC		;restore length & Xchr
	RET
;------------------------------
;
INKEY	EQU	$
	LD	A,1
	RST	40
	RET
;
;------------------------------
;VLINE - draw vertical line
;enter with HL = YX
;           BC = heigth,character
;
VLINE	EQU	$
	PUSH	BC		;save height & Ychr
	LD	A,70H
	OUT	(83H),A
	LD	A,H
	OUT	(81H),A
	LD	A,L
	OUT	(80H),A
	LD	A,C
VLINE1	OUT	(82H),A
	DJNZ	VLINE1
	POP	BC		;restore height & Ychr
	RET
;------------------------------
;MESSAGES
;
MSG1	DB	'TRSTimes presents:',13
	END	START
