GETLOC ;GETLOC/CMD.  String search program
 ;to find a string in a block of memory.
 ;21.11.90 V12
 ;Copyright M.C.Matthews.
 	ORG	2400H
 BEGIN	LD	A,69H
 	RST	28H		;CLS
 	LD	A,02H
 	LD	C,0EH		;Display cursor
 	RST	28H
 	LD	HL,MESS1	;Opening message
 	LD	A,0AH
 	RST	28H
 START2	LD	HL,MESS1A	;Start address
 	LD	A,0AH		
 	RST	28H
 	CALL	GETHEX
 	LD	(START1),HL
 	LD	HL,MESS2	;End address
 	LD	A,0AH
 	RST	28H
 	CALL	GETHEX
 	LD	(END),HL
 GETMOR	LD	HL,MESS3	;Get string for search
 	LD	A,0AH
 	RST	28H
 	CALL	GETSTR
 	LD	HL,(START1)	;Set start address for count
 	LD	(START),HL
 COMPAR	LD	IX,(LEN)	;Get length of string in index
 COMP	LD	(LEN1),IX	;All done?
 	LD	HL,STRING	;Start of string
 	LD	DE,(START)	;Current address (Start is incremented
 COMP1	LD	A,(DE)		;as search goes on
 	CP	(HL)		;Compare current byte with string
 	INC	DE		;Inc string & prog. addresses
 	INC	HL
 	LD	(START),DE	;Update prog.address store
 	JR	NZ,ON10		;No match
 	LD	A,(LEN1)	;Match, so dec.index
 	DEC	A
 	LD	(LEN1),A
 	JR	NZ,COMP1	;Not done yet
 	CALL	SHOWIT		;Got one, so display it
 ON10	LD	HL,(START)	;Else check for end of search area
 	LD	DE,(END)
 	SBC	HL,DE
 	JP	NC,ENDED
 	JR	COMPAR		;or try again
 GETSTR	LD	HL,STRING	;Set buffer address for string
 	LD	(LIST),HL
 	LD	B,20H
 	LD	C,0H
 	LD	A,09H
 	RST	28H		;Get it.
 BK10	LD	A,(HL)
 	CP	0DH
 	JR	Z,BK6A
 	CP	60H		;Check for l/c
 	JR	C,ON12
 	CP	7AH
 	JR	NC,ON12
 	AND	5FH		;and convert to U/C
 ON12	LD	(HL),A		;save it
 	INC	HL
 	JR	BK10		;back for more
 BK6A	LD	(HL),20H	;Put space & CR at end of string
 	INC	HL
 	LD	A,0DH
 	LD	(HL),A
 	LD	HL,STRING	;Now convert to hex
 	LD	(LIST),HL
 	LD	IX,0H		;Set index (counter) to 0
 BK6	LD	A,(HL)
 	CP	0DH
 	JR	Z,DONE
 	CP	20H
 	JR	NZ,PACK		;Skip spaces
 	INC	HL
 	JR	BK6
 PACK	LD	DE,STRING
 MORE	LD	HL,0000H
 	CALL	BK2		;Pack it
 	LD	A,L
 	LD	HL,(LIST)	;Get current position in list
 	LD	(HL),A		;and put in new byte
 	INC	IX
 	INC	HL
 	LD	(LIST),HL	;Inc index & save it
 	LD	A,(DE)		;Get next byte,and check it
 	CP	2FH		;is a valid HEX one
 	JR	C,DONE
 	CP	47H		;If not then finished
 	JR	NC,DONE
 	JR	MORE
 DONE	LD	(LEN),IX
  	LD	HL,(LIST)
 	LD	(HL),A		;Put 0DH at end of list
 	RET
 SHOWIT	EX	DE,HL		;Display address.  DE is 1 byte
 	LD	DE,(LEN)	;MORE than address of END of string
 	SBC	HL,DE		;so subtract length of string for
 	EX	DE,HL		;correct address
 	LD	A,63H
 	LD	HL,BUFFER	;Conv.address to ASC
 	RST	28H
 	LD	A,20H
 	LD	(HL),A
 	INC	HL
 	LD	A,03H
 	LD	(HL),A
 	LD	HL,BUFFER
 	LD	A,0AH
 	RST	28H		;Display address
 	LD	C,20H
 	LD	A,02H
 	RST	28H
 	LD	A,02H
 	RST	28H		;Two spaces
 	LD	A,0FH
 	LD	B,04H
 	RST	28H		;Get current cursor position
 	LD	A,L
 	CP	4CH		;Room for another?
 	RET	C		;Yes
 	LD	C,0AH		;Else Line feed
 	LD	A,02H
 	RST	28H
 	LD	A,H
 	CP	17H		;Done a page?
 	RET	C		;No
 	PUSH	HL
 	PUSH	DE
 BK3	LD	A,01H		;Yes, wait for key
 	RST	28H
 	CP	20H		;Is it space bar?
 	JR	Z,ON5		;Yes, do next page
 	CP	80H		;Is it BREAK?
 	JR	NZ,BK3
 	POP	DE		;Yes, exit to DOS
 	POP	HL
 	LD	A,16H
 	RST	28H		;Finished
 ON5	LD	A,69H
 	RST	28H		;CLS before next page
 	POP	DE
 	POP	HL
 	RET
 GETHEX	LD	HL,BUFFER
 	LD	B,04H		;Get 4-byte input
 	LD	A,09H
 	RST	28H
 	EX	DE,HL
 	LD	HL,0000H
 BK2	LD	A,(DE)
 	CP	61H
 	JR	C,ONB
 	CP	7AH
 	JR	NC,ONB
 	AND	0DFH		;Conv.to U/C
 ONB	INC	DE
 	CP	0DH
 	JR	Z,ONA
 	CP	30H		;Check for valid number
 	JR	C,ON1
 	CP	47H
 	JR	C,ON2
 ON1	XOR	A		;Error,try again
 	RET
 ON2	CP	3AH		;Conv.to Hex
 	JR	C,ON3
 	CP	47H
 	JR	NC,ON1
 ON3	SUB	30H
 	CP	0AH
 	JR	C,ON4
 	SUB	07H
 ON4	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	A,L
 	LD	L,A
 	JR	NC,BK2
 	INC	H
 	JR	BK2
 ONA	OR	A
 	RET
 ENDED	LD	HL,MESS4	;'Any more?'
 	LD	A,0AH
 	RST	28H
 	LD	A,01H
 	RST	28H
 	AND	0DFH		;Conv.to U/C
 	CP	4EH		;If N then exit else more
 	JR	Z,STOP
 	LD	C,0AH
 	LD	A,02H
 	RST	28H
 	JP	GETMOR
 STOP	LD	A,16H		;Else exit.
 	RST	28H
 MESS1	DEFM	'GETLOC. Finds a string of HEX numbers in memory'
 	DEFB	0AH
 	DEFM	'Copyright M.C.Matthews 17.04.90 Version 10'
 	DEFB	0AH
 	DEFB	03H
 MESS1A	DEFB	0AH
 	DEFB	0AH
 	DEFM	'Enter start address (HEX) of search area '
 	DEFB	03H
 MESS2	DEFB	0AH
 	DEFM	'Enter end address (HEX) of search area '
 	DEFB	03H
 MESS3	DEFB	0AH
 	DEFM	'Enter string to be found.   Put a space between'
 	DEFB	0AH
 	DEFM	'consecutive HEX numbers thus:- 1D FF 2 A1   '
 	DEFB	03H
 MESS4	DEFB	0AH
 	DEFB	0AH
 	DEFM	'Any more? '
 	DEFB	03H
 START	DEFW	00H
 START1	DEFW	00H
 END	DEFW	00H
 LIST	DEFW	00H
 LEN	DEFW	00H
 LEN1	DEFW	00H
 BUFFER	DEFS	06H
 STRING	DEFS	20H
 	END	BEGIN
FB	0AH
 	DEFM	'Enter end address (HEX) of search area '
 	DEFB	03H
 MESS3	DEFB	0AH
 	DEFM	'Enter string to be found.   Put a space between'
 	DEFB	0AH
 	DEFM	'consecutive HEX numbers thus:- 1D FF 2