;SCREDT full screen editor for mod 4
;by JMR 5-25-86
;80-micro 8612
;Keys used:
;in normal mode <F2> enters edit mode indicated by large block csr)
;in edit mode <Enter> sends the entire line the cursor is on
;	      <Break> aborts the edit mode
;	      <F2> toggles the insert mode
;	      <F3> deletes the char under cursor
;	      arrows move cursor around the screen
;USAGE SET *SE SCREDT
;      FILTER *KI *SE
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
VDCTL	MACRO	#NUM
	LD	B,#NUM
	SVC	@VDCTL
	ENDM
;
@DSP	EQU	2
@EXIT	EQU	16H
@GTDCB	EQU	52H
@VDCTL	EQU	0FH
@FLAGS	EQU	65H
@ERROR	EQU	1AH
@HIGH$	EQU	64H
@GTMOD	EQU	53H
@DSPLY	EQU	0AH
@HEX16	EQU	63H
@CHNIO	EQU	14H
;
;------------INSTALL FILTER -------------------
;
	ORG	3000H
START	PUSH	DE		;save dcb pointer
	LD	(MODDCB),DE	;put in filter
	SVC	@FLAGS
	BIT	3,(IY+2)	;is it being used?
	JR	NZ,SKIP0
	LD	HL,MSG1
ABORT	SVC	@DSPLY
	LD	HL,-1
	SVC	@EXIT
SKIP0	LD	DE,'OD'		;*do device
	SVC	@GTDCB		;get addr in hl
	LD	(DODCB1+2),HL	;store *do dcb addr
	LD	(DODCB2+2),HL
	LD	DE,MODNAM1
	SVC	@GTMOD		;find $do module
	JR	Z,SKIP1
	LD	HL,MSG2		;couldn't find it
	JR	ABORT
SKIP1	LD	HL,0007		;de now points to current $do module
	ADD	HL,DE		;calculate posn of byte under cursor
	LD	(U1+1),HL	;in $do driver
	LD	(U2+1),HL
	LD	(U3+1),HL
	LD	(U4+1),HL
	LD	(U5+1),HL
	LD	B,0
	LD	HL,0
	SVC	@HIGH$		;get high$ into hl
	LD	(OLDHI),HL	;save in header
	LD	BC,FINAL-SCREDT	;length of routine to move
	PUSH	BC
	XOR	A
	SBC	HL,BC
	LD	B,0
	SVC	@HIGH$
	INC	HL		;new addr for scredt
	PUSH	HL
	LD	BC,SCREDT	;current addr
	XOR	A
	SBC	HL,BC		;hl now contains offset to new locn
	PUSH	HL		;transfer to bc
	POP	BC
	LD	IX,RELTBL	;point to relocation table
LOOPR	LD	L,(IX)		;get addr to be recolcated
	LD	H,(IX+1)
	LD	A,H		;done yet?
	OR	L
	JR	Z,SKIPR
	PUSH	HL		;transfer addr to iy
	POP	IY
	LD	L,(IY)
	LD	H,(IY+1)	;actual value to be changed
	ADD	HL,BC		;add offset
	LD	(IY),L		;put back
	LD	(IY+1),H
	INC	IX
	INC	IX
	JR	LOOPR
SKIPR	LD	HL,SCREDT	;source
	POP	DE		;destination
	POP	BC		;byte count
	PUSH	DE
	LDIR			;move it
	POP	DE		;retrieve new start addr
	POP	HL		;retrieve dcb addr
	LD	(HL),47H	;store dcb type byte
	INC	HL
	LD	(HL),E		;store filter addr in dcb
	INC	HL
	LD	(HL),D
	LD	HL,HEXBUF	;point to buffer for hex conversion
	SVC	@HEX16
	LD	HL,MSG3
	SVC	@DSPLY		;display success msg
	LD	HL,0		;no error
	RET
;
MODNAM1	DB	'$DO'
	DB	0DH
MSG1	DB	'SCREDT must be installed with SET'
	DB	0DH
MSG2	DB	'$DO module not found! SCREDT not installed!'
	DB	0DH
MSG3	DB	'SCREDT installed at '
HEXBUF	DB	'----H'
	DB	0DH
RELTBL	DW	RX1
	DW	RX2
	DW	RX3
	DW	RX4
	DW	RX5
	DW	RX6
	DW	RX7
	DW	RX8
	DW	RX9
	DW	RX10
	DW	RX11
	DW	0
;
;------------ TRSDOS memory header ----------
SCREDT	JR	HERE
OLDHI	DW	0		;previous high$
	DB	MODDCB-MODNAM2	;name length
MODNAM2	DB	'SCREDT'	;module name
MODDCB	DW	0		;addr of this module's dbc
	DW	0		;reserved
;
;data table
;
MODE	DB	0		;bit 7=enter mode,6=edit,5=insert
CURS	DB	0		;cursor char
ROW	DB	0		;current row
COL	DB	0
;
;-filter
;
HERE	JR	C,FILTER	;go if @get request
;
CHAIN	PUSH	IX
	LD	IX,(MODDCB)	;get dcb pointer
RX1	EQU	$-2
	SVC	@CHNIO		;continue with device chain
	POP	IX
	RET
;
FILTER	LD	HL,MODE
RX2	EQU	$-2
	BIT	7,(HL)		;enter mode
	JR	NZ,ENTER
	PUSH	HL
	CALL	CHAIN		;recall current *ki driver
RX3	EQU	$-2
	POP	HL
	RET	NZ		;ret if no key hit
	BIT	6,(HL)		;edit mode?
	JR	NZ,EDIT
	CP	82H		;<F2>?
	JR	Z,SKIP2
	CP	A		;ret with Z flag set (no error)
	RET			;key pressed in A
;
SKIP2	SET	6,(HL)		;turn on edit mode
	LD	C,0BFH		;new cursor
	VDCTL	8		;set new csr char
	LD	(CURS),A	;save old csr
RX4	EQU	$-2
	XOR	A		;return empty
	RET
;
;---process enter mode ----
;
ENTER	LD	A,(COL)		;get col no
RX5	EQU	$-2
COLCNT	CP	80H		;done yet?
	JR	NC,DONE
	INC	A		;next col
	LD	(COL),A		;save for next time
RX6	EQU	$-2
	DEC	A
	LD	L,A
	LD	A,(ROW)
RX7	EQU	$-2
	LD	H,A
	VDCTL	1		;get char from video
	CP	A
	RET			;ret with char in a
DONE	RES	7,(HL)		;turn off enter mode
DODCB1	LD	IY,0
	RES	3,(IY+0)	;TURN VIDEO BACK ON
	LD	A,0DH		;return a CR
	CP	A
	RET
;
;--- check for key in edit mode ----
;
EDIT	CP	80H		;break?
	JR	NZ,SKIP3
	RES	6,(HL)
	RES	5,(HL)
	PUSH	AF
RESTORE	LD	A,(CURS)	;get old cursor char
RX8	EQU	$-2
	LD	C,A
	VDCTL	8		;set cursor char
	POP	AF
	CP	A
	RET
;
SKIP3	CP	0DH		;<enter>?
	JR	NZ,SKIP4
	RES	6,(HL)		;edit off
	RES	5,(HL)		;insert off
	SET	7,(HL)		;enter mode on
	VDCTL	4		;fetch csr posn
	LD	A,H
	LD	(ROW),A
RX9	EQU	$-2
	XOR	A		;start at col 1
	PUSH	AF		;return(later) with no key
	LD	(COL),A
RX10	EQU	$-2
U1	LD	A,(0000)	;get char under csr
	LD	C,A
	VDCTL	2		;display char
	LD	L,79		;start at last col
LOOP	VDCTL	1		;get char
	CP	' '		;blank?
	JR	NZ,FOUND	;exit with last non-blank
	DEC	L		;go back
	JR	NZ,LOOP
FOUND	INC	L		;store one more than last non-blank
	LD	A,L
	LD	(COLCNT+1),A
RX11	EQU	$-2
DODCB2	LD	IY,0
	SET	3,(IY+0)	;set *do to nil
	JR	RESTORE
;
SKIP4	CP	82H		;<F2>? toggle insert mode
	JR	NZ,SKIP5
	LD	A,(HL)
	XOR	20H		;toggle bit 5 
	LD	(HL),A		;replace it
	BIT	5,A
	LD	C,0B3H		;insert mode csr
	JR	NZ,SKIP4A
	LD	C,0BFH		;edit mode csr
SKIP4A	VDCTL	8		;set csr char
	XOR	A
	RET
;
SKIP5	CP	83H		;<F3>? delete
	JR	NZ,SKIP6
	VDCTL	4		;get csr posn
	LD	A,L
	CP	79		;last col?
	JR	NZ,SKIP5A
	LD	A,' '
U2	LD	(0000),A	;put space under csr
	JR	DONE1
SKIP5A	INC	L		;next col
	VDCTL	1		;get next char and
U3	LD	(0000),A	;put it under csr
LOOP2	LD	A,L
	CP	79
	JR	NC,DONE2
	INC	L
	VDCTL	1		;get char at next posn
	DEC	L
	LD	C,A
	VDCTL	2		;put it here
	INC	L
	JR	LOOP2
DONE2	LD	C,' '		;put space in last col
	VDCTL	2
DONE1	XOR	A
	RET
;
SKIP6	CP	08H		;check for arrows
	JR	C,SKIP7
	CP	0CH
	JR	NC,SKIP7
	ADD	A,10H		;convert to 18h to 1bh
DOIT	LD	C,A		;display key hit
	SVC	@DSP
	XOR	A		;but return empty
	RET
;
SKIP7	BIT	5,(HL)		;insert mode?
	JR	Z,DOIT		;if not go ahead and display it
	LD	C,A
U4	LD	A,(0000)	;get char under csr
	LD	D,A
	PUSH	DE
	PUSH	BC
	VDCTL	4		;get csr posn
	LD	E,L
	LD	L,78		;last col
LOOP3	LD	A,E
	CP	L
	JR	NC,DONE3
	VDCTL	1		;get char
	INC	L		;next col
	LD	C,A
	VDCTL	2		;put at next posn
	DEC	L
	DEC	L		;go backward
	JR	LOOP3
DONE3	POP	BC
	SVC	@DSP		;display key hit
	POP	AF
U5	LD	(0000),A	;replace char that was under csr
	XOR	A
	RET
;
FINAL	NOP
	END	START
