10 SYSTEM "SETKI (RATE=3,WAIT=22)"
20 SYSTEM "SYSTEM (BLINK=NO)"
30 SYSTEM "SYSTEM (BLINK=32)"
40 SYSTEM "SYSTEM (TYPE=NO)"
50 SYSTEM "TIME 07:59:30"
60 'PROGRAM NAME = JETSET
70 'IFR FLIGHT SIMULATOR (BOEING 747)
80 'CREATED 06/28/81 BY JEAN SZYMANSKI
90 'REVISED 02/25/82 - INSTRUCTIONS IN NOVEMBER 1982 'BYTE MAGAZINE'
100 'REVISED 01/08/84 BY EUGENE TURNER - CONVERTED IBM PC to TRS80 MODEL 4
110 REM
120 GOTO 7030
130 'BEGIN CRUISE MODULE HERE
140 CLS:CLEAR 2000:RANDOM
150 DIM M$(20)
160 KR=57.2958:XQ=64
170 RS=1:IF RND(0)<.5 THEN RS=-1
180 RW=(15-5)*RND(0)+5
190 RW=RS*RW
200 'SET UP WIND TABLE
210 DIM WA(10,1)
220 FOR I=0 TO 7:WA(I,0)=RND(359):NEXT
230 FOR I=8 TO 10:WA(I,0)=90*RND(0)+225:NEXT
240 A=0
250 FOR I=1 TO 10:WA(I,1)=25*RND(0)+A:A=A+25:NEXT
260 RS$(0)=STRING$(31,"_")
270 RS$(1)=SPACE$(13)+".   ."+SPACE$(13)
280 RS$(2)=SPACE$(11)+".       ."
290 RS$(3)=SPACE$(9)+STRING$(13,"_")
300 'VOR STATION FREQUENCY TABLE
310 DIM VF(15)
320 VF(0)=115.9:VF(1)=113.8:VF(2)=112.7
330 VF(3)=117.7:VF(4)=117.8:VF(5)=112.2
340 VF(6)=117.4:VF(7)=115.5:VF(8)=116.4
350 VF(9)=113.6:VF(10)=116.9:VF(11)=117!
360 VF(12)=112.3:VF(13)=117.9:VF(14)=115.7
370 VF(15)=112.8
380 'ILS CONSTANTS FOR AIRPORTS
390 DIM VG(15,1)
400 VG(0,0)=238:VG(0,1)=28
410 VG(2,0)=240:VG(2,1)=30
420 VG(5,0)=90:VG(5,1)=217
430 VG(7,0)=299:VG(7,1)=164
440 VG(8,0)=166:VG(8,1)=42
450 VG(15,0)=341:VG(15,1)=75
460 'VOR STATION COORDIATES TABLE
470 DIM VP(15,1)
480 VP(0,0)=40.633:VP(0,1)=73.773
490 VP(1,0)=40.202:VP(1,1)=74.495
500 VP(2,0)=42.358:VP(2,1)=70.993
510 VP(3,0)=41.282:VP(3,1)=70.027
520 VP(4,0)=42.743:VP(4,1)=73.802
530 VP(5,0)=46.412:VP(5,1)=84.315
540 VP(6,0)=38.35:VP(6,1)=81.77
550 VP(7,0)=40.917:VP(7,1)=77.993
560 VP(8,0)=42.928:VP(8,1)=78.674
570 VP(9,0)=41.358:VP(9,1)=82.162
580 VP(10,0)=42.967:VP(10,1)=83.724
590 VP(11,0)=44.555:VP(11,1)=88.195
600 VP(12,0)=41.547:VP(12,1)=88.318
610 VP(13,0)=39.495:VP(13,1)=76.978
620 VP(14,0)=42.048:VP(14,1)=83.458
630 VP(15,0)=39.637:VP(15,1)=75.303
640 DATA FUEL,LBS,%,VHF,MHZ,THRUST,MAX,IDLE,REV
650 DATA PITCH," +"," -",DEG,FLAPS,UP,DWN,WHEELS,UP,MID,DOWN
660 DATA COMPASS,AIRSPEED,KTS," VERT",SPEED,FPM
670 DATA ALTITUDE,FEET,CLOCK
680 DIM P$(28)
690 FOR I=0 TO 28:READ P$(I):NEXT
700 DIM S$(25)
710 FOR I=1 TO 25:S$(I)=SPACE$(I):NEXT
720 FOR I=0 TO 9:F(I)=0:NEXT
730 'INIT FLIGHT VARIABLES TO STATE AT LIFTOFF
740 FU=195480!:FP=63:CC=75:ZS=380:RC=6704:AL=1900
750 MZ=122:TR=4:FL=1:FA=10:BR=10:WH=10
760 RA=0:ZS(1)=380:FA(1)=10:CC(1)=75:AL(1)=1900:RP=40
770 DP(4)=39:DP(5)=52:DP(6)=75:DP(7)=15
780 L1=39.8667:G1=75.25:LL(1)=L1:GL(1)=G1:LS(1)=L1:GS(1)=G1
790 VO(1)=0:VO$(1)="OUT ":VO(3)=0:VO(4)=999.9
800 GX(0)=0:GY(0)=0
810 XO=36481!:YO=0
820 TV$=TIME$:GOSUB 6920:TL=TD
830 TW(1)=TD
840 GOSUB 890
850 GOSUB 1340
860 K$=INKEY$:IF LEN(K$)=0 GOTO 880
870 GOSUB 1850
880 GOTO 2420
890 'DISPLAY PANEL (HEADERS ONLY)
900 PRINT@ (0,3),CHR$(16)P$(0);S$(4);P$(5);S$(3);P$(9);S$(3);S$(6);S$(3);P$(20);
910 PRINT@ (9,54),P$(13);S$(3);P$(16);
920 PRINT@ (10,56),P$(14);S$(6);P$(14);
930 PRINT@ (12,56),P$(15);S$(5);P$(15);
940 PRINT@ (1,13),P$(6);S$(6);P$(10);S$(6);
950 PRINT@ (1,68),P$(28);
960 PRINT@ (2,1),P$(1);S$(4);P$(2);S$(21);S$(3);S$(13);P$(23);
970 PRINT@ (3,22),P$(11);S$(13);P$(21);S$(2);P$(24);S$(2);P$(26);
980 PRINT@ (4,0),P$(3);
990 PRINT@ (5,39),P$(22);S$(6);P$(25);S$(5);P$(27);
1000 PRINT@ (6,0),P$(4);S$(10);P$(7);S$(3);P$(12);S$(7);
1010 PRINT@ (7,13),P$(8);
1020 PRINT@ (3,68),"VLF OMEGA";:PRINT@ (4,65),"LAT";
1030 PRINT@ (5,64),"LONG";
1040 PRINT@ (6,32),". . . . : . . . .":PRINT@ (8,39),"RUD";
1050 PRINT@ (9,32),CHR$(171);STRING$(15,140);CHR$(151);CHR$(17);
1060 FOR X = 32 TO 48 STEP 16
1070 FOR Y = 10 TO 22
1080 PRINT@ (Y,X),CHR$(188);
1090 NEXT Y
1100 NEXT X
1110 PRINT@ (23,32),CHR$(182);STRING$(15,134);CHR$(185);
1120 PRINT@ (10,39),CHR$(16);"VOR";:PRINT@ (11,44),"MHZ";
1130 PRINT@ (14,38),"RANGE";
1140 PRINT@ (16,35),".....:.....";
1150 PRINT@ (19,38),"RADIAL";
1160 PRINT@ (21,39),"DME";:PRINT@ (22,44),"NM";CHR$(17);
1170 FOR Y=1 TO 7:PRINT@ (Y,12),CHR$(176);:NEXT
1180 FOR Y=1 TO 3:PRINT@ (Y,21),CHR$(176);:NEXT
1190 PRINT@ (14,0),CHR$(183);STRING$(15,176);CHR$(187);
1200 FOR X = 0 TO 16 STEP 16
1210 FOR Y = 15 TO 21
1220 PRINT@ (Y,X),CHR$(176);
1230 NEXT Y
1240 NEXT X
1250 PRINT@ (22,0),CHR$(153);STRING$(15,164);CHR$(166);
1260 PRINT@ (13,7),CHR$(16);"ILS";
1270 PRINT@ (17,19),"MARKER";:PRINT@ (18,20),">  <";
1280 GX(1)=0:GY(1)=0
1290 GOSUB 5230
1300 PRINT@ (10,7),"     ";
1310 PRINT@ (9,4),"RADAR ALT";SPC(6);"STALL";
1320 PRINT@ (10,18),">     <";CHR$(17);
1330 RETURN
1340 'DISPLAY INSTRUMENT READINGS
1350 GOTO 1720
1360 YP=1:XP=0:F$="######":V1=FU:GOSUB 7010
1370 PRINT@ (0,66),CHR$(16);TIME$;CHR$(17);
1380 YP=1:XP=7:F$="###":V1=FP:GOSUB 7010
1390 YP=1:XP=39:V1=CC:GOSUB 7010
1400 YP=4:XP=39:V1=ZS:GOSUB 7010
1410 YP=4:XP=46:F$="######":V1=RC:GOSUB 7010
1420 YP=4:XP=55:F$="##,###":V1=AL:GOSUB 7010
1430 YP=5:XP=0:F$="###":V1=MZ:GOSUB 7010
1440 IF F(2)=1 THEN YP=10:XP=6:F$="#####":V1=AL:GOSUB 7010
1450 REM:DISPLAY THRUST
1460 FOR I = 1 TO 7:PRINT@ (I,11),CHR$(191);:NEXT
1470 PRINT@ (TR,11),">";
1480 'DISPLAY FLAPS
1490 FOR I=1 TO 3:PRINT@ (I,20),CHR$(191);:NEXT
1500 PRINT@ (FL,20),">";
1510 F$="+###"
1520 YP=5:XP=20:V1=FA:GOSUB 7010
1530 IF F(6)=0 THEN SX=25:GOTO 1560
1540 IF SX=25 THEN SX=26:GOTO 1560
1550 SX=25
1560 IF F(7)=0 THEN PRINT@ (10,19),"     ";
1570 'DISPLAY BRAKES
1580 FOR I=10 TO 12:PRINT@ (I,54)," ";CHR$(191);:NEXT
1590 PRINT@ (BR,54),">";
1600 'WHEELS
1610 FOR I=10 TO 12:PRINT@ (I,62)," ";CHR$(191);:NEXT
1620 PRINT@ (WH,62),">";
1630 IF F(2)=1 THEN GOTO 1750
1640 'DISPLAY LAT/LONGDITUDE
1650 YP=4:XP=69:F$="###":V1=DP(4):GOSUB 7010
1660 YP=4:XP=73:F$="##.#":V1=DP(5):GOSUB 7010
1670 YP=5:XP=69:F$="###":V1=DP(6):GOSUB 7010
1680 YP=5:XP=73:F$="##.#":V1=DP(7):GOSUB 7010
1690 PRINT@ (4,78),"N";
1700 PRINT@ (5,78),"W";
1710 GOTO 1750
1720 'DISPLAY RUDDER POSITION
1730 PRINT@ (7,32),S$(17);
1740 PRINT@ (7,RP),CHR$(148);:GOTO 1360
1750 IF F(2)=1 THEN RETURN
1760 'DISPLAY VOR VALUES
1770 YP=11:XP=38:F$="###.#":V1=VO(1):GOSUB 7010
1780 PRINT@ (13,39),VO$(1);
1790 YP=18:XP=39:F$="###":V1=VO(3):GOSUB 7010
1800 YP=22:XP=38:F$="###.#":V1=VO(4):GOSUB 7010
1810 PRINT@ (17,34),S$(13);
1820 IF VO$(1)="OUT " THEN GOTO 1840
1830 PRINT@ (17,VO),"."; 
1840 RETURN
1850 'KEY POLL SUBROUT
1860 IF K$="F" OR K$="S" OR K$="f" OR K$="s" THEN KK=1:GOTO 1980
1870 IF K$="," OR K$="." THEN KK=2:GOTO 1980
1880 IF K$="/" THEN RA=0:GOTO 1990
1890 IF K$="U" OR K$="D" OR K$="u" OR K$="d" THEN KK=3:GOTO 1980
1900 IF K$="W" OR K$="w" THEN KK=4:GOTO 1980
1910 IF K$="V" OR K$="v" THEN KK=5:GOTO 1980
1920 IF K$="R" OR K$="r" THEN KK=6:GOTO 1980
1930 IF K$="L" OR K$="l" THEN KK=7:GOTO 1980
1940 IF K$="A" OR K$="a" THEN KK=8:GOTO 1980
1950 IF K$="Q" OR K$="q" THEN KK=9:GOTO 1980
1960 IF K$="M" OR K$="m" THEN KK=10:GOTO 1980
1970 IF K$="C" OR K$="c" THEN KK=11:GOTO 1980
1980 ON KK GOSUB 2000,2030,2090,2170,2200,2240,2280,2310,2330,2360,2390
1990 RETURN
2000 'THRUST KEY
2010 IF K$="F" OR K$="f" THEN TR=TR-1 ELSE TR=TR+1
2020 IF TR<1 THEN TR=1:RETURN
2030 'RUDDER KEYS
2040 IF K$="," THEN GOTO 2070 ELSE RA=RA+1
2050 IF RA>4 THEN RA=4
2060 RETURN
2070 RA=RA-1:IF RA<-4 THEN RA=-4
2080 RETURN
2090 'ELEVATOR KEYS
2100 J=5:IF BR=12 THEN J=1
2110 IF K$="U" OR K$="u" THEN FA=FA+J ELSE FA=FA-J
2120 IF FA>40 THEN FA=40
2130 IF FA<-40 THEN FA=-40
2140 IF FA>0 THEN FL=1:RETURN
2150 IF FA=0 THEN FL=2:RETURN
2160 FL=3:RETURN
2170 'WHEELS KEY
2180 IF WH=10 THEN WH=12:RETURN
2190 IF WH=12 THEN WH=10:RETURN
2200 'SET VOR FREQ
2210 PRINT@ (14,55),"";
2220 LINE INPUT "VOR FREQ ";VX$:VO(1)=VAL(VX$)
2230 PRINT@ (14,55),SPC(16);:RETURN
2240 'SET VOR RADIAL
2250 PRINT@ (14,55),"";
2260 LINE INPUT"VOR RADIAL ";VX$:VO(3)=VAL(VX$)
2270 PRINT@ (14,55),SPC(14);:RETURN
2280 'FLAPS KEY
2290 IF BR=10 THEN BR=12:RETURN
2300 IF BR=12 THEN BR=10:RETURN
2310 'AUTO - OBS KEY
2320 F(3)=1:RETURN
2330 'REVERSE THRUST KEY
2340 IF F(7)=1 THEN TR=7
2350 RETURN
2360 'MISSED APPROACH KEY
2370 IF F(2)=1 THEN F(5)=1
2380 RETURN
2390 'FLARE KEY
2400 IF F(2)=0 THEN FA=0:FL=2:RETURN
2410 FA=1:FL=1:RETURN
2420 'SITUATION UPDATE ROUTINE
2430 TV$=TIME$:GOSUB 6920:TJ=TD-TL:TL=TD
2440 GOSUB 2880
2450 GOSUB 3070
2460 GOSUB 3220
2470 IF TR=7 THEN GOSUB 4910 ELSE GOSUB 3020
2480 GOSUB 2910
2490 GOSUB 2960
2500 IF F(2)=1 THEN GOTO 4440
2510 GOSUB 3780
2520 GOSUB 4050
2530 IF AL<=0 THEN AF=1:GOTO 5500
2540 IF F(2)=0 THEN GOTO 2870
2550 IF AL>0 THEN GOTO 2710
2560 IF F(7)=1 THEN GOTO 2830
2570 F(7)=1
2580 TY=YN
2590 TX=XN-750
2600 IF FA>1 THEN AF=2:GOTO 5500
2610 IF FA<0 THEN AF=3:GOTO 5500
2620 IF F(6)=0 THEN GOTO 2700
2630 IF AX>100 THEN AF=4:GOTO 5500
2640 IF AX>80 THEN AF=5:GOTO 5500
2650 IF WH=10 THEN AF=6:GOTO 5500
2660 IF TX>0 THEN AF=7:GOTO 5500
2670 IF TX<-10500 THEN AF=7:GOTO 5500
2680 IF ABS(TY)>100 THEN AF=7:GOTO 5500
2690 GOTO 2870
2700 AF=8:GOTO 5500
2710 IF F(5)=1 THEN GOTO 2800
2720 IF FA>0 THEN GOTO 2750
2730 IF FA<0 THEN F(6)=0
2740 GOTO 2870
2750 IF F(6)=0 THEN AX=AL:F(6)=1
2760 IF TR=6 THEN GOTO 2790
2770 IF FA<2 THEN RC=-1800:GOTO 2870
2780 FA=2:FL=1:RC=-1800:GOTO 2870
2790 FA=1:FL=1:RC=-300:GOTO 2870
2800 IF AL<20 THEN AF=9:GOTO 5500
2810 TR=3:FA=0:FL=2
2820 AF=10:GOTO 5500
2830 IF XN<-9750 OR ABS(YN)>100 THEN GOTO 2860
2840 IF ZS>0 THEN GOTO 2870
2850 AF=0:GOTO 5500
2860 AF=9:GOTO 5500
2870 GOTO 4890
2880 'UPDATE FUEL
2890 FU=FU-(14-TR)*TJ:IF FU<0 THEN FU=0
2900 FP=FU/3120:RETURN
2910 IF F(7)=1 THEN RC=0:RETURN
2920 IF F(6)=1 THEN RETURN
2930 RC=ZS*SIN(ABS(FA/KR))*101.6
2940 IF FA<0 THEN RC=-1*RC
2950 RETURN
2960 'UPDATE ALTITUDE
2970 IF F(7)=1 THEN RETURN
2980 AL=AL+TJ*RC/60
2990 IF AL<0 THEN AL=0:RETURN
3000 IF AL>45000! THEN AL=45000!
3010 RETURN
3020 'UPDATE AIRSPEED
3030 ZS=800-100*TR
3040 ZS=ZS-2*FA
3050 IF BR=10 THEN RETURN
3060 ZS=ZS/3+20:RETURN
3070 IF F(5)=1 THEN GOTO 3090
3080 IF F(2)=1 THEN GOTO 3190
3090 IF RA=0 THEN RT=0:RETURN
3100 IF RA<0 THEN J=-1 ELSE J=1
3110 RA=ABS(RA):IF RA=1 THEN RT=1:GOTO 3140
3120 IF RA=2 THEN RT=10:GOTO 3140
3130 IF RA=3 THEN RT=20 ELSE RT=30
3140 RT=J*RT:RA=J*RA
3150 CC=CC+RT
3160 IF CC=>360 THEN CC=CC-360:RETURN
3170 IF CC<0 THEN CC=360+CC
3180 RETURN
3190 IF RA=0 THEN RETURN
3200 IF RA<0 THEN CC=CC-1 ELSE CC=CC+1
3210 RA=0:GOTO 3160
3220 'UPDATE RUDDER POSITION VALUE
3230 RP=40+RA+RA:RETURN
3240 REM:COMPUTES DIST & BEARING TO A KNOWN POINT LOCATION
3250 VL=ABS(LB-LC):BL(5)=-1:IF LB=>LC THEN BL(5)=1
3260 VG=ABS(GB-GC):BL(4)=1:IF GB=>GC THEN BL(4)=-1
3270 LA=LC:GOSUB 5340
3280 M1=MP
3290 LA=LB:GOSUB 5340
3300 M2=MP:DM=ABS(M2-M1)
3310 IF DM=0 THEN GOTO 3340
3320 QO=VG/(DM/60):IF QO>114.59 THEN GOTO 3340
3330 CA=KR*ATN(QO):DR=VL*(1/COS(CA/KR)):GOTO 3350
3340 CA=90:DR=VG*COS(LC/KR)
3350 DR=DR*60:IF BL(5)=-1 THEN GOTO 3380
3360 IF BL(4)=1 THEN CR=CA ELSE CR=360-CA
3370 RETURN
3380 IF BL(4)=1 THEN CR=180-CA ELSE CR=180+CA
3390 RETURN
3400 'GET WIND VECTOR FOR CURRENT ALTITUDE
3410 I=FIX(AL/4000):IF I=>10 THEN I=10
3420 WD=WA(I,0):WV=WA(I,1)
3430 RETURN
3440 'SOLVES WIND TRIANGLE
3450 A=CC:L=AJ:GOSUB 3530
3460 MX=LX:MY=LY
3470 GOSUB 3400
3480 A=WD+180:IF A=>360 THEN A=A-360
3490 L=WV:GOSUB 3530
3500 MX=MX+LX:MY=MY+LY:GOSUB 3640
3510 TK=MA:GS=VZ
3520 RETURN
3530 'RESOLVES A VECTOR INTO RECT. COORDS
3540 IF A<=90 THEN Q=1:B=90-A:GOTO 3580
3550 IF A<=180 THEN Q=2:B=A-90:GOTO 3580
3560 IF A<=270 THEN Q=3:B=270-A:GOTO 3580
3570 Q=4:B=A-270
3580 LX=L*COS(B/KR):LY=L*SIN(B/KR)
3590 IF Q=1 THEN RETURN
3600 IF Q=2 THEN LY=-1*LY:RETURN
3610 IF Q=3 THEN LX=-1*LX:LY=-1*LY:RETURN
3620 LX=-1*LX
3630 RETURN
3640 'COMPOSES X,Y COMPONENTS INTO A POLAR VECTOR
3650 VZ=SQR(MX^2+MY^2)
3660 IF MX<=0 THEN GOTO 3690
3670 IF MY<=0 THEN Q=2 ELSE Q=1
3680 GOTO 3700
3690 IF MY<=0 THEN Q=3 ELSE Q=4
3700 IF MX=0 THEN MA=90:GOTO 3730
3710 MQ=ABS(MY/MX)
3720 MA=ATN(MQ)*KR
3730 IF Q=1 THEN MA=90-MA:RETURN
3740 IF Q=2 THEN MA=90+MA:RETURN
3750 IF Q=3 THEN MA=270-MA:RETURN
3760 MA=270+MA
3770 RETURN
3780 'GET POSITION FOR OMEGA DISPLAY
3790 ZS(2)=ZS:FA(2)=FA:CC(2)=CC:AL(2)=AL
3800 ZS=ZS(1):FA=FA(1):CC=CC(1):AL=AL(1)
3810 IF ZS(2)<>ZS OR FA(2)<>FA THEN GOTO 3950
3820 IF CC(2)<>CC OR AL(2)<>AL THEN GOTO 3950
3830 F(0)=1:IF TD<TW(1)+60 THEN GOTO 3960
3840 AJ=ZS*COS(ABS(FA)/KR)
3850 GOSUB 3440
3860 DN=GS*(TD-TW(1))/3600
3870 CN=TK:L1=LL(1):G1=GL(1)
3880 GOSUB 4990
3890 F(0)=0:TW(1)=TD:LL(1)=L2:GL(1)=G2
3900 LS(1)=L2:GS(1)=G2
3910 FOR J=4 TO 7:DP(J)=CP(J):NEXT
3920 ZS(1)=ZS(2):FA(1)=FA(2):CC(1)=CC(2):AL(1)=AL(2)
3930 ZS=ZS(2):FA=FA(2):CC=CC(2):AL=AL(2)
3940 RETURN
3950 TW(1)=TD:F(0)=0
3960 AJ=ZS*COS(ABS(FA)/KR)
3970 GOSUB 3440
3980 DN=GS*TJ/3600
3990 CN=TK:L1=LS(1):G1=GS(1)
4000 GOSUB 4990
4010 LS(1)=L2:GS(1)=G2
4020 IF F(0)=1 THEN GOTO 4040
4030 LL(1)=L2:GL(1)=G2
4040 GOTO 3910
4050 'VOR ROUTINE
4060 IF VO(1)=0 THEN GOTO 4300
4070 FOR J=0 TO 15:IF VO(1)=VF(J) THEN GOTO 4090
4080 NEXT:GOTO 4300
4090 LC=VP(J,0):GC=VP(J,1)
4100 LB=L2:GB=G2
4110 AR=VG(J,0):LL=VG(J,1)
4120 LO=360-LL
4130 GOSUB 3240
4140 IF DR>300 THEN GOTO 4300
4150 IF CR=>360 THEN CR=CR-360
4160 GOTO 4420
4170 VO$(1)="FROM"
4180 VO(5)=CR-VO(3):IF VO(5)<=180 THEN GOTO 4200
4190 VO(5)=VO(5)-360:GOTO 4210
4200 IF VO(5)<-180 THEN VO(5)=VO(5)+360
4210 IF ABS(VO(5))>90 THEN I1=VO(3):GOTO 4280
4220 IF VO$(1)="FROM" THEN I=-1 ELSE I=1
4230 IF I=1 THEN VO(3)=I1
4240 VO(2)=40+I*INT(VO(5)):VO(4)=DR
4250 IF VO(2)<35 THEN VO(2)=34
4260 IF VO(2)>45 THEN VO(2)=46
4270 GOTO 4360
4280 VO$(1)=" TO ":VO(3)=VO(3)+180:IF VO(3)=>360 THEN VO(3)=VO(3)-360
4290 GOTO 4180
4300 VO$(1)="OUT ":VO(4)=999.9:F(3)=0:RETURN
4310 IF DR>12 OR DR<10 THEN MK=0:GOTO 4170
4320 IF AL>4000 THEN MK=0:GOTO 4170
4330 IF F(1) =1 THEN J=9 ELSE J=2.5
4340 IF CR>AR+J OR CR<AR-J THEN MK=0:GOTO 4170
4350 F(1)=1:MK=1:GOTO 4170
4360 PRINT@ (18,21),"";:IF MK=1 THEN PRINT "  ":ELSE PRINT "  "
4370 IF MK=0 THEN F(1)=0:RETURN
4380 IF CC>LL+1 OR CC<LL-1 THEN RETURN
4390 IF RA<>0 THEN RETURN
4400 F(1)=0:F(2)=1
4410 GOTO 4300
4420 IF F(3)=1 THEN VO(3)=CR:F(3)=0
4430 GOTO 4310
4440 'ILS ROUTINE
4450 ZN=AL:TH=2.82471:MK=1
4460 DW=1.69*RW*TJ:IF F(7)=1 THEN DW=0
4470 IF F(7)=1 THEN CC=LL:RA=0
4480 CJ=CC
4490 IF CJ>180 THEN CJ=360-CJ:CJ=-1*CJ
4500 HA=LO+CJ
4510 DC=360-HA:TS=1:IF HA<180 THEN DC=HA:TS=-1
4520 IF DC<0 THEN DC=-1*DC:TS=-1*TS
4530 TL$="W":IF TS=1 THEN TL$="E"
4540 DD=1.69*ZS*TJ
4550 DY=DD*SIN(DC/KR):DX=DD*COS(DC/KR)
4560 XN=XO-DX:IF TL$="E" THEN DY=-1*DY
4570 YN=YO+DY+DW
4580 LM=KR*ATN(AL/XN)
4590 BE=KR*ATN(ABS(YN)/ABS(XN)):IF BE>2.5 THEN MK=0
4600 J=(LM-TH)/.25:J=FIX(J)
4610 IF J>3 THEN J=3
4620 IF J<-3 THEN J=-3
4630 BE=BE/.25:BE=FIX(BE)
4640 IF BE<-7 THEN BE=-7
4650 IF BE>7 THEN BE=7
4660 IF YN>0 THEN BE=-1*BE
4670 IF MK=0 THEN GOTO 4710
4680 IF XN>34960! AND XN<38000! THEN GOTO 4710
4690 IF XN>2534 AND XN<5574 THEN GOTO 4710
4700 MK=0
4710 GX(1)=BE:GY(1)=J
4720 GOSUB 5230
4730 PRINT@ (18,21),"";:IF MK=1 THEN PRINT "  ";:ELSE PRINT "  ";
4740 XO=XN:YO=YN
4750 IF F8=1 THEN GOTO 4810
4760 IF XN>12000 THEN GOTO 4810
4770 F8=1
4780 FOR I=0 TO 3
4790 PRINT@ (13+I,49),RS$(I);
4800 NEXT I
4810 IF F8=0 THEN GOTO 4880
4820 PRINT@ (17,XQ)," ";
4830 YU=FIX(YN/16.7):XC=64+YU
4840 IF XC<49 THEN XC=49
4850 IF XC>79 THEN XC=79
4860 PRINT@ (17,XC),CHR$(45);
4870 XQ=XC
4880 GOTO 2540
4890 GOTO 4900
4900 GOTO 850
4910 REM:REVERSE THRUST APPLIED
4920 IF F(4)=1 THEN GOTO 4940
4930 VO=ZS*1.152*1.47:F(4)=1
4940 V=VO-(3.23636)*TJ
4950 IF V<=0 THEN V=0
4960 VO=V
4970 ZS=V/(1.152*1.47)
4980 RETURN
4990 'COMPUTES NEW POSITION
5000 IF CN=0 THEN CA=0:LB(5)=1:LB(6)=1:GOTO 5050
5010 IF CN>0 AND CN<=90 THEN CA=CN:LB(5)=1:LB(6)=1:GOTO 5050
5020 IF CN>90 AND CN<=180 THEN CA=180-CN:LB(5)=-1:LB(6)=1:GOTO 5050
5030 IF CN>180 AND CN<=270 THEN CA=CN-180:LB(5)=-1:LB(6)=-1:GOTO 5050
5040 CA=360-CN:LB(5)=1:LB(6)=-1
5050 IF CA>89.5 THEN GOTO 5140
5060 DL=DN*COS(CA/KR):DL=DL/60:LB(3)=LB(5)
5070 IF LB(3)=1 THEN L2=L1+DL:GOTO 5090
5080 L2=ABS(L1-DL)
5090 LA=L1:GOSUB 5340
5100 M1=MP
5110 LA=L2:GOSUB 5340
5120 M2=MP
5130 DM=ABS(M1-M2):DG=DM*TAN(CA/KR):GOTO 5150
5140 L2=L1:DG=DN/COS(L1/KR)
5150 DG=DG/60:LB(4)=LB(6)
5160 IF LB(4)=-1 THEN GOTO 5190
5170 G2=ABS(G1-DG)
5180 GOTO 5200
5190 G2=G1+DG
5200 CP(4)=FIX(L2):CP(5)=(L2-CP(4))*60
5210 CP(6)=FIX(G2):CP(7)=(G2-CP(6))*60
5220 RETURN
5230 'PLOT GLIDE SLOPE CROSSHAIRS
5240 IF XO<=750 THEN RETURN
5250 X0=8+GX(0):X1=8+GX(1):Y0=18+GY(0):Y1=18+GY(1)
5260 FOR Y=15 TO 21:PRINT@ (Y,X0)," ";:NEXT
5270 PRINT@ (Y0,1),STRING$(15," ");
5280 FOR Y=15 TO 21:PRINT@ (Y,X1),CHR$(176);:NEXT
5290 PRINT@ (Y1,1),STRING$(15,160);
5300 PRINT@ (Y1,X1),"+";
5310 PRINT@ (18,8),"O";
5320 GX(0)=GX(1):GY(0)=GY(1)
5330 RETURN
5340 'COMPUTES MERIDIONAL PARTS, MP
5350 KM(0)=7915.704468#
5360 KM(1)=23.268932#
5370 KM(2)=.0525
5380 KM(3)=.000213
5390 IF LA=0 THEN LA=0+1/60
5400 IF LA>(89+59/60) THEN LA=89+59/60
5410 S1=SIN(LA/KR)
5420 S2=S1*S1:S3=S1*S2
5430 TM(0)=TAN((45+LA/2)/KR)
5440 TM(0)=KM(0)*LOG(TM(0))/LOG(10)
5450 TM(1)=KM(1)*S1
5460 TM(2)=KM(2)*S3
5470 TM(3)=KM(3)*S2*S3
5480 MP=TM(0)-TM(1)-TM(2)-TM(3)
5490 RETURN
5500 'ABORT ROUTINES
5510 M$(1)="---------- A CRASH HAS OCCURED ----------"
5520 M$(2)="YOU ACCIDENTLY STALLED THE AIRCRAFT DURING FINAL APPROACH."
5530 M$(3)="THE STALL OCCURRED AT AN ALTITUDE OF"
5540 M$(4)="THE AIRCRAFT STRUCK THE GROUND IN A NOSE-HIGH ATTITUDE."
5550 M$(5)="THE IMPACT RUPTURED THE TAIL SECTION OF THE FUSELAGE."
5560 M$(6)="---- LOCATION OF CRASH ----"
5570 M$(7)="---- LANDING POSITION ----"
5580 M$(8)="    PITCH ANGLE="
5590 M$(9)="    AIRSPEED="
5600 M$(10)="YOU FLARED AT TOO HIGH AN ALTITUDE DURING FINAL APPROACH."
5610 M$(11)="THE RESULTING STALL OCCURED AT AN ALTITUDE OF"
5620 M$(12)="THE IMPACT RUPTURED THE "
5630 M$(13)="YOU FORGOT TO LOWER THE LANDING GEAR."
5640 M$(14)="YOU FAILED TO TOUCH DOWN INSIDE THE RUNWAY."
5650 M$(15)="---------- AN IMPROPER LANDING WAS MADE ----------"
5660 M$(16)="NO DAMAGE OR INJURIES OCCURRED.
5670 RL=0:IF TX>100 THEN RL=1
5680 RW=0:IF ABS(TY)>100 THEN RW=1
5690 N$(2)="FEET INSIDE OF RUNWAY"
5700 IF TX=>0 THEN N$(2)="FEET SHORT OF RUNWAY"
5710 N$(3)="FEET TO LEFT OF RUNWAY CENERLINE"
5720 IF TY=>0 THEN N$(3)="FEET TO RIGHT OF RUNWAY CENTERLINE"
5730 RX=FIX(TX):RX=ABS(RX)
5740 RY=FIX(TY):RY=ABS(RY)
5750 IF AF=0 THEN GOTO 6580
5760 ZS=INT(AX):FA=INT(FA):ZS=INT(ZS)
5770 PRINT CHR$(16);:ON AF GOTO 5780,5840,5930,6020,6100,6220,6300,6360,6440,6540
5780 GOSUB 6710
5790 YP=4:XP=55:F$="##,###":V1=AL:GOSUB 7010
5800 PRINT@ (15,0),M$(1)
5810 PRINT CHR$(16);"YOU FLEW INTO THE GROUND.":SOUND 0,1:SOUND 3,2
5820 PRINT"THE INSTRUMENT READINGS AT TIME OF THE CRASH ARE SHOWN AS ABOVE.";CHR$(17)
5830 END
5840 CLS
5850 PRINT M$(1)
5860 PRINT M$(2)
5870 PRINT M$(3);AX;"FEET."
5880 PRINT M$(4)
5890 PRINT M$(5)
5900 N$(1)=M$(6)
5910 GOSUB 6760
5920 END
5930 CLS
5940 PRINT M$(1)
5950 PRINT"YOU FLEW INTO THE GROUND DURING FINAL APPROACH."
5960 PRINT"AT THE TIME OF THE CRASH THE AIRCRAFT PROFILE WAS AS FOLLOWS :"
5970 PRINT M$(8);FA;"DEGREES"
5980 PRINT M$(9);ZS
5990 N$(1)=M$(6)
6000 GOSUB 6760
6010 END
6020 CLS
6030 PRINT M$(1)
6040 PRINT M$(10)
6050 PRINT M$(11);AX;"FEET."
6060 PRINT M$(12)+"FUSELAGE."
6070 N$(1)=M$(6)
6080 GOSUB 6760
6090 END
6100 CLS
6110 IF WH=10 THEN PRINT M$(1)
6120 IF WH=12 THEN PRINT"---------- A MINOR CRASH HAS OCCURRED ----------"
6130 PRINT M$(10)
6140 PRINT M$(11);AX;"FEET."
6150 IF WH=10 THEN PRINT M$(13)
6160 IF WH=10 THEN PRINT M$(12)+"FUSELAGE."
6170 IF WH=12 THEN PRINT"THE IMPACT DAMAGED THE LANDING GEAR."
6180 IF WH=12 THEN PRINT"ALL THE PASSENGERS HAVE BEEN SAFELY EVACUATED."
6190 N$(1)=M$(6)
6200 GOSUB 6760
6210 END
6220 CLS
6230 PRINT M$(1)
6240 PRINT M$(13)
6250 PRINT"THE AIRCRAFT LANDED ON ITS BELLY, CAUSING MODERATE DAMAGE."
6260 PRINT"ALL THE PASSENGERS HAVE BEEN SAFELY EVACUATED."
6270 N$(1)=M$(6)
6280 GOSUB 6760
6290 END
6300 CLS
6310 PRINT M$(15)
6320 PRINT M$(14)
6330 N$(1)=M$(7)
6340 GOSUB 6760
6350 END
6360 CLS
6370 PRINT M$(15)
6380 PRINT"YOU FAILED TO EXECUTE A FLARE PRIOR TO TOUCHING DOWN."
6390 PRINT"THIS IS A VIOLATION OF COMPANY PROCEDURES."
6400 PRINT M$(16)
6410 N$(1)=M$(7)
6420 GOSUB 6760
6430 END
6440 CLS
6450 PRINT M$(15)
6460 PRINT"YOU ROLLED OFF THE RUNWAY AFTER TOUCHING DOWN."
6470 PRINT M$(16)
6480 N$(1)=M$(7)
6490 GOSUB 6760
6500 PRINT
6510 IF XN>-9750 THEN PRINT"YOU ROLLED PAST FAR END OF RUNWAY"
6520 IF ABS(YN)>100 THEN PRINT"YOU ROLLED THROUGH RUNWAY SIDE BORDERS"
6530 END
6540 CLS
6550 PRINT"----- YOUR MISSED APPROACH SIGNAL IS ACKNOWLEDGED -----"
6560 PRINT"YOU HAVE FOLLOWED PROPER PROCEDURES."
6570 END
6580 CLS:PRINT CHR$(16);
6590 PRINT"----- YOU HAVE SUCCESSFULLY COMPLETED THE FLIGHT -----"
6600 PRINT"ALL PROCEDURES WERE PROPERLY EXECUTED."
6610 N$(1)=M$(7)
6620 PRINT"CONGRATULATIONS ON A SUCCESSFUL FLIGHT."
6630 GOSUB 6760
6640 PRINT : PRINT CHR$(16);
6650 XN=ABS(XN):JN=FIX(XN+750)
6660 YN=ABS(YN):YN=FIX(YN)
6670 PRINT"YOUR AIRCRAFT CAME TO REST AT THE FOLLOWING POSITION:"
6680 PRINT"     ";JN;"FEET INSIDE THE RUNWAY"
6690 PRINT"     ";YN;"FEET FROM RUNWAY CENTERLINE"
6700 PRINT CHR$(17):END
6710 'SUBROUTINE TO CLEAR LOWER PART OF DISPLAY
6720 FOR I=9 TO 23
6730 PRINT@ (I,0),SPC(79);
6740 NEXT I
6750 RETURN
6760 'LANDING STATISTICS
6770 PRINT
6780 PRINT SPACE$(26);N$(1)
6790 PRINT
6800 IF RL=0 THEN PRINT RX;N$(2)
6810 IF RL=1 THEN PRINT RX;N$(2);
6820 PRINT
6830 IF RW=0 THEN PRINT RY;N$(3)
6840 IF RW=1 THEN PRINT RY;N$(3);
6850 PRINT
6860 PRINT"--- SIZE OF RUNWAY IS 10,500 FEET  X  200 FEET ---";CHR$(17);
6870 RETURN
6880 'TIME DELAY PAD
6890 FOR I=1 TO TQ
6900 NEXT I
6910 RETURN
6920 'CONVERT RTC TO TIME OF DAY IN SECONDS ABSOLUTE
6930 J=7
6940 FOR I=0 TO 2
6950 TC$(I)=MID$(TV$,J,2)
6960 J=J-3
6970 TC(I)=VAL(TC$(I))
6980 TD=(3600*TC(2))+(60*TC(1))+TC(0)
6990 NEXT I
7000 RETURN
7010 'PLOTS VARIABLE ON REVERSE BACKGROUND
7020 PRINT@ (YP,XP),CHR$(16);:PRINT USING F$;V1;:PRINT CHR$(17);:RETURN
7030 'BEGIN TAKEOFF MODULE HERE, EH
7040 CLS:CLEAR 1000:RANDOM
7050 KR=57.2958
7060 DIM XM(13),WM(13)
7070 DIM P$(31)
7080 DATA 37,35,32,30,27,25,22,20,17,15,12,10,7,5
7090 DATA 6,11,16,21,26,31,36,41,46,51,56,61,66,71
7100 FOR I=0 TO 28:READ P$(I):NEXT
7110 FOR I=0 TO 13:READ XM(I):NEXT
7120 FOR I=0 TO 13:READ WM(I):NEXT
7130 M$(1)="_":M$(2)="_":M$(3)="_"
7140 DIM XE(13),WE(13)
7150 K1=29:K2=23
7160 FOR I=0 TO 13
7170 XE(I)=K1:WE(I)=K2
7180 K1=K1-2:K2=K2+4
7190 NEXT
7200 IO=40
7210 RN=RND(0)
7220 RS=1:IF RN>.5 THEN RS=-1
7230 W1=75:IF RS=-1 THEN W1=255
7240 W2=RND(20):W3=RS*W2
7250 DIM XL(14),XR(14)
7260 J=31:K=49
7270 FOR I=0 TO 14
7280 XL(I)=J:XR(I)=K
7290 J=J-2:K=K+2
7300 NEXT
7310 DATA FUEL,LBS,%,VHF,MHZ,THRUST,MAX,IDLE,REV
7320 DATA PITCH," +"," -",DEG,FLAPS,UP,DWN,WHEELS,UP,MID,DOWN
7330 DATA COMPASS,AIRSPEED,KTS," VERT",SPEED,FPM
7340 DATA ALTITUDE,FEET,CLOCK,BRAKE,SET,REL
7350 FOR I=0 TO 31:READ P$(I):NEXT
7360 DIM S$(25)
7370 FOR I=1 TO 25:S$(I)=SPACE$(I):NEXT
7380 FOR I=0 TO 9:F(I)=0:NEXT
7390 'INIT VARIABLES FOR TAKEOFF MODE
7400 FU=200000!:FP=0:CC=75:ZS=0:RC=0:AL=0
7410 MZ=107:TR=6:FL=2:FA=0:WH=13:IX=40:HY=9:BR=11:BK=11
7420 AB=0
7430 PRINT@ (8,17),CHR$(16);"TRS Airlines Flight 4  Cleared as Filed"
7440 PRINT:PRINT
7450 PRINT"          SURFACE WINDS VARIABLE, GUTING TO 15."
7460 PRINT"          MINIMUM CEILING CONDITONS ARE IN EFFECT."
7470 PRINT"          SKY CONDITIONS AT 20,000 SCATTERED."
7480 PRINT"                         AT 30,000 BROKEN."
7490 PRINT:PRINT
7500 PRINT"UPON TAKEOFF, MAINTAIN HEADING 075 TO 3000, THEN PROCEED AS FILED."
7510 PRINT:PRINT:PRINT"        STANDBY FOR TAKEOFF CLEARANCE"
7520 SOUND 0,0:TQ=6000:GOSUB 10170
7530 CLS
7540 PRINT@ (10,17),CHR$(16);"TRS Airlines Flight 4":PRINT:PRINT 
7550 PRINT@ (12,17),"YOU ARE CLEARED FOR TAKEOFF AT 0800 HOURS"
7560 SOUND 0,0:TQ=2000:GOSUB 10170
7570 CLS
7580 TV$=TIME$:GOSUB 10190:TL=TD
7590 GOSUB 7660
7600 GOSUB 7830
7610 GOSUB 7970
7620 GOSUB 8240
7630 K$=INKEY$:IF K$="" THEN GOTO 9020
7640 GOSUB 8590
7650 GOTO 9020
7660 'DISPLAY PANEL (HEADERS ONLY)
7670 PRINT@ (0,3),CHR$(16);P$(0);S$(4);P$(5);S$(3);P$(9);S$(3);S$(6);S$(3);P$(20)
7680 PRINT@ (10,59),P$(13);S$(3);P$(16);S$(2);P$(29)
7690 PRINT@ (11,61),P$(14);S$(6);P$(14);S$(6);P$(30)
7700 PRINT@ (13,61),P$(15);S$(5);P$(15);S$(5);P$(31)
7710 IF F(9)=1 THEN PRINT CHR$(17);:RETURN
7720 PRINT@ (1,13),P$(6);S$(6);P$(10);S$(6)
7730 PRINT@ (1,68),P$(28)
7740 PRINT@ (2,1),P$(1);S$(4);P$(2);S$(21);S$(3);S$(13);P$(23)
7750 PRINT@ (3,22),P$(11);S$(13);P$(21);S$(2);P$(24);S$(2);P$(26)
7760 PRINT@ (4,0),P$(3)
7770 PRINT@ (5,39),P$(22);S$(6);P$(25);S$(5);P$(27)
7780 PRINT@ (6,0),P$(4);S$(10);P$(7);S$(3);P$(12);S$(7)
7790 PRINT@ (7,13),P$(8);CHR$(17);
7800 FOR Y=1 TO 7:PRINT@ (Y,12),CHR$(188);:NEXT
7810 FOR Y=1 TO 3:PRINT@ (Y,21),CHR$(188);:NEXT
7820 RETURN
7830 'DISPLAY HORIZONTAL LINE
7840 IF F(9)=0 THEN GOTO 7870
7850 PRINT@ (9,0),SPACE$(80);
7860 IF HY=20 THEN GOTO 7890
7870 PRINT@ (HY,0),STRING$(80,"_");
7880 RETURN
7890 OH=9:HY=10
7900 FOR I=HY TO 22
7910 PRINT@ (OH,0),SPACE$(80);
7920 PRINT@ (I,0),STRING$(80,"_");
7930 OH=I
7940 NEXT I
7950 PRINT@ (23,IO)," ";
7960 RETURN
7970 'DISPLAY RUNWAY
7980 IF F(4)=1 THEN GOTO 8060
7990 S=10:X=29
8000 FOR Y=10 TO 22
8010 PRINT@ (Y,X),".";SPACE$(S);"|";SPACE$(S);".";
8020 X=X-2:S=S+2
8030 NEXT
8040 S$=S$(13)
8050 RETURN
8060 'PRINTS RUNWAY GRAPHICS
8070 IF N>3 THEN GOTO 8210
8080 PRINT@ (OY,OX),SPACE$(WM);
8090 PRINT@ (NY,NX),MK$;
8100 OY=NY:OX=NX
8110 WM=FW
8120 RETURN
8130 'ENTRY WHEN SHIP IN FINAL ZONE
8140 PRINT@ (OY,OX),SPACE$(WM);:IF F(9)=1 THEN RETURN
8150 FOR I=10 TO NY-1
8160 PRINT@ (I,XE(J)),SPACE$(WE(J));
8170 NEXT I
8180 IF N>4 THEN RETURN
8190 PRINT@ (NY,XY),MK$;
8200 RETURN
8210 IF F(2)=1 THEN GOTO 8130 ELSE F(2)=1
8220 FOR I=10 TO 13:PRINT@ (I,59),SPACE$(21);:NEXT
8230 GOTO 8130
8240 'DISPLAY INSTRUMENT READINGS
8250 PRINT@ (0,67),CHR$(16);TIME$;CHR$(17);
8260 YP=1:XP=0:F$="######":V1=FU:GOSUB 10280
8270 YP=1:XP=7:F$="###":V1=FP:GOSUB 10280
8280 YP=1:XP=39:V1=CC:GOSUB 10280
8290 YP=4:XP=39:V1=ZS:GOSUB 10280
8300 YP=4:XP=46:F$="######":V1=RC:GOSUB 10280
8310 YP=4:XP=55:F$="##,###":V1=AL:GOSUB 10280
8320 YP=5:XP=0:F$="###":V1=MZ:GOSUB 10280
8330 'DISPLAY THRUST
8340 FOR I=1 TO 7
8350 PRINT@ (I,11),"|";
8360 NEXT
8370 PRINT@ (TR,11),">";
8380 'DISPLAY PITCH
8390 FOR I=1 TO 3:PRINT@ (I,20),"|";:NEXT
8400 PRINT@ (FL,20),">";
8410 F$="+###"
8420 YP=5:XP=20:V1=FA:GOSUB 10280
8430 'DISPLAY FLAPS
8440 IF F(2)=1 THEN GOTO 8530
8450 FOR I=11 TO 13:PRINT@ (I,59),"|";:NEXT
8460 PRINT@ (BR,59),">";
8470 'WHEELS
8480 FOR I=11 TO 13:PRINT@ (I,67),"|";:NEXT
8490 PRINT@ (WH,67),">";
8500 REM:BRAKES
8510 FOR I=11 TO 13:PRINT@ (I,75),"|";:NEXT
8520 PRINT@ (BK,75),">";
8530 'DISPLAY RUNWAY ALIGNMENT INDEX
8540 IF F(9)=1 THEN RETURN
8550 PRINT@ (23,IO)," ";
8560 PRINT@ (23,IX),CHR$(149);
8570 IO=IX
8580 RETURN
8590 'POLL KEY SUBROUT
8600 IF K$="F" OR K$="f" THEN KK=1:GOTO 8680
8610 IF K$="," OR K$="." THEN KK=2:GOTO 8680
8620 IF K$="B" OR K$="b" THEN KK=3:GOTO 8680
8630 IF K$="U" OR K$="D" OR K$="u" OR K$="d" THEN KK=4:GOTO 8680
8640 IF K$="L" OR K$="l" THEN KK=5:GOTO 8680
8650 IF K$="W" OR K$="w" THEN KK=6:GOTO 8680
8660 IF K$="S" OR K$="s" THEN KK=7:GOTO 8680
8670 RETURN
8680 ON KK GOSUB 8730,8760,8810,8840,8940,8990,8700
8690 RETURN
8700 'THRUST KEY (DECREASE)
8710 IF F(7)=1 AND BR=11 THEN TR=4
8720 RETURN
8730 'THRUST KEY (INCREASE)
8740 IF F(7)=1 THEN RETURN
8750 F(1)=1:TR=1:RETURN
8760 'RUDDER KEYS
8770 'IF F(7)=1 THEN RETURN
8780 'IF ZS<50 THEN RETURN
8790 IF K$="," THEN CC=CC-1 ELSE CC=CC+1
8800 RETURN
8810 'BRAKES
8820 IF F(0)=1 THEN RETURN
8830 F(0)=1:BK=13:RETURN
8840 'PITCH
8850 IF F(7)=1 THEN RETURN
8860 IF ZS<=50 THEN RETURN
8870 FD=-10:IF K$="U" OR K$="u" THEN FD=10
8880 FA=FA+FD
8890 IF FA>60 THEN FA=60
8900 IF FA<-60 THEN FA=-60
8910 IF FA>0 THEN FL=1:RETURN
8920 IF FA=0 THEN FL=2:RETURN
8930 FL=3:RETURN
8940 'FLAPS
8950 IF F(7)=1 AND WH=11 THEN BR=11:RETURN
8960 IF F(3)=1 THEN RETURN
8970 IF F(3)=0 THEN F(3)=1:BR=13:RETURN
8980 RETURN
8990 'WHEELS
9000 IF F(7)=1 THEN WH=11
9010 RETURN
9020 'SITUATION UPDATE ROUTINE
9030 TV$=TIME$:GOSUB 10190:TJ=TD-TL:TL=TD
9040 IF F(9)=1 THEN GOTO 10300
9050 IF F(0)=1 THEN GOTO 9070
9060 GOSUB 9380:GOTO 7620
9070 IF F(4)=1 THEN GOTO 9110
9080 F(4)=1
9090 XX=0:YY=0
9100 TD=TD:V0=0:N=1:OY=23:OX=5:WM=71
9110 '
9120 A=(118-18*TR)*.04028
9130 GOSUB 9500
9140 IF AL>0 THEN GOTO 9250
9150 IF YY > 10500 OR ABS(XX) > 100 THEN GOTO 9900
9160 IF FA<=0 THEN GOTO 9330
9170 IF ZS<150 THEN GOTO 9890
9180 IF FA>10 THEN GOTO 9890
9190 IF F(3)=0 THEN GOTO 9330
9200 AL=25
9210 GOSUB 9380
9220 GOSUB 9420
9230 GOSUB 9720
9240 GOTO 7610
9250 F(9)=1
9260 GOSUB 9380
9270 GOSUB 9420
9280 GOSUB 9460
9290 FOR I=10 TO 22:PRINT@ (I,0),SPACE$(80);:NEXT
9300 HY=20
9310 GOSUB 7830
9320 GOTO 9360
9330 GOSUB 9380
9340 GOSUB 9720
9350 GOTO 7610
9360 'NOW DO DEPARTURE PROCEDURES
9370 GOTO 7620
9380 REM:UPDATE FUEL
9390 FU=FU-40*TJ
9400 FP=FU/3120
9410 RETURN
9420 'UPDATE RATE OF CLIMB
9430 RC=ZS*SIN(ABS(FA/57.3))*1.693*60
9440 IF FA<0 THEN RC=-1*RC
9450 RETURN
9460 'UPDATE ALT
9470 AL=AL+TJ*RC/60
9480 IF AL<=0 THEN AL=0
9490 RETURN
9500 'EQUATIONS OF MOTION
9510 T=TJ
9520 V=V0+A*T
9530 VB=(V+V0)/2:V0=V
9540 S=VB*T
9550 IF TD<(TX+18) THEN GOTO 9590
9560 TX=TD
9570 WB=RS*RND(2)
9580 CC=CC+WB
9590 DA=(CC-75)/57.3
9600 DY=S*COS(ABS(DA))
9610 DX=S*SIN(ABS(DA))
9620 IF DA<0 THEN DX=-1*DX
9630 YY=YY+DY
9640 XX=XX+DX
9650 ZS=V/1.69278
9660 IF ZS>20 THEN ZS=ZS+WS
9670 IX=40+FIX(XX*7/20):IF IX>79 THEN IX=79
9680 IF IX<0 THEN IX=0
9690 ZP=FIX(YY-2500*(N-1))
9700 IF ZP>2500 THEN N=N+1:GOTO 9690
9710 RETURN
9720 'VARIABLES FOR RUNWAY GRAPHICS
9730 MP=FIX(10+(13*ZP)/2500)
9740 IF N>3 THEN GOTO 9820
9750 NY=MP
9760 J=NY-10
9770 NX=XM(J)
9780 FW=WM(J)
9790 S$=SPACE$(J)
9800 MK$=M$(N)+S$(J)+"_"+S$(J)+"_"+S$(J)+"_"+S$(J)+"_"+S$(J)+"_"
9810 RETURN
9820 'IN ZONE 4-MARKER IS RUNWAY EDGE
9830 NY=MP
9840 J=NY-10
9850 NX=XE(J)
9860 IF N>4 THEN RETURN
9870 MK$=STRING$(WE(J),"_")
9880 RETURN
9890 AB=1:GOTO 9950
9900 AB=2:IF YY<10500 GOTO 9950
9910 FOR I=10 TO 22
9920 PRINT@ (I,0),SPACE$(80);
9930 NEXT I
9940 GOTO 9950
9950 'ABORT
9960 FOR I=10 TO 22:PRINT@ (I,0),SPACE$(80);:NEXT I
9970 SOUND 1,1:PRINT@ (10,29),CHR$(16);"*** TAKEOFF FAILED ***":PRINT:PRINT
9980 ON AB GOSUB 10010,10060
9990 PRINT@ (19,34),"END OF PROGRAM";
10000 GOTO 10520
10010 PRINT"YOU PULLED BACK ON THE STICK AT TOO SLOW A SPEED, OR YOU"
10020 PRINT"PULLED BACK THE STICK TOO FAR WHEN AT PROPER SPEED."
10030 PRINT"AS A RESULT, THE TAIL OF THE FUSELAGE SCRAPED THE RUNWAY"
10040 PRINT"AND THE AIRCRAFT SPUN OUT OF CONTROL."
10050 RETURN
10060 IF YY>10500 THEN GOTO 10110
10070 PRINT"YOU FAILED TO STAY WITHIN THE RUNWAY BOUNDARIES."
10080 PRINT"AS A RESULT, YOU VEERED OFF THE RUNWAY AND COLLIDED WITH"
10090 PRINT" THE RUNWAY LIGHTS."
10100 RETURN
10110 PRINT" YOU RAN OUT OF RUNWAY. AS A RESULT, YOU ROLLED INTO THE"
10120 PRINT" MARSHLANDS LOCATED";FIX(YY)-10500;"FEET PAST THE END OF THE RUNWAY."
10130 IF F(3)=1 THEN RETURN
10140 PRINT:PRINT:PRINT" YOU FORGOT TO LOWER THE FLAPS."
10150 PRINT" AS A RESULT, THE AIRCRAFT COULD NOT DEVELOP SUFFICIENT LIFT."
10160 RETURN
10170 'TIME DELAY PAD
10180 FOR I=1 TO TQ:NEXT I:RETURN
10190 'CONVERT RTC TO TIME OF DAY IN SECONDS, ABSOLUTELY
10200 J=7
10210 FOR I=0 TO 2
10220 TC$(I)=MID$(TV$,J,2)
10230 J=J-3
10240 TC(I)=VAL(TC$(I))
10250 TD=(3600*TC(2))+(60*TC(1))+TC(0)
10260 NEXT I
10270 RETURN
10280 'PLOTS VARIABLE ON REVERSE BACKGROUND
10290 PRINT@ (YP,XP),CHR$(16);:PRINT USING F$;V1;:PRINT CHR$(17);:RETURN
10300 'DEPARTURE ROUTINE
10310 IF F(7)=1 THEN GOTO 10340 ELSE F(7)=1
10320 GOSUB 7680
10330 F(2)=0
10340 IF WH<>11 THEN GOTO 10370 ELSE ZS=ZS+5
10350 IF BR<>11 THEN GOTO 10370 ELSE ZS=ZS+5
10360 IF TR=4 AND AL>1800 THEN GOTO 140 ELSE GOTO 10480
10370 IF AL<1200 THEN GOTO 10480
10380 PRINT@ (12,0),CHR$(16);"******* FLIGHT ABORTED *******"
10390 PRINT:PRINT
10400 PRINT"YOU FAILED TO PERFORM CRUCIAL TRIM MANOUVERS FOLLOWING LIFTOFF."
10410 PRINT" THE PROPER TRIM SEQUENCE, WHICH MUST BE COMPLETED BELOW 1200 FEET, IS AS FOLLOWS:"
10420 PRINT"   1-RAISE LANDING GEAR"
10430 PRINT"   3-REDUCE THRUST"
10440 PRINT"   2-RETRACT FLAPS"
10450 PRINT
10460 PRINT"--------------- END OF PROGRAM --------------"
10470 GOTO 10520
10480 GOSUB 9380
10490 GOSUB 9420
10500 GOSUB 9460
10510 GOTO 7620
10520 ' AT THE END...TRY AGAIN?
10530 PRINT@ (23,30),CHR$(16);:INPUT "Press Enter to try again";ZZZZ$
10540 GOTO 50
10550 'End of this Program....Finally!
