; FIXCLOCK/ASM - VERSION 1.0 - 04/02/86
; AUTHOR: JOE SARE
;	  3965 BRADMORE
;	  WEST BLOOMFIELD, MI 48033
;
; The Fixclock program fixes the speed of the real time clock
; on the model 4 running LDOS in model 3 mode.
;
; There are two options available. They are:
;
; CLOCK-This option allows you to disable the real time clock.
;	This also disables the clock display on the screen, and
;	the blinking cursor.
;	CLOCK=Y or ON  enables  the real time clock routines.
;       CLOCK=N or OFF disables the real time clock routines.
;	(The default is ON.)
;
; TASK -This option allows you to disable the system task
;	processing routines, or to specify that they are also
;	to be slowed down.
;	TASK=Y or ON  enables  the system task routines.
;	TASK=N or OFF disables the system task routines.
;	TASK=1 enables the system task routines, and slows them
;	       down to the normal model 3 rate. This may be
;	       useful if you have task routines which are
;	       time dependent and have to be executed at a
;	       specific time interval.
;
; Once installed Fixclock examines the status of SYSTEM(FAST)
; and SYSTEM(SLOW) in SFLAG$. If SYSTEM(SLOW) is set, Fixclock
; executes the routines that are currently enabled at the
; normal rate. Fixclock may be re-executed at any time to
; modify the options currently in effect. Fixclock may also be
; SYSGENed. Fixclock also corrects the problem in the model 3
; ROM with displaying the char at the cursor with blink on.
;
; I am placing this program in the public domain. Feel free
; to distribute the source and/or the command module as you
; wish. Please direct any comments/criticism/questions to the
; address above, or to 72667,3124.
;
*LIST	OFF
*GET	EQUATE3/EQU;
*LIST	ON
;
	ORG	5200H
FIXCLK	EQU	$
;
;-------------------------------------------------------------;
; Routine: "HSKP" - Set up parms, display messages, and	      ;
;		determine what to do.			      ;
;							      ;
; Specifically:						      ;
; 1. Save parm pointer and display start up message.	      ;
; 2. Process parameters, set up flags, and display options    ;
;    messages based on the options selected.		      ;
; 3. See if we or some other RTC mod have been loaded before. ;
;    This is done by checking the RTC processing S/R address. ;
;    If the address is in the range of 4000H-4FFFH, we assume ;
;    that no clock mod is installed.			      ;
;    If no clock mod is installed, the INIT S/R is executed.  ;
;    Id a  clock mod is installed, the CHNG S/R is executed.  ;
;-------------------------------------------------------------;
	PAGE	OFF
; STEP 1
	PUSH	HL		;Save possible parm pointer
	CALL	01C9H		;Start with a clear screen
	LD	HL,BEGMSG	;Load PTR -> start-up message
	CALL	@DSPLY		;Display start-up message
;
; STEP 2
	POP	HL		;Restore parm pointer
	LD	DE,PARMTAB	;Load PTR -> parm table
	CALL	@PARAM		;Go parse parms
	LD	HL,FLAG		;Load PTR -> flag reg
;
HSKP@10	EQU	$
	LD	DE,DISAMSG	;Load PTR -> disabled message
	LD	A,(TSKEN)	;Load task enable flag
	CP	00H		;Are tasks to be enabled?
	JR	Z,HSKP@20	;No -Go check next parm
;
	SET	TSK_EN,(HL)	;Set flag for "Enable tasks"
	LD	DE,TSKFAST	;Load PTR -> fast tasks message
	CP	01H		;Are tasks to be slowed down?
	JR	Z,HSKP@20	;No -Go check next parm
;
	SET	TSK_SLO,(HL)	;Set flag for "Slow tasks"
	LD	DE,TSKSLOW	;Load PTR -> slow tasks message
;
HSKP@20	EQU	$
	PUSH	DE		;Save PTR -> stat msg for tasks
	LD	DE,DISAMSG	;Load PTR -> disabled MSG
	LD	A,(CLKEN)	;Load clock enable flag
	CP	00H		;Clock to be enabled?
	JR	Z,HSKP@30	;No -Go check next parm
;
	SET	CLK_EN,(HL)	;Set flag for "Enable clock"
	LD	DE,ENABMSG	;Load PTR -> enabled message
;
HSKP@30	EQU	$
	PUSH	DE		;Save PTR -> stat msg for CLKEN
	LD	HL,CLKMSG	;Load PTR -> clock message
	CALL	@DSPLY		;and display it
	POP	HL		;Load PTR -> results for CLKEN
	CALL	@DSPLY		;and display it
	LD	HL,TSKMSG	;Load PTR -> task message
	CALL	@DSPLY		;and display it
	POP	HL		;Load PTR -> results for TSKEN
	CALL	@DSPLY		;and display it
;
; STEP 3
	LD	DE,(INTVC$+4)	;Load PTR -> RTC int vector S/R
	LD	A,D		;Copy high order byte to A reg
	AND	0F0H		;Drop low order nibble
	CP	40H		;Is it pointing to a SYS0 area?
	JR	NZ,CHNG		;No -Go see if we're already in
	PAGE	OFF
;-------------------------------------------------------------;
; Routine: "INIT" - Place new RTC interrupt S/R in HI-MEM.    ;
;							      ;
; Specifically:						      ;
; 1. Verify that the vector is really pointing to the LDOS RTC;
;    S/R. The first 2 instructions in the LDOS S/R are:       ;
;    LD DE,3529H and PUSH DE. This causes the ROM RTC S/R to  ;
;    execute after the LDOS routine returns. This step checks ;
;    to make sure that these instructions are really at the   ;
;    beginning of the code pointed to by the interrupt vector.;
; 2. Calculate relocation factor for "HIGH".		      ;
; 3. Relocate address constants in "HIGH".		      ;
; 4. Set vector to LDOS S/R to bypass the 1st 2 instrcutions. ;
; 5. Put "HIGH" S/R in high memory and protect it with HIGH$  ;
; 6. Set RTC interrupt vector to our routine.		      ;
; 7. Display "INIT completed" message, and exit.              ;
;-------------------------------------------------------------;
INIT	EQU	$
	LD	B,VECLEN	;Load number of bytes to check
	LD	HL,VECINST	;Load PTR -> expected code vals
;
INIT@10	EQU	$
	LD	A,(DE)		;Load byte into A
	CP	(HL)		;Does it match expected?
	JP	NZ,ERR@001	;No -Error code has changed
;
	INC	DE		;Increment PTR -> RTC code
	INC	HL		;Increment PTR -> expected code
	DJNZ	INIT@10		;Loop till we've checked em all
;
	LD	HL,(HIGH$)	;Load PTR -> curr end-of-memory
	LD	BC,HIGH@99	;Load PTR -> end of high S/R
	OR	A		;Reset carry flag
	SBC	HL,BC		;Calc relocation factor
	PUSH	HL		;Save relocation factor
	POP	BC		;and load it into BC
;
	LD	IX,RELOTAB	;Load PTR -> relocation PTRS
	LD	A,RELONUM	;Load number relocation PTRS
;
INIT@20	EQU	$
	LD	L,(IX+00H)	;Load low  order byte of PTR
	LD	H,(IX+01H)	;Load high order byte of PTR
	INC	HL		;Bypass op-code byte
	LD	E,(HL)		;Load low  byte of instr vector
	INC	HL		;Increment instruction PTR
	LD	D,(HL)		;Load high byte of onstr vector
	EX	DE,HL		;Put it in HL
	ADD	HL,BC		;Add in relocation factor
	EX	DE,HL		;Restore HL/DE
	LD	(HL),D		;Init new high order byte
	DEC	HL		;Load PTR -> low order byte
	LD	(HL),E		;Init new low  order byte
	INC	IX		;Bump PTR ->
	INC	IX		;	relo table twice
	DEC	A		;Decrement loop counter
	JR	NZ,INIT@20	;and loop if we're not done
	PAGE	OFF
	LD	BC,(INTVC$+4)	;Load PTR -> LDOS RTC int S/R
	INC	BC		;Bypass
	INC	BC		;	setup
	INC	BC		;		for ROM
	INC	BC		;			RTC S/R
	LD	(LDOSVEC),BC	;and store it for our routine
;
	LD	DE,(HIGH$)	;Load PTR -> 1st avail HI-MEM
	LD	(HIGHNXT),DE	;Init PTR -> next HI-MEM block
	LD	HL,HIGH@99	;Load PTR -> end of "HIGH" S/R
	LD	BC,HIGHLEN	;Load length of "HIGH" S/R
	LDDR			;Move "HIGH" S/R to HI-MEM area
;
	LD	(HIGH$),DE	;Init new 1st avail HI-MEM PTR
	INC	DE		;Load PTR -> 1st byte of S/R
	LD	(INTVC$+4),DE	;Init PTR -> RTC int S/R
;
	LD	HL,INITMSG	;Load PTR -> initted message,
	CALL	@DSPLY		;display it,
	RET			;and return to caller (O/S)
	PAGE	OFF
;-------------------------------------------------------------;
; Routine: "CHNG" - Change Fixclock parm settings	      ;
;							      ;
; Specifically:						      ;
; 1. Verify that the vector is really pointing to the Fixclock;
;    RTC routine. This is done by comparing the eye-catcher   ;
;    for "HIGH" to the values pointed to be the interrupt     ;
;    vector.						      ;
; 2. Calc the address of the "HIGH" control flag in HI-MEM.   ;
; 3. Replace the "HIGH" control flag in HI-MEM with the new   ;
;    one built from the current parms.			      ;
; 4. Display "Modification successful" message, and exit.     ;
;-------------------------------------------------------------;
CHNG	EQU	$
;
	LD	DE,(INTVC$+4)	;Load PTR -> our??? S/R
	INC	DE		;Load
	INC	DE		;   PTR ->
	INC	DE		;	"HIGH" S/R
	INC	DE		;	    eye-catcher
	LD	B,HIGHELN	;Load number of bytes to check
	LD	HL,HIGHEYE	;Load PTR -> expected code vals
;
CHNG@10	EQU	$
	LD	A,(DE)		;Load byte into A
	CP	(HL)		;Does it match expected?
;
	JP	NZ,ERR@002	;No -err someone else is there
	INC	DE		;Increment PTR -> RTC code
	INC	HL		;Increment PTR -> expected code
	DJNZ	CHNG@10		;Loop till we've checked em all
;
	LD	HL,(INTVC$+4)	;Load PTR -> our S/R
	LD	BC,FLAG-HIGH	;Load offset to flag
	ADD	HL,BC		;Calc PTR -> remote flag
	LD	A,(FLAG)	;Load our local flag
	LD	(HL),A		;and set it in the remote flag
;
	LD	HL,CHNGMSG	;Load PTR -> modified message,
	CALL	@DSPLY		;Display it,
	RET			;and return to caller (O/S)
;
ERR@001	LD	HL,ERRM001	;Load PTR -> error message # 1
	DB	0DDH		;Make next instr a "LD IX"
;
ERR@002	LD	HL,ERRM002	;Load PTR -> error message # 2
;
	CALL	@DSPLY		;Display error message
	JP	@ABORT		;Help!!! we're sick
	PAGE	OFF
;-------------------------------------------------------------;
; Program data areas...					      ;
;-------------------------------------------------------------;
PARMTAB	EQU	$
	DB	'CLOCK '	;Keyword for "Clock enable"
	DW	CLKEN		;PTR -> Data area for CLKEN
	DB	'C     '	;Alt keyword for "Clock enable"
	DW	CLKEN		;PTR -> Data area for CLKEN
	DB	'TASK  '	;Keyword for "Task enable"
	DW	TSKEN		;PTR -> Data area for TSKEN
	DB	'T     '	;Alt keyword for "Task enable"
	DW	TSKEN		;PTR -> Data area for TSKEN
;
PARMVAL	EQU	$		;Parm values collection
CLKEN	DW	0FFFFH		;Default-Clock S/R is enabled
TSKEN	DW	0FFFFH		;Default-Tasks enable hi speed
;
RELOTAB	EQU	$	;Table of PTRs to instrs to relocate
	DW	HIGH@R2,HIGH@R4,HIGH@R6,HIGH@R8
RELOLEN	EQU	$-RELOTAB	;Length of RELO table
RELONUM	EQU	RELOLEN/2	;# of entries in RELOTAB
;
VECINST	EQU	$	;Instructions expected at (INTVC$+4)
	LD	DE,3529H	;1ST instr in LDOS RTC S/R
	PUSH	DE		;2ND instr in LDOS RTC S/R
VECLEN	EQU	$-VECINST	;Length of instr to check
;
BEGMSG	DB	'Fixclock clock speed correction module.',0AH
	DB	'For model 4 running in model 3 mode.',0AH
	DB	0AH,'Written by Joe Sare April 1986.',0AH
	DB	'This program is in the public domain,',0AH
	DB	'and may be distributed freely.',0AH,0DH
;
TSKMSG	DB	'System tasks will be ',03H
CLKMSG	DB	'System clocks will be ',03H
;
TSKFAST	DB	'enabled and not slowed down.',0AH,0DH
TSKSLOW	DB	'enabled and slowed down.',0AH,0DH
;
ENABMSG	DB	'enabled',0AH,0DH
DISAMSG	DB	'disabled',0AH,0DH
;
INITMSG	DB	'Fixclock successfully initialized.',0DH
CHNGMSG	DB	'Fixclock parameters successfully modified.'
	DB	0DH
;
ERRM001	DB	'ERROR - System vector contains unrecognized'
	DB	' code.',0AH
	DB	'        Fixclock valid under LDOS 5.1.3 or '
	DB	'5.1.4 only.',0DH
;
ERRM002	DB	'ERROR - Unable to determine location of',0AH
	DB	'        Fixclock HI-MEM driver program,',0AH
	DB	'        or LDOS RTC S/R is not resident',0DH
	PAGE	OFF
;-------------------------------------------------------------;
; Routine: "HIGH" - New RTC interrupt processing routine.     ;
;-------------------------------------------------------------;
HIGH	EQU	$
	JR	HIGH@00		;Branch around HI-MEM header
HIGHNXT	DW	0		;PTR -> next HI-MEM block
HIGHEYE	DB	08H,'FIXCLOCK'	;Program eye-catcher/identifier
HIGHELN	EQU	$-HIGHEYE	;Length of program eye-catcher
;
HIGH@00	EQU	$
	LD	A,(SFLAG$)	;Load system flag byte
	BIT	3,A		;is SYSTEM(FAST) on?
	JR	NZ,HIGH@30	;Yes-Go handle it
;
HIGH@R2	LD	A,(FLAG)	;Load the flags
;
HIGH@10	EQU	$
	BIT	CLK_EN,A	;Is the clock S/R disabled?
	JR	Z,HIGH@15	;Yes-Go process the task S/R
	CALL	3529H		;ROM  sub-routine jump vector
;
	LD	HL,(4020H)	;Load PTR -> current cursor pos
	LD	A,(HL)		;Load cur char from video ram
	CP	' '		;Is it a blank?
	JR	NZ,HIGH@R4	;No -Bypass cur char fix-up
;
	LD	A,(4022H)	;Load char at cursor position
	LD	(HL),A		;Restore char at cursor
	JR	HIGH@R4		;Bypass interrupt reset
;
HIGH@15	EQU	$
	IN	A,(0ECH)	;Must reset RTC interrupt latch
;
HIGH@R4	LD	A,(FLAG)	;Re-load the flags
;
HIGH@20	EQU	$
	BIT	TSK_EN,A	;Is the task S/R disabled?
	RET	Z		;Yes-Return-we're done
	JP	0000H		;LDOS sub-routine jump vector
LDOSVEC	EQU	$-2		;PTR -> LDOS RTC S/R
;
HIGH@30	EQU	$
HIGH@R6	LD	A,(FLAG)	;Load the flags
	XOR	01H		;Flip-flop "Exec nxt time" flag
HIGH@R8	LD	(FLAG),A	;and store it
	BIT	FLP_FLP,A	;are we to execute the S/R'S?
	JR	Z,HIGH@10	;Yes-Execute both S/R'S
;
	BIT	TSK_SLO,A	;are tasks to be slowed down?
	JR	Z,HIGH@15	;No -Go call the LDOS RTC S/R
	IN	A,(0ECH)	;Reset the RTC interrupt latch
	RET			;Yes-Return
;
FLAG	DB	00H		;Flag for "HIGH" S/R
TSK_EN	EQU	3		;Task S/R is enabled
CLK_EN	EQU	2		;Clock S/R is enabled
TSK_SLO	EQU	1		;Tasks are to be slowed down
FLP_FLP	EQU	0		;S/R'S to be exec'ed this time
;
;
HIGH@99	EQU	$-1		;Address of last byte of "HIGH"
HIGHLEN	EQU	$-HIGH		;Length of "HIGH" S/R
;
	END	FIXCLK
