;----------------------------------------------------
;     TRSDOS 6.2 File Map Utility
;
;
;----------------------------------------------------
*LIST OFF
*GET MACLIB
*LIST ON
;
	DEFINE	ETX,03H
	DEFINE	CR,0DH
;
	ORG	3000H
START	CALL	CHKBRK		;check for break key
	CALL	GET_INFO	;info about file and drive
	CALL	SET_ALLOC	;build allocation table for file
	CALL	DISPLAY		;display of file allocation
	@@EXIT			;exit to TRSDOS
;
;-----------
; check for break key
; take error exit if break key pressed
;-----------
;
CHKBRK:
	@@CKBRKC		;use TRSDOS to check
	RET	Z		;return if no break
ERROUT:
	@@EXIT	-1		;else report error and leave
;
BADFILE	LD	HL,BADFILE$	;hl ==> error message
	DB	0DDH		;IX prefix (ignore next instruction)
BADDCT	LD	HL,BADDCT$	;HL or IX ==> error message
	@@DSPLY			;display HL message
	JR	ERROUT		;abort program
;----------
; get information about file and drive
;----------
;
GET_INFO:
	LD	A,(HL)		;get first char of file name
	IFLTJR	'A',BADFILE	;leave if no filename
	@@FSPEC	HL,FCB		;move and test filespec
	@@OPEN	FBUFFER		;open file
	LD	IY,FCB		;IY ==> file control block
	LD	A,(IY+7)	;get file's DEC
	LD	(DEC),A		;and save it
	LD	A,(IY+6)	;get drive number
	AND	07H		;mask off bits 3 thru 7
	LD	(DRV),A		;and save it
	LD	C,A		;move drive number to C
	@@CLOSE			;close file and clear FCB
;
	@@GTDCT			;IY ==> DCT entry
	LD	A,(IY)		;test first byte
	IFNEJR	0C3H,BADDCT	;go if invalid DCT
	LD	A,(IY+6)	;get max cylinder number
	INC	A		;make relative to 1
	LD	(MAXCYL),A	;and save it
	LD	A,(IY+8)	;get grans/cylinder in bits 7 thru 5
	AND	0E0H		;mask off other bits
	RLCA			;move to bits 0 thru 2
	RLCA
	RLCA
	INC	A		;make relative to 1
	BIT	5,(IY+4)	;check DBLBIT
	JR	Z,GET1		;go if not doubled
	ADD	A,A		;else double the count
GET1	LD	(GRANS),A	;save total
	RET			;and return
;
DRV	DB	0		;drive number
DEC	DB	0		;DEC number
MAXCYL	DB	0		;total number of cylinders
GRANS	DB	0		;granules per cylinder
;
;----------
; find file's allocation space and mark each granule
; in the GRANTBL buffer.
;----------
;
SET_ALLOC:
	CALL	MAKE_TBL	;clear gran table
SET1	LD	BC,(DRV)	;C = drive, B = DEC
	@@DIRRD			;get directory sector in sys buffer
	LD	BC,22		;offset to first extent
	ADD	HL,BC		;HL ==> first extent
	PUSH	HL		;move pointer
	POP	IY		;to IY
;
	LD	A,(IY)		;get cylinder number
	CP	-1		;is this extent used
	RET	Z		;return if not
	CALL	ONE_EXT		;else find allocation for this one
	INC	IY		;and point to
	INC	IY		;next extent
	LD	A,(IY)		;repeat for other extents
	CP	-1
	RET	Z
	CALL	ONE_EXT
	INC	IY
	INC	IY
	LD	A,(IY)
	CP	-1
	RET	Z
	CALL	ONE_EXT
	INC	IY
	INC	IY
	LD	A,(IY)
	CP	-1
	RET	Z
	CALL	ONE_EXT
	INC	IY
	INC	IY
;
	LD	A,(IY)		;get FXDE flag
	CP	-1		;is there one?
	RET	Z		;no -- return
	LD	A,(IY+1)	;else get new DEC
	LD	(DEC),A		;and save it
	JR	SET1		;then loop back and start again
;
;----------
; clear the gran table before starting to work
;----------
MAKE_TBL:
	LD	A,(MAXCYL)	;get number of cylinders
	LD	L,A		;into HL
	LD	H,0
	LD	A,(GRANS)	;get number of grans
	LD	C,A		;prepare for HL * C
	@@MUL16
	LD	H,L		;move product to HL
	LD	L,A
	PUSH	HL		;transfer product
	POP	BC		;to BC
	DEC	BC		;# of grans - 1
	LD	HL,GRANTBL	;HL ==> gran table
	LD	DE,GRANTBL+1	;DE ==> second byte of table
	LD	A,'.'		;clear with periods
	LD	(HL),A		;store first one
	LDIR			;clear entire table
	RET
;----------
; mark allocated granules for one extent
;----------
ONE_EXT:
	LD	L,A		;get cylinder number
	LD	H,0		;HL = cylinder
	LD	A,(GRANS)	;A = grans per cylinder
	LD	C,A		;prepare for HL * C
	@@MUL16
	LD	H,L		;move product
	LD	L,A		;to HL
	LD	A,(IY+1)	;get starting gran
	AND	0E0H		;mask off bits 0 thru 4
	RLCA			;move to bits 0 thru 2
	RLCA
	RLCA
	ADD	A,L		;add to HL
	LD	L,A		;LSB to L
	JR	NC,EXT1		;jump if no carry
	INC	H		;else add carry
EXT1	LD	DE,GRANTBL	;DE ==> table of grans
	ADD	HL,DE		;HL ==> first allocated gran
	LD	A,(IY+1)	;get number of grans
	AND	1FH		;mask off bits 5 thru 7
	INC	A		;make relative to 1
	LD	B,A		;store count in B
	LD	A,(CHAR)	;get character for this gran
	INC	A		;add one for next time
	LD	(CHAR),A	;and save again
EXT2	LD	(HL),A		;mark this gran
	INC	HL		;point to next gran
	DJNZ	EXT2		;repeat for all grans
	RET
;
CHAR	DB	'A'-1		;display character
;----------
; display map of grans.
; mimic the 'FREE' map
;----------
DISPLAY:
	@@CLS
	CALL	INFOLINE	;show file info
	DASHLINE	'='	;line of dashes on screen
	LD	HL,GRANTBL	;HL ==> table of used grans
DISP1	CALL	ONELINE		;display one line of map
	JR	NZ,DISP1	;return if end of map
	CURSLOC			;get cursor location
	LD	A,L		;cursor column in A
	IFEQJR	0,DISP2		;jump if it's 0
	@@DSP	CR		;else move to next line
DISP2	DASHLINE	'='	;another line of dashes
	@@KEY			;wait for a key
	RET			;we're done
;----------
; display information about the file
;----------
INFOLINE:
	LD	DE,LINEBUF	;DE ==> line buffer
	LD	HL,FCB		;closed FCB has filename
INFO1	LD	A,(HL)		;get a byte
	IFEQJR	ETX,INFO2	;go if end of filespec
	LD	(DE),A		;else move a character
	INC	DE		;bump pointers
	INC	HL
	JR	INFO1		;and loop back
;
INFO2	LD	A,CR		;mark end with carriage return
	LD	(DE),A		;save it
	@@DSPLY	LINEBUF		;display the line
	RET
;----------
; display one line of gran map
; enter with HL ==> current location in GRANTBL
;----------
ONELINE:
	PUSH	HL		;save pointer
	CALL	MAKENUMS	;make line-number display
	LD	HL,CYL_NUMS	;HL ==> ASCII cylinder numbers
	LD	DE,LINEBUF	;DE ==> buffer for building line
	LD	BC,8		;numbers + space = 8 chars
	LDIR			;move it
	POP	HL		;recover GRANTBL pointer
	LD	B,8		;up to 8 cylinders per line
LINE1	CALL	MOVCYL		;move 1 cylinder and spaces to LINEBUF
	JR	Z,LINE2		;go if short line
	DJNZ	LINE1		;else loop back
; line is built, display it
LINE2	LD	A,ETX		;line is 80 characters long
	LD	(DE),A		;terminate the line
	PUSH	AF		;save the flags
	@@DSPLY	LINEBUF		;put it on screen
	POP	AF		;recover carry flag
	RET			;send flags back to caller
;----------
; move info for one granule to LINEBUF
; test for end of valid list & set ZF to show "done"
;----------
MOVCYL:
	PUSH	BC		;save counters
	LD	A,(GRANS)	;get grans per cylinder
	LD	C,A		;move to C for block move
	LD	B,0		;BC = grans per cylinder
	LDIR			;move the markers
	LD	A,9		;9 chars per cylinder
	LD	IX,GRANS	;IX ==> grans per cylinder
	SUB	(IX)		;A = number of spaces to add
	LD	B,A		;put in B for looping
	LD	A,' '		;space char for padding
MOV1	LD	(DE),A		;save this char
	INC	DE		;point to next space
	DJNZ	MOV1		;loop for all spaces
	LD	A,(MOVDCYLS)	;get count of number moved
	INC	A		;add one
	LD	(MOVDCYLS),A	;and save it
	LD	IX,MAXCYLS	;IX ==> maximum cylinders on disk
	CP	(IX)		;done?  set Z flag
	POP	BC		;clean stack
	RET			;send ZF back for testing
;
MOVDCYLS	DB	0
;----------
; make ASCII number heading for each display line
; form:  'nnn-nnn ' in CYL_NUMS
;----------
MAKENUMS:
	LD	A,(MOVDCYLS)	;get next cylinder number
	LD	DE,CYL_NUMS	;DE ==> destination buffer
	CALL	ONE_NUM		;convert & store value in A
	LD	A,'-'		;dash between numbers
	LD	(DE),A		;store it
	INC	DE		;bump pointer
	LD	A,(MOVDCYLS)	;get number again
	ADD	A,7		;last cylinder in line
	LD	IX,MAXCYL	;IX ==> maximum number of cylinders
	IFLTJR	(IX),MAKE2	;jump if not the end
	LD	A,(MAXCYL)	;else get top number
	DEC	A		;relative to 0
MAKE2	CALL	ONE_NUM		;convert & store value in A
	LD	A,' '		;space for end of string
	LD	(DE),A		;store it
	RET
;----------
; convert value in A to ASCII and store last three digits at (DE)
; then increment DE to next location
;----------
ONE_NUM:
	PUSH	DE		;save pointer
	LD	L,A		;move value to HL
	LD	H,0		;HL = value to convert
	@@HEXDEC	NUMBUF	;convert and store in NUMBUF
	LD	HL,NUMBUF+2	;point to last three chars
	POP	DE		;recover destination pointer
	LD	BC,3		;move three chars
	LDIR			;move them
	RET
;----------
; message area
;----------
BADFILE$	DB	'Missing or Illegal filename on command line.',CR
BADDCT$	DB	'Drive Code Table corrupted!',CR
;----------
; buffer areas
;----------
FCB	DS	32
FBUFFER	DS	256
LINEBUF	DS	81
NUMBUF	DS	5
GRANTBL	DS	256*8
CYL_NUMS	DB	'   -    '
;
	END	START
