;FKEY/ASM - 05/03/84
;*=*=*
;Program to set function key codes in TRSDOS 6.x
;	Use: FKEY (DEFAULT,F1=,S1=,...
;	Sn = shifted Fn. Formats: Fn="c"; Fn=ddd; Fn=x'hh'
;	Released to public domain by Roy Soltoff - 04/13/84
;*=*=*
F1	EQU	0
S1	EQU	1
F2	EQU	2
S2	EQU	3
F3	EQU	4
S3	EQU	5
	ORG	2600H
FKEY	PUSH	HL		;Save command pointer
	LD	HL,HELLO$
	LD	A,10		;@DSPLY
	RST	40
	POP	HL
	LD	DE,PRMTBL$	;Get parameter values
	LD	A,17		;@PARAM
	RST	40
	JP	NZ,PRMERR
	LD	DE,KIMOD$	;Locate *KI driver data area
	LD	A,83		;@GTMOD
	RST	40
	JP	NZ,KIERR
	LD	HL,32		;Index to function key table
	ADD	HL,DE
	PUSH	HL		;Save on stack
	LD	IX,PRMTBL$+4	;Test if user wants to
	LD	A,(IX+F1*6)	;  default to system values
	OR	(IX+S1*6)
	OR	(IX+F2*6)
	OR	(IX+S2*6)
	OR	(IX+F3*6)
	OR	(IX+S3*6)
	JR	NZ,CHGKEY
DPARM	LD	BC,0		;Init DEFAULT=OFF
	OR	B
	OR	C
	JR	Z,CHGKEY	;Go to p/u current key settings
MOVKEYS	LD	HL,DEFKEY	;Move new function key
	POP	DE		;  code table
	PUSH	DE		;Save pointer to table
MOV6	LD	BC,6
	LDIR
	POP	DE		;Recover table pointer
	LD	HL,KEYS$-1	;Index to start of buffer
	LD	B,3		;Loop for 3 keys
DSPLP	PUSH	BC
	LD	BC,6
	ADD	HL,BC		;Point to next field
	CALL	GETKEY		;Unpack unshifted
	CALL	GETKEY		;Unpack shifted
	POP	BC
	DJNZ	DSPLP
	LD	HL,KEYS$
	LD	A,10		;@DSPLY
	RST	40
EXIT	LD	HL,0
	RET
GETKEY	LD	A,(DE)		;P/u key code
	INC	DE
	LD	C,A
	LD	A,98		;@HEX8
	RST	40
	INC	HL
	RET
CHGKEY	LD	DE,DEFKEY
	POP	HL		;Point to KI's table
	PUSH	HL		;Save for update
	LD	B,6		;Init for six tests
	LD	DE,DEFKEY-1	;Point to start of table
KEYLP	CALL	PARSE
	DJNZ	KEYLP
	JR	MOVKEYS
PARSE	LD	A,(IX)		;P/u response code
	INC	IX
	LD	L,(IX)		;P/u vector
	INC	IX
	LD	H,(IX)
	INC	IX
	INC	IX
	INC	IX
	INC	IX
	INC	DE		;Bump pointer to table
	OR	A
	RET	Z
	BIT	7,A
	JR	NZ,PARSE2
	BIT	5,A
	RET	Z
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
PARSE2	LD	A,(HL)		;Get the new value
	LD	(DE),A		;Replace with new value
	RET
KIERR	LD	HL,KIERR$
	DB	0DDH
PRMERR	LD	HL,PRMERR$
	LD	A,12		;@LOGOT
	RST	40
	LD	HL,-1		;Init for error
	RET
PRMTBL$	DB	80H
	DB	0A2H,'F1',0
	DW	F1*2+PARMS
	DB	0A2H,'S1',0
	DW	S1*2+PARMS
	DB	0A2H,'F2',0
	DW	F2*2+PARMS
	DB	0A2H,'S2',0
	DW	S2*2+PARMS
	DB	0A2H,'F3',0
	DW	F3*2+PARMS
	DB	0A2H,'S3',0
	DW	S3*2+PARMS
	DB	57H,'DEFAULT',0
	DW	DPARM+1
	NOP
DEFKEY	DB	81H,91H,82H,92H,83H,93H
PARMS	DW	0,0,0,0,0,0
HELLO$	DB	10,'FKEY - Change or reset Model 4 function keys'
	DB	10,'Public Domain - Written by Roy Soltoff'
	DB	', All rights reserved.',10,13
KIMOD$	DB	'$KI',3
PRMERR$	DB	'Parameter error!',13
KIERR$	DB	'Can''t locate *KI driver',13
KEYS$	DB	'F1 = xx,yy; F2 = xx,yy; F3 = xx,yy',13
	END	FKEY
