; MINIOPHD/ASM -- This is an Extended Command Interpreter for
; TRSDOS 6.02.x (will not work properly on earlier versions of TRSDOS).
; It serves as a "mini-operating" system and is especially useful
; when used with a hard disk drive.  This program was written
; and assembled using the MISOSYS PRO-CREATE (EDAS) editor/assembler.
;
;
; Once compiled and executed, this program will allow you to
; list a directory of drives 0, 1, 2, 3, 4 or 5 by pressing
; F1, F2, F3, Shifted F1, Shifted F2, or Shifted F3, respectively.
; Pressing <Q> will allow you to enter a DOS command (such as LIST,
; COPY, REMOVE, etc.), or it will let you execute a program, and will
; return to MINIOP on exiting that program (in most cases).
;
; After you have compiled this program, copy it to SYS13/SYS as follows:
;
;               COPY MINIOPHD/CMD SYS13/SYS.LSIDOS (C=N)
;
; You can then execute the file by typing <*><ENTER> from TRSDOS Ready.
;
; Copyright (c) 1984 by Ken Christian
;
; Define Supervisor Calls
;
@FLAGS  EQU     101     ; Point IY to the system flag table
@DSPLY  EQU     10      ; Display a message line
@KEY    EQU     1       ; Scan *KI and wait for a character
@DODIR  EQU     34      ; Do a directory
@VDCTL  EQU     15      ; Position/locate cursor
@KEYIN  EQU     9       ; Accept a line of input
@CMNDR  EQU     25      ; Execute a command and return to caller
@CLS    EQU     105     ; Clear video screen
@DSP    EQU     2       ; Display character at cursor
@SOUND  EQU     104     ; Generate a sound (tone and duration)
@EXIT   EQU     22      ; Exit program and return to TRSDOS
;
        ORG     3000H
;
START   LD      A,@FLAGS        ; Get starting address of the flag
        RST     28H
        LD      A,(IY+4)        ; Read the EFLAG$ svc
        OR      A               ; Is it set to zero?
        JR      NZ,GO           ; Skip opening display
        LD      A,8             ; Get a non-zero value
        LD      (IY+4),A        ; Set the EFLAG$ to non-zero
BEGIN   CALL    VDCLS           ; Clear screen
        LD      HL,LOGO         ; Point to logo message
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc;
        LD      HL,BLANK        ; Blank line
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
INTRO   LD      HL,MSG0         ; Point to Message 0
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
        LD      HL,MSG1         ; Point to Message 1
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
        CALL    BEEP            ; Sound a beep
;
GETKEY  LD      A,@KEY          ; Get character from keyboard
        RST     28H             ; Call @KEY svc
        CP      80H             ; Is it the <BREAK> key ?
        JP      Z,EXIT          ; If yes, then exit to TRSDOS
        CP      129             ; Is it the <F1> key ?
        JP      Z,DIR0          ; If yes, do Drive 0 directory
        CP      130             ; Is it the <F2> key ?
        JP      Z,DIR1          ; If yes, do Drive 1 directory
        CP      131             ; Is it the <F3) key ?
        JP      Z,DIR2          ; If yes, do Drive 2 directory
        CP      145             ; Is it <SHIFT><F1>?
        JP      Z,DIR3          ; Yes, do Drive 3 directory
        CP      146             ; Is it <SHIFT><F2>?
        JP      Z,DIR4          ; Yes, do Drive 4 directory
        CP      147             ; Is it <SHIFT><F3>?
        JP      Z,DIR5          ; Yes, do Drive 5 directory
        CP      'Q'             ; Is it the <Q> key ?
        JP      Z,QUERY         ; If yes, jump to QUERY routine
        CP      'q'             ; Is it the <q> key ?
        JP      Z,QUERY         ; If yes, jump to QUERY routine
        JR      GETKEY          ; Loop if none of above keys
;
GO      CALL    TOP             ; Get top display
        CALL    BOTCLR          ; Clear bottom of screen
        LD      HL,MSG3         ; Point to MSG2
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
        LD      A,(IY+4)        ; Get the EFLAG$
        AND     7               ; Delete all but the drive number field
        LD      C,A             ; Store the drive number for the svc
        LD      A,@DODIR        ; Do a directory display
        LD      B,2             ; of all visible, non-system files
        LD      HL,CMDTXT       ; with /CMD extent
        RST     28H             ; Call the @DODIR svc
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
        JP      SELECT          ; Go to SELECT
;
DIR0    CALL    TOP             ; Top display, scroll protect
;
        CALL    BOTCLR          ; Clear bottom of screen
        LD      HL,DR0MSG       ; Point to Drive 0 message
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it
        RST     28H
;
        LD      A,0             ; Put drive number in A
        LD      (IY+4),A        ; Store drive number for future use
;
        LD      B,2             ; All visible files
        LD      C,0             ; Drive 0
        LD      HL,CMDTXT       ; /CMD extension
        LD      A,@DODIR        ; Do Directory
        RST     28H
;
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it (skip a line)
        RST     28H             ; Call @DSP svc
;
        JP      SELECT          ; Go to SELECT
;
DIR1    CALL    TOP             ; Top display, scroll protect
;
        CALL    BOTCLR          ; Clear bottom of screen
        LD      HL,DR1MSG       ; Point to Drive 1 message
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it
        RST     28H
;
        LD      A,1             ; Place drive number in A
        LD      (IY+4),A        ; Save drive number for future use
;
        LD      B,2             ; All visible files
        LD      C,1             ; Drive 1
        LD      HL,CMDTXT       ; /CMD extension
        LD      A,@DODIR        ; Do directory
        RST     28H
;
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it (skip a line)
        RST     28H             ; Call @DSP svc
;
        JP      SELECT          ; Jump to SELECT
;
DIR2    CALL    TOP             ; Top display, scroll protect
;
        CALL    BOTCLR          ; Clear bottom of screen
        LD      HL,DR2MSG       ; Point to Drive 2 message
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it
        RST 28H
;
        LD      A,2             ; Place drive number in A
        LD      (IY+4),A        ; Save drive number for future use
;
        LD      B,2             ; All visible drives
        LD      C,2             ; Drive 2
        LD      HL,CMDTXT       ; /CMD extension
        LD      A,@DODIR        ; Do directory
        RST     28H
;
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it (skip a line)
        RST     28H             ; Call @DSP svc
;
        JP      SELECT          ; Goto SELECT
;
DIR3    CALL    TOP             ; Top display, scroll protect
;
        CALL    BOTCLR          ; Clear bottom of screen
        LD      HL,DR3MSG       ; Point to Drive 3 message
        LD      A,@DSPLY        ; Display it
        RST     28H
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it
        RST     28H
        LD      A,3             ; Place drive number in A
        LD      (IY+4),A        ; Save drive number for future use
;
;
        LD      B,2             ; All visible files
        LD      C,3             ; Drive 3
        LD      HL,CMDTXT       ; /CMD extension
        LD      A,@DODIR        ; Do directory
        RST     28H
;
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it (skip a line)
        RST     28H
;
        JP      SELECT          ; Goto SELECT
;
DIR4    CALL    TOP             ; Top display, scroll protect
;
        CALL    BOTCLR          ; Clear bottom of screen
        LD      HL,DR4MSG       ; Point to Drive 4 message
        LD      A,@DSPLY        ; Display it
        RST     28H
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it
        RST     28H
;
        LD      A,4             ; Place drive number in A
        LD      (IY+4),A        ; Save drive number for future use
;
        LD      B,2             ; All visible files
        LD      C,4             ; Drive 4
        LD      HL,CMDTXT       ; /CMD extension
        LD      A,@DODIR        ; Do directory
        RST     28H
;
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it (skip a line)
        RST     28H
;
        JP      SELECT          ; Goto SELECT
;
DIR5    CALL    TOP             ; Top display, scroll protect
;
        CALL    BOTCLR          ; Clear bottom of screen
        LD      HL,DR5MSG       ; Point to Drive 5 message
        LD      A,@DSPLY        ; Display it
        RST     28H
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it
        RST     28H
;
        LD      A,5             ; Place drive number in A
        LD      (IY+4),A        ; Save drive number for future use
;
        LD      B,2             ; All visible files
        LD      C,5             ; Drive 5
        LD      HL,CMDTXT       ; /CMD extension
        LD      A,@DODIR        ; Do directory
        RST     28H
;
        LD      HL,BLANKLN      ; Point to blank line
        LD      A,@DSPLY        ; Display it (skip a line)
        RST     28H
;
        JP      SELECT          ; Go to SELECT routine
;
QUERY   LD      B,4             ; Get current cursor position
        LD      A,@VDCTL        ; from video control svc
        RST     28H             ; Call @VDCTL svc
;
        DEC     HL              ; Decrease HL by 13
        DEC     HL              ; to move the cursor
        DEC     HL              ; 13 places to the left
        DEC     HL
        DEC     HL
        DEC     HL
        DEC     HL
        DEC     HL
        DEC     HL
        DEC     HL
        DEC     HL
        DEC     HL
        DEC     HL
;
        LD      B,3             ; Move cursor to new location
        LD      A,@VDCTL        ; using video control svc
        RST     28H             ; Call @VDCTL svc
;
        LD      HL,MSG2         ; Point to Message 2
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
        LD      A,@KEYIN        ; Get DOS command
        LD      HL,CMDBUF       ; Put it here
        LD      B,64            ; Maximum number of characters in cmd
        LD      C,0             ; The svc requires a zero here
        RST     28H             ; Call @KEYIN svc
;
        CP      80H             ; Is it the <BREAK> key ?
        JP      Z,BEGIN         ; Go to opening logo
;
        CALL    DESCRL          ; De-scroll protect the screen
        CALL    VDCLS           ; Clear the screen
        LD      HL,CMDMSG       ; Point to the COMMAND: message
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call the @DSPLY svc
;
        LD      HL,CMDBUF       ; Point to command user entered
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
        LD      HL,CMDBUF       ; Point to command user entered
        LD      A,@CMNDR        ; Execute command and return, if possible
        RST     28H             ; Call @CMNDR svc
;
        LD      HL,BLANK        ; Point to a blank line
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
        LD      HL,CNTMSG       ; Get CONTINUE: message
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
        CALL    BEEP            ; Sound a beep
;
GET2    LD      A,@KEY          ; Get character from keyboard
        RST     28H             ; Call @KEY svc
;
        CP      0DH             ; Is it the <ENTER> key ?
        JP      NZ,GET2         ; If not, then loop
;
        CALL    TOP             ; Put top message, scroll protect it
        CALL    BOTCLR          ; Clear bottom of screen
        JP      SELECT          ; Go to SELECT
;
SELECT  LD      HL,GETMSG       ; Point to GETMSG
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
        CALL    BEEP            ; Sound a beep
;
        JP      GETKEY          ; Jump to GETIT routine
;
; Subroutines for MINIOP
;
; Clear screen routine
;
VDCLS   LD      A,@CLS          ; Get @CLS svc
        RST     28H             ; Execute it
        RET                     ; Return
;
; Setup top portion of screen and scroll protect it
;
TOP     CALL    VDCLS           ; Clear screen
        LD      HL,TOPDSP       ; Point to top display
        LD      A,@DSPLY        ; Display it
        RST     28H             ; Call @DSPLY svc
;
        LD      B,7             ; Prepare to scroll protect
        LD      C,5             ; the top 5 lines of the screen
        LD      A,@VDCTL        ; using the @VDCTL svc
        RST     28H             ; Call it
        RET                     ; Return
;
; Remove scroll protection from screen
;
DESCRL  LD      B,7             ; Prepare to scroll protect screen
        LD      C,0             ; Scroll protect ZERO lines
        LD      A,@VDCTL        ; using @VDCTL svc
        RST     28H             ; Call it
        RET                     ; return
;
; Clear the bottom portion of the screen
;
BOTCLR  LD      B,3             ; Move cursor to specified position
        LD      H,5             ; In this case, row 5
        LD      L,0             ; and column 0 (leftmost column)
        LD      A,@VDCTL        ; using the @VDCTL svc
        RST     28H             ; Call the svc
        LD      C,1FH           ; Erase to end of display
        LD      A,@DSP          ; using the @DSP svc
        RST     28H             ; Call the svc
        RET                     ; Return
;
; Sound a beep through the Model 4's built-in speaker
;
BEEP    PUSH    AF              ; Save AF register
        LD      B,0             ; Set tone and duration
        LD      A,@SOUND        ; Make the sound
        RST     28H             ; Call @SOUND svc
        POP     AF              ; Restore AF register
        RET                     ; Return to caller
;
; Remove scroll protection and exit to TRSDOS
;
EXIT    CALL    DESCRL          ; Remove scroll protection
        CALL    VDCLS           ; Clear the screen
        XOR     A               ; Get a zero
        LD      (IY+4),A        ; Set EFLAG$ to zero
        LD      A,@EXIT         ; Exit to TRSDOS
        RST     28H             ; Call @EXIT svc
;
; Buffer allocations
;
CMDBUF  DEFS    64              ; 64 characters maximum input
;
; Text prompts
;
DR0MSG  DEFM    'Drive 0 directory:',0DH
DR1MSG  DEFM    'Drive 1 directory:',0DH
DR2MSG  DEFM    'Drive 2 directory:',0DH
DR3MSG  DEFM    'Drive 3 directory:',0DH
DR4MSG  DEFM    'Drive 4 directory:',0DH
DR5MSG  DEFM    'Drive 5 directory:',0DH
CMDMSG  DEFM    'Executing DOS command: ',03H
GETMSG  DEFM    ' Selection : ',03H
CNTMSG  DEFM    'Press <ENTER> to continue: ',03H
MSG0    DEFM    '                  MINI-OPerating System HD Version 04.00.00',0AH
        DEFM    '                  A Directory Utility for TRSDOS 6.2.x',0AH
        DEFM    '                  Copyright (c) 1984 by Ken Christian',0AH,0AH
        DEFM    '                      KEY      FUNCTION',0AH
        DEFM    '                  ===========  ===========================',0DH
MSG1    DEFM    '                        <F1> : Directory for Drive 0',0AH
        DEFM    '                        <F2> : Directory for Drive 1',0AH
        DEFM    '                        <F3> : Directory for Drive 2',0AH
        DEFM    '                 <SHIFT><F1> : Directory for Drive 3',0AH
        DEFM    '                 <SHIFT><F2> : Directory for Drive 4',0AH
        DEFM    '                 <SHIFT><F3> : Directory for Drive 5',0AH
        DEFM    '                         <Q> : Execute DOS command',0AH
        DEFM    '                       BREAK : Exit to TRSDOS',0AH,0AH
        DEFM    '                      Select : ',03H
MSG2    DEFM    '   Command : ',03H
MSG3    DEFM    'Directory: ',0AH,0DH
BLANK   DEFM    ' ',0DH
CMDTXT  DEFM    'CMD'
BLANKLN DEFM    '                           ',0DH
;
;This file created with ZGRAPH
;
LOGO    DB      151,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,171
        DB      149,128,128,128,128,128,128,128,128,128,32,32,32,32,32,32
        DB      32,32,32,32,32,191,140,176,140,191,32,32,32,131,191,131
        DB      32,32,32,191,173,144,32,191,32,32,32,131,191,131,32,32
        DB      32,188,131,131,131,188,32,32,191,131,131,131,188,32,32,32
        DB      32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,170
        DB      149,128,128,128,128,128,128,128,128,128,32,32,32,32,32,32
        DB      32,32,32,32,32,191,32,32,32,191,32,32,32,32,191,32
        DB      32,32,32,191,32,139,180,191,32,32,32,32,191,32,32,32
        DB      32,191,32,32,32,191,32,32,191,131,131,131,32,32,32,32
        DB      32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,170
        DB      149,128,128,128,128,128,128,128,128,128,32,32,32,32,32,32
        DB      32,32,32,32,32,131,32,32,32,131,32,32,32,131,131,131
        DB      32,32,32,131,32,32,130,131,32,32,32,131,131,131,32,32
        DB      32,32,131,131,131,32,32,32,131,32,32,32,32,32,32,32
        DB      32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,170
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      03H
;
;This file created with ZGRAPH
;
TOPDSP  DB      151,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131
        DB      131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,171
        DB      149,128,128,70,49,32,58,32,68,73,82,32,49,32,47,32
        DB      70,50,32,58,32,68,73,82,32,50,32,47,32,70,51,32
        DB      58,32,68,73,82,32,51,32,47,32,83,72,70,84,32,70
        DB      49,32,58,32,68,73,82,32,52,32,47,32,83,72,70,84
        DB      32,70,50,32,58,32,68,73,82,32,53,32,32,32,32,170
        DB      149,128,128,128,128,128,83,72,70,84,32,70,51,32,58,32
        DB      68,73,82,32,54,32,47,32,81,32,61,62,32,69,110,116
        DB      101,114,32,68,79,83,32,67,111,109,109,97,110,100,32,47
        DB      32,60,66,82,69,65,75,62,32,61,62,32,69,120,105,116
        DB      32,116,111,32,68,79,83,128,32,128,128,128,128,128,128,170
        DB      141,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140
        DB      140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140
        DB      140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140
        DB      140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140
        DB      140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,142
        DB      03H
;
        END     START
