;		savekey/asm
;
DOSAVEKEY	EQU	$
		LD	HL,SAVESPEC
		CALL	GETKEYFILE	;Get the key file
;
		LD	HL,SAVEMSG	;Get the string
		SVC	@DSPLY		;Print it
		LD	HL,NAMEREST	;Print rest of message
		SVC	@DSPLY
		LD	DE,(LOADFCB)
		PUSH	DE
		LD	HL,SAVESPEC
		LD	BC,32
		LDIR
		POP	DE
		LD	HL,(FBUFF)
		LD	B,0
		SVC	@INIT		;Create the output file
		JP	NZ,ERROR	;Jump if we can't
;
		LD	HL,0		;Reset the pointer to start over
		LD	DE,DEFBUFF	;DE must point at something
		CALL	GETMAP		;Get a mapping
		LD	B,1		;Ignore key 0 and start at key 1
SAVE_1		EQU	$
		PUSH	BC
		LD	HL,1		;Get something non-zero
		LD	DE,DEFBUFF	;Get the destination buffer
		CALL	GETMAP		;Get the map
		POP	BC		;Restore the definition number
		PUSH	BC		;Save it back
		LD	IX,DEFBUFF	;Get the definition
		LD	A,(IX)
		OR	A		;Test for no definition
		JR	Z,NODEFINIT
		LD	C,B		;Get the key number
		LD	HL,HEXBUF	;Get the buffer
		SVC	@HEX8
		CALL	OUTLEAD		;Output leading string
		LD	C,'.'
		SVC	@DSP		;Print a dot
		LD	HL,DEFBUFF	;Get the source buffer
SAVE_2		EQU	$
		PUSH	HL
		LD	A,(HL)		;Get a character
		OR	A
		JP	Z,SAVE_11		;Jump if at the end
		CP	' '		;See if control
		JR	NC,NOCTL	;Jump if not control
		LD	C,A
		LD	A,'^'
		CALL	OUTPUT
		LD	A,C
		ADD	A,'@'		;Make it printable
		CALL	OUTPUT
		JR	SAVE_10
;
NOCTL		EQU	$
		CP	'^'
		JR	NZ,NOCARRAT	;Jump if not special case
		CALL	OUTPUT
		CALL	OUTPUT
		JR	SAVE_10
;
NOCARRAT	EQU	$
		CP	'\'		;Is it the backslash
		JR	NZ,NOBACK
		CALL	OUTPUT
		CALL	OUTPUT
		JR	SAVE_10
;
NOBACK		EQU	$
		BIT	7,A
		JR	NZ,DO8BIT
		CALL	OUTPUT
		JR	SAVE_10
;
DO8BIT		EQU	$
		LD	C,A
		LD	A,'\'
		CALL	OUTPUT
		LD	HL,TBUF
		SVC	@HEX8
		LD	A,(TBUF)
		CALL	OUTPUT
		LD	A,(TBUF+1)
		CALL	OUTPUT
SAVE_10		EQU	$
		POP	HL
		INC	HL
		JP	SAVE_2
;
SAVE_11		EQU	$
		POP	HL
		LD	A,13
		CALL	OUTPUT
SAVE_12		EQU	$
		POP	BC
		INC	B
		JP	SAVE_1
;
NODEFINIT	EQU	$
		LD	A,(IX+1)	;check for eof
		OR	A
		JR	NZ,SAVE_12		;Continue if not end
;
		LD	DE,(LOADFCB)
		SVC	@CLOSE		;Close the output file
		POP	BC
		LD	C,CR		;Get a new line
		SVC	@DSP
		JP	ENTRY
;
;	Output a byte to the file
;
OUTPUT		EQU	$
		PUSH	AF
		PUSH	DE
		PUSH	HL
		PUSH	BC
		LD	DE,(LOADFCB)
		LD	C,A
		SVC	@PUT
		POP	BC
		POP	HL
		POP	DE
		JP	NZ,ERROR
		POP	AF
		RET
;
;
;
OUTLEAD		EQU	$
		PUSH	HL
		LD	HL,HEXBUF	;Get the message
OUT_1		EQU	$
		LD	A,(HL)		;Get a character
		IFZ	OUT_2		;End? jump if so
		CALL	OUTPUT		;Output the character
		INC	HL		;Point to next
		JR	OUT_1		;Loop
OUT_2		EQU	$
		POP	HL		;Restore stack
		RET			;Return to caller
;
;	Data definition area
;
;
HEXBUF		DW	0		;This data must preceed that
		DB	'<=>',0		;which is on this line
TBUF		DS	3
SAVEMSG		DB	'Writing definitions to '
SAVESPEC	DB	'KEYDEFS/ECI',3
		DS	32
