;		memmap/asm
;
;	This is a handy little program that allows you to manipulate
;	sysresd modules, and otherwise munge high memory.  Look at the
;	@PARAM block for the possibilities.
;
LOADOFF		EQU	13		;Offset to SYSRES info in module
MAXMOD		EQU	14		;One more than maximum SYSxx mod
RESOFF		EQU	15		;Offset to sysres table in SYSRES
;
*GET		EQUATE4/EQU
;
		ORG	3000H
START		EQU	$
		LD	DE,PARAMS	;Get the parameter table
		SVC	@PARAM		;Parse the command line
		JP	NZ,BADPARAM	;Jump if bad parse
;
;	Check if making a SYSRES module invisible
;
CHK_UNRES	EQU	$
		LD	A,(UNRES_RESP)	;Get the response byte
		OR	A		;Check for any response
		JP	Z,CHK_RERES	;Jump if none
		AND	60H		;Check for bad parameter
		JP	NZ,BADPARAM	;Jump if not strictly numeric
		LD	HL,(UNRESFLG)	;Get the selected module number
		LD	A,H		;Check for out of range
		OR	A		;If H <> 0 then error
		JP	NZ,BADPARAM
		LD	A,L		;Check here too
		CP	MAXMOD		;Check for beyond known modules
		JP	NC,BADPARAM	;Jump if out of range
		LD	C,A		;Get the module number
		LD	B,0		;Make BC an index
		LD	HL,HEX		;Index into characters
		ADD	HL,BC		;Get the real address
		LD	C,(HL)		;Get the letter of module number
		SLA	A		;A << 1 to get word offset
		LD	(MODNO),A	;Save the module offset
		LD	A,C		;Get the character into A
		LD	(STRVAL),A	;Save the module name number
		LD	DE,SYSMOD
		SVC	@GTMOD		;Get the SYSRES module
		JP	NZ,NOSYSMOD	;Jump if module not there
		LD	BC,0
MODNO		EQU	$-2
		ADD	HL,BC		;Index into module
		LD	BC,RESOFF	;Get the normal offset
		ADD	HL,BC
		LD	E,(HL)
		INC	HL
		LD	D,(HL)
		LD	A,D		;Check for resident
		OR	A		;Check for no MSB
		JP	Z,MODNOTRES	;Jump if it is not there
		XOR	A
		LD	(HL),A
		DEC	HL
		LD	(HL),A
		LD	HL,MODREMOVED
		SVC	@DSPLY
;
;	Check to see if restoring visibility of of SYSRES module
;
CHK_RERES	EQU	$
		LD	A,(RERES_RESP)	;Get the response byte
		OR	A		;Check for any response
		JP	Z,CHK_RENAME	;Jump if none
		AND	60H		;Check for bad parameter
		JP	NZ,BADPARAM	;Jump if not strictly numeric
		LD	HL,(RERESFLG)	;Get the selected module number
		LD	A,H		;Check for out of range
		OR	A		;If H <> 0 then error
		JP	NZ,BADPARAM
		LD	A,L		;Check here too
		CP	MAXMOD		;Check for beyond known modules
		JP	NC,BADPARAM	;Jump if out of range
		LD	C,A		;Get the module number
		LD	B,0		;Make BC an index
		LD	HL,HEX		;Index into characters
		ADD	HL,BC		;Get the real address
		LD	C,(HL)		;Get the letter of module number
		SLA	A		;A << 1 to get word offset
		LD	(MODNO2),A	;Save the module offset
		LD	A,C		;Get the character into A
		LD	(STRVAL),A	;Save the module name number
		LD	DE,SYSMOD
		SVC	@GTMOD		;Get the SYSRES module
		JP	NZ,NOSYSMOD	;Jump if module not there
		LD	BC,0
MODNO2	EQU	$-2
		ADD	HL,BC		;Index into module
		LD	BC,RESOFF	;Get the normal offset
		ADD	HL,BC
		LD	E,(HL)		;Get the address there
		INC	HL
		LD	D,(HL)
		LD	A,D		;Check for resident
		OR	A
		JP	NZ,MODISRES	;Jump if it is already there
		PUSH	HL
		LD	DE,RESMOD	;See if module there
		SVC	@GTMOD
		JP	NZ,NOSUCHMOD	;Jump if not there
		LD	BC,LOADOFF
		ADD	HL,BC
		POP	DE
		EX	DE,HL
		LD	(HL),D
		DEC	HL
		LD	(HL),E
		LD	HL,MODRESTORED
		SVC	@DSPLY
;
;	Check if changing the name of a module
;
CHK_RENAME	EQU	$
		LD	A,(RENAME_RESP)	;Was RENAME given?
		OR	A
		JP	Z,CHK_NAME	;Jump if RENAME not given
		LD	C,A		;Save the length
		AND	0C0H		;Check to make sure it is string
		JP	NZ,BADPARAM	;Jump if not STRING argument
		LD	A,C		;Get the value back
		AND	1FH		;Save the length
		LD	C,A		;Put it back in C
		LD	A,(NAME_RESP)	;Was NAME also specified?
		OR	A
		JP	Z,NEEDNAME	;Jump if no NAME given
		LD	B,A		;Save the response value
		AND	0C0H		;Check for string only
		JP	NZ,BADPARAM	;Jump if not string
		LD	A,B		;Get the response value
		AND	1FH		;Trim to just length
		CP	C		;Make sure same length
		JP	NZ,NEEDLEN	;Jump if length not same
		LD	(NAMELEN),A	;Save the length
		LD	(NAMELEN2),A
		LD	HL,(RENAMEADDR)	;Get the module name
		LD	DE,MODNAME	;Get the vector addr
		PUSH	DE		;Save for later
		LD	BC,0		;Get the length
NAMELEN		EQU	$-2
		LDIR			;Move it
		EX	DE,HL		;Swap pointers
		LD	(HL),3		;Put in ETX for end
		POP	DE		;Restore name buffer start
		SVC	@GTMOD		;See if module there
		JP	NZ,NOSUCHMOD	;Jump if not there
		LD	BC,5
		ADD	HL,BC		;Move up to name address
		EX	DE,HL
		LD	HL,(NAMEADDR)	;Get the new name address
		LD	BC,0		;Get the length
NAMELEN2	EQU	$-2
		LDIR			;Move in new name
		LD	HL,RENAMED
		SVC	@DSPLY
		JP	CHK_MAP
;
CHK_NAME	EQU	$
		LD	A,(NAME_RESP)	;Check if name, but not rename
		OR	A		;Set the flags
		JP	NZ,NORENAME	;Jump if no rename
;
;	Check if removing a module from memory
;
CHK_REMOVE	EQU	$
		LD	A,(REMOVE_RESP)	;Get the response
		OR	A
		JP	Z,CHK_MAP	;Jump if no parameter
		LD	C,A
		AND	0C0H		;Check for non-string
		JP	NZ,BADPARAM	;Jump if not string
		LD	A,C		;Get response back
		AND	01FH		;Save length
		LD	HL,(REMADDR)	;Get the string address
		LD	DE,MODNAME	;Get destination buffer
		PUSH	DE		;Save the address for later
		LD	B,0		;Make BC length
		LD	C,A		;Move the length into C
		LDIR			;Move the name into the buffer
		EX	DE,HL		;Swap pointers
		LD	(HL),3		;Terminate the string
		POP	DE		;Get the start back
		SVC	@GTMOD		;Get the module address
		JP	NZ,NOSUCHMOD	;Jump if module not there
		PUSH	HL		;Save the address of module
		LD	B,0		;Select HIGH$
		LD	HL,0		;Select GET HIGH$
		SVC	@HIGH$		;Get the current HIGH$
		POP	BC		;Restore the pointer to delete at
		PUSH	BC		;Save it back
		DEC	BC		;Adjust back one byte
		OR	A		;Reset carry
		SBC	HL,BC		;See if same value
		POP	HL
		JP	NZ,NOTSAME
		INC	HL
		INC	HL
		LD	A,(HL)
		INC	HL
		LD	H,(HL)
		LD	L,A
		LD	B,0
		SVC	@HIGH$
		LD	HL,HIGHSET
		SVC	@DSPLY
		JP	END_REMOVE
;
NOTSAME		EQU	$
		LD	HL,HIGHNOTSAME
		SVC	@DSPLY
;
END_REMOVE	EQU	$
;
;	Check if map parameter present
;
CHK_MAP		LD	A,(MAP_RESP)	;Was memory map selected
		OR	A		;Test the flag
		JP	Z,OUT		;If not then test next parameter
		AND	0A0H		;Check if other than flag
		JP	NZ,BADPARAM	;Jump if bad parameter
		LD	HL,(MAPFLG)	;Check the value
		LD	A,H
		OR	L
		JP	Z,OUT
		LD	HL,LOWMES
		SVC	@DSPLY		;Print the low memory message
		LD	HL,08F0H	;Get the start 
SOME_HERE	EQU	$
		LD	D,H		;DE needs value for @HEX16
		LD	E,L
		PUSH	HL		;Save the address
		LD	HL,ADDRBUF	;Get the buffer
		SVC	@HEX16		;Make it printable
		POP	HL		;Restore the address
		INC	HL		;Point past JR vector
		INC	HL
;
		LD	E,(HL)		;Get next value
		INC	HL
		LD	D,(HL)
		LD	(NEXT),DE	;Save the next address
		INC	HL		;Point to length byte
		LD	B,(HL)
		INC	HL		;Point to string
		PUSH	HL
		LD	HL,LEADER
		SVC	@DSPLY
		POP	HL
PRINT_IT	LD	C,(HL)
		PUSH	BC
		PUSH	HL
		PUSH	DE
		SVC	@DSP
		POP	DE
		POP	HL
		POP	BC
		INC	HL
		DJNZ	PRINT_IT
		LD	HL,EQUDATA
		SVC	@DSPLY
		LD	HL,0000
NEXT		EQU	$-2
		INC	HL
		LD	A,H
		OR	L
		JP	Z,OUT
		LD	DE,(0206H)	;Get end of low memory
		EX	DE,HL
		OR	A
		SBC	HL,DE
		EX	DE,HL
		JP	NZ,SOME_HERE
DO_HIGH:
		LD	HL,HIGHMES	;Print start of high memory mess
		SVC	@DSPLY
		LD	HL,0		;Get HIGH$
		LD	B,H		;Select option 0
		SVC	@HIGH$		;Get the first available
		INC	HL		;Point to first used byte
		LD	A,H		;Check if at end
		OR	L
		JP	NZ,SOME_HERE	;Go if memory there
		LD	HL,NOMEM	;Print message
		SVC	@DSPLY
;
OUT		EQU	$
		LD	HL,0
		RET
;
NEEDLEN		EQU	$
		LD	HL,SAMELEN
		DB	0DDH
;
NORENAME	EQU	$
		LD	HL,RENAMETOO
		DB	0DDH
;
NEEDNAME	EQU	$
		LD	HL,NAMETOO
		DB	0DDH
;
MODISRES	EQU	$
		LD	HL,MODTHERE
		DB	0DDH		;Make LD HL,xxx into LD IX
;
NOSUCHMOD	EQU	$
		LD	HL,NOMODTHERE
		DB	0DDH
;
NOSYSMOD	EQU	$
		LD	HL,NOSYS
		DB	0DDH
;
MODNOTRES	EQU	$
		LD	HL,NOMOD
		DB	0DDH
;
BAD_HEAD	EQU	$
		LD	HL,BAD_MEM_HEAD
		DB	0DDH
;
BADPARAM	EQU	$
		LD	HL,BADPARM
;
		SVC	@DSPLY
		JP	OUT
;
HIGHSET		DB	'Memory module deleted, new HIGH$ set',13
BAD_MEM_HEAD	DB	'ERROR:  Bad memory header encountered',13
HIGHNOTSAME	DB	'HIGH$ not same as requested module',13
SAMELEN		DB	'New name must be same length as old!',13
RENAMED		DB	'Memory module renamed',13
RENAMETOO	DB	'NAME requires RENAME be specified',13
NAMETOO		DB	'RENAME requires NAME be specified',13
MODREMOVED	DB	'SYSRES module removed',13
MODTHERE	DB	'Specified module is already resident',13
NOMODTHERE	DB	'Specified module is not present',13
MODRESTORED	DB	'Module restored as resident',13
NOSYS		DB	'The SYSRES module is not resident',13
NOMOD		DB	'Specified module is not resident',13
HIGHMES		DB	'High memory modules',13
LOWMES		DB	'Low memory modules',13
BADPARM		DB	'Invalid parameter format',13
NOMEM		DB	'No memory modules are resident',13
HEX		DB	'0123456789ABCDEF'
MODNAME		DS	32
RESMOD		DB	'SYS'
STRVAL		DB	'X',3
SYSMOD		DB	'SYSRES',3
LEADER		DB	'    ',3
EQUDATA		DB	' = X',39
ADDRBUF		DS	4
		DB	39,13
;
PARAMS		DB	080H
;
		DB	53H		;MAP=YES/NO
		DB	'MAP'
MAP_RESP	DB	40H
		DW	MAPFLG
;
		DB	95H		;UNRES=nn where nn is SYSnn/SYS
		DB	'UNRES'
UNRES_RESP	DB	0
		DW	UNRESFLG
;
		DB	95H		;RERES=nn where nn is SYSnn/SYS
		DB	'RERES'
RERES_RESP	DB	0
		DW	RERESFLG
;
		DB	26H		;RENAME='MODNAME' to rename mod
		DB	'RENAME'
RENAME_RESP	DB	0
		DW	RENAMEADDR
;
		DB	24H		;NAME='NEWNAME' is the new name
		DB	'NAME'
NAME_RESP	DB	0
		DW	NAMEADDR
;
		DB	26H
		DB	'REMOVE'	;REMOVE='NAME' to remove NAME
REMOVE_RESP	DB	0
		DW	REMADDR
;
;
		DB	0
;
;	Param values are stuck into these memory locations
;
MAPFLG		DW	-1		;Was MAP specified
UNRESFLG	DW	0		;UNRES value
RERESFLG	DW	0		;RERES value
RENAMEADDR	DW	0		;RENAME string pointer
NAMEADDR	DW	0		;NEW NAME string pointer
REMADDR		DW	0
		END	START
