;		loadkey/asm
;
DOLOADKEY	EQU	$
		LD	HL,LOADSPEC
		CALL	GETKEYFILE	;Get the file parameter
		LD	HL,LOADMSG	;Get the string
		SVC	@DSPLY		;Print it
		LD	HL,NAMEREST	;Print rest of message
		SVC	@DSPLY
		LD	DE,(LOADFCB)
		PUSH	DE
		LD	HL,LOADSPEC
		LD	BC,32
		LDIR
		POP	DE
		LD	HL,(FBUFF)
		LD	B,0
		SVC	@OPEN		;Open a file for read
		JP	NZ,ERROR	;Jump if we can't
;
LOADK_8		EQU	$
		CALL	READLINE
		JP	NZ,DONE		;Jump if error occurs
		LD	C,'.'
		SVC	@DSP		;Display a dot for this line
		LD	HL,DEFBUFF	;Get the start of line
		LD	A,(HL)		;Get the high nibble
		CALL	HEXCONV		;Convert to binary
		SLA	A		;Move into high nibble
		SLA	A
		SLA	A
		SLA	A
		LD	C,A		;Save the high nibble in C
		INC	HL		;Increment pointer to low nibble
		LD	A,(HL)		;Get the low nibble
		CALL	HEXCONV
		OR	C		;Or in high nibble
		LD	(KEYNO),A	;Save the key number
		INC	HL		;Skip to definition string
		INC	HL
		INC	HL
		INC	HL
		LD	DE,BUFFER	;Get the destination
LOADK_5		EQU	$
		LD	A,(HL)		;Check for end
		IFA	13,LOADK_30		;Jump if carriage return
		IFANOT	'^',LOADK_7		;Jump if not control prefix
		INC	HL
		LD	A,(HL)
		IFA	'^',LOADK_20	;Jump if should just use it
		IFA	13,LOADK_30		;Jump if it is EOF
		SUB	'@'		;Convert to control
		LD	(DE),A
		INC	DE
		INC	HL
		JR	LOADK_5
;
LOADK_7		EQU	$
		IFANOT	'\',LOADK_20	;Jump if not eightbit quote
		INC	HL
		LD	A,(HL)
		IFA	'\',LOADK_20	;Jump if it is just '\'
		IFA	13,LOADK_30		;Jump if EOF
		INC	HL		;Point to next character
		LD	C,A		;Save the previous
		LD	A,(HL)		;Get the current
		IFA	13,LOADK_30		;Jump if EOF
		LD	B,A		;Save it
		LD	A,C		;Get the high nibble
		INC	HL		;Point past hex number
		CALL	HEXCONV		;Convert high to binary
		SLA	A		;Shift into position
		SLA	A
		SLA	A
		SLA	A
		LD	C,A		;Save the high nibble
		LD	A,B		;Get the low nibble
		CALL	HEXCONV		;Convert low to binary
		OR	C		;Or in the high nibble
		LD	(DE),A		;Store into buffer
		INC	DE		;Point to next place
		JR	LOADK_5
;
LOADK_20	EQU	$
		LDI			;Move a byte
		JR	LOADK_5
;
LOADK_30	EQU	$
		LD	HL,BUFFER	;Get the start of the buffer
		EX	DE,HL		;Swap the values
		LD	(HL),0		;Terminate the string
		OR	A		;Reset carry
		SBC	HL,DE		;Calculate the length
		LD	B,L		;Save the length
		LD	A,H
		IFZ	LOADK_31		;Jump if length < 256
		LD	HL,TOOLONG
		SVC	@DSPLY
		LD	HL,DEFBUFF	;Get the defintion and printit
		SVC	@DSPLY
		LD	B,255		;Use first 255 characters
LOADK_31	EQU	$
		LD	A,(KEYNO)	;Get the key we are defining
		LD	HL,BUFFER	;Get the definition string
		CALL	DEFKEY		;Define the key
		JP	LOADK_8
;
;	Get a keydef file name from the command line, if it is there
;
GETKEYFILE	EQU	$
		PUSH	HL		;Save the destination of @fspec
		LD	IX,(CMDBUF)	;Get the arg vector address
		LD	L,(IX-3)	;Get the lsb of FCB
		LD	H,(IX-2)	;Get msb
		LD	(LOADFCB),HL	;Save it
;
		LD	L,(IX-5)	;Get the lsb of buffer
		LD	H,(IX-4)	;Get msb
		LD	(FBUFF),HL	;Save it
;
		LD	HL,(CMDEND)
		CALL	SKIP_BLANKS	;Skip blanks
		POP	DE
		JR	Z,GETK_1
;
;	If filespec given, the @FSPEC it, and add the /ECI extension
;	if there is no extension given.
;
		SVC	@FSPEC		;Move the filename
		LD	HL,ECIEXT	;Get the default extension
		SVC	@FEXT		;Add it
;
GETK_1		EQU	$
		RET
;
;	Read one line from the file
;
READLINE	EQU	$
		PUSH	HL
		PUSH	DE
		PUSH	BC
		LD	HL,DEFBUFF
READL_1		EQU	$
		LD	DE,(LOADFCB)
		SVC	@GET
		JR	NZ,READL_4
		LD	(HL),A
		IFA	13,READL_4
		INC	HL
		JR	READL_1
;
READL_4		EQU	$
		POP	BC
		POP	DE
		POP	HL
		RET
;
;	Convert character in A to binary equivelent
;
HEXCONV		EQU	$
		OR	020H		;Set bit to make lower case
		SUB	7
		CP	'9'+1
		JR	C,ISDIGIT_3
		SUB	32		;Convert lower to upper case
		JR	ISDIGIT_4
;
ISDIGIT_3	EQU	$
		ADD	A,7
ISDIGIT_4	EQU	$
		SUB	'0'		;Make it binary
		RET			;Return A
;
;	Come to here on EOF of file
;
DONE		EQU	$
		PUSH	AF
		LD	C,CR
		SVC	@DSP
		POP	AF
		CP	28		;Check if EOF error
		JR	NZ,ERROR	;Jump if not EOF error
		LD	DE,(LOADFCB)	;Close the file
		SVC	@CLOSE
		JP	Z,ENTRY
ERROR		EQU	$
		PUSH	AF
		LD	C,CR
		SVC	@DSP
		POP	AF
		OR	0C0H		;Set short message bits
		LD	C,A
		SVC	@ERROR
		JP	ENTRY
;
;	Data definition area
;
TOOLONG		DB	'Key definition too long using 255 characters '
		DB	'only.',13
KEYNO		DW	0
DEFBUFF		DS	256
BUFFER		DS	256
FBUFF		DW	0
ECIEXT		DB	'ECI',3
NAMEREST	DB	' > ',3
LOADMSG		DB	'Reading definitions from '
LOADSPEC	DB	'KEYDEFS/ECI',3
		DS	32
LOADFCB		DW	0
