;		fixres/asm
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	This program patches the SYSRES interface in TRSDOS 6.2.x to
;	allow high memory modules to use SVC's that cause SYSTEM overlay
;	references.  Normally, the system does not check to see if BANK
;	zero is present before it calls the SYSRES module.  This can
;	cause havoc when BANK 0 is not in.  This module patches the
;	operating system code to include a module that will make sure
;	that BANK 0 is present before the SYSRES module is called.
;
;	Written by Gregg Wonderly, Febuary 9, 1987
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
*GET		EQUATE4/EQU
CR		EQU	13
		ORG	3000H
;
START		EQU	$
		LD	HL,INITMES		;Display intro
		SVC	@DSPLY
		LD	DE,SYSRES		;Check to see if SYSRES
		SVC	@GTMOD			;module is resident.
		JR	NZ,NO_SYSRES_MOD	;Jump if not
;
		LD	BC,0FFC1H-0FF92H	;Get normal offset to
		LD	(SAVEADDR),HL		;check if this SYSRES
		ADD	HL,BC			;module is called from
		LD	A,(1A6CH)		;the OS.  Check for CALL
		CP	0CDH			;Make sure it is a CALL
		JR	NZ,NO_CALL_INSTR	;Jump if not
;
		LD	DE,(1A6DH)		;Get the address
		OR	A			;Reset carry
		SBC	HL,DE			;Check if CALL dest sane
		JR	NZ,NO_CALL_INSTR	;Jump if not
;
		LD	(CALLADDR),DE		;Save that address
		LD	HL,(SAVEADDR)		;Get the address back
		LD	BC,0FFFDH-0FF92H	;Get difference
		ADD	HL,BC
		LD	A,(HL)			;Check for JP instruction
		CP	0C3H			;Check for JP
		JR	NZ,NO_JUMP_INSTR	;Jump if not
;
		DI				;Disable interrupts
		CALL	INST_PATCH		;Do the patch
		EI				;Enable interrupts
		LD	HL,PATCHED		;Print the message
		SVC	@DSPLY
		LD	HL,0			;Exit normally
		RET
;
;	Print selected error messages
;
NOMEM		LD	HL,NOLOWMEM		;No low memory to use
;
		DB	0DDH			;Change to IX instr
NO_SYSRES_MOD	LD	HL,NOSYSRES		;SYSRES module not there
;
		DB	0DDH			;Change to IX instr
NO_CALL_INSTR	LD	HL,NOCALL		;Things don't look right
;
		DB	0DDH			;Change to IX instr
NO_JUMP_INSTR	LD	HL,NOJUMP		;More inconsistancies
		PUSH	HL
		LD	HL,ABORTED		;Print aborted next
		SVC	@DSPLY			;to intro message
;
		LD	DE,SFMOD		;Check if module there
		SVC	@GTMOD
		LD	HL,-1			;Get error exit
		JR	NZ,NOSFMOD		;Jump if not
;
		LD	HL,MODRES		;Print message
		EX	(SP),HL			;Exit normally so that
		LD	HL,0			;JCL won't bomb
NOSFMOD:
		EX	(SP),HL			;Get the message
		SVC	@DSPLY			;Display it
		POP	HL			;Get the exit code
		RET				;Back to TRSDOS
;
;	Put that patch code into TRSDOS
;
INST_PATCH:
		INC	HL			;Point to JP address
		PUSH	HL			;Save that address
		CALL	MOVEMOD			;Move $SF into place
		POP	HL			;Get the jump data addr
		LD	C,(HL)			;Get LSB
		INC	HL			;Point to MSB
		LD	B,(HL)			;Get the MSB
		LD	(JUMPADDR),BC		;Put in JP data
RX04		EQU	$-2
		LD	BC,RET_NF		;Patch SYSRES JP so
RX05		EQU	$-2			;that it points to us
		LD	(HL),B			;Store MSB
		DEC	HL
		LD	(HL),C			;Store LSB
		LD	HL,CONT			;Patch CALL so SYSRES
RX06		EQU	$-2			;to call us
		LD	(01A6DH),HL
;
;	While we are diddling, lets fix the TRACE problem with the
;	XLR8TR interrupt fix.  The 5 bytes of code that 38H-40H
;	jump to store the TRACE value.  Mike didn't look at the
;	code he was circumventing to slow the clock down during
;	keyboard scanning, which happens to be the TRACE code.
;	I put the code in here, and noop'd it out at 1BFFH-1C02H.
;
		LD	HL,(0039H)		;Get interrupt vector
		LD	(NEWINT),HL		;Save it
RX08		EQU	$-2
		LD	HL,INTRADDR		;Store our own
RX07		EQU	$-2
		LD	(0039H),HL
		LD	HL,0			;NOP out the code
		LD	(1BFFH),HL		;at 1BFFH-1C02H
		LD	(1C01H),HL
		LD	(1C02H),HL
		RET				;Back to caller
;
;	This is the patch module, $SF
;
PATCHDATA:
		JR	CONT		;Jump to addr
		DW	MODEND-1
RX03		EQU	$-2
		DB	3,'$SF'
		DW	0,0
CONT:
		PUSH	AF		;Save AF and BC
		PUSH	BC
		XOR	A		;Select BANK 0
		LD	B,A
		LD	C,A
		CALL	0877H		;Switch it in place
		LD	(RESTORE),BC	;Save current bank
RX01		EQU	$-2
		POP	BC		;Restore registers
		POP	AF
		CALL	0		;Call the SYSRES module
CALLADDR	EQU	$-2
		PUSH	AF		;Save returned flags
		PUSH	BC		;And BC
		LD	BC,0		;Get the old bank
RESTORE		EQU	$-2
		LD	A,C
		CALL	0877H		;Switch back to old bank
		POP	BC		;Restore regs
		POP	AF
NOCHANGE:
		RET			;Out...
INTRADDR:
		EX	(SP),HL		;Code that was at interrupt vector
		LD	(07AFH),HL
		EX	(SP),HL
		JP	0		;Jump to original code
NEWINT		EQU	$-2
;
;	SYSRES comes to here of requested module is not resident
;
RET_NF:
		PUSH	AF		;Save return values
		PUSH	BC
		LD	BC,(RESTORE)	;Get old bank info
RX02		EQU	$-2
		LD	A,C
		CALL	0877H		;Put that bank back
		POP	BC		;Restore regs
		POP	AF
		JP	0		;Go to TRSDOS code
JUMPADDR	EQU	$-2
MODEND		EQU	$
MODLEN		EQU	$-PATCHDATA
;
;
;
SAVEADDR	DW	0
SFMOD		DB	'$SF',3
MODRES		DB	'Patch is already installed.',13
NOLOWMEM	DB	'Insufficent low memory, to install patch.',CR
NOSYSRES	DB	'"SYSRES" memory module is not resident.',13
NOCALL		DB	'Address 1A6CH does not contain a CALL to the'
		DB	' SYSRES memory module.',CR
NOJUMP		DB	'SYSRES module is not terminated by a JP '
		DB	'instruction.',CR
PATCHED		DB	'installed.',CR
ABORTED		DB	'aborted.',CR
INITMES		DB	'TRSDOS 6.2.x SYSRES patch (c) 1987 Gregg '
		DB	'Wonderly  -  ',3
SYSRES		DB	'SYSRES',3
;
;
;
MOVEMOD		EQU	$
		LD	DE,(0206H)	;Get the low memory pointer
		PUSH	DE		;Save it for the transfer address
		LD	HL,MODLEN	;Get the length of the filter
		LD	BC,1300H	;Get the maximum useable address
		ADD	HL,DE		;Compute the would be new high
		PUSH	HL		;Save as the new low pointer
		OR	A		;Reset the carry
		SBC	HL,BC		;See if we would over shoot
		POP	HL		;Restore HL before the jump
		POP	DE
		JP	NC,NOMEM	;If NC, then no space
		PUSH	DE
		LD	(0206H),HL	;Save the new low pointer
		POP	HL		;Get the destination
		PUSH	HL		;Save the start back
		LD	BC,PATCHDATA	;Calculate offset from source
		OR	A		;Reset the carry
		SBC	HL,BC		;Offset now in HL
		LD	IX,OFFTBL	;Get start of offset table
		PUSH	HL		;Transfer offset to BC
;
;	LOOP TO ADD OFFSET TO ALL ADDRESSES NECESSARY
;
MOVNXT		EQU	$
		POP	BC		;Restore the offset to BC
		PUSH	BC		;Save it back
		LD	L,(IX)		;Get LSB of address to change
		INC	IX		;POINT TO MSB
		LD	H,(IX)		;GET IT
		INC	IX		;POINT TO LSB OF NEXT, OR END
		PUSH	IX		;SAVE POINTER TO TABLE
		PUSH	HL		;Put the address into IX
		POP	IX
		LD	L,(IX)		;Get the LSB for relocation
		LD	H,(IX+1)	;Get the MSB
		ADD	HL,BC		;Relocate it
		LD	(IX),L		;Put it back
		LD	(IX+1),H
		POP	BC		;Get the table address in BC
		PUSH	BC		;Copy it back into IX
		POP	IX		;Restore the table address
		LD	HL,OFFEND	;Get the end of the offset table
		OR	A		;Reset the carry
		SBC	HL,BC		;Compute the difference
		JR	NZ,MOVNXT	;Loop, if not done
;
		POP	BC		;RESTORE STACK TO PREVIOUS STATE.
		LD	BC,MODLEN	;MOVE MODULE INTO HIGH MEMORY.
		POP	DE		;Get the relocated start
		LD	HL,PATCHDATA	;Get the load address
		LDIR			;Move it into place
		RET
OFFTBL		EQU	$
		DW	RX01,RX02,RX03,RX04,RX05,RX06,RX07,RX08
OFFEND		EQU	$
		END	START
