;		fileio/asm
;
		IFNDEF	@DSPLY
*GET		EQUATE4/EQU
		ENDIF
;
;	struct listtab {
;		char len;
;		short load_addr;
;		short nrn;
;		char nrn_offset;
;	}
;
;	These routines provide access to a load module based on an
;	address.  A table of the load modules is built, and then
;	referenced to determine where to go to get the byte.
;
RECLEN		EQU	6
;
;
;
GETFILE_2:
		PUSH	HL
		JR	GETF_0
;
;
;
GETFILE:
		PUSH	HL		;Save current HL
		LD	A,(FROMFILE)
		OR	A
		CALL	NZ,CLOSEFILE
		XOR	A
		LD	(HAVEPDS),A
		LD	HL,FNAMMESG	;Display prompt for filename
		SVC	@DSPLY
		LD	BC,2000H	;Get the max (b=32,c=0)
		LD	HL,FNBUF
		SVC	@KEYIN		;Get the file name
		JP	C,GETFILE_OUT	;Return if break pressed
;
;	Secondary entry point for startup when a filename is given
;	on the command line.
;
GETF_0:
		LD	A,' '
		LD	(TEMPBUF),A	;Say no PDS MEMBER
		XOR	A
		LD	(HAVEPDS),A
		LD	DE,INFCB	;Get the destination
		LD	HL,FNBUF
		SVC	@FSPEC		;Convert the name and move it
		LD	A,19		;Get illegal file name error
		JP	NZ,GET_ERR	;Jump if bad filespec
		LD	A,(HL)		;Look for PDS member
GETF_1:
		CP	'('		;Look for start of PDS member
		JR	Z,GETF_5	;Jump if got paren
		CP	' '		;Check for blanks
		JR	C,GETF_8	;Jump if end of line
		JP	NZ,GET_ERR	;If not space then fspec error
		INC	HL		;Move to next
		JR	GETF_1		;Loop
;
GETF_5:
		INC	HL		;Move to name
		PUSH	DE		;Save old FCB pointer
		LD	DE,TEMPBUF	;Get PDS name buffer
GETF_6:
		LD	A,(HL)		;Get a byte
		CP	' '		;End of line?
		JR	C,GETF_7	;Jump if it is
		CP	')'		;Check for other end
		JR	Z,GETF_7	;Jump if it is
		CP	'A'		;Convert to lower case
		JR	C,GETF_6A	;Jump if not upper
		CP	'Z'+1		;Check for MAX
		JR	NC,GETF_6A	;Jump if not upper
		ADD	A,32		;Make it lower
GETF_6A:
		LD	(DE),A		;Store new value
		INC	DE		;Increment the pointers
		INC	HL
		JR	GETF_6		;Loop until done
;
GETF_7:
		EX	DE,HL		;Move ending pointer to HL
		LD	(HL),' '	;Terminate string
		POP	DE		;Get old FCB back
		LD	A,1		;Set flag saying we have a name
		LD	(HAVEPDS),A
		LD	HL,TEMPBUF+8	;Make sure it is only 8 chars
		LD	(HL),' '
GETF_8:
		LD	HL,CMDEXT	;Add the /CMD default extension
		SVC	@FEXT
		PUSH	DE		;Save the FCB address
		EX	DE,HL		;Put it into HL as source
		LD	DE,CURFILE	;Get destination buffer
		LD	BC,32		;Get max length
		LDIR			;Copy the string
		LD	A,(TEMPBUF)	;Check for no member
		CP	' '
		JR	Z,GETF_15
		CALL	MOVE_MEMBER	;Move the member into buffer
GETF_15:
		POP	DE
		LD	HL,INBUF	;Get the data buffer
		LD	B,0
		SVC	@OPEN		;Open the file
		JR	Z,GETFILE_1	;Jump if file was found
GET_ERR:
		OR	0C0H		;Set short message bits
		LD	C,A
		SVC	@ERROR		;Display the system message
GETFILE_OUT:
		POP	HL
		RET
;
GETFILE_1:
		POP	HL
		LD	HL,0		;Zero entry point
		LD	(ENTADDR),HL
		LD	A,1		;Set flag to read from file
		LD	(FROMFILE),A
		CALL	BUILDLIST	;Build the list of names
		LD	A,H
		OR	L
		CALL	Z,SHOWLIST	;Print list of load addresses
		LD	HL,(ENTADDR)	;Return entry point to caller
		RET			;Return status
;
;	Build a list of locations on disk where load addresses are
;	located, the address to load into, and the length of the
;	block
;
BUILDLIST:
		XOR	A
		LD	(SEENPDS),A
		LD	(SEENISAM),A
		LD	(PDSNUM),A
		LD	IX,LISTTAB	;Get the table to store descr's
		LD	(ENDLIST),IX	;Set end
BUILD_0:
		LD	DE,INFCB	;Get the file FCB to read from
		SVC	@GET		;Get a byte
		JP	NZ,BUILD_EOF	;Jump if problem during read
		CP	3		;Non executable block
		JR	Z,BUILD_1
		CP	1		;Load module?
		JP	NZ,BUILD_5	;Jump if not load module
BUILD_1:
		LD	IX,(ENDLIST)
		SVC	@GET		;Get the length
		JP	NZ,LOADERR
		SUB	2		;Decrement by 2 for LOAD address
		LD	(IX),A		;Store length
		SVC	@GET		;Get the lsb of load address
		JP	NZ,LOADERR	;Jump if there is a problem
		LD	(IX+1),A	;Save the LSB
		SVC	@GET		;Get the MSB of LOAD address
		JP	NZ,LOADERR	;Jump if error during @GET
		LD	(IX+2),A	;Save the MSB
		LD	IY,INFCB	;Get the NRN out of the FCB
		LD	L,(IY+10)	;and copy it into the buffer
		LD	H,(IY+11)
		BIT	5,(IY+1)	;Check if valid
		JR	NZ,BUILD_2	;Jump if at end of buffer
		DEC	HL		;Correct NRN to current rec
BUILD_2:
		LD	(IX+3),L	;Store NRN
		LD	(IX+4),H
		LD	A,(IY+5)	;Get the byte offset
		LD	(IX+5),A	;Save it
		LD	BC,RECLEN	;Get the length of the structure
		ADD	IX,BC		;Move to next record
		LD	(ENDLIST),IX	;Save the ending pointer
		LD	B,(IX-RECLEN)	;Get the length
BUILD_3:
		LD	DE,INFCB	;Get the FCB
		SVC	@GET		;Get a byte
		JP	NZ,LOADERR	;Jump if error during @GET
		DJNZ	BUILD_3		;Loop until all bytes READ
		JP	BUILD_0		;Get next record type
;
BUILD_5:
		CP	5		;Module name field
		JP	NZ,BUILD_10	;Jump if not
		PUSH	HL
		LD	HL,TAG5
		SVC	@DSPLY
		POP	HL
BUILD_6:
		LD	DE,INFCB
		SVC	@GET		;Get the length
		JP	NZ,LOADERR	;Jump if there is an error
		LD	B,A		;Get the length
BUILD_7:
		LD	DE,INFCB
		SVC	@GET
		JP	NZ,LOADERR
		LD	C,A
		SVC	@DSP
		DJNZ	BUILD_7
		LD	C,13
		SVC	@DSP
		JP	BUILD_0
;
BUILD_10:
		CP	31		;Copyright block
		JR	NZ,BUILD_12
		PUSH	HL
		LD	HL,TAG31
		SVC	@DSPLY
		POP	HL
		JR	BUILD_6
;
BUILD_12:
		CP	7		;Patch name header
		JR	NZ,BUILD_14
		PUSH	HL
		LD	HL,TAG7
		SVC	@DSPLY
		POP	HL
		JP	BUILD_6
;
BUILD_14:
		CP	6		;PDS header?
		JR	NZ,BUILD_16
		PUSH	HL
		LD	HL,TAG6
		SVC	@DSPLY
		POP	HL
		JP	BUILD_6
;
BUILD_16:
		CP	2		;Entry point?
		JP	NZ,BUILD_30	;Jump if not entry point
		SVC	@GET		;Get the length
		JP	NZ,LOADERR	;Jump if error
		LD	B,A		;Get the length
		LD	IY,ENTADDR
BUILD_22:
		LD	DE,INFCB	;Get the FCB
		SVC	@GET		;Get a byte
		JP	NZ,LOADERR	;Jump if error during @GET
		LD	(IY),A		;Save entry address
		INC	IY
		DJNZ	BUILD_22	;Loop until all bytes READ
		JP	BUILD_0
;
;	Check for an ISAM directory entry.  If we have seen a previous
;	PDS directory entry, then use the ISAM directory number that
;	we obtained from there.  Otherwise, ask if this is the entry
;	That the user wants.
;
BUILD_30:
		CP	8		;Isam data record?
		JP	NZ,BUILD_40	;Jump if not
		LD	A,1
		LD	(SEENISAM),A	;Say we have seen isam entry
		LD	A,(SEENPDS)	;Have we seen a pds record?
		OR	A		;Check for zero
		JP	NZ,BUILD_36	;Jump if seen a PDS
		SVC	@GET		;Get the length
		JP	NZ,LOADERR
		LD	(ISAMLEN),A	;Save it
		SVC	@GET		;Get the isam record number
		JP	NZ,LOADERR
		LD	(ISAMREC),A
		LD	C,A		;Save it
		LD	HL,PDSNUM	;Get the number buffer
		SVC	@HEX8		;Convert byte to ascii string
BUILD_32:
		LD	HL,THISISAM	;Get the prompt
		SVC	@DSPLY		;Print it
		CALL	GETANSWER
		CP	'Y'
		JR	Z,BUILD_33	;Jump if so
;
;	Skip the isam record entry
;
		LD	A,(ISAMLEN)	;Get the record length
		LD	B,A
		DEC	B		;Adjust for record byte
		JP	BUILD_3		;Go skip it
;
;	We must now pull the information out of the ISAM directory
;	record, and then seek to the location of the record, and
;	set up to read the load modules.
;
BUILD_33:
		LD	DE,INFCB	;Get the FCB
		SVC	@GET		;Get the LSB of entry point
		JP	NZ,LOADERR
		LD	C,A
		SVC	@GET		;Get the MSB
		JP	NZ,LOADERR
		LD	B,A
		LD	(ENTADDR),BC	;Save the entry point
		SVC	@GET		;Get LSB of NRN
		JP	NZ,LOADERR
		LD	C,A
		SVC	@GET		;Get MSB
		JP	NZ,LOADERR
		LD	B,A
		SVC	@GET		;Get the OFFSET
		JP	NZ,LOADERR
		PUSH	AF		;Save it
		SVC	@POSN		;Position to NRN in BC
		EX	AF,AF'		;Save return flags
		POP	AF		;Get offset back
		EX	AF,AF'		;Get @POSN code
		JP	NZ,LOADERR	;Jump if error
		EX	AF,AF'		;Get OFFSET back
		LD	IY,INFCB	;Get FCB
		LD	(IY+5),A	;Set offset in FCB
		LD	A,1
		LD	(PDSMEM),A	;Say we are processing a PDS
		JP	BUILD_0
;
BUILD_36:
		LD	DE,INFCB	;Get the file FCB
		SVC	@GET		;Get the length of ISAM record
		JP	NZ,LOADERR
		LD	B,A		;Save the length
		SVC	@GET		;Get the ISAM directory number
		JP	NZ,LOADERR
		LD	C,A
		LD	A,(ISAMREC)	;Get the ISAM rec number
		CP	C		;Check it
		JR	Z,BUILD_33	;Jump if this is the one
		DEC	B		;Account for the one byte read
		JP	BUILD_3		;Skip this rec
;
;	Check if this is the end of an ISAM directory
;
BUILD_40:
		CP	10
		JR	NZ,BUILD_50	;Jump if not end of ISAM
		LD	A,(SEENISAM)	;Check if should be here
		OR	A		;Check it
		JR	Z,BUILD_43
		LD	HL,ENDISAM
;
BUILD_42:
		SVC	@DSPLY
		LD	DE,INFCB
		SVC	@CLOSE
		XOR	A
		LD	(FROMFILE),A
		RET
;
BUILD_43:
		LD	HL,OOPSISAM
		JR	BUILD_42
;
;
;
BUILD_50:
		CP	4		;Check for end of PDS member
		JR	NZ,BUILD_55	;Jump if not
		LD	A,(SEENISAM)	;Have we started a load
		OR	A		;Set the flags
		JP	NZ,BUILD_EOF	;If so, then go to EOF
		LD	HL,OOPSPDSEOF	;Print error message
		JP	BUILD_42
;
;	Check if this is a PDS directory entry.  If it is, then check
;	to see if a member name was already specified.  If so, then
;	try to match that one against this one.  If not, then ask
;	if this is the member that should be loaded.
;
BUILD_55:
		CP	12		;PDS directory entry?
		JP	NZ,BUILD_65	;Jump if not
		LD	DE,INFCB	;Get the record length
		SVC	@GET
		LD	B,A		;Save it
		LD	A,(SEENPDS)	;Have we previously seen one?
		OR	A		;Set the flags
		JP	NZ,BUILD_3	;If so, then ignore this record
;
		LD	A,(HAVEPDS)	;Do we already have a pds name?
		OR	A		;Set the flag
		JR	NZ,BUILD_62	;Jump if we have a name
		LD	HL,TEMPBUF	;Get the place to store the name
		LD	B,8		;Get the count
		CALL	GETBUF		;Get the 8 bytes
		JP	NZ,LOADERR	;Jump if @GET error
		LD	A,' '		;Get a space
BUILD_56:
		DEC	HL		;Backup one character in buffer
		CP	(HL)		;Check for space
		JR	Z,BUILD_56	;Loop if it is
		LD	A,(TEMPBUF)	;Check for deleted entry
		CP	'*'
		JP	Z,BUILD_58	;If deleted, then skip it
;
		INC	HL		;Point back at a space
		LD	(HL),3		;Store ETX for printing
BUILD_57:
		LD	HL,THISPDS	;Get the initial message
		SVC	@DSPLY		;Print it
		LD	HL,TEMPBUF	;Get the name
		SVC	@DSPLY		;Print it
		LD	HL,PDSPROMPT	;Get the end of the prompt
		SVC	@DSPLY		;Print that
		CALL	GETANSWER
		CP	'Y'		;Use this one?
		JR	Z,BUILD_60	;Jump if so
BUILD_58:
		LD	DE,INFCB	;Get the FCB
		LD	B,3		;Characters left in PDS record
		JP	BUILD_3		;Go eat rest of record
;
BUILD_60:
		CALL	MOVE_MEMBER	;Move member name in
		LD	DE,INFCB	;Get the FCB
		SVC	@GET		;Get the ISAM record number
		JP	NZ,LOADERR
		LD	(ISAMREC),A	;Save the ISAM record number
		LD	A,1
		LD	(SEENPDS),A	;Say we have seen a pds dir
		LD	IX,LISTTAB	;Reset to new data
		LD	(ENDLIST),IX
		LD	B,2
		JP	BUILD_3		;Eat the rest of the PDS dir
;
BUILD_62:
		LD	C,B
		LD	B,8		;Compare 8 bytes
		LD	HL,TEMPBUF	;Get the buffer holding the name
BUILD_63:
		LD	DE,INFCB
		SVC	@GET		;Get the byte
		JP	NZ,LOADERR	;Abort on error
		CPI			;Compare, INC HL and DEC C
		JR	NZ,BUILD_64	;Stop if not
		CP	' '		;End of name?
		JR	Z,BUILD_63A	;Jump if got a match
		DJNZ	BUILD_63	;Loop until max of 8
		JR	BUILD_60	;Get ISAM rec number
;
BUILD_63A:
		DJNZ	BUILD_63C	;Check if at end
		JR	BUILD_60	;Get ISAM rec if at end
BUILD_63C:
		SVC	@GET		;Get a byte
		JP	NZ,LOADERR	;Jump if error
		JR	BUILD_63A	;Loop until got them all
;
;	Eat PDS dir entry have a failed match.  NOTE that B has not been
;	DEC'd for the compared character.  Therefore, we only need to
;	add 2 to account for the length.
;
BUILD_64:
		INC	B		;Add 2 to B
		INC	B
		JP	BUILD_3		;Eat the characters
;
;
;
BUILD_65:
		CP	14		;End of PDS directory
		JR	NZ,BUILD_75
		LD	A,(SEENPDS)
		OR	A
		JR	NZ,BUILD_68
		LD	HL,OOPSPDS
		SVC	@DSPLY
		JP	BUILD_EOF
;
;
;
BUILD_68:
		LD	DE,INFCB
		SVC	@GET
		LD	B,A
		JP	BUILD_3
;
;
;
BUILD_75:
		CP	16		;Yanked load block?
		JR	NZ,BUILD_85	;Jump if not
		LD	DE,INFCB	;Get the length byte
		SVC	@GET
		JP	NZ,LOADERR	;Jump if error
		LD	B,A		;Get the count
		SVC	@GET		;Get load address and adjust
		JP	NZ,LOADERR	;B so that it is correct
		DEC	B
		SVC	@GET
		JP	NZ,LOADERR
		DEC	B
		JP	BUILD_3
;
BUILD_85:
		LD	HL,HEXBUF	;Convert to HEX ASCII
		LD	C,A		;Get byte to convert
		SVC	@HEX8
		LD	IY,INFCB
		LD	C,(IY+5)
		LD	HL,OFFSET
		SVC	@HEX8
		LD	DE,(INFCB+10)
		LD	HL,NRN
		SVC	@HEX16
		LD	C,(IY+1)
		LD	HL,STATUS
		SVC	@HEX8
		LD	HL,UNKNOWN	;Get string start
		SVC	@DSPLY		;Print unknown opcode message
BUILD_EOF:
		LD	HL,0		;Return success
		RET
;
LOADERR:
		OR	0C0H		; Set short error code
		LD	C,A		; Put it in C
		SVC	@ERROR		; Print the error message
		LD	HL,FORMATERR	; Print the message
		SVC	@DSPLY
		LD	DE,INFCB	; Get the FCB
		SVC	@CLOSE		; Close the file
		XOR	A
		LD	(FROMFILE),A
		LD	HL,1		; Set error exit
		RET
;
;	Get a byte.  If file access is active, then do the proper
;	steps to get the byte.  Otherwise retrieve the byte, (HL),
;	and return it to the caller.
;
GETBYTE:
		LD	A,(FROMFILE)	;Check if from file
		OR	A		;Set the flags
		LD	A,(HL)		;Get byte in case no file
		RET	Z		;Return if no get from file
		CALL	CHKBUF		;See if byte in buffer
		RET	Z
		LD	A,(HL)		;Get byte from memory
		RET			;Return NZ status to caller
;
;	Check if address in HL represents a byte in the record
;	list.  If it is there, then check the buffer contents to
;	determine if the byte is there
;
CHKBUF:
		PUSH	IX
		PUSH	IY
		PUSH	DE		;Save the registers
		PUSH	BC
		PUSH	HL
		LD	IX,LISTTAB	;Get the buffer address
;
;	Given the addres in HL, and the current table entry as given
;	by IX, check if the address in HL resides in the LOAD record
;	indicated by the entry pointed to by IX.
;
CHK_1:
		LD	BC,(ENDLIST)	;Check if past end
		PUSH	IX		;Save the new value
		EX	(SP),HL		;Save HL and get it back
		OR	A		;Reset carry
		SBC	HL,BC		;Check for out of range
		POP	HL		;Restore old HL
		JP	Z,CHK_2A	;Jump if at end
;
		LD	C,(IX+1)	;Get the lsb of load address
		LD	B,(IX+2)	;Get the msb of load address
		POP	HL		;Get requested address
		PUSH	HL		;Put it back
		OR	A		;Reset the carry
;
;	If the subtraction yields a carry, then the address in BC is
;	larger than HL.  This indicates that this record does not
;	contain the byte requested.  After the subtraction, HL
;	contains the offset from the start of the record where we
;	must look for this byte.  We must still see if the record is
;	that long.
;
		SBC	HL,BC		;Check if greater or equal
		JR	NC,CHK_3	;Jump if might work
CHK_2:
;
;	Got a carry, move to next record and check for end.
;
		LD	BC,RECLEN	;Get then length of a record
		ADD	IX,BC		;Point IX at the next
		JP	CHK_1
;
CHK_2A:
		LD	A,1		;Return NZ status
		OR	A
GETB_RET:
		POP	HL		;Restore stack
		POP	BC
		POP	DE
		POP	IY
		POP	IX
		RET			;Return not found
;
;	When control comes to here, HL contains the difference between
;	the address that was passed in HL, and the address that the
;	LOAD record loads into.  By subtracting the length of the LOAD
;	record, we will determine if the byte lies in this record.
;
CHK_3:
		LD	C,(IX)		;Get the length of load rec
		LD	B,0		;Set B to zero initially
		LD	A,C		;Check for 256 byte rec
		OR	A		;which is when C is zero
		JR	NZ,CHK_5	;Jump if C not zero
		INC	B		;Make BC be 256
CHK_5:
		OR	A		;Reset carry
		PUSH	HL		;Save offset into record
		SBC	HL,BC		;Check if in range
		POP	HL		;Restore offset
		JR	C,CHK_8		;Jump if it contains enough
		JR	CHK_2		;else get next entry
;
;	Now we need to take the offset in HL, and add it to the
;	NRN offset given in (IX+5).  By checking for a result > 255
;	after this addition, we can determine if the NRN in the buffer
;	should be incremented to account for crossing a sector boundry.
;
CHK_8:
		LD	C,(IX+5)	;Get the NRN offset
		LD	B,0		;Set B to zero
		ADD	HL,BC		;Compute offset
		LD	E,L		;Get the offset of the byte
		LD	C,(IX+3)	;Get the NRN lsb
		LD	B,(IX+4)	;Get the NRN msb
		LD	A,H		;Check if MSB non zero
		OR	A		;Check for next sector
		JR	Z,CHK_10	;Jump if not > 255
		INC	BC		;Move to NRN
;
;	Now E has the offset in the sector indicated by BC where
;	we will find the byte that we need.
;
CHK_10:
		LD	IY,INFCB	;Get the file FCB address
		LD	L,(IY+10)	;Get the file NRN
		LD	H,(IY+11)
		LD	A,H
		OR	L		;Check if NRN is zero
		JR	Z,CHK_12	;Jump if no dec
		BIT	5,(IY+1)	;Check if NRN valid
		JR	NZ,CHK_12
		DEC	HL		;Correct HL for current record
;
;	Now compare HL to BC to see if the record in the buffer is
;	the one needed.
;
CHK_12:
		OR	A		;Reset carry
		SBC	HL,BC		;Check for equal
		JR	Z,CHK_20	;Jump if right record
		PUSH	DE		;Save the offset in E
		LD	DE,INFCB	;Get the FCB
		SVC	@POSN		;Position to that sector
		POP	DE		;Restore it
		JP	Z,CHK_15	;Jump if position error
		CP	1CH		;Check for proper error code
		JR	Z,CHK_15
		CP	1DH
		JP	NZ,POS_ERR	;Jump if error
;
CHK_15:
		PUSH	DE		;Save OFFSET in E
		LD	DE,INFCB
		SVC	@GET		;Read the sector in
		POP	DE
;
;	Now the proper sector is in the buffer, so we need to set
;	the offset to the proper value indicated in E
;
CHK_20:
		LD	IY,INFCB
		LD	(IY+5),E	;Set the offset
		LD	DE,INFCB
		SVC	@GET		;Get the byte needed
		JR	NZ,POS_ERR
		CP	A		;Set Z status
		JP	GETB_RET
;
;	Come here if a positioning error occurs
;
POS_ERR:
		OR	0C0H
		LD	C,A
		SVC	@ERROR		;Print the message
		LD	HL,BAD_POS	;Print the message
		SVC	@DSPLY
		LD	A,1		;Set NZ
		OR	A
		JP	GETB_RET
;
;	Close any open input file, signaling an error if no file
;	is open.
;
CLOSEFILE:
		PUSH	BC
		PUSH	HL
		PUSH	DE
		LD	A,(FROMFILE)	;Check if open
		OR	A
		JR	Z,NOTOPEN	;Jump if not
		LD	DE,INFCB
		SVC	@CLOSE
		XOR	A
		LD	(FROMFILE),A
		LD	HL,CLOSEMSG
		SVC	@DSPLY
		LD	HL,INFCB
		SVC	@DSPLY
		LD	C,13
		SVC	@DSP
CLOSE_OUT:
		POP	DE
		POP	HL
		POP	BC
		RET
NOTOPEN:
		LD	HL,NOTOPMSG
		SVC	@DSPLY
		JR	CLOSE_OUT
		RET
;
;
;
GETBUF:
		LD	DE,INFCB
		SVC	@GET
		RET	NZ
		LD	(HL),A
		INC	HL
		DJNZ	GETBUF
		RET
;
;
;
MOVE_MEMBER:
		LD	BC,32
		LD	HL,CURFILE
		LD	A,3
		CPIR			;Find end
		DEC	HL		;Back up to ETX
		LD	(HL),'('	;Store (
		INC	HL		;Point past it
		EX	DE,HL
		LD	HL,TEMPBUF
		LD	A,' '
MOVE_MEM_1:
		CP	(HL)
		JR	NC,MOVE_MEM_3
		LDI
		JR	MOVE_MEM_1
MOVE_MEM_3:
		PUSH	DE
		POP	IX
		LD	(IX),')'
		LD	(IX+1),3
		RET
;
;
;
GETANSWER:
		SVC	@KEY
		AND	0DFH
		CP	'Y'
		JR	Z,GETANS_3
		CP	'N'
		JR	NZ,GETANSWER
GETANS_3:
		PUSH	AF
		LD	C,A
		SVC	@DSP
		LD	C,13
		SVC	@DSP
		POP	AF
		RET
;
;	Show the list of load address for the currently open file
;
SHOWLIST:
		PUSH	BC		;Save regs
		PUSH	HL
		PUSH	DE
		LD	A,(FROMFILE)	;Check if open
		OR	A
		JP	Z,NOTOPEN	;Jump if not
		LD	HL,LISTTAB
		LD	BC,(ENDLIST)
		OR	A
		SBC	HL,BC		;Check for end
		JP	Z,SHOW_20
		XOR	A
		LD	(ADFLAG),A	;Reset address active flag
		LD	HL,FILEMSG
		SVC	@DSPLY
		LD	HL,CURFILE
		SVC	@DSPLY
		LD	C,13
		SVC	@DSP
		LD	HL,ENTMESS	;Get the entrypoint message
		SVC	@DSPLY		;Print it
		LD	DE,(ENTADDR)	;Get the entry point
		CALL	HEXOUT
		LD	C,'H'		;Make it pretty
		SVC	@DSP
		LD	C,13		;Get a new line
		SVC	@DSP
		LD	HL,LISTTAB
SHOW_1:
		LD	C,(HL)		;Get the length
		LD	B,0		;Make BC the length of block
		LD	A,C		;If C is zero then inc B
		OR	A
		JR	NZ,SHOW_2
		INC	B		;Make BC be 256
SHOW_2:
		INC	HL		;Point to addr field
		LD	E,(HL)		;Get the LSB
		INC	HL
		LD	D,(HL)		;Get the MSB
		LD	A,(ADFLAG)	;Check the flag
		OR	A
		JR	Z,SHOW_5
;
		PUSH	HL
		LD	HL,(OLDADDR)
		OR	A
		SBC	HL,DE
		POP	HL
		JR	Z,SHOW_7
;
		CALL	DASH
		PUSH	DE
		PUSH	BC
		LD	DE,(OLDADDR)
		DEC	DE
		CALL	HEXOUT
		LD	C,13
		SVC	@DSP
		POP	BC
		POP	DE
SHOW_5:
		CALL	HEXOUT
SHOW_7:
		EX	DE,HL
		ADD	HL,BC
		EX	DE,HL
		LD	(OLDADDR),DE
		LD	A,1
		LD	(ADFLAG),A
		LD	BC,4
		ADD	HL,BC
		LD	BC,(ENDLIST)	;Check for end
		OR	A		;Reset carry
		PUSH	HL		;Save current address
		SBC	HL,BC
		POP	HL
		JR	Z,SHOW_13
;
;
;
		PUSH	DE
		PUSH	HL
		SVC	@KBD
		POP	HL
		POP	DE
		JR	NZ,SHOW_1
		CP	'`'
		JR	NZ,SHOW_1
		PUSH	HL
		PUSH	DE
		LD	BC,10000
		SVC	@PAUSE
SHOW_12:
		SVC	@KBD
		JR	Z,SHOW_12
		SVC	@KEY
		POP	DE
		POP	HL
		JR	SHOW_1
;
;
;
SHOW_13
		CALL	DASH
		LD	DE,(OLDADDR)
		DEC	DE
		CALL	HEXOUT
		LD	C,13
		SVC	@DSP
SHOW_15:
		POP	DE
		POP	HL
		POP	BC
		RET
;
;
;
SHOW_20:
		LD	HL,NOMODS
		SVC	@DSPLY
		JR	SHOW_15
;
;
;
DASH:
		PUSH	HL
		PUSH	DE
		PUSH	BC
		LD	HL,DASHES
		SVC	@DSPLY
		POP	BC
		POP	DE
		POP	HL
		RET
;
;
;
HEXOUT:
		PUSH	BC		;Save regs
		PUSH	HL
		PUSH	DE
		LD	HL,OUTBUF	;Get the buffer
		PUSH	HL		;Save the pointer
		SVC	@HEX16		;Convert DE to ASCII string
		LD	(HL),3		;Terminate with ETX
		POP	HL		;Get pointer back
		SVC	@DSPLY		;Display the contents
		POP	DE		;Restore registers
		POP	HL
		POP	BC
		RET			;Return 
;
;	Data area
;
UNKNOWN		DB	'Unknown record type, '
HEXBUF		DB	'  H, NRN: '
NRN		DB	'    H, Offset: '
OFFSET		DB	'  H, FCB+1: '
STATUS		DB	'  H, aborting',13
TAG6		DB	'PDS header: ',3
TAG7		DB	'Patch name: ',3
TAG5		DB	'Module name: ',3
TAG31		DB	'Copyright: ',3
FROMFILE	DB	0
FNAMMESG	DB	'Filename: ',3
FORMATERR	DB	'Load file format error',13
ENDLIST		DW	LISTTAB
BAD_POS		DB	'Can not position in load module',13
ENTMESS		DB	'Entry point: ',3
CLOSEMSG	DB	'Closed input file: ',3
NOTOPMSG	DB	'No input file is active!',13
FILEMSG		DB	'Current input file: ',3
NOMODS		DB	'No load modules found',13
DASHES		DB	' - ',3
CMDEXT		DB	'CMD',3
OLDADDR		DW	0
ADFLAG		DB	0
SEENISAM	DB	0
SEENPDS		DB	0
HAVEPDS		DB	0
ISAMLEN		DB	0
ISAMREC		DB	0
THISISAM	DB	'Found ISAM record number: '
PDSNUM		DB	'  H.  Load this entry? ',3
THISPDS		DB	'Load PDS member, "',3
TEMPBUF		DS	32
PDSPROMPT	DB	'"? ',3
PDSMEM		DB	0
ENDISAM		DB	'End of ISAM directory encountered!',13
OOPSISAM	DB	'Found end of ISAM with seeing beginning!',13
OOPSPDSEOF	DB	'Found end of PDS member without seeing '
		DB	'start!',13
ENDPDS		DB	'End of PDS directory!',13
OOPSPDS		DB	'Specified member not in PDS!',13
CURFILE		DS	40
INFCB		DS	32
INBUF		DS	256
FNBUF		DS	32
ENTADDR		DW	0
		DS	8
OUTBUF		DS	32
;
;	This should be at end in case of overflow
;
LISTTAB		DS	RECLEN*150
