;	ecisubs/asm
;
;	Display a character on the command line.
;
DISCHAR		EQU	$
		LD	C,A		;Save the character
		LD	A,(INS)		;Check for insert mode
		OR	A
		CALL	NZ,DOINSERT
		LD	A,C		;Get the character back
		LD	(HL),A		;Save the character
		INC	HL		;Move pointer
		CALL	CHROUT		;Display it
		LD	A,(MAX)		;Check right pos
		IFALT	B,DISCH_1	;Jump if not yet
;
		LD	(HL),0		;Terminate string
		LD	A,B		;Get the count
		LD	(MAX),A		;Save as new max
		LD	(ENDCMD),HL	;Save the position
DISCH_1		EQU	$
		RET
;
;	Insert a character into the input line
;
DOINSERT	EQU	$
		PUSH	HL		;Save the registers
		PUSH	BC
		PUSH	DE
		PUSH	AF
		EX	DE,HL		;Move HL to DE
		PUSH	BC		;Save the remaining count
		LD	HL,(CMDBUF)	;Get the start
		LD	A,(MAXCHR)	;Get count of bytes to move
		LD	C,A		;Make the count be 16 bits
		LD	B,0
		DEC	BC		;Move top back by one
		DEC	BC
		ADD	HL,BC		;Point to last
		LD	D,H
		LD	E,L		;Copy HL to DE
		POP	BC		;Get the count back
		LD	C,B		;Convert to value in BC
		XOR	A		;Zero B
		LD	B,A		;BC is 255 max
		OR	C		;Check for C equal to zero
		JR	Z,DOINS_1
;
		DEC	C		;Check for zero
		JR	Z,DOINS_1
;
		INC	DE		;Move dest one up
		LD	(HL),0		;Must have a zero byte terminator
		LDDR			;Move the line
		LD	B,4		;Save the cursor position
		SVC	@VDCTL
		PUSH	HL
		LD	A,15
		CALL	CHROUT		;Turn cursor off
		CALL	PRTSTR		;Print remaining command
		POP	HL		;Restore cursor pos
		LD	B,3		;Move cursor back
		SVC	@VDCTL
		LD	A,14		;Turn cursor back on
		CALL	CHROUT		;Out to *DO
		LD	A,(MAX)		;Get the max right position
		DEC	A		;Move one right
		IFA	0FFH,DOINS_1	;If too far then don't move end
		LD	(MAX),A		;Store new position
		LD	HL,(ENDCMD)	;Move end pointer up
		INC	HL		;By one...
		LD	(ENDCMD),HL	;Store new value
;
DOINS_1		EQU	$
		POP	AF		;Restore the registers
		POP	DE
		POP	BC
		POP	HL
		RET
;
;	Define a key.  A prompt is printed, and a key is read from the
;	keyboard to determine which key to define.  Following this,
;	a sequence of keys up to a BREAK are read as the definition
;	of the keystroke.
;
SETKEY		EQU	$
		LD	DE,KEYHELP	;Get the help message
		CALL	PRTSTR		;Display it
SETKEY_6	CALL	CONIN		;Get the character to define
		IFZ	SETKEY_6	;Loop until get one
		LD	(KEYNUM),A	;Save the number
		CALL	VERPRT		;Print the key desciptor
		LD	DE,STRHELP	;Get the next message
		CALL	PRTSTR		;Print that
		LD	HL,DATA		;Get the destination buffer
		LD	B,0		;Get the initial count
		PUSH	HL
SETKEY_7	CALL	CONIN		;Get a character
		IFZ	SETKEY_7	;Loop until got one
		POP	HL
		IFA	128,SETKEY_10	;If BREAK then stop
		LD	(HL),A		;Save the character
		PUSH	HL
		CALL	VERPRT		;Print the character
		INC	B		;Increment the count
		LD	A,255		;Check for end
		POP	HL
		IFA	B,SETKEY_10	;If too many keys then stop
		INC	HL		;Point to next location
		PUSH	HL
		JR	SETKEY_7	;Get another key
SETKEY_10	LD	A,B		;Save the length
		LD	(KEYLEN),A
		LD	HL,DATA		;Get the start
		LD	A,(KEYNUM)	;Get the key value
		CALL	DEFKEY		;Define the key
		LD	HL,ATNULL	;Reset the pointer
		LD	(KEYPOS),HL
		JP	ENTRY		;Do another command
;
;	Read a key from the keyboard
;
CONIN		EQU	$
		PUSH	HL		;Save the registers
		PUSH	BC
		PUSH	DE
		SVC	@KEY		;Get a key
		POP	DE		;Restore the registers
		POP	BC
		POP	HL
		RET			;Return to caller
;
;	Print a verbose representation of a character
;
VERPRT		EQU	$
		PUSH	HL		;Save the registers
		PUSH	BC
		IFAGE	' ',VER_2	;Jump if character not ctl char
VER_1		PUSH	AF		;Save the character
		LD	A,'^'		;Print a carrat first
		CALL	CHROUT		;Output it
		POP	AF		;Get the character back
		ADD	A,64		;Uncontrolify it
		AND	127		;Remove eighth bit for <DEL>
		JP	VER_20		;Output and return
VER_2		IFA	127,VER_1	;If <DEL> then process as ctl
		JP	C,VER_15	;If less that 127 then print it
;
;		Characters greater than 127 are printed as \nn, where
;		nn is the 2 digit hexidecimal number representing the
;		value of the character
;
		LD	C,A		;Save the character
		LD	A,'\'		;Get a leading \
		CALL	CHROUT		;Output it
		LD	A,C		;Get a copy of the character
		PUSH	BC		;Save the character
		SRL	A		;Shift right by 4
		SRL	A
		SRL	A
		SRL	A
		LD	C,A		;Put the character into BC
		LD	B,0
		LD	HL,HEXCH	;Get the characters
		ADD	HL,BC		;Index into them
		LD	A,(HL)		;Get the right character
		CALL	CHROUT		;Output it
		POP	BC		;Get the character back
		LD	A,C		;Get another copy
		AND	0FH		;Save bits 3-0
		LD	C,A		;Move A to BC as offset
		LD	B,0
		LD	HL,HEXCH	;Get base address
		ADD	HL,BC		;Index into right character
		LD	A,(HL)		;Get the character
		JR	VER_20
VER_15		EQU	$
		IFANOT	'\',VER_16
		CALL	CHROUT
		JR	VER_20
;
VER_16		EQU	$
		IFANOT	'^',VER_20
		CALL	CHROUT
VER_20		EQU	$
		CALL	CHROUT		;Output it, and return
		POP	BC
		POP	HL
		RET
;
;	Output a character to the screen
;
CHROUT		EQU	$
		PUSH	HL		;Save the registers
		PUSH	BC
		PUSH	DE
		LD	C,A		;Get the character to output
		SVC	@DSP		;Display it on screen
		POP	DE		;Restore the registers
		POP	BC
		POP	HL
		RET			;Back to caller
;
;	Compare 2 strings.  Their equality is returned in the flags.
;	Z status implies the strings are equal.  NZ,C,NC implies
;	that the strings are not equal, but (HL) > (DE) in the case
;	of a C status, and (HL) < (DE) in the case of a NC status.
;
STRCMP		EQU	$
		PUSH	HL		;Save the regs
		PUSH	DE
STRCMP_1	EQU	$
		LD	A,(DE)		;Get a character
		IFANOT	(HL),STRCMP_4	;Exit if not equal
		IFZ	STRCMP_4	;Return equal if end of string
		INC	HL		;Move pointers forward
		INC	DE
		JR	STRCMP_1	;Loop until done
;
STRCMP_4	EQU	$
		POP	DE		;Restore regs
		POP	HL
		RET
;
;	Get the current key mappings.  Call this routine with HL
;	initially zero, and then non-zero every time after that
;	This routine must be called 256 times to get all of the
;	definitions.  DE should point to a buffer to hold the definition
;	string.  The string will be terminated with a zero byte,
;	followed by a one byte, until there are no keys left.
;	Then, the buffer will contain 2 zero bytes.
;
GETMAP		EQU	$
		LD	A,H		;See if should start over
		OR	L
		JR	NZ,GETMAP_1	;Jump if not
		LD	HL,KEYTABLE	;Reset the pointer
		LD	(CURDEF),HL
GETMAP_1	EQU	$
		LD	HL,(CURDEF)	;Get the current pointer
		PUSH	HL		;Save the current
		LD	BC,KEYTABLE+512	;Get the end
		OR	A		;Reset carry for subtract
		SBC	HL,BC		;Compute remaining
		POP	HL		;Reset pointer
		JP	Z,GETMAP_6	;Jump if at end
		PUSH	DE		;Save the destination
		LD	E,(HL)		;Get the LSB
		INC	HL		;Point to MSB
		LD	D,(HL)		;Get that
		INC	HL		;Point to next
		LD	(CURDEF),HL	;Save that pointer
		LD	A,D
		OR	E
		POP	HL		;Restore destination into HL
		EX	DE,HL		;Swap DE and HL
		JR	Z,GETMAP_4	;Jump if DE is NULL
GETMAP_3	EQU	$
		LDI			;Move a byte
		LD	A,(HL)		;Check for end
		IFNZ	GETMAP_3	;Jump if not at end
GETMAP_4	EQU	$
		XOR	A		;Clear A
		LD	(DE),A		;Store the EOF byte
		INC	DE		;Point to next
		INC	A		;Make A non-zero
		LD	(DE),A		;Store not end marker
		RET			;Back to caller
;
GETMAP_6	EQU	$
		XOR	A		;Clear A
		LD	(DE),A		;Store eof marker
		INC	DE		;Point forward
		LD	(DE),A		;Terminate for real
		RET
;
;	Get the next character from the keyboard, or definition
;	string.
;
GETKEY		EQU	$
		LD	HL,(KEYPOS)	;Get the buffered keys address
		LD	A,(HL)		;Get the key there
		IFZ	GETKEY_1	;Jump if no key available
		INC	HL		;Point to next
		LD	(KEYPOS),HL	;Save the new pointer
		JR	GETKEY_2	;Translate it
GETKEY_1	EQU	$
		CALL	POPKP		;Pop a KEYPOS value
		JR	NZ,GETKEY	;Jump if not end of stack
;
;	We must move the pointer back to ATNULL otherwise key definition
;	changes may leave a non-zero byte at the address pointed to by
;	(HL)
;
		SVC	@KEY		;Get a key for the keyboard
		RET	NZ		;Return if nothing there
;
GETKEY_2	EQU	$
		LD	(SAVEDKEY),A	;Save it for later use
		CALL	KEYTRANS	;Get the address from the table
		OR	H		;A holds L, OR in H to check
		JR	NZ,GETKEY_3	;Jump if string is present
		LD	A,(SAVEDKEY)	;Get the real key back
		CP	A		;Set Z status
		RET			;Return the key
;
GETKEY_3	EQU	$
		CALL	PUSHKP		;Push the current KEYPOS
		JR	Z,GETKEY_4	;Jump if push fails
		LD	(KEYPOS),HL	;Save the new position
		JR	GETKEY		;Restart processing loop
;
GETKEY_4	EQU	$	
		LD	DE,BIGKP	;Print message
		CALL	PRTSTR
		XOR	A		;Reset all values to force
		LD	(KPCNT),A	;the keyboard to be scanned
		LD	HL,KPSTK	;on the next call
		LD	(CURKP),HL
		LD	HL,ATNULL
		LD	(KEYPOS),HL
		INC	A		;Set NZ status
		RET			;Return to caller
;
;	Push the current KEYPOS value
;
PUSHKP		EQU	$
		PUSH	HL		;Save the registers
		PUSH	BC
		LD	A,(KPCNT)	;Get the counter
		IFA	MAXKP,PUSHKP_8	;Jump if stack too deep
		INC	A
		LD	(KPCNT),A	;Save the new value
		LD	HL,(CURKP)	;Get the pointer
		LD	BC,(KEYPOS)	;Get the current value
		LD	(HL),C		;Save the LSB
		INC	HL		;Point to MSB
		LD	(HL),B		;Save MSB
		INC	HL
		LD	(CURKP),HL	;Save the new pointer
		OR	1		;Set NZ status
PUSHKP_8	EQU	$
		POP	BC		;Restore the registers
		POP	HL
		RET
;
;	Pop a new KEYPOS from the stack, or return underflow
;
POPKP		EQU	$
		LD	A,(KPCNT)	;Get the number of pushes
		OR	A		;Check for underflow
		RET	Z		;Return if stack underflows
		PUSH	HL		;Save the registers
		PUSH	BC
		LD	HL,(CURKP)	;Get the stack pointer
		DEC	HL		;Point back to previous MSB
		LD	B,(HL)		;Get the MSB
		DEC	HL		;Point back to LSB
		LD	C,(HL)		;Get the LSB
		LD	(CURKP),HL	;Save the new top pointer
		LD	(KEYPOS),BC	;Store the new KEYPOS
		DEC	A		;Decrement push count
		LD	(KPCNT),A	;Save it
		OR	1		;Set NZ status
		POP	BC		;Restore registers
		POP	HL
		RET			;Back to caller
;
;		Store a key definition into the table
;
DEFKEY		EQU	$
		LD	(KEYSTRING),HL	;Save the pointer to the data
		LD	(KEYNUMBER),A	;Save the key to be replaced
		PUSH	AF
		LD	A,B		;Get the number of bytes in (HL)
		LD	(STRINGLEN),A	;Store it
		POP	AF
		CALL	KEYTRANS	;Get the address of the current
		OR	H		;definition and see if one exists
		CALL	NZ,DELETEKEY	;If so, then remove it
		LD	A,(STRINGLEN)	;Get the length
		OR	A		;Is there a string there?
		RET	Z		;Return if none.  Old was deleted
		LD	HL,DEFTABLE+DEFTLEN-1;Get the top of the table
		LD	DE,(TOPADDR)	;Get the start of available
		OR	A		;Reset carry
		SBC	HL,DE		;Compute available number bytes
		LD	C,A		;Get the request size as 16 bits
		LD	B,0
		OR	A		;Reset the carry
		SBC	HL,BC		;Compute the remaining after use
		JR	NC,DEFKEY_1	;Jump if there is room for it
		LD	DE,NOSPACE	;Print the error message
		CALL	PRTSTR
		RET			;Return without defining it
DEFKEY_1	EQU	$
		LD	HL,(KEYSTRING)	;Get the new definition
		PUSH	DE		;Save the address to store at
		LDIR			;Move the string
		EX	DE,HL		;Get the ending address
		LD	(HL),0		;Put a NULL in
		INC	HL		;Point to next available
		LD	(TOPADDR),HL	;Save the new available address
		POP	DE		;Restore the definition address
		LD	HL,(TABLEADDR)	;Get the address in the table
		LD	(HL),E		;Store the LSB
		INC	HL		;Point to the MSB
		LD	(HL),D		;Save the MSB
		RET			;Return to the caller
;
;	Get the address of the string corresponding to the key number
;	in A.  A holds the value of H on return.  HL is zero if no
;	definition exists.  HL is the address of the string that is
;	defined for the key if it is non-zero.  The last byte in the
;	string is followed by a zero byte.
;
KEYTRANS	EQU	$
		LD	HL,KEYTABLE	;Get the pointer table
		LD	C,A		;Put it into C
		LD	B,0		;Set B to zero initially
		RLC	C		;C = C * 2
		JR	NC,KEYTRANS_1	;If carry on shift then c > 127,
		INC	B		;so increment B to recover bit 7
KEYTRANS_1	EQU	$
		RES	0,C		;Reset the LSB of C.
		ADD	HL,BC		;Compute the table address
		LD	(TABLEADDR),HL	;Save the address of the key def
		LD	A,(HL)		;Get the LSB
		INC	HL		;Point to the MSB
		LD	H,(HL)		;Get it
		LD	L,A		;Get the LSB
		RET			;Return to caller
;
;	Delete a key definition from the table.  No parameters are
;	needed.  The key to undefine is pointed to by (TABLEADDR)
;
DELETEKEY	EQU	$
		LD	HL,(TABLEADDR)	;Get the addr of the definition
		LD	E,(HL)		;Get the LSB of the string
		LD	(HL),0		;Zap the LSB
		INC	HL		;Point to the MSB
		LD	D,(HL)		;Get the MSB
		LD	(HL),0		;Zap the MSB
		LD	(CMPADDR),DE	;Save the address for compares
		LD	H,D		;Copy DE to HL
		LD	L,E
		XOR	A		;Byte to look for
		CPIR			;Look for it
		PUSH	HL		;Save the ending address
		OR	A		;Reset the carry
		SBC	HL,DE		;Compute the difference
		LD	(MOVEDIFF),HL	;Save the difference
		LD	HL,(TOPADDR)	;Get the end of the table
		POP	BC		;Get the end of string to delete
		OR	A		;reset the carry
		SBC	HL,BC		;Calculate number bytes to move
		PUSH	BC		;Exchange HL and BC
		PUSH	HL
		POP	BC
		POP	HL
		LD	A,B		;Check for zero length
		OR	C
		JR	Z,DELETEKEY_1	;Don't move 65536 bytes
		LDIR			;Adjust the strings down
DELETEKEY_1	EQU	$
		LD	(TOPADDR),DE	;Set the new top address
		LD	HL,KEYTABLE	;Get start of table
		LD	B,0		;Check 256 entrys
DELETEKEY_2	EQU	$
		PUSH	BC		;Save the counter
		LD	C,(HL)		;Get the table value LSB
		INC	HL		;Point to MSB
		LD	B,(HL)		;Get the MSB
		DEC	HL		;Back to original address
		LD	A,B		;Check for any definition
		OR	C		;Set the flags
		JR	Z,DELETEKEY_4	;Skip this entry
		PUSH	HL		;Save the table address
		LD	HL,(CMPADDR)	;Get the address to check against
		OR	A		;Reset the carry
		SBC	HL,BC		;Compute the difference
		JP	P,DELETEKEY_3	;Jump if no adjust needed
		LD	H,B		;Copy BC to HL
		LD	L,C
		LD	BC,(MOVEDIFF)	;Get the difference
		OR	A		;Reset the carry
		SBC	HL,BC		;Adjust the pointer
		LD	C,L		;Copy HL to BC
		LD	B,H		;Get the MSB
		POP	HL		;Get the destination address
		LD	(HL),C		;Store the LSB back
		INC	HL		;Point to MSB
		LD	(HL),B		;Store the MSB
		JR	DELETEKEY_5	;Join other code
DELETEKEY_3	EQU	$
		POP	HL		;Get the table address back
DELETEKEY_4	EQU	$
		INC	HL		;Point to next table pos
DELETEKEY_5	EQU	$
		INC	HL		;One more increment
		POP	BC		;Get the counter back
		DJNZ	DELETEKEY_2	;Loop until done
		RET
;
;	Print the EOS terminated string pointed to by DE
;
PRTSTR		EQU	$
		PUSH	BC
PRT_1		EQU	$
		LD	A,(DE)
		IFZ	PRT_2
		CALL	CHROUT
		INC	DE
		JR	PRT_1
PRT_2		EQU	$
		POP	BC
		RET
