;		eciparse/asm
;
ATEOF		EQU	01CH		;TRSDOS end of file
NUMPDS		EQU	40
MEMLEN		EQU	14
PDSLEN		EQU	16
PDSENTRYLEN	EQU	32
;
PARSE		EQU	$
		PUSH	HL
		LD	DE,INPDSFCB
		PUSH	DE		;Save the start
		SVC	@FSPEC		;Convert and move it
		POP	HL		;Get starting address back
		CALL	FNLENGTH	;Get the length in BC
		ADD	HL,BC		;Compute the end
		LD	(HL),EOS	;Terminate it
		POP	HL		;Get the original address back
		LD	DE,PARSETAB	;Get the parse table
		EX	DE,HL		;Swap the 2 pointers
		LD	(OLDSTART),DE	;Save start of string
PARSE_1		EQU	$
		LD	A,(DE)		;Get a character
		CALL	UPCASE		;Convert to uppercase
		IFANOT	(HL),PARSE_4	;Jump if no match
		INC	DE		;Increment command pointer
		INC	HL		;Increment parse table pointer
		LD	A,(HL)		;Check for end
		IFANOT	' ',PARSE_1	;Check for table end, jump if not
		LD	A,(DE)		;Make sure it is end of command
		IFAGE	' '+1,PARSE_4	;Jump if at a separator
		INC	HL		;Point to type
		LD	(CMDEND),DE	;Save address of end of command
		LD	A,(HL)		;Get the type
		CP	A		;Get builtin offset number
		RET			;Return it and Z status
;
PARSE_4		EQU	$
		LD	DE,0
OLDSTART	EQU	$-2
		LD	BC,0		;Get enough count
		LD	A,SEPAR		;Get the command separator
		CPIR			;Move pointer forward
		IFANOT	(HL),PARSE_1	;Jump if not end of table
		LD	A,1		;Get none zero
		OR	A		;Set NZ status
		RET			;Return to caller
;
;	Check if string in INPDSFCB is in the PDS->MEMBER table
;
CHECK_PDS:
		CALL	PDS_FIND	;Check if the entry is there
		LD	(PDSENTRY),HL	;Save address of entry
		RET			;Return the Z or NZ status
;
;	Perform the string substitution to turn a PDS member reference
;	into the PDS(MEMBER) notation.
;
ADD_PDS_SPEC:
		LD	HL,(PDSENTRY)	;Get the address of entry
		INC	HL		;Move to data
		PUSH	HL		;Save the pointer
		LD	DE,TMPBUFF	;Get temporary buffer
		CALL	MOVE2EOS	;Copy bytes to EOS
		POP	HL		;Get buffer back
		LD	BC,PDSLEN	;Get the offset to member name
		ADD	HL,BC
		EX	DE,HL		;Put pointer back into HL
		LD	(HL),'('	;Put in member
		INC	HL
		EX	DE,HL
		CALL	MOVE2EOS
		EX	DE,HL
		LD	(HL),')'
		INC	HL		;Plus a separator
		LD	(HL),' '
		INC	HL
		EX	DE,HL		;Now add the rest of the line
		LD	HL,(CMDBUF)	;Get start of command
		CALL	SKIP2SPACE	;Skip to separator
		CALL	MOVE2EOS
		XOR	A
		LD	(DE),A		;End the string with EOS
		LD	DE,(CMDBUF)
		LD	HL,TMPBUFF	;Get the source buffer
		CALL	MOVE2EOS
		RET
;
;
;
MOVE2EOS:
		LD	A,(HL)		;Get the source character
		CP	EOS		;Check for EOS
		RET	Z		;Return if found it
		PUSH	BC		;Save BC
		LDI			;Move a character
		POP	BC		;Restore BC
		JR	MOVE2EOS	;Loop on
;
;	Skip pointer to next character less than or equal to a space.
;
SKIP2SPACE:
		LD	A,' '		;Get a space
SKIP2SPACE_1:
		CP	(HL)		;Check for space character
		RET	NC		;Return if space or less
		INC	HL		;Point to next
		JR	SKIP2SPACE_1	;Loop on
;
;	Convert the character in A to upper case
;
UPCASE		EQU	$
		CP	'a'		;Less than 'a'
		RET	C		;Return if so
		CP	'z'+1		;Greater than 'z'?
		RET	NC		;Return if so
		SUB	' '		;Make upper case
		RET			;Return the character
;
;	This routine handles the builtin commands
;
BUILTIN		EQU	$
		DEC	A		;Make zero based
		LD	C,A		;Put it into BC as 16 bits
		LD	B,0
		LD	HL,JUMPTAB	;Get the table
		ADD	HL,BC		;Add 3 times to get HL=HL+(BC*3)
		ADD	HL,BC
		ADD	HL,BC
		JP	(HL)		;Branch to jump table 
;
JUMPTAB		EQU	$
		JP	DOEXIT
		JP	DOQUIT
		JP	DODEF
		JP	DOSHOW
		JP	DOCLS
		JP	DOPROMPT
		JP	DOMORE
		JP	DOINPDS
		JP	DOLOADKEY
		JP	DOSAVEKEY
		JP	DOTAKE
		JP	DOECHO
;
;	Change the echo flag, or echo a line of text to the screen
;
DOECHO:
		LD	HL,(CMDEND)
		CALL	SKIP_BLANKS
		LD	(CMDEND),HL
		PUSH	HL
		POP	IX
		LD	A,(IX)
		CALL	UPCASE
		IFANOT	'O',ECHO_6
		LD	A,(IX+1)
		CALL	UPCASE
		IFANOT	'N',ECHO_3
		LD	A,(IX+2)
		IFAGE	' ',ECHO_6
		LD	A,1
		LD	(ECHOFLG),A
		JR	ECHO_8
ECHO_3:
		IFANOT	'F',ECHO_6
		LD	A,(IX+2)
		CALL	UPCASE
		IFANOT	'F',ECHO_6
		LD	A,(IX+3)
		IFAGE	' ',ECHO_6
		XOR	A
		LD	(ECHOFLG),A
		JR	ECHO_8
;
ECHO_6:
		LD	HL,(CMDEND)
		SVC	@DSPLY
ECHO_8:
		JP	ENTRY
;
;	Set up to take commands from a file
;
DOTAKE:
		XOR	A
		LD	(DONEINI),A	;Signal routine to execute file
		LD	HL,(CMDEND)	;Get ending data
		CALL	SKIP_BLANKS	;Skip blanks
		JR	Z,TAKE_USE
		LD	DE,INITFCB
		SVC	@FSPEC
		JR	Z,TAKE_1
		LD	A,19		;Get illegal filename code
		JR	TAKE_2		;Go do error
TAKE_1:
		LD	HL,INIEXT
		SVC	@FEXT		;Add the /INI extension
		LD	A,1		;Set the take file active flag
		LD	(TAKEACT),A
		JP	ENTRY
TAKE_2:
		OR	0C0H		;Set the short message flag
		LD	C,A
		LD	A,2		;Get the done flag
		LD	(DONEINI),A	;Store it
		SVC	@ERROR		;Print the error message
		JP	ENTRY
;
TAKE_USE:
		LD	HL,TAKE_USAGE
		SVC	@DSPLY
		LD	A,2
		LD	(DONEINI),A
		JP	ENTRY
;
;	Clear screen
;
DOCLS		EQU	$
		LD	C,28		;Move to top of screen
		SVC	@DSP
		LD	C,31		;Clear to end of screen
		SVC	@DSP
		JP	ENTRY		;Restart line input
;
;	Exit from the ECI, leaving it in tack for later rentry
;
DOEXIT		EQU	$
		SVC	@FLAGS
		XOR	A
		LD	(IY+EFLAG$),A	;Reset the ECI bit
		LD	IX,(CMDBUF)
		SET	EXIT,(IX-1)
		LD	HL,EXITMES
		SVC	@DSPLY
		JP	OUT
;
;	Exit from the ECI for good, the sys13 overlay will free
;	this bank for reuse.
;
DOQUIT		EQU	$
		SVC	@FLAGS		;Get the flags
		XOR	A		;Turn the ECI off
		LD	(IY+EFLAG$),A
		LD	IX,(CMDBUF)	;Get the arg buffer address
		SET	QUIT,(IX-1)	;Set the QUIT bit
		LD	HL,QUITMES
		SVC	@DSPLY
		JP	OUT		;Return to caller
;
DODEF		EQU	$
		JP	SETKEY		;Go set the key definition
;
;	Print usage message for MORE
;
MORE_USE:
		LD	DE,MORE_USAGE
		CALL	PRTSTR
		JP	ENTRY
;
;	Do the MORE builtin command
;
DOMORE		EQU	$
		LD	HL,(CMDEND)	;Get the start of args
		CALL	SKIP_BLANKS	;Skip white space
		JP	Z,MORE_USE
;
		LD	IX,(CMDBUF)	;Get arg vector address
		LD	E,(IX-3)	;Get FCB address from vector
		LD	D,(IX-2)
		LD	(FCB),DE
		PUSH	DE		;Save it
		PUSH	HL		;Save current pointer
		LD	L,(IX-5)	;Get BUFFER address from vector
		LD	H,(IX-4)
		EX	(SP),HL		;Exchange with source for FSPEC
		SVC	@FSPEC		;Move FILESPEC to FCB
		POP	HL		;Get args from stack
		POP	DE
		JP	NZ,MORE_ERR
		LD	B,0		;Select LRL of 256
		SVC	@OPEN		;Try to open the file
		JP	NZ,MORE_ERR
;
;	file is open, read it and count the lines etc...
;
		LD	DE,(FCB)	;Get the DCB
		SVC	@GET		;Get the first character
		LD	B,8		;Select initial 8 character tabs
		SELECT	'/',4		;C comment? 4 character tabs
		SELECT	'#',4		;C #include? 4 character tabs
		PUSH	AF		;Save the character
		LD	A,B		;Get the selected value for tab
		LD	(TABLEN),A	;Save it
		LD	B,22		;22 lines at a time
		POP	AF		;Restore the character
		CP	A		;Set Z status for below
		PUSH	BC
		JR	MORE_2A
MORE_2:
		PUSH	BC
		LD	DE,(FCB)
		SVC	@GET
MORE_2A:
		LD	(LASTCH),A	;Save the last character
		POP	BC
		JR	NZ,MORE_EOF
		IFANOT	9,MORE_2B
		LD	C,A
		PUSH	BC
		LD	B,4
		SVC	@VDCTL		;Get the cursor position
		LD	E,L
		LD	A,(TABLEN)
		LD	C,A
		SVC	@DIV8
		LD	A,(TABLEN)
		SUB	E
		LD	B,A
MORE_2AA:
		LD	C,' '
		SVC	@DSP
		DJNZ	MORE_2AA	;Display spaces to end
		JR	MORE_2BA
MORE_2B:
		LD	C,A
		PUSH	BC
		SVC	@DSP
MORE_2BA:
		POP	BC
		LD	A,C
		IFANOT	CR,MORE_2	;Jump in time for a newline
		DJNZ	MORE_2		;Decrement line count and check
;
;	At end of page, so display prompt, and wait
;
		LD	HL,MOREPROMPT
		SVC	@DSPLY		;Display the prompt
MORE_2D:
		SVC	@KEY		;Get a key
		IFANOT	CR,MORE_2E
		LD	B,1
		JR	MORE_2H
MORE_2E:
		IFANOT	32,MORE_2F
		LD	B,22
		JR	MORE_2H
MORE_2F:
		IFA	'q',MORE_2G
		IFA	'Q',MORE_2G
		IFANOT	128,MORE_2D
MORE_2G:
		LD	A,0
		JR	MORE_EOF	;Close and quit on break
;
MORE_2H:
		LD	C,29		;Carriage return on screen
		SVC	@DSP
		LD	C,30		;Erase to end of line
		SVC	@DSP
		JR	MORE_2		;Get more input
;
MORE_EOF:
		PUSH	AF		;Save A
		LD	DE,(FCB)	;Get the FCB
		SVC	@CLOSE		;Close the file
		POP	AF		;Get A back
		OR	A		;Check for zero
		JR	Z,MORE_4	;If a is zero, then no error
		IFANOT	ATEOF,MORE_ERR	;If not AT EOF error then jump
MORE_4:
		LD	C,29
		SVC	@DSP
		LD	C,30
		SVC	@DSP
		LD	A,(LASTCH)	;Check if last character was cntl
		IFALT	32,MORE_5	;If control character then jump
		LD	C,CR		;Print a new line
		SVC	@DSP
MORE_5:
		JP	ENTRY		;Jump to top of ECI
MORE_ERR:
		OR	0C0H
		LD	C,A
		SVC	@ERROR
		JP	ENTRY
;
;	Do the INPDS command
;
DOINPDS		EQU	$
		LD	HL,(CMDEND)	;Get the start of args
		CALL	SKIP_BLANKS	;Skip white space
		JP	Z,INPDS_USE	;Jump if end of line found
		LD	A,(HL)		;Check for curious user
		CP	'?'
		JP	Z,SHOW_PDS
;
;	Copy the pds name
;
		LD	DE,PDSNAME	;Get the destination
		SVC	@FSPEC		;Move FILESPEC to FCB
		JP	NZ,MORE_ERR	;Jump if @FSPEC error
;
		LD	(CMDEND),HL	;Save next parse position
		LD	A,(HL)		;Get the terminating character
		CP	' '		;If less than space jump
		JP	C,INPDS_DELETE	;to do delete a reference
;
;	Copy member name
;
		CALL	SKIP_BLANKS	;Skip white space
		LD	DE,INPDSFCB	;Destination for member name
		PUSH	DE		;Save the start
		SVC	@FSPEC		;Move it
		POP	HL		;Get the start
		JP	NZ,MORE_ERR	;Jump if conversion error
		CALL	FNLENGTH	;Get the length of member name
		ADD	HL,BC		;Compute ending address
		LD	(HL),EOS	;Terminate the string for FIND
		CALL	PDS_FIND	;Look for a duplicate
		JR	NZ,INPDS_1	;Jump if not one
;
		CALL	PDS_REPLACING	;Print replacing message
		INC	HL		;Point to name space
		EX	DE,HL		;Put slot address into DE
		JR	INPDS_2		;Join code
;
INPDS_1:
		CALL	AVAIL_PDS	;Get the next available in DE
		JP	NZ,NO_PDS_SPACE	;Go print message if no space
INPDS_2:
		LD	HL,PDSNAME	;Get the start of name
		CALL	FNLENGTH	;Get the length in BC
		PUSH	DE		;Save DE
		LDIR			;Move the string
		EX	DE,HL		;Put pointer into HL
		LD	(HL),EOS	;Terminate the string
;
		POP	HL		;Get start of dest back
		LD	BC,PDSLEN	;Point ahead to member name
		ADD	HL,BC		;Get start of name space
		EX	DE,HL		;Swap position back into DE
		LD	BC,MEMLEN	;Get max name length for member
		LD	HL,INPDSFCB	;Get the address of the member
INPDS_3:
		LD	A,(HL)		;Check for space
		IFALT	' '+1,INPDS_4
		CALL	UPCASE
		LD	(HL),A
		LDI
		LD	A,B
		OR	C
		JR	NZ,INPDS_3
;
INPDS_4:
		XOR	A
		LD	(DE),A		;Terminate the string
;
		JP	ENTRY
;
;
;
INPDS_ERR:
		LD	DE,INPDSERR
		CALL	PRTSTR
		JP	ENTRY
;
NO_PDS_SPACE	EQU	$
		LD	DE,PDS_NOSPACE
		CALL	PRTSTR
		JP	ENTRY
;
;	Print the how to do it message
;
INPDS_USE:
		LD	DE,INPDS_USAGE
		CALL	PRTSTR
		JP	ENTRY
;
;	Delete the a member=>pds reference from the table
;
INPDS_DELETE	EQU	$
		LD	HL,PDSNAME	;Get the source
		LD	DE,INPDSFCB	;Get the destination
		PUSH	DE		;Save it
		LD	BC,32		;Max bytes
		LDIR			;Move the string
		POP	HL		;Get FCB address back
		CALL	FNLENGTH	;Length is now in BC and HL
		ADD	HL,BC		;Compute address of end of FCB
		LD	(HL),0		;Terminate the string
		CALL	PDS_FIND	;See if entry exists
		JR	Z,INPDS_FOUND	;Jump if found
;
;	Didn't find the entry, so print a message
;
		LD	DE,NOPDS	;Get the message
		CALL	PRTSTR		;Print it
		JP	ENTRY		;Restart ECI
;
;	Found the entry.  Mark it as available, and print some info
;	about the reference.
;
INPDS_FOUND:
		XOR	A		;Zero A
		LD	(HL),A		;Mark it as available
		INC	HL		;Point to PDS name
		PUSH	HL		;Save the address
		LD	BC,PDSLEN	;Move ahead to member
		ADD	HL,BC
		LD	DE,INIPDSDEL	;Get the initial message
		CALL	PRTSTR		;Print it
		EX	DE,HL		;Get the member name into DE
		CALL	PRTSTR		;Print it
		LD	DE,PDS_SEPAR	;Print the separator message
		CALL	PRTSTR
		POP	DE		;Get the PDS name back
		CALL	PRTSTR		;Print it
		LD	DE,DELMESS	;Get the ending message
		CALL	PRTSTR
		JP	ENTRY
;	Look for the member name specified in INPDSFCB in the table.
;	If found, return the address of the entry.
;
PDS_FIND:
		LD	DE,INPDSFCB	;Get the start
		LD	HL,INPDS_TAB	;Get the start of the table
PDS_FIND_1:
		LD	A,(HL)		;Check if used spot
		INC	HL		;Point past avail byte
		OR	A		;Check if in use
		JR	Z,PDS_FIND_2	;Jump if not in use
		PUSH	HL		;Save pointer
		LD	BC,PDSLEN	;Get length of first field
		ADD	HL,BC		;Move to member field
		PUSH	DE
		CALL	PDS_CMP		;Check if equal
		POP	DE		;Restore string
		POP	HL		;Restore pointer
		JR	Z,PDS_FIND_3	;Jump if found it
PDS_FIND_2:
		LD	BC,PDSENTRYLEN-1;Point to next
		ADD	HL,BC
		PUSH	HL		;Save the address
		OR	A		;Reset the carry
		LD	BC,INPDS_END	;Get the ending address
		SBC	HL,BC		;Check if at the end yet
		POP	HL		;Restore the spot
		JR	C,PDS_FIND_1	;Jump if not done
;
		LD	A,1
		OR	A
		RET			;Return NZ status
;
PDS_FIND_3:
		DEC	HL		;Point to start
		XOR	A		;Return Z status
		RET			;Return Z status
;
;	Print message about replacing PDS reference
;
PDS_REPLACING:
		PUSH	HL		;Save the regs
		PUSH	DE
		PUSH	BC
		LD	DE,INI_REP	;Print initial message
		CALL	PRTSTR
		CALL	PRINT_PDS
		POP	BC
		POP	DE
		POP	HL
		RET
;
PRINT_PDS:
		PUSH	HL		;Save the regs
		PUSH	DE
		PUSH	BC
		INC	HL		;Point to start of data
		PUSH	HL
		EX	DE,HL		;Put it into DE
		CALL	PRTSTR		;Print PDS name
		LD	C,'('
		SVC	@DSP
		POP	HL		;Restore start
		LD	BC,PDSLEN	;Move to member field
		ADD	HL,BC
		EX	DE,HL		;Put address into DE
		CALL	PRTSTR		;Print that
		LD	C,')'
		SVC	@DSP
		LD	C,CR
		SVC	@DSP
		POP	BC
		POP	DE
		POP	HL
		RET			;Return
;
;	Compare the two EOS terminated strings pointed to by HL and DE
;	return their equality with Z status or inequality with NZ status.
;
PDS_CMP:
		LD	A,(DE)		;Get the byte at DE
		CALL	UPCASE		;Upper case it
		CPI			;Compare against the byte at HL
		RET	NZ		;Return if not equal
		CP	EOS		;Check for EOS
		RET	Z		;Return if AT EOS
		INC	DE		;Point to next at DE
		JR	PDS_CMP		;Loop
;
;	Initialize the PDS entries as being available only once
;
INIT_PDS	EQU	$
		LD	A,(PDSINIT)	;Check if already done
		OR	A		;Check if flag set
		RET	NZ		;Return if already done
		DEC	A		;Change to 0ffh
		LD	(PDSINIT),A	;Set the done flag
		PUSH	HL		;Save the registers
		PUSH	BC
		PUSH	DE
		LD	HL,INPDS_TAB	;Get the table start
		LD	DE,INPDS_TAB+1
		LD	BC,INPDS_END-INPDS_TAB-1
		LD	(HL),0
		LDIR
		POP	DE
		POP	BC
		POP	HL
		RET			;Return to caller
;
;	Get the next available location for a PDS entry
;
AVAIL_PDS	EQU	$
		LD	DE,INPDS_TAB	;Get the table start
AV_1:
		LD	A,(DE)		;Get the first byte of entry
		PUSH	BC		;Save BC
		LD	C,A		;Save it
		LD	A,1		;Set it to 1
		LD	(DE),A		;Done....
		LD	A,C		;Get the original back
		POP	BC		;Restore BC
		INC	DE		;Move to first used spot
		OR	A		;Check for zero (available)
		RET	Z		;Return if so
		PUSH	HL		;Save HL
		LD	H,D		;Copy DE to HL
		LD	L,E
		PUSH	BC		;Save BC
		LD	BC,PDSENTRYLEN-1;Get the next available offset
		ADD	HL,BC		;Point HL to it
		LD	BC,INPDS_END	;Get the ending address
		OR	A		;Reset CARRY
		PUSH	HL		;Save the value
		SBC	HL,BC		;Check difference
		POP	HL		;Restore it
		JR	NC,AV_4		;Jump at or past end
		POP	BC		;Restore BC
		EX	DE,HL		;Point new pointer into DE
		POP	HL		;Restore HL
		JR	AV_1		;Loop on
;
AV_4:
		POP	BC		;Restore the regs
		POP	HL
		LD	DE,0		;Set pointer to NULL
		LD	A,1		;Set NZ status
		OR	A
		RET			;Return to caller
;
;	Print all currently mapped pds entries
;
SHOW_PDS:
		LD	DE,PDSINFO	;Print info string
		CALL	PRTSTR
		LD	HL,INPDS_TAB	;Get start of string
SHOW_PDS_1:
		LD	A,(HL)		;Check in used
		OR	A
		JR	Z,SHOW_PDS_3
;
		CALL	PRINT_PDS
		PUSH	HL
		CALL	CHECK_PAUSE
		POP	HL
SHOW_PDS_3:
		LD	BC,PDSENTRYLEN
		ADD	HL,BC
		PUSH	HL
		LD	BC,INPDS_END
		OR	A
		SBC	HL,BC
		POP	HL
		JR	C,SHOW_PDS_1
		JP	ENTRY
;
;	Calculate the length of a filename based on the presence of
;	ETX at the end of the name which is pointed to by HL.  Length
;	is return in BC
;
FNLENGTH:
		LD	A,3		;Character to look for
		LD	BC,PDSLEN-1	;Maximum length
		PUSH	HL		;Save start
		PUSH	HL		;Plus another copy of it
		CPIR			;Look for the ETX character
		DEC	HL		;HL is one passed, so backup
		POP	BC		;Get start
		OR	A		;Reset the carry
		SBC	HL,BC		;Length is now in HL
		PUSH	HL		;Copy to BC
		POP	BC
		POP	HL		;Restore the start
		RET
;
;	Skip all white space pointed to by HL
;
SKIP_BLANKS:
		LD	A,' '
SKIP_1:
		CP	(HL)		;See if at a space
		INC	HL
		JR	Z,SKIP_1
;
		DEC	HL		;Back up
		LD	A,(HL)		;Check for ending CR
		CP	CR
		RET
;
;
;
CHECK_PAUSE	EQU	$
		PUSH	HL
		PUSH	BC
		PUSH	DE
		SVC	@FLAGS		;Get the flags
		LD	A,(IY+KFLAG$)	;Get the keys byte
		AND	2		;Is pause signaled
		JR	Z,CHECK_3	;Jump if not
CHECK_2:
		SVC	@KBD
		JR	Z,CHECK_2	;Jump while key still pressed
		SVC	@KEY		;Get just one key
		PUSH	AF
		LD	A,(IY+KFLAG$)	;Get the keys byte
		AND	0FDH		;Take off pause bit
		LD	(IY+KFLAG$),A	;Store new value
		POP	AF
		OR	A		;Set nz for return
		JR	CHECK_4
CHECK_3:
		SVC	@CKBRKC		;Check if break set
		LD	A,128		;Get break in case NZ set
CHECK_4:
		POP	DE
		POP	BC
		POP	HL
		RET
;
;	Showkey command
;
DOSHOW		EQU	$
		SVC	@CKBRKC		;Clear the break key
		LD	B,1		;Get the initial key number
SHOW_1		EQU	$
		CALL	CHECK_PAUSE	;Check for pause key
		JR	Z,SHOW_1A
		CP	128		;Was break pressed?
		JP	Z,ENTRY		;Restart with a new command
;
SHOW_1A:
		PUSH	BC
		LD	A,B		;Get the number
		CALL	KEYTRANS	;Translate the key number
		OR	H		;Test for zero
		JR	Z,SHOW_4	;Jump if no definition
		POP	BC		;Get the key number back
		PUSH	BC		;Put it back for later
		PUSH	HL		;Save string
		LD	A,B		;Get the value to convert
		LD	HL,DESCR	;Get the string
		CALL	KEYSEQ		;Get the descr
		LD	DE,DESCR	;Print the message
		CALL	PRTSTR
		LD	DE,DESCRARR
		CALL	PRTSTR
		POP	HL		;Restore string
SHOW_2		EQU	$		;Now print the definition
		LD	A,(HL)		;Get the character
		IFZ	SHOW_3		;Jump at end
		CALL	VERPRT		;Print the character
		INC	HL		;Point to next in buffer
		JR	SHOW_2		;Loop
;
SHOW_3		EQU	$
		LD	C,CR		;Get a newline
		SVC	@DSP		;Print it
SHOW_4		EQU	$
		POP	BC		;Restore keynumber
		INC	B		;Increment it
		JR	NZ,SHOW_1	;Jump if not at end
		LD	HL,DEFTABLE+DEFTLEN
		LD	BC,(TOPADDR)	;Calculate remaining space
		OR	A		;Reset the carry
		SBC	HL,BC		;Compute remaining space
		LD	DE,SPACSTR	;Get the message
		CALL	PRTSTR		;Print the description string
		LD	DE,DECBUF	;Get the buffer for number
		SVC	@HEXDEC		;Convert to printable
SHOW_6		EQU	$
		LD	A,(DE)		;Back up to first non-blank
		IFA	' ',SHOW_7	;At a space?  Jump if so.
		DEC	DE		;Back up
		JR	SHOW_6		;Loop
SHOW_7		EQU	$
		INC	DE		;Move forward to first non-blank
		CALL	PRTSTR		;Print the number
		JP	ENTRY		;Restart
;
;	Redefine the prompt shown to the user
;
DOPROMPT	EQU	$
		LD	DE,PROMPTMSG
		CALL	PRTSTR
		LD	DE,PROMPTBUF
DOPRM_1		EQU	$
		CALL	CONIN		;Get a key
		IFA	128,DOPRM_4	;Jump if break
		LD	(DE),A
		CALL	VERPRT		;Print it
		INC	DE
		JR	DOPRM_1
;
DOPRM_4		EQU	$
		XOR	A
		LD	(DE),A
		JP	ENTRY
;
;	Decipher a key definition into a string representation
;
;	Input:		HL buffer to hold key's name
;			A  key to decipher
;
KEYSEQ		EQU	$
		PUSH	BC		;Save registers
		PUSH	DE
		EX	DE,HL		;Put buffer into DE
		LD	H,D		;Copy DE to HL
		LD	L,E
		PUSH	DE		;Save the pointer
		INC	DE		;Move dest one ahead
		LD	BC,21		;Fill 22 bytes worth
		LD	(HL),' '	;Put in one space
		LDIR			;Copy to rest of places
		LD	(HL),0		;Put in zero terminator
		POP	DE		;Restore buffer address
		LD	C,A		;Get the key number
		LD	B,0		;Make it 16 bits, and mul by 2
		OR	A		;Reset the carry
		RL	C		;Multiply BC by 4
		RL	B		;Put carry into B
		OR	A		;Reset the carry
		RL	C
		RL	B
		LD	HL,KEYTAB	;Get the base table
		ADD	HL,BC		;Compute real address
		LD	A,(HL)		;Get the description byte
		BIT	7,A		;Check for SHIFT
		CALL	NZ,PUTSHIFT	;If so, but it in
		BIT	6,A		;Is it control?
		CALL	NZ,PUTCTRL	;If so put it in
		BIT	5,A		;Is it CLEAR
		CALL	NZ,PUTCLEAR	;if so put it in
		BIT	4,A		;Is it BREAK
		CALL	NZ,PUTBREAK	;If so, put it in
		BIT	3,A		;Is it space
		CALL	NZ,PUTSPACE	;If so, put it in
		BIT	0,A		;Is it ENTER?
		CALL	NZ,PUTENTER	;If so, put it in
		INC	HL		;Point to next flag byte
		LD	A,(HL)		;Get that byte
		BIT	0,A
		CALL	NZ,PUTUP
		BIT	1,A
		CALL	NZ,PUTDOWN	;If so, put it in
		BIT	2,A
		CALL	NZ,PUTLEFT
		BIT	3,A
		CALL	NZ,PUTRIGHT
		BIT	4,A
		CALL	NZ,PUTF3
		BIT	5,A
		CALL	NZ,PUTF2
		BIT	6,A
		CALL	NZ,PUTF1
		INC	HL		;Move to character
		LD	A,(HL)		;Check for no character
		IFZ	KEYSEQ_4	;Jump if none
		INC	DE		;Increment the pointer
		LDI			;Move normal character into buf
KEYSEQ_4	EQU	$
		POP	DE		;Restore registers
		POP	BC
		RET			;Return to caller
;
PUTSHIFT	EQU	$
		PUSH	HL
		PUSH	BC
		LD	HL,SHIFTSTR
		LD	BC,SHIFTLEN
PUTSHIFT_1	EQU	$
		LDIR
		POP	BC
		POP	HL
		RET
