;		ecimain/asm
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	An Extended Command Interpreter (ECI) for TRSDOS 6.2.x
;	By:	Gregg Wonderly
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
*GET		ECIMAC/ASM
;
MAXKP		EQU	30		;Maximum nested key defintions
MAXCMD		EQU	20		;Maximum history of commands
CR		EQU	13		;Carriage return character
EOS		EQU	0		;Terminator for strings
;
		ORG	8000H
;
;	This is the common data area that should be used by programs
;	wishing to use the ECI's functions.  These three words are
;	in a particular order, and should no be moved.  Additional
;	data should be added after that already here
;
ECILENOFF	EQU	$-8000H
		DW	TOTLEN		;Total length of initialized data
CURSOROFF	EQU	$-8000
LINECURS	DB	05FH		;Overstrike mode cursor
INSCURS		DB	0BFH		;Insert mode cursor
HISTBUFF	DW	BUFADDR		;Start of history buffer
STKSTART	DW	0		;Stack save area
DONEINI		DB	0		;Initialization is not done yet
;
;	Entry point to ECI.  This is the address at which the ECI should
;	be entered.  Note that the @BANK SVC should be used to transfer
;	control in order for proper return from the ECI.  It is
;	anticipated that DE will point to a buffer that should contain
;	the line of text entered.  Note that this buffer is accessed
;	directly, so it MUST lie below 8000H.
;
START		EQU	$
		LD	B,8
		LD	C,05FH
		SVC	@VDCTL
		LD	C,A
		LD	B,8
		LD	(LINECURS),A
		SVC	@VDCTL
		LD	(STKSTART),SP	;Save the stack pointer
		LD	(CMDBUF),DE	;Save the buffer
		LD	(RETADDR),HL	;Save return address
		LD	HL,(LASTCMD)	;Get last command pointer
		LD	A,H
		OR	L		;See if not set
		JR	NZ,LASTSET	;Last pointer is set
		LD	HL,(HISTBUFF)	;Get the end
		LD	(HL),0		;Say nothing there
		LD	(LASTCMD),HL	;Save it
LASTSET		EQU	$
		CALL	INIT_PDS	;Do one time initialization
		SVC	@FLAGS		;Get the flags
		LD	A,1		;Set EFLAG$ to always be there
		LD	(IY+EFLAG$),A
;
ENTRY		EQU	$
		LD	SP,(STKSTART)	;Get the stack pointer start
		LD	A,(DONEINI)	;Check if ECI/INI done yet
		CP	2		;Check for completed
		JP	Z,INI_DONE
		OR	A
		JR	NZ,INI_1
		LD	IX,(CMDBUF)
		LD	E,(IX-7)
		LD	D,(IX-6)
		LD	(INIFCB),DE
		PUSH	DE
		LD	HL,INITFCB
		LD	BC,32
		LDIR
		POP	DE
		LD	L,(IX-9)
		LD	H,(IX-8)
		LD	B,0
		SVC	@OPEN
		PUSH	AF
		LD	A,2		;Set completed in case no file
		LD	(DONEINI),A	;Set the flag
		POP	AF
		JR	NZ,INI_CHK	;Jump if file not opened
		LD	A,1		;Change to open and ready
		LD	(DONEINI),A	;Store it
INI_1:
		LD	HL,(CMDBUF)	;Get start of buffer to put into
INI_2:
		SVC	@CKBRKC		;Check for break
		JR	NZ,INI_CLOSE
		LD	DE,(INIFCB)	;Get FCB
		SVC	@GET		;Get a character
		JR	NZ,INI_CLOSE	;Close up on error
		LD	(HL),A		;Store the character
		INC	HL		;Point to next pos
		LD	(HL),EOS	;End with EOS
		CP	CR		;Check for end of line
		JR	NZ,INI_2		;Loop until CR or EOF
		JP	DO_A_CMD
;
INI_CLOSE:
		CP	28		;Check for eof
		JR	Z,INICL_1	;Jump if it is
		OR	0C0H		;Set short message code
		LD	C,A		;Put it into c
		SVC	@ERROR		;Print the message
INICL_1:
		LD	DE,(INIFCB)	;Get the FCB
		SVC	@CLOSE		;Close the file
		LD	A,2		;Set the completed flag
		LD	(DONEINI),A
		JP	ENTRY
;
INI_CHK:				;Check for possible error
		LD	C,A		;Get the error number
		LD	A,(TAKEACT)	;Check if take active
		IFZ	INI_DONE	;Jump if not
		XOR	A		;Reset the take active flag
		LD	(TAKEACT),A
		PUSH	BC
		LD	HL,(INIFCB)
		SVC	@DSPLY		;Print the filename
		LD	C,','
		SVC	@DSP
		LD	C,' '
		SVC	@DSP
		POP	BC
		SET	7,C		;Set the short message bits
		SET	6,C
		SVC	@ERROR		;Print the message
INI_DONE:
		SVC	@CKBRKC		;Clear break bit
		LD	DE,PROMPTBUF	;Get the command prompt
		CALL	PRTSTR
		XOR	A		;Reset the insert mode flag
		LD	(INS),A
		LD	HL,(HISTBUFF)
		LD	(CURCMD),HL
		CALL	INITMAX		;Initialize character count
;
LOOP_1		EQU	$
		PUSH	HL		;Save the regs
		PUSH	BC
		CALL	GETKEY		;Get a translated (maybe) key
		POP	BC		;Restore the regs
		POP	HL
		JR	NZ,LOOP_1	;Jump if none there
		IFANOT	8,L_1		;Jump if not back space
		LD	A,(MAXCHR)	;Get the count
		IFA	B,LOOP_1	;If at end, then stop
		LD	A,24		;Get a non-destructive backspace
		CALL	CHROUT		;Output it
		INC	B		;Add one to available count
		DEC	HL		;Back up pointer
		JR	LOOP_1		;Get another key
;
L_1		EQU	$
		IFANOT	128,L_4		;If not erase all then skip
		SVC	@CKBRKC		;Clear the break bit now
		SVC	@FLAGS		;Get the flags address in IY
		BIT	7,(IY+18)	;Check if DEBUG on
		JR	Z,L_2		;If not, erase to beginning line
		LD	IX,(CMDBUF)	;Get the arg vector
		SET	DEBUG,(IX-1)	;Set the activate debug flag
		JP	OUT		;Exit to caller
;
L_2		EQU	$
		CALL	ERASE_LINE	;Erase the current line
		LD	HL,(HISTBUFF)	;Reset history pointer to start
		LD	(CURCMD),HL	;of the buffer of commands
		CALL	INITMAX		;Reset line information
		XOR	A		;Reset the insert flag
		JP	CTL_A_1
;
L_4		EQU	$
		IFA	13,CTL_M	;Jump if enter pressed
		CP	24		;See if delete character
		JP	Z,DELETECH	;Go do it
		CP	25
		JP	Z,CTL_E		;Move cursor to end of line
		CP	10		;See if next command
		JP	Z,NEXTCMD
		CP	11		;See if previous command
		JP	Z,PREVCMD
		CP	'A'-64		;Is it CNTL-A
		JP	Z,CTL_A
		CP	31		;Shift Clear?
		JP	Z,CLESCR	;Jump if clear screen
		CP	9
		JP	Z,CURRIGHT	;Move cursor to right one char
		CALL	DISCHAR		;Display the character
		DEC	B		;Decrement counter
		JP	NZ,LOOP_1	;Jump if not at end
;
L_5		EQU	$
		INC	B		;Point one ahead
		DEC	HL		;Erase the character
		LD	A,8
		CALL	CHROUT		;On screen as well
		JP	LOOP_1		;Wait for enter or another key
;
;	Do CTRL-E processing
;
CTL_E		EQU	$
		LD	A,(HL)		;Get the character
		IFZ	L_8		;If null, then at end
		CALL	CHROUT		;Print it on the screen
		DEC	B		;One less available
		INC	HL		;Point ahead
		JR	CTL_E		;Jump to loop
;
L_8		JP	LOOP_1		;At end wait for more keys
;
;
;
CTL_M		EQU	$
		LD	A,29
		CALL	CHROUT		;Print a true CR
		LD	A,26
		CALL	CHROUT		;And add a line feed
		LD	A,(LINECURS)	;Get the line mode cursor
		LD	C,A
		LD	B,8		;Select put cursor of @vdctl
		SVC	@VDCTL		;Set the cursor
		LD	HL,(CMDBUF)	;Get the start
		LD	A,(HL)		;Check the first character
		OR	A		;Is it the end?
		JP	Z,ENTRY		;If so then get another command
		PUSH	HL		;Save the command buffer address
		LD	HL,(ENDCMD)	;Get the end+1 position
		LD	A,(MAX)		;Get the max offset
		LD	B,A		;Put it into B
CTL_M_1		EQU	$
		DEC	HL		;Back up one
		INC	B		;Add one to count
		LD	A,(MAXCHR)	;Get the max value for B
		INC	A
		CP	B		;See if past beginning
		JP	C,ENTRY		;Jump when B > A
;
		LD	A,(HL)		;Get the character
		CP	' '		;Is it a space
		JR	Z,CTL_M_1	;If so, back up again
;
		INC	HL		;Otherwise move back to end
		LD	(ENDCMD),HL	;Save the new pointer
		LD	(HL),0		;Put zero at the end
;
;	Now we move the command into the history buffer if it is not
;	the same as the previous command
;
		LD	DE,(HISTBUFF)	;Get the previos command address
		LD	HL,(CMDBUF)	;Get the typed command address
		CALL	STRCMP		;Are they the same?
		JP	Z,CTL_M_3	;Jump if they are the same
;
		LD	HL,(LASTCMD)	;Check the top pointer to see if
		PUSH	HL		;we should delete top
		POP	DE		;Copy HL to DE
		LD	BC,(HISTBUFF)	;Get start of commands
		LD	A,MAXCMD	;Move forward MAXCMD commands
		ADD	A,B		;Add A*256 to address in BC
		LD	B,A		;Put new MSB back in B
		OR	A		;Reset carry
		PUSH	HL		;Save current pointer
		SBC	HL,BC		;Compute difference
		POP	HL		;Restore the pointer
		JR	Z,NOINCEND	;Jump we aren't to MAXCMD yet
;
		INC	D		;Move forward one command
		LD	(LASTCMD),DE	;Set new top
		INC	D		;Terminate next string
		XOR	A		;Clear A to store zero
		LD	(DE),A		;Put a terminator byte at start
		DEC	D		;Move back one string
		JR	DOMOVE		;Join other code
;
NOINCEND	EQU	$
		DEC	H		;Back up source to delete last
;
DOMOVE		EQU	$
		PUSH	HL		;Save the start again
		LD	BC,(HISTBUFF)	;Get the start
		OR	A
		SBC	HL,BC		;Compute the length
		EX	(SP),HL		;Get the start in HL and push len
		POP	BC		;Get the length in BC
		LD	A,B		;Check for zero
		OR	C
		JR	Z,NOCNT		;Jump if no move necessary
		INC	BC		;Plus one
		LDDR			;Move the commands
NOCNT		EQU	$
		POP	HL		;Restore the command text addr
		LD	DE,(HISTBUFF)
		LD	A,(MAXCHR)	;Get the number to move
		INC	A		;Plus one to get zero byte
		LD	C,A		;Get the count in BC
		LD	B,0
		LDIR
CTL_M_3		EQU	$
		LD	HL,(ENDCMD)	;Make the last character
		LD	(HL),13		;be a <CR> for @CMNDI
		INC	HL		;Point ahead one character
		LD	(HL),EOS	;Terminate for moves
DO_A_CMD:
		LD	HL,(CMDBUF)	;Get the command
		CALL	PARSE		;Check for one of out commands
		PUSH	AF
		JR	NZ,NOECHO_CHK
		CP	CMDECHO
		JR	Z,NOECHO_IT
NOECHO_CHK:
		LD	A,(ECHOFLG)
		IFZ	NOECHO_IT
		LD	A,(DONEINI)
		IFANOT	1,NOECHO_IT
		LD	HL,PREECHO
		SVC	@DSPLY
		LD	HL,(CMDBUF)
		SVC	@DSPLY
NOECHO_IT:
		POP	AF
		JP	Z,BUILTIN	;Jump to builtin command
		CALL	CHECK_PDS	;Check if pds member used
		CALL	Z,ADD_PDS_SPEC	;Add the pds name in front.
;
OUT		EQU	$
		CP	A		;Set the Z status
		JP	0		;Go to return address in low mem
RETADDR		EQU	$-2
;
;	Toggle insert mode
;
CTL_A		EQU	$
		LD	A,(INS)		;Get the current value
		XOR	1		;Invert it
CTL_A_1		EQU	$
		LD	(INS),A		;Put it back
		PUSH	HL		;Save the registers
		PUSH	BC
		LD	A,(LINECURS)	;Get the linemode cursor
		JR	Z,CTL_A_2	;Jump if turning insert off
		LD	A,(INSCURS)	;Turning insert on, so get cursor
CTL_A_2		EQU	$
		LD	B,8		;Set new cursor
		LD	C,A		;Get the real cursor
		SVC	@VDCTL		;Set the new cursor character
		POP	BC		;Restore
		POP	HL
		JP	LOOP_1		;Jump back to line editor
;
;	Clear the screen
;
CLESCR		EQU	$
		CALL	INITMAX		;Reinitialize character count
		LD	C,28		;Move cursor to home
		SVC	@DSP
		LD	C,31
		SVC	@DSP		;Clear to end of screen
		JP	LOOP_1		;Restart
;
;	Expand a tab character using spaces
;
DOTAB		EQU	$
		PUSH	BC		;Save the registers
		PUSH	HL
		LD	B,4		;Get the cursor position
		SVC	@VDCTL
		LD	E,L		;Save the column
		POP	HL		;Restore the registers
		POP	BC
DOT_1		EQU	$
		LD	A,' '		;Display a space
		CALL	DISCHAR
		DJNZ	DOT_3
		JP	L_5		;Join other code
DOT_3		EQU	$
		INC	E		;Increment column
		LD	A,E		;Get it
		AND	7		;Modulo 8 yet?
		JP	Z,LOOP_1	;Jump if so
		JR	DOT_1		;Loop until there
;
;	Find next previous command and make it the current
;
PREVCMD		EQU	$
		PUSH	HL
		PUSH	BC
		LD	HL,(CURCMD)	;Get the pointer
		LD	BC,(LASTCMD)	;Get the max address
		OR	A
		PUSH	HL		;Save position
		SBC	HL,BC		;See if we can back up
		POP	HL		;Restore position
		JP	Z,NOPREV
		LD	A,(HL)		;Check if no command
		IFZ	NOPREV
		POP	BC		;Remove saved values
		EX	(SP),HL
		CALL	ERASE_LINE	;Erase the current line
		LD	A,(MAXCHR)	;Initial characters available
		LD	B,A
		POP	HL
		INC	H		;Point to next
		LD	(CURCMD),HL	;Save it
		DEC	H		;Point back
		LD	DE,(CMDBUF)	;Get the command buffer
PREV_1		EQU	$
		LD	A,(HL)		;Get a character
		IFZ	PREV_2		;Jump if end
		CALL	CHROUT		;Print the character
		PUSH	BC
		LDI			;Move next character
		POP	BC
		DEC	B		;Decrement available count
		JR	NZ,PREV_1	;Jump if end of user buffer
;
PREV_2		EQU	$
		EX	DE,HL		;Put string address into HL
		LD	(HL),0
		LD	(ENDCMD),HL	;Save the end pointer
		LD	A,B		;Save ending values
		INC	A		;Plus one for max count
		LD	(MAX),A
		JP	LOOP_1		;Jump to edit
;
NOPREV		EQU	$
		POP	BC		;Restore position
		POP	HL
		JP	LOOP_1		;Restart the input
;
;	Index to next command and make it the current
;
NEXTCMD		EQU	$
		PUSH	HL
		PUSH	BC
		LD	HL,(CURCMD)	;Get the pointer
		LD	BC,(HISTBUFF)	;Get the start
		OR	A
		PUSH	HL		;Save position
		SBC	HL,BC		;See if we can back up
		POP	HL		;Restore position
		JP	Z,NONEXT
		DEC	H		;Move back to previous
		PUSH	HL
		OR	A
		SBC	HL,BC
		POP	HL
		JP	Z,NONEXT
		LD	(CURCMD),HL	;Save the current command
		DEC	H		;Back up to next
		POP	BC
		EX	(SP),HL
		CALL	ERASE_LINE	;Erase the current line
		LD	A,(MAXCHR)	;Initial characters available
		LD	B,A
		POP	HL
		LD	DE,(CMDBUF)	;Get the command buffer
NEXT_1		EQU	$
		LD	A,(HL)		;Get a character
		IFZ	NEXT_2		;Jump if end
		CALL	CHROUT		;Print the character
		PUSH	BC
		LDI			;Move next character
		POP	BC
		DEC	B		;Decrement the counter
		JR	NZ,NEXT_1	;Jump if not done
;
NEXT_2		EQU	$
		EX	DE,HL		;Put dest into HL
		LD	(HL),0
		LD	A,31		;Clear to end of line
		CALL	CHROUT
		LD	A,B
		INC	A		;Plus one for max
		LD	(MAX),A
		LD	(ENDCMD),HL
		JP	LOOP_1		;Jump to edit
;
NONEXT		EQU	$
		POP	BC
		POP	HL
		CALL	ERASE_LINE
		LD	DE,(HISTBUFF)
		LD	(CURCMD),DE
		JP	LOOP_1
;
;	Move the cursor right when SHIFT --> is pressed
;
CURRIGHT	EQU	$
		LD	A,(MAX)		;See if at end
		DEC	A		;Convert to right most
		CP	B		;Are we at the end of the line
		JP	Z,LOOP_1	;Jump and get a new key if so
		DEC	B		;Decrement available count
		INC	HL		;Move line pointer forward
		LD	A,25		;Move cursor right on screen
		CALL	CHROUT
		JP	LOOP_1		;Get a new key
;
;	Delete the character to the left of the cursor
;
DELETECH	EQU	$
		LD	A,(MAXCHR)	;Check if at start of line
		CP	B
		JP	Z,LOOP_1	;Jump if we are
;
		DEC	HL		;Move the pointer back one char
		INC	B		;Increment available count
		PUSH	HL		;Save HL for a second
		LD	A,(MAX)		;Get the current max right pos
		INC	A		;Adjust one position left
		LD	(MAX),A		;Save the new value
		LD	HL,(ENDCMD)	;Get the end pointer
		DEC	HL		;Back it up by one
		LD	(ENDCMD),HL	;Save the new value
		POP	HL		;Get the value of HL back
		PUSH	HL		;Put it back for later
		PUSH	BC		;Save BC as well
		LD	D,H		;Copy HL to DE
		LD	E,L
		INC	HL		;Move source up one
		LD	C,B		;Make BC be a 16 bit count
		LD	B,0		;
		INC	BC		;Make BC at least 1
		PUSH	DE		;Save the print place
		LDIR			;Delete one character
		LD	A,24
		CALL	CHROUT		;Back up the cursor
		LD	B,4		;Get the cursor position
		SVC	@VDCTL
		LD	A,15		;Turn the cursor off
		CALL	CHROUT
		POP	DE		;Get the print place back
		CALL	PRTSTR		;Print the remaining data
		LD	A,32		;Remove the last character
		CALL	CHROUT
		LD	B,3		;Put the cursor back
		SVC	@VDCTL
		LD	A,14
		CALL	CHROUT		;Turn the cursor back on
		LD	HL,(ENDCMD)	;Get the end
		LD	(HL),0		;Terminate the string
		POP	BC
		POP	HL
		JP	LOOP_1
;
;	Erase the current line as if SHIFT <-- was pressed
;
ERASE_LINE	EQU	$
		XOR	A
		LD	(INS),A
ERALN_1		EQU	$
		LD	A,(MAX)		;Get the max
		DEC	A		;Minus one for real value
		IFA	B,ERALN_3	;Jump if at end
		LD	A,(HL)		;Get the character
		INC	HL
		CALL	CHROUT		;Print the character
		DEC	B		;Add one to count
		JR	ERALN_1		;Loop
;
ERALN_3		EQU	$
		LD	A,(MAXCHR)	;Get the maximum number of chars
		IFA	B,ERALN_5	;Jump if at end
		LD	A,8		;Get a space
		CALL	CHROUT		;Print it
		INC	B
		JR	ERALN_3
;
ERALN_5		EQU	$
		CALL	INITMAX		;Reset the character counters
		RET			;Restart
;
;	Initialize character counters and the pointer to the end of
;	the command line.
;
INITMAX		EQU	$
		LD	A,(MAXCHR)	;Get the max allowed
		LD	B,A		;Put it into B
		INC	A		;Make the maximum right position
		LD	(MAX),A		;be one to the left of that
		LD	HL,(CMDBUF)	;Get the start of the input line
		LD	(ENDCMD),HL	;Save it as the starting end
		LD	(HL),0		;Make sure that the line is 0 len
		RET
;
*GET		ECISUBS
*GET		ECIPARSE
*GET		LOADKEY
*GET		SAVEKEY
*GET		ECIDATA
		END	START
