;		eciload/asm
		ORG	2A00H
*GET		ECIMAC
;
;	Loader routine for ECI
;
START		EQU	$
		LD	(STAKSAV),SP
		LD	SP,STAK
		LD	HL,INTRO
		SVC	@DSPLY
		LD	DE,MODNAME
		SVC	@GTMOD
		JP	Z,MODIN
;
;	Module not in, so load it
;
		LD	HL,0		;Get the current high$
		LD	B,L
		SVC	@HIGH$		;Get it
		JP	NZ,ERROR	;Abort if error
		LD	(OLDHIGH),HL	;Save the current high pointer
NOMODIN		EQU	$
GETBANK		EQU	$
		LD	HL,BANKMES	;Get the bank number
		SVC	@DSPLY
		LD	BC,0300H	;Three characters max
		LD	HL,ANSBUF	;Place to but characters
		SVC	@KEYIN		;Get the bank number
		JP	C,OUT		;If break, then exit
		LD	HL,ANSBUF	;Get the number
		LD	A,(HL)		;Get the first character
		IFA	13,BADNUM	;Jump if no number
		SVC	@DECHEX		;Convert to binary
		LD	A,(HL)		;Check terminator to assure
		IFANOT	13,BADNUM	;Jump if not
		LD	A,B		;Check the range
		IFNZ	BADNUM		;If b is NZ than too big
		LD	A,C		;Check LSB for 127 >= A >= 0
		BIT	7,A
		JR	NZ,BADNUM
;		IFZ	BADNUM		;Disallow bank zero
		LD	(BANKNUM),A	;Save the number
		LD	C,A		;Select that bank
		LD	B,2		;Test BUR for that bank
		SVC	@BANK		;Try to get it
		JR	Z,BANKOK	;Jump if we got it
BADNUM		EQU	$
		LD	HL,NOBANK	;Get the message
		SVC	@DSPLY		;Print invalid bank message
		JR	GETBANK		;Get another bank
BANKOK		EQU	$
		LD	A,(BANKNUM)	;Get the bank
		LD	C,A
		LD	B,3		;Set BUR to reserve bank
		SVC	@BANK
		JP	NZ,ERROR
		LD	DE,ECICMD	;Get the name of the load module
		SVC	@LOAD		;Load the module
		JP	NZ,ERROR	;Jump if no such module
		LD	(MODADDR),HL	;Save the entry point
		LD	BC,(8000H+ECILENOFF)	;Get the length
		LD	HL,8000H	;Get the start of module
		LD	DE,3000H	;Get the destination
		PUSH	BC		;Save the values
		PUSH	DE
		PUSH	HL
		LDIR			;Move down
		LD	A,(BANKNUM)	;Get the destination bank
		LD	C,A		;Put it in C for @bank
		LD	B,0		;Get select bank code
		SVC	@BANK		;Move in the destination bank
		JP	NZ,ERROR
		POP	HL
		POP	DE
		POP	BC
		EX	DE,HL		;Switch source and destination
		LDIR			;Move back up
		LD	BC,0		;Put bank zero back in
		SVC	@BANK
		JP	NZ,ERROR	;Abort if error
		LD	A,(ECIIN)	;See if just reloading
		OR	A
		JR	Z,L_10
;
		LD	HL,(MEMADDR)	;Get the address back
		LD	A,(BANKNUM)	;Get the bank selected
		LD	(HL),A		;Put it into the header
		INC	HL		;Point to load address
		LD	DE,(MODADDR)	;Get the new one
		LD	(HL),E		;Put it into the header
		INC	HL
		LD	(HL),D
		JP	JCLOUT		;Exit so JCL can continue
;
L_10		EQU	$
		LD	HL,(OLDHIGH)	;Get the high pointer
		LD	BC,MODLEN+1	;Back up to start of space
		OR	A		;Reset carry
		SBC	HL,BC		;Move back size of module
		EX	DE,HL		;Make DE that address as dest
		LD	HL,MODHEAD	;Get the header
		PUSH	DE		;Save the start for new HIGH$
		INC	DE		;Point ahead to byte to use
		LDIR			;Move the block
		POP	HL		;Get the start back
		LD	B,0		;Select HIGH$
		SVC	@HIGH$
		JP	NZ,ERROR
		JP	JCLOUT		;Exit now, JCL might be active
;
MODIN		EQU	$
		LD	BC,BANKOFF
		ADD	HL,BC
		LD	(MEMADDR),HL	;Store offset
		LD	C,(HL)		;Get the bank number
		BIT	7,C		;Make sure the bank is valid
		LD	A,1
		LD	(ECIIN),A	;Set flag saying it is there
		JP	NZ,NOMODIN
		LD	HL,MODHERE	;Get the message
		SVC	@DSPLY
		SVC	@FLAGS
		BIT	5,(IY+18)
		JR	Z,NOJCL
		LD	HL,IGNORE	;Display message
		SVC	@DSPLY
		LD	BC,0300H	;Read the expected bank
		LD	HL,ANSBUF	;number to keep from aborting
		SVC	@KEYIN
NOJCL:
		JP	OUT
;
;
;
JCLOUT		EQU	$
		SVC	@FLAGS		;Set the ECI to on
		LD	A,1
		LD	(IY+EFLAG$),A
		JP	OUT		;Return to DOS
;
;
;
ERROR		EQU	$
		PUSH	AF
		LD	BC,0
		SVC	@BANK
		LD	HL,ECIERR
		SVC	@DSPLY
		POP	AF
		OR	0C0H		;Set short message bits
		LD	C,A
		SVC	@ERROR
		LD	HL,-1
		JP	ERROUT
;
;
;
OUT		EQU	$
		LD	HL,0
ERROUT		EQU	$
		LD	SP,0000H
STAKSAV	EQU	$-2
		SVC	@EXIT
;
;
;
NEWLINE		EQU	$
		PUSH	BC
		PUSH	AF
		LD	C,13
		SVC	@DSP
		POP	AF
		POP	BC
		RET
;
;
;
*GET		ECIHEAD/ASM		;Get the header definition
;
ECIERR		DB	'EXECI error: ',3
MODNAME		DB	'MEMRES',3
BANKMES		DB	10,'EXECI is not resident.  Use which bank ==> ',3
ANSBUF		DS	10
ECICMD		DB	'ECIMAIN/CMD',13
		DS	32
NOBANK		DB	'That bank is not available!',13
MODHERE		DB	10,'EXECI is already resident',3
IGNORE		DB	', ignoring input ==> ',3
MEMADDR		DW	0
ECIIN		DB	0
INTRO		DB	'EXECI - Extended Command Interpreter for TRSDOS'
		DB	' 6.2.X',10,'(c) 1987 Gregg Wonderly, '
		DB	'All rights reserved',13
;
;	Don't move these data structures
;
FLAGS		DB	0
CMDBUF		DS	257
		DS	64
STAK		EQU	$
		END	START
