;		ECI/ASM
		ORG	2600H
*GET		ECIMAC
;
;	Loader routine for ECI
;
START		EQU	$
		LD	(STAKSAV),SP
		LD	SP,STAK
		LD	DE,MODNAME
		SVC	@GTMOD
		JP	Z,MODIN
;
;	Module not in, so load it
;
NOMODIN		EQU	$
		LD	A,1
		LD	(DIDLOAD),A	;Set the flag
		LD	A,(ONCE)	;Check if already tried
		OR	A
		JP	NZ,OUT
		CALL	LOADECI		;Load the ECI
		LD	A,1		;Set the one time flag
		LD	(ONCE),A
		JR	START		;Try to get the header again
;
;
;
MODIN		EQU	$
		LD	BC,BANKOFF
		ADD	HL,BC
		LD	(MEMADDR),HL	;Store offset
		LD	C,(HL)		;Get the bank number
		BIT	7,C		;Make sure the bank is valid
		LD	A,1
		LD	(ECIIN),A	;Set flag saying it is there
		JP	NZ,NOMODIN
		LD	A,C
		LD	(BANKNUM),A	;Save the current bank number
		PUSH	BC
		PUSH	HL
		SVC	@FLAGS
		LD	A,(IY+4)	;Check if ECI currently active
		IFNZ	ECIACT
		LD	A,(DIDLOAD)
		IFNZ	ECIACT
		LD	HL,RESUMECI
		SVC	@DSPLY
ECIACT:
		POP	HL
		POP	BC
		INC	HL
		LD	A,(HL)		;Get the lsb of transfer
		INC	HL
		LD	H,(HL)		;Get the msb
		LD	L,A		;Put lsb into l
		SET	7,C		;Set the transfer bit
		LD	B,0		;Get the select code
		LD	DE,CMDBUF	;Get the command buffer
		XOR	A
		LD	(FLAGS),A	;Reset alt command flags
		SVC	@BANK		;Transfer to ECI code
		JP	NZ,ERROR
		LD	BC,0
		SVC	@BANK		;Put bank zero back in
		LD	A,(FLAGS)
		IFNZ	ALTCMD
		LD	HL,CMDBUF	;Get the command buffer
		SVC	@CMNDI		;Do the command
		JP	OUT
;
ALTCMD		EQU	$
		BIT	DEBUG,A		;Check for debug
		JR	Z,ALT_1
		SVC	@DEBUG
		JP	OUT
;
ALT_1		EQU	$
		BIT	EXIT,A		;Check if exit ECI
		JR	Z,ALT_2
		JP	OUT
;
ALT_2		EQU	$
		BIT	QUIT,A		;Check for quit
		JR	Z,UNKNOWN
		LD	A,(BANKNUM)
		LD	C,A
		LD	B,1
		SVC	@BANK		;Reset the BUR
		JP	NZ,ERROR
		LD	HL,(MEMADDR)	;Get the memory header offset
		LD	(HL),0FFH	;Set flag saying ECI disabled
		JP	OUT
;
UNKNOWN		EQU	$
		JP	OUT
;
;
;
LOADECI		EQU	$
		PUSH	HL
		PUSH	DE
		PUSH	BC
		PUSH	AF
		LD	HL,LOADCMD	;Get the command
		SVC	@CMNDR		;Does return
		POP	AF
		POP	BC
		POP	DE
		POP	HL
		RET
;
;
;
ERROR		EQU	$
		PUSH	AF
		LD	BC,0
		SVC	@BANK
		LD	HL,ECIERR
		SVC	@DSPLY
		POP	AF
		OR	0C0H		;Set short message bits
		LD	C,A
		SVC	@ERROR
		LD	HL,-1
		JP	ERROUT
;
;
;
OUT		EQU	$
		LD	HL,0
ERROUT		EQU	$
		LD	SP,0000H
STAKSAV	EQU	$-2
		SVC	@EXIT
;
;
;
NEWLINE		EQU	$
		PUSH	BC
		PUSH	AF
		LD	C,13
		SVC	@DSP
		POP	AF
		POP	BC
		RET
;
;
;
*GET		ECIHEAD/ASM		;Get the header definition
;
ECIERR		DB	'EXECI error: ',3
RESUMECI	DB	'Resuming EXECI...',13
LOADCMD		DB	'eciload',13
MODNAME		DB	'MEMRES',3
DIDLOAD		DB	0
MEMADDR		DW	0
ECIIN		DB	0
ONCE		DB	0
;
;	Don't move these data structures
;
ECIPARAMS	EQU	$
		DW	INIBUF
		DW	INIFCB
		DW	MOREBUF
		DW	MOREFCB
FLAGS		DB	0
CMDBUF		DS	257
		DS	256
STAK		EQU	$
MOREBUF		DS	256
MOREFCB		DS	40
INIBUF		DS	256
INIFCB		DS	40
		END	START
