/* Example Program Using the Expanded Memory Manager (EMM)	 */

#include <stdio/h>
#include <emm/h>

#option INLIB
#option USERLIB
#option ARGS OFF
#option REDIRECT OFF

/* Access Macros first array */

#define REC1(i) ((item1 *)emmacc(item_array_1,i))
#define itm1(i) REC1(i)->b_item
#define qty1(i) REC1(i)->b_qty
#define desc1(i) REC1(i)->b_desc

/* Access Macros second array */

#define REC2(i) ((item2 *)emmacc(item_array_2,i))
#define itm2(i) REC2(i)->b_item
#define qty2(i) REC2(i)->b_qty
#define desc2(i) REC2(i)->b_desc

/* Array element structure typedef */

typedef struct	{			/* ints used	*/
	int b_item;
	int b_qty;
	char b_desc[26];
}item1;

typedef struct	{			/* longs used	*/
	long b_item;
	long b_qty;
	char b_desc[52];
}item2;

main()
{
EMCB *item_array_1;					/* EM Control Block for 1st array	*/
EMCB *item_array_2;					/* EM Control Block for 2nd array	*/
long time();						/* elapsed seconds function	*/
long time_start;					/* start of program	*/
long crea1_start;					/* start of 1st array creation	*/
long crea1_end;						/* end of 1st array creation	*/
long crea2_start;					/* start of 2nd array creation	*/
long crea2_end;						/* end of 2nd array creation	*/
long prin1_start;					/* start of 1st array print	*/
long prin1_end;						/* end of 1st array print	*/
long prin2_start;					/* start of 2nd array print	*/
long prin2_end;						/* end of 2nd array print	*/
long time_end;						/* end of program	*/
int i;
unsigned freemem();

		/* create two arrays after allowing emminit() determine the		*/
		/* amount of expanded memory available.							*/
		/* Set element size	to the size of items structure for each		*/
		/* array (30 bytes for the first, and 60 bytes for the second).	*/

		time(&time_start);

		/* initialize the expanded memory and find out how much is */
		/* available	*/

		if(emminit() < 31000)	{
			printf("Not enuff expanded memory available\n");
			exit(-1);
		}

		printf("Expanded memory available is %ld bytes\n",emmavail());
		printf("Core available = %u\n",freemem());

		/* obtain the space for 500 elements in the 1st array and specify */
		/* the cache size as 100 elements (3200 bytes array 1)	*/

		item_array_1 = emmalloc(500,  sizeof(item1), 100);

		/* find out how much expanded memory is left	*/
		printf("Expanded memory after 1 emmalloc() is %ld bytes\n",emmavail());
		printf("Core available = %u\n",freemem());

		/* obtain the space for 250 elements in the 2nd array and specify */
		/* the cache size as 50 elements (3100 bytes array 2)	*/

		item_array_2 = emmalloc(250,  sizeof(item2), 50);

		/* find out how much expanded memory is left	*/
		printf("Expanded memory after 2 emmalloc() is %ld bytes\n",emmavail());
		printf("Core available = %u\n",freemem());

		/* make sure we obtained the expanded memory or the cache space	*/
		if(item_array_1 == NULL || item_array_2 == NULL)	{
			printf("not enuff expanded memory or cache memory\n");
			beep();
			exit(-1);
		}
		
		time(&crea1_start);

		/* fill 500 array items of size 30 bytes = 15,000 bytes	*/
		/* for 1st array	*/

		for(i = 0; i < 500 ; i++)	{
			itm1(i) = i + 1;
			qty1(i)  = 0;
			sprintf(desc1(i)," Item # %d", i + 1);
			desc1(i)[25] = '\xde';	/* last char equals dec 222	*/
		}

		time(&crea1_end);
		time(&crea2_start);

		/* fill 250 array items of size 60 bytes = 15,000 bytes	*/
		/* for 2nd array	*/

		for(i = 0; i < 250 ; i++)	{
			itm2(i) = (long) i + 1L;
			qty2(i)  = 0;
			sprintf(desc2(i)," Item # %ld", (long) i + 1L);
			desc2(i)[51] ='\xde';	/* last char equals dec 222	*/
		}

		time(&crea2_end);
		time(&prin1_start);

		/* print contents of the 500 array items in steps of 5	*/
		/* plus the ascii code of last char in b_desc for 1st array	*/

		for(i = 0; i < 500; i += 5)
			printf("Array_1 Element # %d Item = %d  Qty = %d Desc = %s  %d\n",
				i, itm1(i), qty1(i), desc1(i), (int) desc1(i)[25]);

		time(&prin1_end);
		printf("\n\n");
		time(&prin2_start);

		/* print contents of the 250 array items in steps of 2	*/
		/* plus the ascii code of last char in b_desc for 2nd array	*/

		for(i = 0; i < 250; i += 2)
			printf("Array_2 Element # %d  Item = %ld  Qty = %ld Desc = %s \
 %d\n",	i, itm2(i), qty2(i), desc2(i), (int) desc2(i)[51]);

		time(&prin2_end);

		emmfree(item_array_1);	/* free expanded and cache memory	*/
		emmfree(item_array_2);
		
		/* find out how much expanded memory is left	*/

		printf("\nExpanded memory after emmfree() is %ld bytes\n",emmavail());
		printf("Core available = %u\n",freemem());

		time(&time_end);
		printf("\n\nCreation time for array 1 = %ld:%ld\n",(crea1_end-
crea1_start)/60,(crea1_end-crea1_start) %60);
		printf("\n\nCreation time for array 2 = %ld:%ld\n",(crea2_end-
crea2_start)/60,(crea2_end-crea2_start) %60);
		printf("\n\nPrint/Retrieval time for array 1 = %ld:%ld\n",(prin1_end-
prin1_start)/60,(prin1_end-prin1_start) %60);
		printf("\n\nPrint/Retrieval time for array 2 = %ld:%ld\n",(prin2_end-
prin2_start)/60,(prin2_end-prin2_start) %60);
		printf("\n\nTotal elapsed program time = %ld:%ld\n",(time_end-
time_start)/60,(time_end-time_start) %60);
}
