 ;
6 ;	Modem/Xmodem protocol for interchange of programs
0 ;	with the CP/M operating system. Employs the
 ;	"Christensen" protocol.
 ;
3 ;	Note entry into the routine is direct from the
/ ;	terminal mode. The program prompts for the
 ;	filename to send/receive.
 ;
2 ;	This segment makes no attempt to translate or
5 ;	otherwise adjust the outgoing (or incoming) data
5 ;	for the target/source system format. The user is
2 ;	responsible for seeing to it that the data is
, ;	in the correct format for the transfer.
 ;
 ;	Comment (Copyright notice)
/ 		'XMODEM 3.1.1 Authored by Karl Denninger.
2 		'  Released to the public domain 11/11/1984.
 ;
@SOH		1
@EOT		4
@ACK		6
@NAK		21
@CAN		24
 ;
 ;	Called subroutines:
( ;	Getchar		- Called to check on input
! ;			from the Rs-232 interface.
* ;	Send		- Called to send a character to
 ;			to other end.
 ;
3 ;	Note that CP/M sends in 128-byte blocks, which
, ;	means that it is 2-for-1 on the TRS-80.
2 ;	Due to this difference in record lengths, the
1 ;	system treats the file(s) to send/receive as
0 ;	a byte-stream of data. 1 record is buffered
2 ;	by the segment (128 bytes). The last block is
, ;	padded with zeros if padding is needed.
 ;
 ;
 ;	Entry points:
+ ;	SENDCPM	-	Send a file to another MODEM
 ;			system.
, ;	RECVCPM	- 	Receives a file from a MODEM
 ;			system.
 ;
" 		0A000H		; THE STARTING POINT
 ;
 ;
@DUMMY		DUMMY-$

 		,DUMMY

 		SVC/ASM
 	
 ;
	 SENDXY
 ;
0 ;	ENTER HERE TO SEND A XMODEM FILE. (HL) MUST
" ;	CONTAIN THE FILESPEC TO SEND.
 ;
>N		,@FSPEC
3ڡ		,CPMDCB
			28H		; PARSE FILENAME
+3ƣ		,CERROR	; FATAL ERROR IN FILENAME
 ;	LD	A,@FLAGS
 ;	RST	28H
 ;	SET	0,(IY+18)	; READ-ONLY
 >;		,@OPEN		; OPEN THE FILE
3ڡ		,CPMDCB
3!		,CPMBUF
  		,0		; DO IT IN ANY CASE
			28H		; OK -- IT IS OPEN!
)3ƣ		,CERROR	; OH OH -- SOMETHING IS
 				; WRONG!
>		,@GET
3ڡ		,CPMDCB
$			28H		; ATTEMPT TO READ 1 CHAR
&3ƣ		,CERROR	; SOMETHING IS WRONG
>D		,@REW
3ڡ		,CPMDCB
			28H		; REWIND IF OK
 3		WAIT5		; WAIT 5 SECONDS
3͗		SETOFF
3!a		,STSMES
>
		,@DSPLY
			28H
 3ͫ		FLUSHBF		; FLUSH BUFFER
(s8WAIT10		GETCHAR		; WAIT FOR A NAK
		NAK		; SAME?
(		,OKSND
		CAN		; CANCEL?
3ʱ		,CANCPM
>		,@KBD
			28H
		80H
%3ʱ		,CANCPM	; CANCEL IF <BREAK>
		WAIT10
R>OKSND		,1
321		(BLOCK),
		
323		(LASTB),
(s!FILL1		,XMTBUF	; TRANSMIT BUFFER
3		,XMTBUF+1
> 		,0
w		,
3 		,127
				; ZERO IT
		
324		(CPMRET),

		,128
3!		,XMTBUF
sڡFILDC		,CPMDCB
>		,@GET
			28H		; GET 1 CHARACTER
3		,DONXM
w		,
#		

		FILDC
/s̈́SENDC		SENDBFR		; SEND A BUFFER UNTIL OK
3:3		,(LASTB)
		
3		,ENDXMT

		FILL1
 R>SENDBFR		,SOH		; SEND SOH
 
3͆		SEND		; SEND IT
3:1		,(BLOCK)
"3͆		SEND		; SEND BLOCK NUMBER
3:1		,(BLOCK)	; RELOAD IT
/				; COMPLEMENT ACCUM
&3͆		SEND		; CHECK OF BLOCK NUMBER
 		,0		; STORE CHECKSUM
		,128		; HOW MANY TO DO
%3!		,XMTBUF	; PLACE TO GET FROM
A~SDCPM1		,
		,
_		,
~		,		; RELOAD
		
		
3͆		SEND		; SEND IT
				; RESTORE REGS
		
#		
		SDCPM1		; CONTINUE
{		,
3͆		SEND		; SEND CHECKSUM
"		,15		; 15 SECONDS TO WAIT
AWTOK				; SAVE COUNT
*3͍		GETFROM		; GET ONE CHARACTER WITH
 				; TIMOUT
'(		,NOERX		; CHECK THE ONE WE GOT
				; RESTORE COUNT
		WTOK
$3		PERMER		; WE HAVE A PROBLEM
ANOERX				; FIX STACK
		CAN		; DO WE CANCEL?
3		,CCCPM		; CANCEL XMIT
		ACK		; IS IT OK?
! 			,CHKRET	; RETRIES IF NOT
$3:1		,(BLOCK)	; ELSE NEXT BLOCK
<		
321		(BLOCK),
				; SET ZERO FLAG
	
s:4CHKRET		,(CPMRET)
<				; INCREMENT IT

		10		; IS IT 10?
"(		,TOMRET	; PERMANENT ERROR
324		(CPMRET),
		SENDBFR
s!TOMRET		,TOMER
>
		,@DSPLY
			28H
3ñ		CANCPM
/!TOMER		'! Cannot send block -- abort !',13
s!CCCPM		,CCPM
>
		,@DSPLY
			28H
s!@PERMER		,PERM
>
		,@DSPLY
			28H
"3ñ		CANCPM		; CANCEL FILESEND
;!CCPM		'! Transmission cancelled by receiving end !',13
2
PERM		10,'! Timeout waiting for ACK/NAK !',13
=!STSMES		'! Waiting for initial NAK -- ^X to cancel !',13
s8GETFROM		GETCHAR
		
				; SAVE THIS
d		,100		; 100 TIMES
ADXC				; SAVE AGAIN
38		GETCHAR

(		,RTX
3		,500
>		,@PAUSE
			28H
		
		DXC
		
		0FFH
ART		
				; RETURN TO CALLER
ARTX		
		RT		; RETURN ALSO
"s͍FLUSHBF		GETFROM		; CALL IT
		
(		FLUSHBF		; CONTINUE TILL NOTHING
R>CANCPM		,CAN
(3͆		SEND		; CALL THE SEND TO CANCEL
>
		,@DSPLY
3!¡		,CANCDX
			28H
3!		,0FFFFH
&3«		RETTER		; GO BACK TO TERMINAL
+
CANCDX		10,'! Transmit cancelled !',13
@CPMDCB		32
@CPMBUF		256
@XMTBUF		129
@CPMFIL		25
R>DONXM		,0FFH
323		(LASTB),
3x		SENDC
 RENDXMT		,5		; TRY 5 TIMES
R>ENDXM1		,EOT

3͆		SEND
s͍WTCRL		GETFROM
# 		,XMW1		; RESEND IF NOTHING
		ACK		; ACK?
(		,OKXT
RXMW1		ENDXM1
3!5		,WRD
>
		,@DSPLY
			28H
R>
OKXT		,@DSPLY
3!		,SDCCPM
			28H
><		,@CLOSE
3ڡ		,CPMDCB
			28H
3!  		,0
3«		RETTER
 ;
!ACERROR				; SAVE ERROR CODE
>
		,@DSPLY
3!		,DSSS
			28H
ALVN				; WE RESTORE
O		,
:		6,
:		7,
>		,@ERROR
!			28H		; PRINT ERROR MESSAGE
>
		,@DSPLY
3!		,FRXN
			28H
3!		,0FFFFH	; ERROR!
3«		RETTER
?DSSS		'? ',03
6!FRXN		'! Fatal error in Xmodem mode -- exit !',13
6!SDCCPM		'! Modem protocol filesend complete !',13

 BLOCK		0
 OLDBIT7		0

 LASTB		0
 CPMRET		0
;!WRD		'! Terminator not correct -- exiting anyway !',13
	 RECVXY
6 ;	ENTER HERE TO RECEIVE A XMODEM FILE. THE FILESPEC
 ;	MUST BE IN (HL).
 ;
%3"		(STORHLX),	; SAVE FOR LATER
>N		,@FSPEC
3ڡ		,CPMDCB
			28H
"3«		,RXERROR	; RECIEVE ERROR
 ;	LD	A,@FLAGS
 ;	RST	28H
" ;	SET	0,(IY+18)	; SET READ ONLY
'>;		,@OPEN		; WE TRY AN OPEN FIRST
3ڡ		,CPMDCB
3!		,CPMBUF
 		,0		; 0 LRL.
			28H		; OPEN IT.
"3		,MAYROK	; MAY NOT EXIST.
3		NOEXBAT
!RMAYROK		24		; FILE NOT HERE
"3«		,RXERROR	; RECEIVE ERROR
R>NMAYO3		,@FSPEC
3*		,(STORHLX)
3ڡ		,CPMDCB
			28H
3«		,RXERROR
>:		,@INIT
 		,0
3!		,CPMBUF
3ڡ		,CPMDCB
			28H		; ATTEMPT TO INIT
3«		,RXERROR	; ERROR!
 3		WAIT5		; WAIT 5 SECONDS
3͗		SETOFF
3!$		,RDYRCV
$>
		,@DSPLY	; READY TO RECEIVE 
			28H
				; RETRY COUNTER
"32j		(COUNTR),	; COUNTER LOAD
>		,1
321		(BLOCK),
&sͫNAKIT		FLUSHBF		; FLUSH BUFFERS

>		,NAK
3͆		SEND		; SEND A <NAK>

		,10		; WAIT 10 SECONDS
s͍WAITFOR		GETFROM
%3/		,GOXIN		; WE GOT SOMETHING!
>		,@KBD
			28H
				; CHECK KB
3ڤ		,RXCAN
		WAITFOR
3:j		,(COUNTR)
<		

		10		; 10 RETRIES?
"3ڤ		,RXCAN		; CANCEL RECEIVE
32j		(COUNTR),
		NAKIT		; NAK IT AGAIN!
%s͍RXCAN		GETFROM		; GET ONE CHAR
(		,RXCAN

>		,CAN

3͆		SEND
3!k		,RXCCAN
>
		,@DSPLY
			28H
>9		,@REMOV
3ڡ		,CPMDCB
			28H		; KILL THE FILE
3!		,CNC
>
		,@DSPLY
			28H
3ͫ		FLUSHBF
3!		,0FFFFH
3«		RETTER
>!CNC		'! Receive cancelled, incomplete file deleted. !',13

AGOXIN		
		
32j		(COUNTR),
		
$RGOXMOR		EOT		; END OF TRANSMIT
3u		,ENDRCV
		SOH		; IS IT SOH?
3G		,SOHX		; GO GET BLOCK
		CAN		; CANCEL?
3ڤ		,RXCAN
3Æ		RESEND
)s!SOHX		,CPMI		; CLEAR INPUT BUFFER
3		,CPMI+1
#3 		,127		; WE ZERO 128 BYTES
		
w		,
				; ZERO IT
$3͍		GETFROM		; GET THE NEXT ONE
"3ܥ		,TIMOR	; TIMEOUT RECEIVE
G		,
(3:1		,(BLOCK)	; WE GET BLOCK NUMBER
		
*3u		,BLKOK		; THE BLOCK NUMBER IS OK
=				; CHECK THIS ONE TOO
		
"3j		,RECVIGN	; IT'S A REPEAT

3Ä		LOST
1sͫRECVIGN		FLUSHBF		; WAIT FOR LINE TO CLEAR

>		,ACK

3͆		SEND
3ӥ		CONTMX
s͍BLKOK		GETFROM
3ܥ		,TIMOR
/	
G		,
3:1		,(BLOCK)
		
3ʌ		,CONV		; WE ARE OK!
=		
				; CHECK LAST ONE
3j		,RECVIGN

3Ä		LOST
%RCONV		,128		; 128 BYTES/RECORD
" 		,0		; INITIALIZE CHECKSUM
3!		,CPMI
s͍RECV1		GETFROM
(3		,RESEND	; RE-SEND (NOT ENOUGH)
w		,
#		
		,
O		,
>		,@KBD
			28H		; SCAN KEYBOARD
		80H		; IS IT A <BREAK>?
3ڤ		,RXCAN

		RECV1
s͍GETCK		GETFROM
&3		,RESEND	; SOMETHING GOT LOST
				; CHECK IT
!3		,RESEND	; RE SEND BLOCK

		,128
3!		,CPMI
R>WRITI		,@PUT
3ڡ		,CPMDCB
N		,
		
		
			28H
		
		
3«		,RXERROR
#		

		WRITI

>		,ACK

3͆		SEND
3:1		,(BLOCK)
<		
321		(BLOCK),
sͫCONTMX		GETFRX
$3ܥ		,TIMOR	; TIMOUT ON RECEIVE
35		GOXMOR
 ;
R>9TIMOR		,@REMOV
3ڡ		,CPMDCB
			28H
3!		,TIMORX
>
		,@DSPLY
			28H
3!		,0FFFFH
3«		RETTER
G!TIMORX		'! Timeout during receive - incomplete file deleted. !',13
 ;
 ;
1!RDYRCV		'! File open, ready to receive !',10
<!		'! Type ^X to cancel before transmission begins !',13
R><ENDRCV		,@CLOSE
3ڡ		,CPMDCB
			28H
>
		,@DSPLY
3!		,FILCOM
			28H

>		,ACK

3͆		SEND
3«		RETTER
3!FILCOM		'! Modem protocol file received. !',13
 RXERROR
		
>
		,@DSPLY
3!		,RXERM
			28H
		
!3ƣ		CERROR		; ERROR HANDLING
C!RXERM		'! ? Disk error during receive -- message follows !',13

@CPMI		129
 COUNTR		0
,
RXCCAN		10,'! Cancelling receive. !',13
 ;
 ;
 R LOST		RESEND		; TRY AGAIN.
s:jRESEND		,(COUNTR)
<		
32j		(COUNTR),

		10		; 10 RETRIES?
(		,RESOUT
3ۧ		FLUSHBX		; CLEAR INPUT

>		,NAK

3͆		SEND
3ͫ		GETFRX
3ܥ		,TIMOR
35		GOXMOR
s!RESOUT		,RESX
>
		,@DSPLY
			28H
3ڤ		RXCAN
AGETFRX		
 
		,10		; WE USE 10 COUNTS
s͍FFX		GETFROM
'(		,GOB		; RETURN IF THERE IS ONE
!		FFX		; CONTINUE TILL DONE
		
			1
		
 				; RETURN WITH NZ RESULT
AGOB		
				; RETURN WITH IT
.!RESX		'! ? Block cannot be received !',13
/s͍FLUSHBX		GETFROM		; GET ONE WITH TIMEOUT
				; RETURN IF NOTHING
		FLUSHBX		; CONTINUE
R>
NOEXBAT		,@DSPLY
3!		,BATMX
			28H
3!		,0FFFFH
3«		RETTER
9!BATMX		'! ? Xmodem receive file exists - ABORT !',13
)  STORHLX		0		; PLACE TO SAVE POINTER
 ;
 ;
 ;
s^START		,PLACE

32 		,50
#				; MOVE IT TO A SAFE PLACE
3!ƪ		,XMODEM
>
		,@DSPLY
			28H
3!^		,PLACE
~		,

		13		; CHECK IT OUT
3@		,GETPARMS
3!^		,PLACE	; CHECK IT OUT
!P		,80		; WE CHECK 80 CHARS
A~CHKIT		,		; CHECK IT OUT

		13		; <ENTER>
(		,CXX		; NOTHING
			3
(		,CXX		; NOTHING
(		'('		; OPEN PAREN'S?
(		,GETCCC
#		

		CHKIT
		CXX
s<GETCCC		,DEVNAME
#		
		,3
A~MOVIT		,
		,
#		
		

		MOVIT
R>NCXX		,@FSPEC
3>		,DCB
3!<		,DEVNAME
"			28H		; MOVE THE DEVICE NAME
>;		,@OPEN
3>		,DCB
3!^		,BUFFER
 		,0		; OPEN IT
			28H		; DO IT!
)3		,NODEV	; NO DEVICE OF THAT NAME
3!^		,PLACE
~		,		; CHECK IT AGAIN!

		13		; <RET>?
3ʄ		,EXIT1		; LEAVE IF SO
		0DFH
S		'S'		; SEND?
3&		,SENDCPM	; SEND IF SO
R		'R'		; RECEIVE?
#32		,RECVCPM	; GO TO IT IF SO
>
		,@DSPLY
3!		,NOTLEG
			28H
R>EXIT1		,@EXIT
3!  		,0
			28H
4?NOTLEG		'? Not a legal option. Options are:',10
3 		'  S filename  - send a file to your end',10
8 		'  R filename  - receive a file from your end',10
"
		10,'  Please try again.',13
 ;
 OKGO
		
3*D		,(4475H+10)
3"		(OLDIY),
3!		,INTHDL
3"D		(4475H+10),
		
	
 ;
A#SENDCPM				; SKIP NEXT
#		
%3		OKGO		; GO ATTACH THE RS-232
!4s		(OLDSTK),	; SAVE STACK
 3 		SENDXY		; SEND THE FILE
A#RECVCPM		
#		

3		OKGO
!4s		(OLDSTK),	; SAVE STACK
3b		RECVXY
@DCB		32
@BUFFER		256

@PLACE		64
R>
NODEV		,@DSPLY
3!		,NODVR
			28H
3!		,0FFFFH
!				; NO DEVICE OF THAT NAME
.?NODVR		'? No RS-232 device available.',13

XMODEM		10,10
**		'** XMODEM TRS-80 Version 3.0.0',10
% 		'   Model III LDOS version',10
( 		'   Written by Karl Denninger',10
+ 		'   Released to public domain',10,13
*DEVNAME		'*RS',13
 GETPARMS
3!W		,PARIN
>
		,@DSPLY
			28H
3!^		,PLACE
2		,50
>			,@KEYIN
			28H
3ڽ		,LXV
x		,
		
3ʽ		,LXV
				; RETURN TO THE PLACE.
=EPARIN		'Enter direction, filename, and device as:',10,10
S		'S filename (*XX)',10
 		'     or',10
R		'R filename (*XX)',10
 
		10,'Instructions? ',14,03
 ALXV				; RESTORE OLD PLACE
3!		,0FFFFH
				; RETURN TO CALLER
ARETTER		
		,4
4*		,(OLDIY)
4"D		(4475H+10),
3		WAIT5
3͘		SETON
3!߫		,DSPX
>
		,@DSPLY
			28H
		
4{		,(OLDSTK)
				; RETURN TO CALLER

DSPX		10,'% Exiting',13
  OLDSTK		0
!  OLDIY		0		; OLD IY LOCATION
 AINTHDL				; NOT RE-ENTRANT!
		
		
		
		
4[2		,(BUFPOS)
		
3*4		,(POSOF)
		
R		,
|		,
		
()		,NORES
3*0		,(POSIT)
		,(0EBH)
w		,
#		
3"0		(POSIT),
3*2		,(BUFPOS)
#		
3"2		(BUFPOS),
%4[̬		,(LASTW)	; LAST LEGAL WORD
		
R		,
|		,
		
 
		,NORES
3!ά		,INTBUF
3"0		(POSIT),
3  		,0
4S2		(BUFPOS),

ANORES		
		
		
		
	
άPOSIT		INTBUF
  BUFPOS		0
  POSOF		0
άPOSRED		INTBUF
 ;
 GETCHAR
		
		
		
		
	
3*2		,(BUFPOS)
4[4		,(POSOF)
		
R		,
|		,
 				; CHECK TO SEE IF SAME
(0		,NOCHAR
		
4S4		(POSOF),
3*6		,(POSRED)
N		,
#		
3"6		(POSRED),
3*4		,(POSOF)
4[̬		,(LASTW)
		
R		,
|		,
		
 
		,NORESX
3!ά		,INTBUF
3"6		(POSRED),
3  		,0
4S4		(POSOF),
ANORESX		
y		,
		
		
		
		
	
	
ANOCHAR		
		
		
		
> 		,0
			1
	
	
 BKMK		0
ASEND		
		
		
		
RWAITIII		,(0EAH)
:w		6,
(		,WAITIII
		
		(0EBH),
		
		
		
				; RETURN TO CALLER
 ;ETOFF	LD	A,43H
 ;	LD	(0FFFFH),A
! ;	PUSH	HL		; SAVE COMMAND LINE
 ;	LD	A,@CMNDR
 ;	LD	HL,SETOF
 ;	RST	28H		; SET IT OFF
# ;	POP	HL		; RESTORE COMMAND LINE
 ;	XOR	A
 ;	LD	(0FFFFH),A
ASETOFF				; RETURN
ASETON	

>C		,43H
32		(0FFFFH),
 ;	LD	A,@CMNDR
! ;	PUSH	HL		; SAVE COMMAND LINE
 ;	LD	HL,SETO
 ;	RST	28H
# ;	POP	HL		; RESTORE COMMAND LINE
		
32		(0FFFFH),
	
(SSETOF		'Setcom (break=0,word=8)',13
 SSETO		'Setcom (break=3)',13
/ LASTW		256		; THE LAST PLACE (SUPPOSEDLY)
 INTBUF		0
	 		257
 ;
TTTON		'TTY CRT',13
TTTOF		'TTY OFF',13

AWAIT5		
		
		
		,4
AWT1		
3`		,60000
>		,@PAUSE
			28H
		
		WT1
		
		
		
	
 		START
