10 REM *******************************************************************
20 REM
30 REM                             Ex Editor
40 REM             Modeled after Mark Horton's Ex command in UNIX
50 REM                      last revision 23 Jul 84
60 REM
70 REM   TB$(n) = text buffer 		NF$ = new File name
80 REM   IL$ = input line		WF = write flag
90 REM   B = buffer length		SB$(n) = substitute buffer
100 REM  CLN = current line number      ELN = ending line number
110 REM  LLN = last line number		BLN = beginning line number
120 REM  F$ = File name			CL$ = command line
130 REM
140 REM ******************************************************************
150 DIM TB$(1000)
160 ON ERROR GOTO 610
170 WF = 1 : B = 0
180 CLS : PRINT : PRINT
190 PRINT "           Ex Editor - syntactically similar to UNIX's Ex command"
200 PRINT "                         for Model 4 (TRSDOS 6.x)"
210 PRINT "                             by Emmet P Gray"
220 PRINT : PRINT "  Commands supported :"
230 PRINT
240 PRINT "                 a  append                     (n,n)p  print"
250 PRINT "            (n,n)c  change                          q  quit"
260 PRINT "            (n,n)d  delete                    (n)r F$  read File"
270 PRINT "              e F$  edit File          (n,n)s/x/x/(g)  substitute"
280 PRINT "              (n)i  insert                (n,n)w (F$)  write File"
290 PRINT "      (n,n)g/x/cmd  global"
300 PRINT : PRINT : PRINT "  Abbrieviations supported :"
310 PRINT
320 PRINT "                          .  current line"
330 PRINT "                          ^  beginning character"
340 PRINT "                          $  ending line/character"
350 PRINT : PRINT
360 REM ******************  parse the command line **********************
370 LN$ = "" : BLN = 0 : ELN = 0 : NC = 0
380 LINE INPUT ":"; CL$
390 IF CL$ = "" THEN ELN = LLN + 1 : CL$ = "p" : PRINT CHR$(27);
400 FOR Q = 1 TO LEN(CL$)
410   C$ = MID$(CL$,Q,1)
420   IF C$ = "," THEN BLN = ELN : GOTO 500
430   IF C$ = "." THEN ELN = LLN : GOTO 500
440   IF C$ = "$" THEN ELN = B : GOTO 500
450   IF C$ > "9" OR C$ < "0" THEN 520
460   LN$ = LN$ + C$
470   IF LEN(CL$) = Q THEN 700
480   C1$ = MID$(CL$,Q+1,1)
490   IF C1$ > "9" OR C1$ < "0" THEN ELN = VAL(LN$) : LN$ = ""
500 NEXT
510 GOTO 700
520 IF BLN = 0 AND ELN = 0 THEN BLN = LLN : ELN = LLN
530 IF BLN = 0 THEN BLN = ELN
540 IF ELN > B THEN 680
550 Z = INT(INSTR(" qQeEgGrRsSwWaAcCdDiIpP",C$)/2)
560 IF Z = 0 THEN 700
570 IF Z > 6 AND Q <> LEN(CL$) THEN 700
580 ON Z GOSUB 1250,1320,2450,1880,2060,1480,720,810,910,1040,1160
590 GOTO 370
600 REM ********************** errors *********************************
610 CLOSE
620 IF ERR = 14 THEN PRINT "Text buffer overflow" : RESUME 370
630 IF ERR = 23 OR ERR = 15 THEN PRINT "Buffer line too long" : RESUME 370
640 IF ERR = 53 THEN PRINT CHR$(34); NF$; CHR$(34); " File not found" : RESUME 370
650 IF ERR = 61 THEN PRINT "Disk full" : RESUME 370
660 IF ERR = 64 THEN PRINT "Bad file name" : RESUME 370
670 PRINT "Internal Error #"; ERR; "in line"; ERL : RESUME 370
680 PRINT "Not that many lines in buffer" : GOTO 370
690 PRINT CL$; " : Not an editor command" : RETURN
700 PRINT CL$; " : Not an editor command" : GOTO 370
710 REM ******************** append ***********************************
720 CLN = B + 1
730   PRINT USING "  ### "; CLN;
740   LINE INPUT IL$
750   IF IL$ = "." THEN LLN = CLN -1 : RETURN
760   TB$(CLN) = IL$
770   CLN = CLN + 1 : B = B + 1
780   WF = 0
790 GOTO 730
800 REM ********************* change **********************************
810 FOR CLN = BLN TO ELN
820   PRINT USING "  ### "; CLN;
830   LINE INPUT IL$    
840   IF IL$ = "." THEN LLN = CLN : RETURN
850   TB$(CLN) = IL$
860 NEXT CLN
870 LLN = CLN -1
880 WF = 0
890 RETURN
900 REM ********************** delete ********************************
910 NL = ELN-BLN+1
920 FOR CLN = BLN TO B-NL
930   TB$(CLN) = TB$(CLN+NL)
940 NEXT CLN
950 IF ELN = B THEN LLN = BLN -1 ELSE LLN = BLN
960 B = B - NL
970 NC = -NL
980 IF NL > 1 THEN PRINT NL; "lines deleted"
990 PRINT USING "  ### "; LLN;
1000 PRINT TB$(LLN)
1010 WF = 0
1020 RETURN
1030 REM ********************** insert *******************************
1040 CLN = BLN
1050   PRINT USING "  ### "; CLN;
1060   LINE INPUT IL$
1070   IF IL$ = "." THEN LLN = CLN  : RETURN
1080   FOR NL = B+1 TO CLN+1 STEP -1
1090     TB$(NL) = TB$(NL-1)
1100   NEXT NL
1110   TB$(CLN) = IL$
1120   CLN = CLN + 1 : B = B + 1 : NC = NC + 1
1130   WF = 0
1140 GOTO 1050
1150 REM ************************ print ********************************
1160 IF ELN-BLN > 12 THEN CLS
1170 FOR CLN = BLN TO ELN
1180   PRINT USING "  ### "; CLN;
1190   PRINT TB$(CLN)
1200   IF INKEY$ = CHR$(13) THEN LLN = CLN : RETURN
1210 NEXT CLN
1220 LLN = CLN -1
1230 RETURN
1240 REM ************************ quit ********************************
1250 IF LEN(CL$) > 1 AND MID$(CL$,2) <> "!" THEN 690
1260 IF WF = 1 THEN 1290
1270 IF RIGHT$(CL$,1) = "!" THEN 1290
1280 PRINT "No write since last change (q! overrides)" : RETURN
1290 ON ERROR GOTO 0
1300 END
1310 REM ************************ edit *********************************
1320 IF LEN(CL$) < 3 OR MID$(CL$,2,1) <> " " THEN 690
1330 F$ = MID$(CL$,3)
1340 NF$ = F$
1350 OPEN "I",1,NF$
1360 IF EOF(1) THEN PRINT "File is empty" : RETURN
1370 B = 0
1380   IF EOF(1) THEN 1420
1390   B = B + 1
1400   LINE INPUT #1, TB$(B)
1410 GOTO 1380
1420 CLOSE
1430 PRINT CHR$(34); NF$; CHR$(34); B; "lines"
1440 LLN = 1
1450 WF = 1
1460 RETURN
1470 REM ********************** write *********************************
1480 IF Q = 1 THEN BLN = 1 : ELN = B
1490 IF F$ = "" THEN F$ = "NEWFILE"
1500 NF$ = F$ : NW = 0
1510 IF LEN(CL$) = Q THEN 1730
1520 IF MID$(CL$,Q+1,1) = "!" THEN Q = Q + 1 : NW = 1
1530 IF LEN(CL$)-Q < 3 OR MID$(CL$,Q+1,1) <> " " THEN 690
1540 NF$ = MID$(CL$,Q+2)
1550 IF LEFT$(NF$,1) <> ">" THEN 1670
1560 NF$ = MID$(NF$,2)
1570 OPEN "E",1,NF$
1580 REM
1590 REM
1600 REM  To maintain line number
1610 REM  compatibility with other 
1620 REM  versions
1630 REM
1640 REM
1650 REM
1660 GOTO 1740
1670 IF NW = 1 THEN 1730
1680 ON ERROR GOTO 1840
1690 OPEN "I",1,NF$
1700 CLOSE
1710 PRINT CHR$(34); NF$; CHR$(34); " already exists - use w! to overwrite"
1720 RETURN
1730 OPEN "O",1,NF$
1740 FOR CLN = BLN TO ELN
1750   PRINT #1, TB$(CLN)
1760 NEXT CLN
1770 LLN = CLN -1
1780 CLOSE
1790 REM
1800 PRINT CHR$(34); NF$; CHR$(34); ELN-BLN+1; "lines"
1810 WF = 1
1820 ON ERROR GOTO 610
1830 RETURN
1840 IF ERR = 53 THEN CLOSE : RESUME 1730
1850 ON ERROR GOTO 610
1860 GOTO 610
1870 REM *********************** read ********************************
1880 IF LEN(CL$)-Q < 3 OR MID$(CL$,Q+1,1) <> " " THEN 690
1890 NF$ = MID$(CL$,2+Q)
1900 CLN = BLN + 1
1910 OPEN "I",1,NF$
1920   IF EOF(1) THEN 2000
1930   LINE INPUT #1, IL$
1940   FOR N = B+1 TO CLN+1 STEP -1
1950     TB$(N) = TB$(N-1)
1960   NEXT N
1970   TB$(CLN) = IL$
1980   CLN = CLN + 1 : B = B + 1 : NC = NC + 1
1990 GOTO 1920
2000 LLN = CLN
2010 CLOSE
2020 PRINT CHR$(34); NF$; CHR$(34); NC; "lines"
2030 WF = 0
2040 RETURN
2050 REM *********************** substitute *****************************
2060 IF LEN(CL$)-Q < 4 THEN 690
2070 SB$(1) = "" : SB$(2) = "" : BUFF = 0 : G = 0
2080 FOR I = Q+1 TO LEN(CL$)
2090   C$ = MID$(CL$,I,1)
2100   IF I = Q+1 AND C$ <> "/" THEN 690
2110   IF SKIP = 0 AND C$ = "\" THEN SKIP = 1 : GOTO 2150
2120   IF C$ = "/" AND SKIP = 0 THEN BUFF = BUFF + 1 : GOTO 2150
2130   SB$(BUFF) = SB$(BUFF) + C$
2140   SKIP = 0
2150   IF BUFF = 3 THEN 2180
2160 NEXT I
2170 GOTO 690
2180 IF I = LEN(CL$) THEN 2210
2190 IF I+1 = LEN(CL$) AND (RIGHT$(CL$,1) = "g" OR RIGHT$(CL$,1) = "G") THEN G = 1 : GOTO 2210
2200 GOTO 690
2210 S1 = LEN(SB$(1)) : S2 = LEN(SB$(2))
2220 C = 0 : LC = 0 : K = 0
2230 IF S1 = 0 THEN 2370
2240 FOR CLN = BLN TO ELN
2250   IF SB$(1) = "^" THEN S1 = 0 : I = 1 : GOTO 2300
2260   IF SB$(1) = "$" THEN S1 = 0 : I = LEN(TB$(CLN))+1 : GOTO 2300
2270   N = 1
2280   I = INSTR(N,TB$(CLN),SB$(1))
2290   IF I = 0 THEN 2340
2300   C = C + 1
2310   IF K <> CLN THEN LC = LC + 1
2320   TB$(CLN) = LEFT$(TB$(CLN),I-1) + SB$(2) + MID$(TB$(CLN),I+S1) : K = CLN
2330   IF G = 1 THEN N = I + S2 : GOTO 2280
2340 NEXT CLN
2350 SOUND 3,0
2360 LLN = CLN -1
2370 IF C = 0 THEN PRINT "Substitute pattern match failed" : RETURN
2380 IF G = 0 THEN 2400
2390 PRINT C; "substitutions on"; LC; "lines"
2400 PRINT USING "  ### "; K;
2410 PRINT TB$(K)
2420 WF = 0
2430 RETURN
2440 REM ********************* global *********************************
2450 IF LEN(CL$)-Q < 3 THEN 690
2460 SB$ = "" : SKIP = 0 : C = 0
2470 FOR I = Q+1 TO LEN(CL$)
2480   C$ = MID$(CL$,I,1)
2490   IF I = Q+1 AND C$ <> "/" THEN 690
2500   IF SKIP = 0 AND C$ = "\" THEN SKIP = 1 : GOTO 2540
2510   IF C$ = "/" AND SKIP = 0 THEN C = C + 1 : GOTO 2540
2520   SB$ = SB$ + C$
2530   SKIP = 0
2540   IF C = 2 THEN 2570
2550 NEXT I
2560 GOTO 690
2570 IF LEN(CL$) =< I THEN 690
2580 I1 = I : K1 = 0 : C1 = BLN : B1 = BLN : E1 = ELN : C1$ = CL$
2590   I = INSTR(1,TB$(C1),SB$)
2600   NC = 0
2610   IF I = 0 THEN 2700
2620   K1 = K1 + 1
2630   Q = 1 : BLN = C1 : ELN = C1
2640   CL$ = MID$(C1$,I1+1)
2650   C$ = LEFT$(CL$,1)
2660   Z = INT(INSTR(" rRsSwWcCdDiIpP",C$)/2)
2670   IF Z = 0 THEN 690
2680   IF Z > 3 AND LEN(CL$) <> 1 THEN 690
2690   ON Z GOSUB 1880,2060,1490,810,910,1040,1160
2700   E1 = E1 + NC
2710   IF NC > 0 THEN C1 = C1 + NC+1
2720   IF NC = 0 THEN C1 = C1 + 1
2730 IF C1 <= E1 THEN 2590
2740 SOUND 3,0
2750 IF K1 = 0 THEN PRINT "Subsitute pattern match failed" : RETURN
2760 PRINT "command performed on"; K1; "lines"
2770 WF = 0
2780 RETURN
