10 REM *******************************************************************
20 REM
30 REM                             Ed Editor
40 REM             Modeled after Mark Horton's Ed command in UNIX SYSTEM III
50 REM                      last revision 12 JAN 85
60 REM
70 REM   TB$(n) = text buffer 		NF$ = new File name
80 REM   IL$ = input line		WF = write flag
90 REM   B = buffer length		SB$(n) = substitute buffer
100 REM  CLN = current line number      ELN = ending line number
110 REM  LLN = last line number		BLN = beginning line number
120 REM  F$ = File name			CL$ = command line
130 REM
140 REM ******************************************************************
150 DIM TB$(1000)
160 ON ERROR GOTO 610
170 WF = 1 : B = 0
180 CLS : PRINT : PRINT
190 PRINT "           Ed Editor - syntactically similar to UNIX's Ed command"
200 PRINT "                         for Model 4 (TRSDOS 6.x)"
210 PRINT "                             by Hal N. Fuquay
220 PRINT : PRINT "  Commands supported :"
230 PRINT
240 PRINT "                 a  append                     (n,n)p  print"
250 PRINT "            (n,n)c  change                          q  quit"
260 PRINT "            (n,n)d  delete                    (n)r F$  read File"
270 PRINT "              e F$  edit File          (n,n)s/x/x/(g)  substitute"
280 PRINT "              (n)i  insert                (n,n)w (F$)  write File"
290 PRINT "      (n,n)g/x/cmd  global"
300 PRINT : PRINT : PRINT "  Abbrieviations supported :"
310 PRINT
320 PRINT "                          .  current line"
330 PRINT "                          ^  beginning character"
340 PRINT "                          $  ending line/character"
350 PRINT : PRINT
360 REM ******************  parse the command line **********************
370 LN$ = "" : BLN = 0 : ELN = 0 : NC = 0
380 LINE INPUT ":"; CL$
390 IF CL$ = "" THEN ELN = LLN + 1 : CL$ = "p" : PRINT CHR$(27);
400 FOR Q = 1 TO LEN(CL$)
410   C$ = MID$(CL$,Q,1)
420   IF C$ = "," THEN BLN = ELN : GOTO 500
430   IF C$ = "." THEN ELN = LLN : GOTO 500
440   IF C$ = "$" THEN ELN = B : GOTO 500
450   IF C$ > "9" OR C$ < "0" THEN 520
460   LN$ = LN$ + C$
470   IF LEN(CL$) = Q THEN 700
480   C1$ = MID$(CL$,Q+1,1)
490   IF C1$ > "9" OR C1$ < "0" THEN ELN = VAL(LN$) : LN$ = ""
500 NEXT
510 GOTO 700
520 IF BLN = 0 AND ELN = 0 THEN BLN = LLN : ELN = LLN
530 IF BLN = 0 THEN BLN = ELN
540 IF ELN > B THEN 680
550 Z = INT(INSTR(" qQeEgGrRsSwWaAcCdDiIpP",C$)/2)
560 IF Z = 0 THEN 700
570 IF Z > 6 AND Q <> LEN(CL$) THEN 700
580 ON Z GOSUB 1250,1320,2450,1880,2060,1480,720,810,910,1040,1160
590 GOTO 370
600 REM ********************** errors *********************************
610 CLOSE
620 IF ERR = 14 THEN PRINT "Text buffer overflow" : RESUME 370
630 IF ERR = 23 OR ERR = 15 THEN PRINT "Buffer line too long" : RESUME 370
640 IF ERR = 53 THEN PRINT CHR$(34); NF$; CHR$(34); " File not found" : RESUME 370
650 IF ERR = 61 THEN PRINT "Disk full" : RESUME 370
660 IF ERR = 64 THEN PRINT "Bad file name" : RESUME 370
670 PRINT "Internal Error #"; ERR; "in line"; ERL : RESUME 370
680 PRINT "Not that many lines in buffer" : GOTO 370
690 PRINT CL$; " : Not an editor command" : RETURN
700 PRINT CL$; " : Not an editor command" : GOTO 370
710 REM ******************** append ***********************************
720 CLN = B + 1
730   PRINT USING "  ### "; CLN;
740   LINE INPUT IL$
750   IF IL$ = "." THEN LLN = CLN -1 : RETURN
760   TB$(CLN) = IL$
770   CLN = CLN + 1 : B = B + 1
780   WF = 0
790 GOTO 730
800 REM ********************* change **********************************
810 FOR CLN = BLN TO ELN
820   PRINT USING "  ### "; CLN;
830   LINE INPUT IL$    
840   IF IL$ = "." THEN LLN = CLN : RETURN
850   TB$(CLN) = IL$
860 NEXT CLN
870 LLN = CLN -1
880 WF = 0
890 RETURN
900 REM ********************** delete ********************************
910 NL = ELN-BLN+1
920 FOR CLN = BLN TO B-NL
930   TB$(CLN) = TB$(CLN+NL)
940 NEXT CLN
950 IF ELN = B THEN LLN = BLN -1 ELSE LLN = BLN
960 B = B - NL
970 NC = -NL
980 IF NL > 1 THEN PRINT NL; "lines deleted"
990 PRINT USING "  ### "; LLN;
1000 PRINT TB$(LLN)
1010 WF = 0
1020 RETURN
1030 REM *******************