         NAME('TYPE')
;
;        MG-TRS80-4     REV870203
;
;        Characters typed are sent to printer/buffer depending
; on the mode selected.
;        During direct print, bacspaces cause overstrike,
; in buffer mode, backspace causes last character to
; be deleted.  Only the current line can be erased.
; Attempting to bacspace beyond BOL is frustrated.
;        Print buffer command CLOSEs the buffer. To add
; additional characters to the buffer use the DOWN-ARROW function.
;        Commands marked with (*) may be within a stored buffer
;        Non-printable characters (<32 or >128) are ignored.
;        Buffer is limited to 10K keystrokes..overload leads to abort.
;        '$' printer control strings are set for RS-DMP series printers.
; They can easily be altered for any printer, but MUST end in 3D.
;
M1:      DB 'Dumb typewriter mode:',10D,'Press ^D or BREAK to exit',10D
         DB 10D,'MG-TRS80-4     Rev870203',10D
         DB 10D,'F1=Clear & open buffer..disable printer',10D
         DB 'F2=Close buffer..enable printer',10D
         DB 'F3=Print entire buffer..(no display during print)',10D,10D
         DB 'Shift-F1=set to PICA (*)',10D
         DB 'Shift-F2=set to ELITE (*)',10D
         DB 'Shift-F3=set to CORRESPONDENCE QUALITY (*)',10D,10D
         DB 'UP-ARROW=Form feed (*)',10D
         DB 'DOWN-ARROW=Reopen buffer at existing position',10D
         DB '(*)=May be within a stored buffer',10D
         DB 'Backspace/overstrike supported',10D
         DB 'CHR$ <32 or >128, unless above, are ignored',13D
M2:      DB 'Memory overload.../TYPE: ABORTED!',13D
M3:      DB '.....Printing a copy of memory.....',13D
M4:      DB '> Done printing <',13D
BSL:     DB 12D
PRINT:   DB 1D
DISPLAY: DB 1D
MEM:     DB 0D
$PICA:   DB 27D,19D,3D
$ELITE:  DB 27D,23D,3D
$CORRES: DB 27D,18D,3D
$BS:     DB 8D,12D,3D
START:   LD HL,BFR      ;Clear buffer &...
         LD (BP),HL
         LD A,105D      ;screen &...
         RST 28H
         LD HL,M1       ;display opening banner.
         LD A,10D
         RST 28H
GET:     LD A,1D        ;Fetch a character from keyboard
         RST 28H
         LD C,A         ;Save it in 'C'
         CP 81H         ;F1?=clear & open buffer
         JP Z,BON
         CP 82H         ;F2?=close buffer
         JP Z,BOFF
         CP 83H         ;F3?=print buffer
         JP Z,MKCPY
         CP 10D         ;DOWN-ARROW?=reopen old buffer
         JP Z,BON1
         CP 8H          ;LEFT-ARROW (^H)?=handle backspace
         JP Z,BS
         CP 4H          ;^D or...
         JP Z,EXIT
         CP 80H         ;BREAK?=Exit to DOS
         JP Z,EXIT
         CALL HANDLR    ;Handle all other keystrokes
         JR Z,GET       ;Successful handle?=get next chara.
         JP EXIT        ;Failure=exit to DOS.
HANDLR:  LD A,(MEM)     ;buffer on?
         OR A
         JR Z,E1
         LD HL,(BP)     ;YES=put character in buffer &...
         LD A,C
         LD (HL),A
         INC HL
         LD (BP),HL
         LD A,L         ;check for overload
         CPL
         LD E,A
         LD A,H
         CPL
         LD D,A
         INC DE
         LD HL,BP
         ADD HL,DE
         LD A,H
         OR A
         JR NZ,E1
         LD A,L
         OR A
         JP Z,OVRLD     ;Overload=exit to DOS
E1:      LD A,C         ;no buffer,or,after buffer routine
         CP 91H         ;SHIFT-F1?=set to PICA
         JR Z,PICA
         CP 92H         ;SHIFT-F2?=set to ELITE
         JR Z,ELITE
         CP 93H         ;SHIFT-F3=set to CORRESPONDENCE QUALITY
         JR Z,CORRES
         CP 11D         ;UP-ARROW=Form Feed
         JR NZ,E4
         LD C,12D
         JR E5
E4:      CP 13D         ;Allow carriage returns
         JR Z,E5
         SUB 32D        ;Ignore if <32
         JP M,RTN
         SUB 97D        ;Ignore if >128
         JP P,RTN
         JR Z,RTN
E5:      LD A,(PRINT)   ;Printer enabled?
         OR A
         JR Z,E2
         LD A,6D        ;YES=print the character
         RST 28H
E2:      LD A,(DISPLAY);Display enabled?
         OR A
         JR Z,RTN
         LD A,2D        ;YES=display the character
         RST 28H
RTN:     XOR A          ;do successful return
         RET
PICA:    LD HL,$PICA    ;Point HL at PICA string
$$:      LD A,12D       ;Set backspace dots to 12
         LD (BSL),A
         LD A,(PRINT)   ;Execute change if printer enabled
         OR A
         JR Z,RTN
         LD A,14D
         RST 28H
         JR RTN         ;do successful return in any case
ELITE:   LD HL,$ELITE   ;Point HL at ELITE string
         JR $$
CORRES:  LD HL,$CORRES  ;Point HL at CORRESPONDENCE string
         LD A,20D       ;set bacspace dots at 20
         JR $$+2
BON:     LD HL,BFR      ;clear buffer
         LD (BP),HL
BON1:    XOR A          ;printer=OFF,display & buffer=ON
         LD (PRINT),A
         INC A
         LD (DISPLAY),A
         LD (MEM),A
         JP GET
BOFF:    XOR A          ;buffer=OFF,display & printer=ON
         LD (MEM),A
         INC A
         LD (PRINT),A
         LD (DISPLAY),A
         JP GET
MKCPY:   LD HL,M3       ;printer=ON,display & buffer=OFF
         LD A,10D
         RST 28H
         XOR A
         LD (MEM),A
         LD (DISPLAY),A
         INC A
         LD (PRINT),A
         LD HL,BFR      ;Initialize output pointer
E6:      LD (BP1),HL    ;output pointer=end of buffer marker?
         LD A,L
         CPL
         LD E,A
         LD A,H
         CPL
         LD D,A
         INC DE
         LD HL,(BP)
         ADD HL,DE
         LD A,H
         OR A
         JR NZ,E3
         LD A,L
         OR A
         JR Z,DONE      ;YES=done
E3:      LD HL,(BP1)    ;NO=fetch and handle the character
         LD A,(HL)
         LD C,A
         CALL E1        ;(auxiliary handler entry point)
         LD HL,(BP1)    ;Increment output pointer & go back
         INC HL
         JR E6
DONE:    LD HL,M4       ;display done printing message &...
         LD A,10D
         RST 28H
         XOR A
         INC A
         LD (DISPLAY),A ;turn on display &...
         JP GET         ;go get more chara's
BS:      LD A,(PRINT)   ;Printer on?
         OR A
         JR Z,E7
         LD A,(BSL)     ;Yes=lock in BS dots & do backspace &...
         LD ($BS+1),A
         LD A,14D
         LD HL,$BS
         RST 28H
         JR E8          ;go display it
E7:      LD A,(MEM)     ;buffer on?
         OR A
         JP Z,GET       ;NO=ignore
E9:      LD HL,(BP)     ;BOL OR BEGINNING OF BUFFER?
         DEC HL
         LD A,(HL)
         CP 13D
         JP Z,GET       ;Yes=ignore(BUFFER(-1)=13)
         LD (BP),HL     ;else decrement buffer pointer &...
E8:      LD A,2D        ;display the BS
         RST 28H
         JP GET         ;go back for more chara's
EXIT:    LD A,22D       ;NON-ERROR exit to DOS
         LD HL,0D
         RST 28H
OVRLD:   LD A,10D       ;Display overload message &...
         LD HL,M2
         RST 28H
         XOR A
         INC A
         RET            ;do unsuccessful return from handler
         DB 13D
BFR:     DS 10240D      ;Designated buffer area
BP:      DS 2           ;end-of-buffer pointer area
BP1:     DS 2           ;output pointer area
         END START      ;This program starts at 'START'
