'    DISASM  Z80 disassembler,  this program will generate a listing in
'    assembly language from a file of ascii hex codes of Z80 opcodes
'     written by garry gruenke     may 29, 1989
'                    version 1.0

'******************  declarations and setup

KEY OFF                                         'disable function keys
FOR N=1 TO 10
          KEY N, ""
NEXT N
CLS
CLOSE
REM $STATIC
OPTION BASE 0
DEFINT W, Z, X
DIM O$(256), OCB$(256), OED$(128), IX$(1,40), IXCB$(1,35), IY$(1,40), IYCB$(1,35)
D$="0123456789ABCDEF"
DEF SEG=&H40                                    'set caps lock
POKE &H17,(PEEK(&H17) OR &H40)
DEF SEG

'***************  print logo and info

LOCATE 1,20
PRINT CHR$(201);
FOR N=1 TO 39
          PRINT CHR$(205);
NEXT N
PRINT CHR$(187);
LOCATE 6,20
PRINT CHR$(200);
FOR N=1 TO 39
          PRINT CHR$(205);
NEXT N
PRINT CHR$(188);
FOR N=2 TO 5
          LOCATE N,20
          PRINT CHR$(186);
          LOCATE N,60
          PRINT CHR$(186);
NEXT N
LOCATE 2,32
PRINT "Z80 Disassembler";
LOCATE 3,34
PRINT "Version 1.0";
LOCATE 4,32
PRINT "by Garry Gruenke";
LOCATE 5,30
PRINT "copyright (C) May 1989";
LOCATE 8,1
PRINT "           This program will create a Z80 assembly language listing"
PRINT "           from a file of opcodes in ascii hex format."
PRINT CHR$(198);
PRINT STRING$(78,CHR$(205));
PRINT CHR$(181);
VIEW PRINT 11 TO 24

'*****************  load data files

LOCATE 17,15
PRINT "Loading opcodes. Please wait";
INFILE$="OPCODE"
GOSUB LOADER
INFILE$="OPCODE.CB"
GOSUB LOADER
INFILE$="OPCODE.ED"
GOSUB LOADER
INFILE$="INDEXX"
GOSUB LOADER
INFILE$="INDEXX.CB"
GOSUB LOADER
INFILE$="INDEXY"
GOSUB LOADER
INFILE$="INDEXY.CB"
GOSUB LOADER

'***************** check for command line parameters

IF COMMAND$="" THEN GOTO GETSOURCE
D=INSTR(COMMAND$," ")
IF D THEN
	INFILE$=LEFT$(COMMAND$,D-1)
	OUTFILE$=RIGHT$(COMMAND$,LEN(COMMAND$)-D)
	CLS
	GOTO OFFSETSTART
END IF
INFILE$=COMMAND$
CLS
GOTO GETDEST

'**************** get source and destination file names

GETSOURCE:
CLS
INFILE$=""
LOCATE 16,10
LINE INPUT "Source file name (HEX file only)? ";INFILE$

GETDEST:
LOCATE 18,10
PRINT "Destination device? (may be file name, SCRN:, or LPT1:)"
LINE INPUT "         Default is screen ";OUTFILE$
IF OUTFILE$="" THEN OUTFILE$="SCRN:"

'**************  get starting offset for disassembly

OFFSETSTART:
OPEN INFILE$ FOR INPUT AS #1
OPEN OUTFILE$ FOR OUTPUT AS #2
AD$=""
LOCATE 21,10
PRINT "Enter the HEX offset at which to start disassembly: ";

GETOFFSET:
Q$=INKEY$
WHILE Q$=""
	Q$=INKEY$
WEND
IF Q$=CHR$(13) THEN GOTO OFFSET
D=INSTR(D$,Q$)
IF D THEN
	AD$=AD$+Q$
	PRINT Q$;
	GOTO GETOFFSET
ELSE
	GOTO GETOFFSET
END IF


OFFSET:
IF AD$="" THEN
	AD=0
	CLS
	GOTO START
END IF
AD=VAL("&H"+AD$)
FOR N=1 TO AD
	IF EOF(1) THEN GOTO QUIT
	A$=INPUT$(2,#1)
NEXT N

'*************  start of main disassembly

CLS
START:
IF EOF(1) THEN GOTO QUIT
A$=INPUT$(2,#1)
HC$=A$
IF A$="DD" THEN                                 'IX register operators
	A$=INPUT$(2,#1)
	HC$=HC$+A$
	IF A$="CB" THEN                         'indexed bit operators
		W1$=INPUT$(2,#1)
		W2$=INPUT$(2,#1)
		Z=0
		WHILE IXCB$(0,Z)<>W2$ AND IXCB$(1,Z)<>"---"
			Z=Z+1
		WEND
		OP$=IXCB$(1,Z)
		IF OP$="---" THEN GOTO ILLEGAL
		B=INSTR(OP$,"#")
		NN$=LEFT$(OP$,B-1)+W1$+RIGHT$(OP$,LEN(OP$)-B)
		AD$=HEX$(AD)
		AD$=STRING$(4-LEN(AD$),"0")+AD$
		HX$=HC$+W1$+W2$
		PRINT #2, AD$,HX$,NN$
		AD=AD+4
		GOTO START
	END IF
	IF A$="36" THEN                         'special case
		W1$=INPUT$(2,#1)
		W2$=INPUT$(2,#1)
		NN$="LD    (IX+" + W1$ + ")," + W2$
		AD$=HEX$(AD)
		AD$=STRING$(4-LEN(AD$),"0")+AD$
		HX$=HC$+W1$+W2$
		PRINT #2, AD$,HX$,NN$
		AD=AD+4
		GOTO START
	END IF
	Z=0
	WHILE IX$(0,Z)<>A$ AND IX$(1,Z)<>"---"
		Z=Z+1
	WEND
	OP$=IX$(1,Z)
	IF OP$="---" THEN GOTO ILLEGAL
	B=INSTR(OP$,"#")
	W=INSTR(OP$,"@")
	IF W THEN GOSUB WORD ELSE IF B THEN GOSUB BITE ELSE NN$=OP$
	AD$=HEX$(AD)
	AD$=STRING$(4-LEN(AD$),"0")+AD$
	IF W THEN
		HX$=HC$+W1$+W2$
		PRINT #2, AD$,HX$,NN$
		AD=AD+4
		GOTO START
	END IF
	IF B THEN
		HX$=HC$+B1$
		PRINT #2, AD$,HX$,NN$
		AD=AD+3
		GOTO START
	END IF
	HX$=HC$
	PRINT #2, AD$,HX$,NN$
	AD=AD+2
	GOTO START
END IF
IF A$="FD" THEN                                 'IY register operators
	A$=INPUT$(2,#1)
	HC$=HC$+A$
	IF A$="CB" THEN                         'indexed bit operators
		W1$=INPUT$(2,#1)
		W2$=INPUT$(2,#1)
		Z=0
		WHILE IYCB$(0,Z)<>W2$ AND IYCB$(1,Z)<>"---"
			Z=Z+1
		WEND
		OP$=IYCB$(1,Z)
		IF OP$="---" THEN GOTO ILLEGAL
		B=INSTR(OP$,"#")
		NN$=LEFT$(OP$,B-1)+W1$+RIGHT$(OP$,LEN(OP$)-B)
		AD$=HEX$(AD)
		AD$=STRING$(4-LEN(AD$),"0")+AD$
		HX$=HC$+W1$+W2$
		PRINT #2, AD$,HX$,NN$
		AD=AD+4
		GOTO START
	END IF
	IF A$="36" THEN                         'special case
		W1$=INPUT$(2,#1)
		W2$=INPUT$(2,#1)
		NN$="LD    (IY+" + W1$ + ")," + W2$
		AD$=HEX$(AD)
		AD$=STRING$(4-LEN(AD$),"0")+AD$
		HX$=HC$+W1$+W2$
		PRINT #2, AD$,HX$,NN$
		AD=AD+4
		GOTO START
	END IF
	Z=0
	WHILE IY$(0,Z)<>A$ AND IY$(1,Z)<>"---"
		Z=Z+1
	WEND
	OP$=IY$(1,Z)
	IF OP$="---" THEN GOTO ILLEGAL
	B=INSTR(OP$,"#")
	W=INSTR(OP$,"@")
	IF W THEN GOSUB WORD ELSE IF B THEN GOSUB BITE ELSE NN$=OP$
	AD$=HEX$(AD)
	AD$=STRING$(4-LEN(AD$),"0")+AD$
	IF W THEN
		HX$=HC$+W1$+W2$
		PRINT #2, AD$,HX$,NN$
		AD=AD+4
		GOTO START
	END IF
	IF B THEN
		HX$=HC$+B1$
		PRINT #2, AD$,HX$,NN$
		AD=AD+3
		GOTO START
	END IF
	HX$=HC$
	PRINT #2, AD$,HX$,NN$
	AD=AD+2
	GOTO START
END IF
IF A$="ED" THEN                                 'misc. port and interrupt
	A$=INPUT$(2,#1)
	HC$=HC$+A$
	Z=VAL("&H"+A$)-&H40
	IF Z<0 OR Z>&H7B THEN GOTO ILLEGAL
	OP$=OED$(Z)
	IF OP$="---" THEN GOTO ILLEGAL
	W=INSTR(OP$,"@")
	IF W THEN
		W1$=""
		W2$=""
		GOSUB WORD
		AD$=HEX$(AD)
		AD$=STRING$(4-LEN(AD$),"0")+AD$
		HX$=HC$+W1$+W2$
		PRINT #2, AD$,HX$,NN$
		AD=AD+4
		GOTO START
	END IF
	AD$=HEX$(AD)
	AD$=STRING$(4-LEN(AD$),"0")+AD$
	PRINT #2, AD$,HC$,OP$
	AD=AD+2
	GOTO START
END IF
IF A$="CB" THEN                                 'bit operators
	A$=INPUT$(2,#1)
	HC$=HC$+A$
	Z=VAL("&H"+A$)
	OP$=OCB$(Z)
	IF OP$="---" THEN GOTO ILLEGAL
	AD$=HEX$(AD)
	AD$=STRING$(4-LEN(AD$),"0")+AD$
	PRINT #2, AD$,HC$,OP$
	AD=AD+2
	GOTO START
END IF
B1$=""                                          '8080 subset operators
W1$=""
W2$=""
Z=VAL("&H"+A$)
OP$=O$(Z)
W=INSTR(OP$,"@")
B=INSTR(OP$,"#")
IF W THEN GOSUB WORD ELSE IF B THEN GOSUB BITE ELSE NN$=OP$
AD$=HEX$(AD)
AD$=STRING$(4-LEN(AD$),"0")+AD$
IF W THEN
	HX$=HC$+W1$+W2$
	PRINT #2, AD$,HX$,NN$
	AD=AD+3
	GOTO START
END IF
IF B THEN
	HX$=HC$+B1$
	PRINT #2, AD$,HX$,NN$
	AD=AD+2
	GOTO START
END IF
HX$=HC$
PRINT #2, AD$,HX$,NN$
AD=AD+1
GOTO START

'**************  assembly data loader subroutine

LOADER:
X=0
OPEN INFILE$ FOR INPUT AS #1
WHILE NOT EOF(1)
	SELECT CASE INFILE$
		CASE "OPCODE"
			LINE INPUT #1,O$(X)
		CASE "OPCODE.CB"
			LINE INPUT #1,OCB$(X)
		CASE "OPCODE.ED"
			LINE INPUT #1,OED$(X)
		CASE "INDEXX"
			LINE INPUT #1,IXL$
			IX$(0,X)=LEFT$(IXL$,2)
			IX$(1,X)=RIGHT$(IXL$,LEN(IXL$)-2)
		CASE "INDEXX.CB"
			LINE INPUT #1,IXL$
			IXCB$(0,X)=LEFT$(IXL$,2)
			IXCB$(1,X)=RIGHT$(IXL$,LEN(IXL$)-2)
		CASE "INDEXY"
			LINE INPUT #1,IXL$
			IY$(0,X)=LEFT$(IXL$,2)
			IY$(1,X)=RIGHT$(IXL$,LEN(IXL$)-2)
		CASE "INDEXY.CB"
			LINE INPUT #1,IXL$
			IYCB$(0,X)=LEFT$(IXL$,2)
			IYCB$(1,X)=RIGHT$(IXL$,LEN(IXL$)-2)
		CASE ELSE
	END SELECT
	X=X+1
WEND
CLOSE #1
PRINT ".";
RETURN

'************ byte operand subroutine

BITE:
B1$=INPUT$(2,#1)
NN$=LEFT$(OP$,B-1)+B1$+RIGHT$(OP$,LEN(OP$)-B)
RETURN

'************ word operand subroutine

WORD:
W1$=INPUT$(2,#1)
W2$=INPUT$(2,#1)
WW$=W2$+W1$
NN$=LEFT$(OP$,W-1)+WW$+RIGHT$(OP$,LEN(OP$)-W)
RETURN

'**************  illegal opcode detected

ILLEGAL:
AD$=HEX$(AD)
AD$=STRING$(4-LEN(AD$),"0")+AD$
PRINT
PRINT "         Illegal opcode encountered at offset: ";AD$
PRINT "         Probable data area in listing. "
PRINT "         Restart disassembly at a greater offset."
GOTO QUIT

'*************  quit routine

QUIT:
PRINT
PRINT "                         Job finished."
CLOSE
VIEW PRINT
LOCATE 25,10
PRINT "Press any key to continue......";
Q$=INKEY$
WHILE Q$=""
	Q$=INKEY$
WEND
CLS
