;*****************************************************************
;
; DRIVES/CMD:	Freely donated to the public domain.  Permission
;		is granted for personal but not commercial use.
;
; Purpose:	Tests the floppy disk drives status via SVC @GTDCT
;		If enabled, disable.  If disabled, enable.
;
;		Useful if running applications which search all
;		active drives for a file if running from a hard
;		disk or Ramdisk.
;		i.e. compilers, assemblers, word processors.
;
;		For TRSDOS/LS-DOS 6.x only.
;
; Syntax:	DRIVES
;
; Programmer:	R. A. Basham
; Date written:	April 20, 1988
;
; Set up for the Misosys MRAS assembler.  Minor modifications
; may be necessary if using some other assembler package.
;
;***************************************************************
;
;	SVC Equates
;
@CMNDR	EQU	19H
@DSPLY	EQU	0AH
@EXIT	EQU	16H
@GTDCT	EQU	51H
;
;	Set the following equates for the logical floppy drive
;	positions in your system configuration Drive Code Table.
;
;	Example: Drive 0 is a RAMDISK.
;		 Drives 1, 2, 3, are DISKdisk files.
;		 Drives 4, 5 are Harddisk drives
;		 Drives 6, 7 are the floppies.
;
DECDRV0	EQU	'6'	;Physical floppy drive 0
HEXDRV0	EQU	6
DECDRV1	EQU	'7'	;Physical floppy drive 1
HEXDRV1	EQU	7
CR	EQU	0DH
;
SVC	MACRO	#ADDR		;Supervisor call
	LD	A,#ADDR
	RST	28H
	ENDM
;
	ORG	3000H
;
;	Messages and commands
;
SYSTEM	DB	'SYSTEM (DRIVE='
DRIVE	DB	0
DISABLE	DB	',DISABLE)',CR
ENABLE	DB	',ENABLE)',CR
MSG	DB	'Floppy drives are '
MSG1	DB	'disabled.',CR
MSG2	DB	'enabled.',CR
;
BEGIN	LD	A,DECDRV0	;Load command with
	LD	(DRIVE),A	; first drivespec
	LD	C,HEXDRV0
	CALL	SETSTAT		;Execute DISABLE/ENABLE
	LD	A,DECDRV1	;Load command with
	LD	(DRIVE),A	; second drivespec
	LD	C,HEXDRV1
	CALL	SETSTAT		;Execute DISABLE/ENABLE
	LD	HL,MSG
	SVC	@DSPLY		;Tell us what it did
	LD	HL,0
	SVC	@EXIT		;Back to the system
;
SETSTAT	SVC	@GTDCT		;Get the drive table.
	LD	A,(IY+0)
	CP	0C9H		;Drive disabled?
	JR	NZ,EXECUTE	;No. Then disable it.
	LD	BC,9
	PUSH	BC
	LD	DE,DISABLE
	LD	HL,ENABLE	;Yes. Then enable it.
	LDIR
	POP	BC
	LD	DE,MSG1
	LD	HL,MSG2
	LDIR
EXECUTE	LD	HL,SYSTEM	;Exec the 'SYSTEM'
	SVC	@CMNDR		; command
	RET			; and back to caller.
	END	BEGIN
