;	UNIQUE -- duplicate line remover
@FSPEC	EQU	4EH
@OPEN	EQU	3BH
@GET	EQU	03H
@DSPLY	EQU	0AH
@INIT	EQU	3AH
@PUT	EQU	04H
@CLOSE	EQU	3CH
@ERROR	EQU	1AH
@EXIT	EQU	16H
@PARAM	EQU	11H
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
CR	EQU	0DH
LF	EQU	0AH
ETX	EQU	03H
EOF	EQU	1CH
;
	ORG	3000H
;
START:	LD	DE,FCB1
	SVC	@FSPEC		;TEST FILE NAME & MOVE
	JP	NZ,FILE_ERR	;GO FILE NAME ERROR
	CALL	SKIP_SP
	JP	NZ,USE_ERR
	LD	DE,FCB2
	SVC	@FSPEC
	JP	NZ,FILE_ERR
;
	PUSH	HL		;SAVE POINTER TO POSSIBLE PARAMS
	LD	DE,FCB1		;CK FOR DUPLICATE FILENAME
	LD	HL,FCB2
	LD	B,32		;MAX FILE NAME LEN
	CALL	COMPARE_1
	POP	HL		;P/U CMD LINE POINTER
	JP	Z,DUP_ERR	;GO DUPLICATE FILE NAME ERROR
;
	LD	DE,PARM_TBL	;DE==>PARAMETER TABLE
	SVC	@PARAM		;PARSE TABLE IF NEEDED
	JP	NZ,PARM_ERR
	LD	DE,0		;FLAG SET FOR ASCENDING MERGE
D_SAVE	EQU	$-2
	LD	A,D
	OR	E
	JR	Z,START1
	LD	A,20H		;JR NZ, OP CODE
	LD	(OP_STUF),A	;SET FOR DESCENDING SORT
	LD	(OP_STUF2),A
;
START1:	LD	HL,F_BUF1	;OPEN INPUT FILE
	LD	DE,FCB1
	LD	B,0		;SET LRL=256
	SVC	@OPEN
	JP	NZ,DOS_ERR
	LD	HL,F_BUF2
	LD	DE,FCB2
	LD	B,0
	SVC	@INIT
	JP	NZ,DOS_ERR
;
	LD	HL,(F_START)	;START OF FIELD TO MERGE
	LD	H,0
	LD	A,0		;COMPARE TO MAX LENGTH
	SUB	L		;COMPARE TO START 
	LD	(F_START),HL	;SAVE FIELD START, MAX OFFSET IS 256
	LD	A,L		;SAVE FIELD START
	LD	HL,(F_END)
	INC	L		;OFFSET FROM 1
	LD	H,A		;SAVE FIELD START
	LD	A,L		;A=FIELD END
	SUB	H		;A=FIELD LENGTH
	LD	L,A		;SAVE FIELD LEN
	LD	A,0
	SUB	H		;A=MAX LEN OF FIELD
	LD	H,A		;H=MAX FIELD LEN
	CP	L		;COMPARE TO FIELD LEN
	JR	C,FL_2		;IF MAX FIELD LEN < FIELD LEN, GO USE MAX
	LD	H,L		;ELSE SET FIELD LEN
FL_2:	LD	A,H
	LD	(F_LEN),A	;SAVE FIELD LEN
;
	CALL	GET_1		;FILL BUFS WITH FIRST LINES
	CALL	GET_2
;
UNIQUE:
	LD	DE,LINE2
	LD	HL,LINE1
	CALL	COMPARE		;COMPARE TWO INPUT LINES
	JR	Z,UNIQUE1	;EQUAL, DO NOT SAVE LINE 1
OP_STUF: EQU	$-2
	CALL	SAVE_1
UNIQUE1:
	LD	DE,LINE1	;COPY LINE 2 TO LINE 1
	LD	HL,LINE2
	LD	BC,256		;MOVE 256 BYTES
	LDIR
	CALL	GET_2		;FILL LINE BUFFER 2
	LD	DE,FCB1		;TEST IF INPUT FCB IS CLOSED
	LD	A,(DE)
	AND	80H
	JR	NZ,UNIQUE	;LOOP IF NOT AT END OF FILE
;
EXIT:
	LD	DE,LINE1
	LD	HL,LINE2
	CALL	COMPARE
	JR	Z,EXIT_A
OP_STUF2: EQU	$-2
	CALL	SAVE_1		;SAVE FIRST LINE IF DIFERENT FROM SECOND
EXIT_A:	CALL	SAVE_2
	CALL	CLOSE
	LD	HL,0		;SET NO ERROR EXIT
EXIT1:	SVC	@EXIT		;QUIT TO DOS
;
SAVE_2:	LD	HL,LINE2
	JR	SAVE_LINE
;
SAVE_1:	LD	HL,LINE1                                                        ;
SAVE_LINE:
	LD	DE,FCB2
	LD	A,(HL)		;P/U CHAR FROM BUFFER
	OR	A		;END OF BUFFER MARKER?
	RET	Z		;YES, QUIT
;
PUTCHAR:
	LD	C,A		;CHAR TO SAVE TO C
	SVC	@PUT
	JP	NZ,DOS_ERR
	INC	HL		;BUMP BUFFER PTR
	JR	SAVE_LINE	;AND LOOP
;
DUP_ERR:
	LD	HL,DUP_ERR$
	DB	0DDH
USE_ERR:
	LD	HL,USEAGE$
	DB	0DDH
PARM_ERR:
	LD	HL,PARM_ERR$
	DB	0DDH
FILE_ERR:
	LD	HL,FILE_ERR$
	SVC	@DSPLY
	LD	HL,-1		;SHOW ERROR EXIT
ABORT:	JP	EXIT1
;
CLOSE:	LD	DE,FCB1
	LD	A,(DE)
	AND	80H		;TEST FOR OPEN BIT
	JR	Z,CLOSE_1	;FILE CLOSED, GO TEST NEXT
	SVC	@CLOSE
CLOSE_1:
	LD	DE,FCB2
	LD	A,(DE)
	AND	80H
	RET	Z		;DONE, RETURN
	SVC	@CLOSE
	RET
;
DOS_ERR:
	PUSH	AF
	CALL	CLOSE
DE_1	POP	AF		;P/U ERROR CODE
	LD	L,A
	LD	H,0
	OR	0C0H		;SET SHORT BIT AND RETURN
	LD	C,A		;MOVE TO C
	SVC	@ERROR		;ABORT PROGRAM
	JR	ABORT
;
COMPARE:	;ROUTINE TO COMPARE TWO STRINGS.
		;STRING 1 IN HL, STRING 2 IN DE
		;RET NC IF STRING 1 < STIRNG 2
		;RET  C IF STIRNG 1 > STRING 2
		;RET  Z IF STIRNG 1 = STRING 2
	LD	A,(F_START)	;P/U FIELD START
	LD	C,A
	LD	B,0		;BC=OFFSET TO FIELD START
	ADD	HL,BC		;HL==>FIELD IN LINE 1
	EX	DE,HL		;HL==>LINE 2
	ADD	HL,BC		;HL==>FIELD LINE 2
	EX	DE,HL		;DE==>LINE 2, HL ==>LINE 1
	LD	A,(F_LEN)
	LD	B,A		;P/U FIELD LEN
COMPARE_1:
	LD	A,(DE)		;P/U CHAR LINE 2
	CP	(HL)		;COMPARE LINE 1
	JR	NZ,COMPARE_2	;NOT EQUAL, CK FOR RIGHT ORDER
	INC	HL		;BUMP PTR LINE 1
	INC	DE		;BUMP PTR LINE 2
	DJNZ	COMPARE_1	;LOOP FOR FIELD
				;LINES ARE EQUAL, SO GO, RET Z
COMPARE_2:
	RET			;RET  C FLAG,  LINE 1 > LINE 2
				;RET NC FLAG,  LINE 1 < LINE 2
				;RET  Z FLAG,  LINE1 == LINE 2
;
SKIP_SP:	;routine to advance HL to next non space character
		;return NZ if control character is reached before
		;non-space
	LD	A,' '
SKIP_SP1:
	CP	(HL)
	JR	NZ,SKIP_SP2
	INC	HL
	JR	SKIP_SP1
SKIP_SP2:
	RET	NC		;WAS CONTROL, RET NZ
	CP	A		;SET Z FLAG, NOT CONTROL CHAR
	RET
;
GET_1:		;FILL LINE BUFFER 1
	LD	HL,LINE1
	JR	GET_LINE
;
GET_2:
	LD	HL,LINE2
;
GET_LINE:	;ROUTINE TO LOAD A LINE BUFFER (HL==>BUF) WITH
		;CHARACTERS FROM A FILE (DE==>FCB)
		;IF END OF FILE, THE LINE BUFFER WILL BE FILLED WITH NULLS
		;LINE WILL BE PADDED WITH NULL
	LD	DE,FCB1
GET_LINE1:
	SVC	@GET		;GET BYTE FROM FILE
	JR	Z,GET_LINE2	;GOT CHAR & NO ERROR
	OR	A		;TEST FOR NO CHAR AVAILABLE
	JR	Z,GET_LINE1	;NO CHAR, LOOP FOR ONE
	CP	EOF		;END OF FILE REACHED?
	JP	NZ,DOS_ERR	;NO, QUIT WITH DOS ERROR
	SVC	@CLOSE		;CLOSE FILE ON EOF
	JR	FILL_BUF	;AND FILL BUFFER
GET_LINE2:
	LD	(HL),A		;SAVE CHAR IN BUF
	INC	HL		;BUMP BUF PTR
	DEC	B		;REDUCE TO FILL IN BUFFER
	RET	Z		;GO IF BUFFER FILLED
	CP	CR		;TEST FOR END OF LINE
	JR	NZ,GET_LINE1	;LOOP TO END OF LINE, END OF FILE,
				;  OR FULL BUFFER
FILL_BUF:
	LD	A,0		;FILL BUFFER WITH NULL
FILL_BUF1:
	LD	(HL),A
	INC	HL
	DJNZ	FILL_BUF1
	RET
;
FCB1:	DS	32		;FILE BUFFERS
F_BUF1:	DS	256
FCB2:	DS	32
F_BUF2:	DS	256
;
LINE1	DS	256		;LINE BUFFERS
	DB	0		;MARK VERY END OF BUFFER
LINE2	DS	256
	DB	0		;MARK VERY END OF BUFFER
;
F_START: DW	$-$		;FIELD START
F_END:	DW	-1		;FIELD END
F_LEN:	DB	0FFH		;LENGTH OF FIELD
;
FILE_ERR$ DB	'Invalid file name!',CR
DUP_ERR$: DB	'Duplicate file names not allowed.',CR
PARM_ERR$: DB	'Parameter error.',LF
USEAGE$: DB	'Useage: UNIQUE FILE1 FILE2 [(START=##,END=##,DUPLICATE)]',LF
	DB	'Where: FILE1   is a required name for the file to remove duplicate lines from',LF
	DB	'       FILE2   is a required name for the file for the output of the program',LF
	DB	'       START   is an optional parameter for the starting position of a field',LF
	DB	'               (default is 0, the beginning of the line).',LF
	DB	'       END     is an optional parameter for the ending position of',LF
	DB	'               the merge field (default is the end of the line).',LF
	DB	'       DUPLICATE is a flag that indicates save only the duplicate lines',LF
	DB	'               (deafult is OFF, i.e., discard duplicates).'
	DB	'Abbreviations are S for START, E for END, and D for DUPLICATE.',CR
;
PARM_TBL:
	DB	80H		;MARK START OF PARAMETER TABLE
;
	DB	10010101B	;NUMERIC, ABRV, 5 CHAR LONG
	DB	'START'
	DB	0
	DW	F_START
;
	DB	10010011B	;NUMERIC, ABRV, 3 CHAR LONG
	DB	'END'
	DB	0
	DW	F_END
;
	DB	01011001B	;FLAG, ABRV, 9 CHAR LONG
	DB	'DUPLICATE'
	DB	0
	DW	D_SAVE
	DB	0		;MARK END OF TABLE
;
	END	START
