 ;DOSOVLDR/ASM
 ;
 ;Loader routine for system overlayers in high memory
 ;
 ;Written by
 ;Dr. J. Szajman
 ;29 June 1987
 ;
 ;Use CMDFILE to change base address to C000H,
 ;and rename to CONTROL/CIM
 ;
 ;
 CTRL	EQU	0DFH		;BANK SWITCHING PORT
 DBUFF	EQU	4200H
 STACK	EQU	DBUFF+0F0H	;NEW STACK
 OSTACK	EQU	DBUFF+0FDH	;STORAGE FOR OLD STACK
 ROVLO	EQU	DBUFF+0FFH	;ORIGINAL RAM OVERLAY
 OVL	EQU	4317H		;DOS OVERLAYER NO, HERE
 TBL	EQU	0C100H		;TABLE
 ;
 ;
 	ORG	DBUFF
 START	LD	HL,4369H
 	SET	6,(HL)
 	LD	HL,45BEH
 	LD	(HL),00
 	LD	A,(ROVLO)
 	OUT	(CTRL),A
 	POP	AF		;RECOVER RST 28 CODE
 	PUSH	AF
 	AND	1FH
 	LD	HL,OVL
 	CP	(HL)		;IS IT NEW OVERLAYER?
 	EI
 	JP	Z,4C19H
 	DI
 	LD	(HL),A
 	CP	16H		;<SYS22?
 	JR	C,MAIN
 	AND	7		;DIR SECTOR + 2
 	LD	C,A
 	XOR	A
 	LD	(43D8H),A
 	EI
 	JP	4BE8H		;GET OVL FROM DISK
 ;
 MAIN	LD	(OSTACK),SP
 	LD	SP,STACK
 	CALL	LOAD
 	LD	SP,(OSTACK)
 	LD	A,(ROVLO)
 	OUT	(CTRL),A
 	EI
 	JP	4C09H
 ;
 LOAD	LD	B,A
 	LD	HL,TBL-3	;CONTROL AREA
 	DEC	B
 	DEC	B		;B=xx, SYSxx/SYS
 	LD	A,0FH		;RAM BANK
 	OUT	(CTRL),A
 LOOP1	INC	HL
 	INC	HL
 	INC	HL
 	DJNZ	LOOP1		;FIND OVERLAY ADDRESS
 	LD	E,(HL)
 	INC	HL
 	LD	D,(HL)		;DE=OVERLAY ADDRESS
 	INC	HL
 	DEC	DE
 	LD	A,(HL)		;RAM BANK OF OVERLAY
 	OUT	(CTRL),A
 	LD	(ROVL),A	;STORE IT
 LOOP2	CALL	NEXT
 	LD	C,A		;SAVE FIRST BYTE
 	LD	A,1FH		;LARGEST LOADER CODE
 	CP	C
 	LD	A,22H		;ERROR CODE
 	RET	C		;ERROR EXIT
 	CALL	NEXT		;GET LENGTH
 	LD	B,A		;SAVE
 	CALL	NEXT
 	LD	L,A		;LSB OF LOAD/TRANSF. ADDR
 	LD	H,C
 	DEC	C		;01 LOADER CODE?
 	JR	Z,JP1
 	DEC	C		;02 LOADER CODE?
 	JR	NZ,SKIP
 	CALL	NEXT
 	LD	H,A		;MSB OF TRANSFER ADDRESS
 	XOR	A
 	RET	
 JP1	CALL	NEXT
 	LD	H,A		;MSB OF LOAD ADDRESS
 	DEC	B
 	DEC	B		;ADJUST COUNT FOR ADDR
 LOOP3	CALL	NEXT
 	LD	(HL),A		;MOVE BYTE
 	CP	(HL)		;ROM OR MAYBE VIDEO?
 	INC	HL
 	JR	Z,SKIP
 	LD	A,24H		;ERROR CODE
 	INC	C
 	DEC	C
 	JR	NZ,SKIP		;IGNORE IF COMMENT
 	OR	A		;SET FLAG
 	RET	
 SKIP	DJNZ	LOOP3
 	JR	LOOP2
 NEXT	INC	DE		;BUMP SOURCE POINTER
 	LD	A,D
 	OR	E		;END OF MEMORY?
 	LD	A,(DE)
 	RET	NZ
 	LD	A,(ROVL)
 	DEC	A		;NEXT RAM BANK
 	LD	(ROVL),A
 	OUT	(CTRL),A
 	LD	DE,0C000H	;BEGINING OF BUFFER
 	LD	A,(DE)
 	RET	
 ;
 ROVL	DEFB	0FH		;CURRENT RAM BANK
 FINISH	EQU	$
 ;
 	END	FINISH-START
                                                                                                                                                                                                                                               