;********************************************************
;*							*
;*                LEAPYEAR - Version 5.1		*
;*							*
;*                   December 18, 1987			*
;*							*
;*             Written by Steven G. Bradley		*
;* 							*
;*	This program is for use only on the model 1	*
;*	(it is not needed for models 3 or 4) and must	*
;*	be used with LDOS 5.1.4 or LDOS 5.1.5.		*
;*							*
;*	The purpose of this program is to install	*
;*	corrective code in the link between the LDOS	*
;*	resident date handler and the high-memory	*
;*	UPDATE handler.  The update handler updates	*
;*	the day, month, year, etc, whenever midnight	*
;*	passes.  This routine will keep it accurate on	*
;*	leap years, as someone forgot to check for	*
;*	leap years when they wrote the update routine.	*
;*							*
;*	To use this program, first install the UPDATE	*
;*	module using the SYSTEM (UPDATE) command (see	*
;*	LDOS manual for details), after update has been	*
;*	installed, enter LEAPYEAR and press enter.  It  *
;*	is a good idea to use SYSTEM (SYSGEN) to save	*
;*	the LEAPYEAR and UPDATE modules to your system	*
;*	configuration file.				*
;*							*
;********************************************************
;
LF	EQU	10		; Linefeed character
CR	EQU	13		; Carriage return
;
MODEL3	EQU	49H		; Model 3 machine flag
MOD1OR3	EQU	125H		; Test for model 1 or 3
;
YEAR	EQU	4044H		; Where year is found
HIGH$	EQU	4049H		; Model 1 HIGH$ location
@DSPLY	EQU	4467H		; Display a message
@LOGOT	EQU	447BH		; Display and log message
;
UPDATE	EQU	45DDH		; Where UPDATE is called
;
	ORG	5200H		; Good place to begin
;
START	LD	HL,HEADER	; Display opening header
	CALL	@DSPLY		; but don't log it
;
	LD	A,(MOD1OR3)	; Check for model 1
	CP	MODEL3		; Model 3?
	LD	HL,NOTMOD1	; If bad model
	JP	Z,@LOGOT	; Log and display message
;
	LD	A,(UPDATE)	; Check for UPDATE module
	SUB	0C9H		; Function installed?
	LD	HL,NOGO		; In case it isn't
	JP	Z,@LOGOT	; Log and display message
;
	LD	HL,(UPDATE+1)	; Get jump address
	LD	(DONE),HL	; Store it for later
	PUSH	HL		; Save start of update
	LD	DE,60H		; Offset for February
	ADD	HL,DE		; Find table address
	LD	(FEB),HL	; Store address
	POP	HL		; Get start of update
	INC	HL		; and see if this fix
	INC	HL		; routine was already
	INC	HL		; installed...
	INC	HL
	LD	A,(HL)		; Length is a quick check
	CP	8		; Already installed?
	LD	HL,GOODMSG	; In case it is...
	JP	Z,@LOGOT	; Show good install
	LD	HL,ENDPGM-1	; First address to move
	LD	DE,(HIGH$)	; First free location
	LD	(OLDMEM),DE	; Save it
	LD	BC,ENDPGM-ENTRY	; # of bytes to move
	LDDR			; Move bytes
	LD	(HIGH$),DE	; Store new HIGH$
	INC	DE		; Find entry to routine
	LD	(UPDATE+1),DE	; Store entry
	LD	HL,GOODMSG	; Show good install
	JP	@LOGOT		; Log and display it
;
HEADER	DB	LF,'LEAPYEAR - Corrects error in leap year routines.  Version 5.1'
	DB	LF,'Copyright (C) 1987 by Steven G. Bradley.  ** Not For Sale **',CR
NOGO	DB	LF,'SYSTEM (UPDATE) must be executed prior to running this program.',CR
NOTMOD1	DB	LF,'This program is for model 1 use only!',CR
GOODMSG	DB	LF,'Leap year corrective code installed.',CR
;
ENTRY	JR	LEAPFIX		; Enter LEAPFIX routine
OLDMEM	DW	$-$		; Old high memory
	DB	8,'LEAPYEAR'	; Label for module
;
LEAPFIX	PUSH	HL		; Save HL
	LD	HL,0		; Get table entry for
FEB	EQU	$-2		; February
	LD	(HL),28		; Normally = 28 days
	LD	A,(YEAR)	; Get the year
	AND	3		; Leap year?
	JR	NZ,NOLEAP	; Nope, maybe next year
	INC	(HL)		; Bump it one
NOLEAP	POP	HL		; Restore HL
	JP	0		; We are done
DONE	EQU	$-2		; Resume update routine
ENDPGM	EQU	$		; End of module
;
	END	START		; End of program
