;********************************************************
;*							*
;*		CONV515 - Version 5.1.5			*
;*							*
;********************************************************
;
LF	EQU	10		; Linefeed
CR	EQU	13		; Carriage return
;
DATEFLG	EQU	8		; Date flag mask
;
@DSP	EQU	33H		; Display a character
;
@EXIT	EQU	402DH		; Normal exit
@ABORT	EQU	4030H		; Abort exit
@ERROR	EQU	4409H		; Error routine
@DSPLY	EQU	4467H		; Display a message
@LOGOT	EQU	447BH		; Display & log message
@CKDRV	EQU	44B8H		; Check drive status
WRPROT	EQU	4768H		; Write directory sector
GETDCT	EQU	478FH		; IY=DCT of drive in C
RDSSEC	EQU	4B45H		; Read a directory sector
DIRCYL	EQU	4B65H		; Locate the directory
;
	ORG	5200H		; Good place to put it
;
START	PUSH	HL		; Save command pointer
	LD	HL,HEADER	; Display header
	CALL	@DSPLY		; on the screen
	POP	HL		; Get command pointer
;
	LD	A,(HL)		; Get drive number
	CP	':'		; Colon?
	INC	HL		; (maybe it is...)
	JR	NZ,CKDRIVE	; No, must be drive #
;
	LD	A,(HL)		; Yes, get drive number
;
CKDRIVE	LD	HL,DRVERR	; Drive error message
	SUB	'0'		; Make it binary 0-7
	JP	C,ERRMSG	; If bad drive number...
;
	CP	8		; Check upper limit
	JP	NC,ERRMSG	; If bad drive number...
;
	LD	C,A		; Put it in C
	CALL	@CKDRV		; Check for disk status
	LD	HL,WRERR	; If write protected
	JP	C,ERRMSG	; Go show problem
;
	LD	HL,DRVERR	; If other problem
	JP	NZ,ERRMSG	; Go show problem
;
	CALL	DIRCYL		; Find the directory
;
	LD	HL,GATBUF	; Where to put GAT
	LD	E,0		; Sector zero (GAT)
	CALL	GETSEC		; Read a directory sector
;
	LD	HL,CONVMSG	; In case of 5.3 / 6.3
	LD	A,(GATBUF+0CDH)	; Check date flag
	AND	DATEFLG		; Is it 5.3/6.3 format?
	JP	NZ,ERRMSG	; Yes, it is... (done)
;
	CALL	GETDCT		; Get DCT for drive
	LD	A,(IY+7)	; Find how many
	AND	31		; sectors per track
	INC	A		; Add 1 for real count
;
	BIT	5,(IY+4)	; Double sided?
	JR	Z,NOTDBL	; No, single sided drive
;
	ADD	A,A		; Double sector count
;
NOTDBL	CP	35		; Check for max dir size
	JR	C,SIZEOK	; If size is okay
;
	LD	A,34		; Set max dir size to 34
;
SIZEOK	SUB	2		; Minus GAT & HIT sectors
	LD	B,A		; Count of sectors to fix
	LD	E,2		; First dir entry sector
;
LOOP1	PUSH	BC		; Save BC
	PUSH	DE		; and DE
	LD	HL,BUFFER	; Where to put it
	CALL	GETSEC		; Read a directory sector
	LD	IX,BUFFER	; Pointer to buffer
	LD	B,8		; 8 entries / sector
;
LOOP2	LD	A,(IX+0)	; Check for active entry
	AND	90H		; FPDE & FXDE flags
	CP	10H		; FPDE?
	JR	NZ,NEXT		; No, try another entry
;
	LD	A,(IX+2)	; Get old year
	AND	7		; Bottom 3 bits only
	LD	(IX+18),0	; Set time to 0
	LD	(IX+19),A	; and store year
;
NEXT	PUSH	BC		; Save BC
	LD	BC,32		; Increment pointer
	ADD	IX,BC		; to next entry
	POP	BC		; Restore BC
	DJNZ	LOOP2		; Finish rest of entries
;
	LD	HL,BUFFER	; Buffer to write
	CALL	PUTSEC		; Write directory sector
	POP	DE		; Restore registers
	POP	BC		; DE and BC
	INC	E		; Increment sector
	DJNZ	LOOP1		; Convert next sector
;
	LD	A,53H		; Change format version #
	LD	(GATBUF+0CBH),A	; Store version value
	LD	A,(GATBUF+0CDH)	; Get flags
	OR	DATEFLG		; Set DATE flag
	LD	(GATBUF+0CDH),A	; Store flags
;
	LD	E,0		; Sector zero (GAT)
	LD	HL,GATBUF	; Where to write from
	CALL	PUTSEC		; Write directory sector
;
	LD	HL,DONEMSG	; Show and log
	CALL	@LOGOT		; successful conversion
	JP	@EXIT		; and we are done...
;
GETSEC	CALL	RDSSEC		; Read directory sector
;
IOERRCK	RET	Z		; If no error, we're done
	OR	40H		; Want only an error msg
	PUSH	AF		; Save error code
	LD	A,CR		; Advance a line
	CALL	@DSP		;
	POP	AF		; Restore error code
	JP	@ERROR		; Show message and exit
;
PUTSEC	CALL	WRPROT		; Write directory sector
	JR	IOERRCK		; Go check for errors
;
ERRMSG	CALL	@LOGOT		; Log and display error
	JP	@ABORT		; and use abort exit
;
HEADER	DB	LF,'CONV515 - LDOS Date Conversion Utility - Version 5.1.5'
	DB	LF,'Copyright (C) 1987, by Steven Bradley.  All Rights Reserved.',CR
;
DRVERR	DB	LF,'Illegal drive number',CR
WRERR	DB	LF,'Write protected drive!',CR
CONVMSG	DB	LF,'Disk already converted!',CR
DONEMSG	DB	LF,'Date conversion completed',CR
;
GATBUF	DS	256		; Buffer for GAT
BUFFER	DS	256		; Work buffer
;
	END	START		; End of program
