R      ;R/ASM - edit TRSDOS 6.2 command line 86-07-10
 ;programmed by arne rohde, box 82-211, auckland, nz
 ;for TRSDOS 6.2 Model 4 TRS-80
 BUFF	EQU	420H		;command buffer
 @EXIT	EQU	16H
 @DSP	EQU	02H
 @DSPLY	EQU	0AH
 @KEY	EQU	01H
 @CMNDI	EQU	18H
 @VDCTL	EQU	0FH
 	ORG	2600H		;dos buffer area
 BEGIN	EQU	$
 	LD	A,@VDCTL
 	LD	B,4		;get cursor pos
 	RST	28H
 	LD	(CURP),HL	;save pos
 	LD	HL,SCRN		;save screen info
 	LD	B,6		;screen to mem
 	LD	A,@VDCTL
 	RST	28H
 	LD	A,@DSP
 	LD	C,0FH		;cursor off
 	RST	28H
 	LD	HL,BUFF+1	;second buffer char
 	LD	(HL),20H	;first two to spaces
 	DEC	HL
 	LD	(HL),20H
 	LD	A,0DH		;set last to cr
 	LD	(BUFF+79),A
 BEGLIN	EQU	$
 	LD	HL,BUFF		;buffer start
 DSPLC	EQU	$
 	LD	C,1CH		;home cursor
 	LD	A,@DSP
 	RST	28H
 	LD	C,1FH		;clr screen
 	LD	A,@DSP
 	RST	28H
 DSPLB	EQU	$
 	LD	B,(HL)		;buffer char
 	LD	A,L
 	CP	BUFF+79&0FFH	;check at buffer end
 	JR	Z,RPLNOC	;yes, no cursor
 	LD	A,B		;char at cursor
 	CP	0DH		;check if end of line
 	JR	C,RPLNOC	;line feed, no cursor
 	JR	NZ,RPLCUR	;no, replace cursor
 	INC	HL		;to next char
 	LD	(HL),A		;set to line end
 	DEC	HL		;cursor pos back
 RPLCUR	EQU	$
 	LD	(HL),0BFH	;set cursor
 	LD	A,(MODFLG)	;check insert mode
 	OR	A
 	JR	Z,RPLNOC	;replace mode
 	LD	(HL),0B0H	;alternative cursor
 RPLNOC	EQU	$
 	LD	A,@DSP
 	LD	C,1CH		;home cursor
 	RST	28H
 	PUSH	HL		;save pos
 	LD	HL,BUFF		;start for display
 	LD	A,@DSPLY	;display line
 	RST	28H
 	POP	HL		;pos back to hl
 	LD	(HL),B		;restore char
 	LD	A,@KEY		;wait for key
 	RST	28H
 	CP	24		;shift left
 	JR	Z,BEGLIN	;line begin
 	CP	80H		;break key
 	JP	Z,RETDS		;return to dos
 	CP	9		;right arrow
 	JR	Z,MVRGT
 	CP	8		;left arrow
 	JR	Z,MVLFT
 	CP	10		;down arrow
 	JR	Z,INSMDE	;set insert mode
 	CP	0DH		;enter key
 	JR	Z,ENTRKY
 	CP	25		;shift right
 	JR	Z,LINEND
 	CP	31		;shift clear key
 	JR	Z,DELCHR	;delete character
 	CP	20H		;check ctrl char
 	JR	C,DSPLB		;yes, ignore
 	EX	AF,AF'		;save key code
 	LD	A,L		;get addr lsb
 	CP	BUFF+79&0FFH	;check if end
 	JR	Z,DSPLB		;yes, ignore
 	LD	A,(HL)		;get char
 	CP	0DH		;check current end
 	CALL	Z,MBUFRG	;yes, move buffer right
 	LD	A,(MODFLG)	;check insert mode
 	OR	A
 	CALL	NZ,MBUFRG	;insert character
 	EX	AF,AF'		;get char again
 	LD	(HL),A		;insert char
 MVRGT	EQU	$
 	LD	A,(HL)		;check if end of line
 	CP	0DH
 	JR	Z,DSPLB		;at end, no move right
 	INC	HL		;else incr cursor pos
 JDSPLB	EQU	$
 	JR	DSPLB
 MVLFT	EQU	$
 	LD	A,L		;current pos lsb
 	CP	BUFF&0FFH	;check at beginning
 	JR	Z,DSPLB		;yes, exit
 	LD	A,(HL)		;char at cursor
 	DEC	HL		;else cursor back
 	CP	0DH		;check line end
 	JR	NZ,DSPLB	;no, no screen clear
 JDSPLC	EQU	$
 	JP	DSPLC		;else clear screen
 INSMDE	EQU	$
 	LD	A,0		;current mode flag
 MODFLG	EQU	$-1
 	XOR	0FFH		;invert flag
 	LD	(MODFLG),A
 	JR	JDSPLB
 ENTRKY	EQU	$
 	CALL	RSTSCR		;restore screen
 	LD	HL,BUFF		;command buffer start
 	LD	A,@DSPLY
 	RST	28H		;display line
 	LD	DE,SCRN		;save command line
 	LD	BC,80		;max 80 chars
 	LDIR
 	LD	HL,SCRN		;command line
 	LD	A,@CMNDI
 	RST	28H
 LINEND	EQU	$
 	LD	A,0DH
 	CP	(HL)		;find line end
 	JR	Z,JDSPLC	;found, display new
 	INC	HL
 	JR	LINEND		;to next char
 DELCHR	EQU	$
 	LD	A,(HL)		;char at cursor
 	CP	0DH		;check end of line
 	JR	Z,JDSPLB	;yes, exit
 	LD	D,H		;addr in buffer
 	LD	E,L
 DELNCH	EQU	$
 	LD	A,E		;addr lsb
 	CP	BUFF+79&0FFH	;check end of buff
 	JR	Z,JDSPLC	;yes, exit to clr screen
 	INC	DE		;next source char
 	LD	A,(DE)
 	DEC	DE		;to dest
 	LD	(DE),A
 	INC	DE		;ready for next move
 	JR	DELNCH		;delete next
 MBUFRG	EQU	$
 	LD	BC,BUFF+80	;end addr + 1
 	LD	DE,BUFF+79	;end addr
 MBUFCH	EQU	$
 	LD	A,E		;check if at end
 	CP	L		;current cursor addr
 	RET	Z		;yes, exit
 	DEC	BC		;else back one
 	DEC	DE
 	LD	A,(DE)
 	LD	(BC),A
 	JR	MBUFCH		;repeat move
 RSTSCR	EQU	$
 	LD	HL,SCRN		;saved screen
 	LD	B,5		;back to screen
 	LD	A,@VDCTL
 	RST	28H
 	LD	B,3		;cursor pos set
 	LD	HL,(CURP)
 	LD	A,@VDCTL
 	RST	28H
 	LD	A,@DSP
 	LD	C,0EH		;cursor on
 	RST	28H
 	RET
 RETDS	EQU	$
 	CALL	RSTSCR		;restore screen
 	LD	A,@EXIT
 	LD	HL,0
 	RST	28H
 CURP	DEFW	0		;save cursor pos
 SCRN	DEFS	2048		;screen data
 	END	BEGIN
	LD	A,@DSP
 	LD	C,0EH		;cursor on
 	RST	28H
 	RET
 RETDS	EQU	$
