;ENTER ASSEMBLER WITH (P1) PARAMETER FOR MODEL III ASSEMBLY
;********************************************************
;*							*
;*	MODCLEAR/cmd					*
;*		Clears the MOD flag from all files on	*
;*		the specified drive			*
;*	Syntax:						*
;*		MODCLEAR :d				*
;*							*
;********************************************************
@LOGOT	EQU	12
@CKDRV	EQU	33
@DIRRD	EQU	87
@DIRWR	EQU	88
@DSP	EQU	2
@DSPLY	EQU	10
@ERROR	EQU	26
@ABORT	EQU	21
SVC	MACRO	#AA$
	LD	A,#AA$
	RST	28H
	ENDM
	IF	@@1
	ORG	5200H
	ELSE
	ORG	2600H		;Overlay area
	ENDIF
START	PUSH	HL		;Save parameters
	LD	HL,HELLO$	;Point to message
	SVC	@LOGOT		;Show the message
	POP	HL		;retrieve parameters
	JR	NZ,ERROR	;if error
	LD	A,':'		;Indicates drive spec.
	CP	(HL)		;1st character?
	JR	NZ,PARMERR	;No - parameter error
	INC	HL		;Point to drive specified
	LD	A,(HL)		;get drive number
	AND	7		;Strip high bits
	LD	C,A		;move to C
	LD	B,0		;start with DEC=0
	SVC	@CKDRV		;Is drive ready?
	JR	NZ,NOTRDY	;If not
	JR	C,NOTRDY	;If write protected
READ	SVC	@DIRRD
	JR	NZ,ERROR	;if error
	LD	A,(HL)		;get byte 0
	AND	10010000B	;see if active &
	CP	00010000B	; primary entry
	JR	NZ,OK		;if not
	INC	HL		;point to next byte
	BIT	4,(HL)		;mod flag set?
	JR	Z,OK		;if not set
	RES	4,(HL)		;reset MOD flag
	SVC	@DIRWR		;rewrite DEC
	JR	NZ,ERROR	;error trap
	PUSH	BC		;Save
	PUSH	DE		; registers
	LD	C,'.'		;Display a period
	SVC	@DSP		; when modified
	POP	DE		;Restore
	POP	BC		; registers
	JR	NZ,ERROR	;error trap
OK	INC	B		;point to next DEC
	XOR	A		;Zero A
	CP	B		;see if finished
	JR	NZ,READ		;if not finished
DONE	LD	HL,DONE$	;point to message
	SVC	@DSPLY		;show it
	LD	HL,0		;no error exit
	RET
NOTRDY	LD	HL,RDY$
	DB	0DDH		;Dummy argument
PARMERR	LD	HL,PARM$	;parameter error message
	SVC	@LOGOT		;log error
	LD	HL,0FFFFH	;error exit
	RET
ERROR	CP	16		;Illegal file # error
	JR	Z,DONE
	OR	01000000B	;Short message
	SVC	@ERROR
	SVC	@ABORT
;
;********************************************************
;*	Messages					*
;********************************************************
HELLO$	DB	0AH,'MODCLEAR - Clears out MOD flag'
	DB	0AH,'Copyright (c) 1986 by Daniel J. Fox',0DH
PARM$	DB	'Needs drive specification:',0AH
	DB	'   MODCLEAR :d',0DH
DONE$	DB	0AH,'Finished.',0DH
RDY$	DB	0AH,'Drive is not available.',0DH
	END	START
  