; **************************************
; CDD - Change DiskDisk - Ver. 1.0
; By Irwin B. Burton - 09/30/93
; **************************************
;
LF	EQU	0AH
CR	EQU	0DH
ETX	EQU	03H
;
@DSPLY	EQU	0AH
@EXIT	EQU	16H
@CMNDR	EQU	25
@GTMOD	EQU	83
@HIGH$	EQU	100
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
;----------------------------------
; Start of Program
;----------------------------------
	ORG	2400H		;Runs in the Library area
;
BEGIN	LD	DE,CMDLN$	;Save Command Line
	LD	B,0
	LD	C,13
	LDIR
;
	LD	HL,HELLO$
	SVC	@DSPLY		;Display Welcome
;
CHK4MOD	LD	DE,MODNM$
	SVC	@GTMOD		;Check for DiskDisk Module in Memory
;				;Z <= set if the module is found
	CALL	Z,CMNDR		;If DD found, Close Present DD
;
	LD	HL,CMDLN$	;Recover Command Line
;
	CALL	Z,CHK4CR	;Check for CR or a filename
;
	CALL	NZ,NEWDD	;If not CR, Install New DiskDisk File
;
	LD	HL,0		;Successful completion
	SVC	@EXIT
;
;
;----------------------------------
; Sub Routines
;----------
;
CHK4CR	LD	A,(HL)
	CP	CR
	RET
;
NEWDD	LD	DE,ACTN$
	LD	B,0
	LD	C,9
	LDIR
CMNDR	LD	HL,CMD$
	SVC	@CMNDR
	RET
;
;
;----------
; Data Storage
;----------
;
HELLO$	DB	LF,'CDD - Change DiskDisk Utility - 1.0',LF
	DB	'By Irwin B. Burton - 09/30/93',LF,CR
;
MODNM$	DB	'$DD',ETX
;
CMD$	DB	'DD :2 '
ACTN$	DB	'(DISABLE)',CR
CMDLN$	DB	'             '
;
	END	BEGIN
